#
# TABLE STRUCTURE FOR: activities
#

DROP TABLE IF EXISTS `activities`;

CREATE TABLE `activities` (
  `activitiesID` int(11) NOT NULL AUTO_INCREMENT,
  `activitiescategoryID` int(11) NOT NULL,
  `description` text NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `time_to` varchar(40) DEFAULT NULL,
  `time_from` varchar(40) DEFAULT NULL,
  `time_at` varchar(40) DEFAULT NULL,
  `usertypeID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  PRIMARY KEY (`activitiesID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `activities` (`activitiesID`, `activitiescategoryID`, `description`, `create_date`, `modify_date`, `time_to`, `time_from`, `time_at`, `usertypeID`, `userID`, `schoolyearID`) VALUES (1, 1, 'CREATIE', '2023-07-08 12:06:11', '2023-07-08 12:06:11', '15:05:00', '15:05:00', '15:05:00', 1, 1, 3);


#
# TABLE STRUCTURE FOR: activitiescategory
#

DROP TABLE IF EXISTS `activitiescategory`;

CREATE TABLE `activitiescategory` (
  `activitiescategoryID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `fa_icon` varchar(40) DEFAULT NULL,
  `schoolyearID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`activitiescategoryID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (1, 'Photos', 'fa-picture-o', 19, '2017-04-30 09:04:15', '2017-08-01 05:15:23', 1, 1);
INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (2, 'Food', 'fa-cutlery', 19, '2017-04-30 02:28:09', '2017-04-30 02:28:09', 1, 1);
INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (3, 'Sleep', 'fa-bed', 19, '2017-04-30 02:51:08', '2017-04-30 02:51:08', 1, 1);
INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (4, 'Sports', 'fa-trophy', 19, '2017-04-30 02:52:04', '2017-04-30 02:52:04', 1, 1);
INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (5, 'Activities', 'fa-puzzle-piece', 19, '2017-04-30 02:52:36', '2017-04-30 02:56:41', 1, 1);
INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (6, 'Note', 'fa-edit', 19, '2017-04-30 02:55:08', '2017-04-30 02:55:08', 1, 1);
INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (7, 'Incident', 'fa-times', 19, '2017-04-30 03:00:54', '2017-04-30 03:02:37', 1, 1);
INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (8, 'Meds', 'fa-medkit', 19, '2017-04-30 03:02:47', '2017-04-30 03:02:47', 1, 1);
INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (9, 'Art', 'fa-paint-brush', 19, '2017-04-30 03:06:07', '2017-04-30 03:06:07', 1, 1);


#
# TABLE STRUCTURE FOR: activitiescomment
#

DROP TABLE IF EXISTS `activitiescomment`;

CREATE TABLE `activitiescomment` (
  `activitiescommentID` int(11) NOT NULL AUTO_INCREMENT,
  `activitiesID` int(11) NOT NULL,
  `comment` text NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  PRIMARY KEY (`activitiescommentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: activitiesmedia
#

DROP TABLE IF EXISTS `activitiesmedia`;

CREATE TABLE `activitiesmedia` (
  `activitiesmediaID` int(11) NOT NULL AUTO_INCREMENT,
  `activitiesID` int(11) NOT NULL,
  `attachment` text NOT NULL,
  `create_date` datetime NOT NULL,
  PRIMARY KEY (`activitiesmediaID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: activitiesstudent
#

DROP TABLE IF EXISTS `activitiesstudent`;

CREATE TABLE `activitiesstudent` (
  `activitiesstudentID` int(11) NOT NULL AUTO_INCREMENT,
  `activitiesID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `classesID` int(11) NOT NULL,
  PRIMARY KEY (`activitiesstudentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: addons
#

DROP TABLE IF EXISTS `addons`;

CREATE TABLE `addons` (
  `addonsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `package_name` varchar(180) DEFAULT NULL,
  `slug` varchar(180) DEFAULT NULL,
  `description` longtext,
  `version` varchar(11) DEFAULT NULL,
  `author` varchar(100) DEFAULT NULL,
  `init` longtext,
  `files` longtext,
  `preview_image` varchar(180) DEFAULT NULL,
  `date` datetime NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` varchar(100) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`addonsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: alert
#

DROP TABLE IF EXISTS `alert`;

CREATE TABLE `alert` (
  `alertID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `itemID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `itemname` varchar(128) NOT NULL,
  PRIMARY KEY (`alertID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: asset
#

DROP TABLE IF EXISTS `asset`;

CREATE TABLE `asset` (
  `assetID` int(11) NOT NULL AUTO_INCREMENT,
  `serial` varchar(255) DEFAULT NULL,
  `description` text COMMENT 'Title',
  `manufacturer` varchar(255) DEFAULT NULL,
  `brand` varchar(255) DEFAULT NULL,
  `asset_number` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `asset_condition` int(11) DEFAULT NULL,
  `attachment` text,
  `originalfile` text,
  `asset_categoryID` int(11) DEFAULT NULL,
  `asset_locationID` int(11) DEFAULT NULL,
  `create_date` date NOT NULL,
  `modify_date` date NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`assetID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: asset_assignment
#

DROP TABLE IF EXISTS `asset_assignment`;

CREATE TABLE `asset_assignment` (
  `asset_assignmentID` int(11) NOT NULL AUTO_INCREMENT,
  `assetID` int(11) NOT NULL COMMENT 'Description and title',
  `usertypeID` int(11) DEFAULT NULL,
  `check_out_to` int(11) NOT NULL,
  `due_date` date DEFAULT NULL,
  `note` text,
  `assigned_quantity` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `asset_locationID` int(11) DEFAULT NULL,
  `check_out_date` date DEFAULT NULL,
  `check_in_date` date DEFAULT NULL,
  `create_date` date NOT NULL,
  `modify_date` date NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`asset_assignmentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: asset_category
#

DROP TABLE IF EXISTS `asset_category`;

CREATE TABLE `asset_category` (
  `asset_categoryID` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(255) NOT NULL,
  `create_date` date NOT NULL,
  `modify_date` date NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  `active` int(11) NOT NULL,
  PRIMARY KEY (`asset_categoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: assignment
#

DROP TABLE IF EXISTS `assignment`;

CREATE TABLE `assignment` (
  `assignmentID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(128) NOT NULL,
  `description` text NOT NULL,
  `deadlinedate` date NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `originalfile` text NOT NULL,
  `file` text NOT NULL,
  `classesID` longtext NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `sectionID` longtext,
  `subjectID` longtext,
  `assignusertypeID` int(11) DEFAULT NULL,
  `assignuserID` int(11) DEFAULT NULL,
  PRIMARY KEY (`assignmentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: assignmentanswer
#

DROP TABLE IF EXISTS `assignmentanswer`;

CREATE TABLE `assignmentanswer` (
  `assignmentanswerID` int(11) NOT NULL AUTO_INCREMENT,
  `assignmentID` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `uploaderID` int(11) NOT NULL,
  `uploadertypeID` int(11) NOT NULL,
  `answerfile` text NOT NULL,
  `answerfileoriginal` text NOT NULL,
  `answerdate` date NOT NULL,
  PRIMARY KEY (`assignmentanswerID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: attendance
#

DROP TABLE IF EXISTS `attendance`;

CREATE TABLE `attendance` (
  `attendanceID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `classesID` int(11) NOT NULL,
  `sectionID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `usertype` varchar(60) NOT NULL,
  `monthyear` varchar(10) NOT NULL,
  `a1` varchar(3) DEFAULT NULL,
  `a2` varchar(3) DEFAULT NULL,
  `a3` varchar(3) DEFAULT NULL,
  `a4` varchar(3) DEFAULT NULL,
  `a5` varchar(3) DEFAULT NULL,
  `a6` varchar(3) DEFAULT NULL,
  `a7` varchar(3) DEFAULT NULL,
  `a8` varchar(3) DEFAULT NULL,
  `a9` varchar(3) DEFAULT NULL,
  `a10` varchar(3) DEFAULT NULL,
  `a11` varchar(3) DEFAULT NULL,
  `a12` varchar(3) DEFAULT NULL,
  `a13` varchar(3) DEFAULT NULL,
  `a14` varchar(3) DEFAULT NULL,
  `a15` varchar(3) DEFAULT NULL,
  `a16` varchar(3) DEFAULT NULL,
  `a17` varchar(3) DEFAULT NULL,
  `a18` varchar(3) DEFAULT NULL,
  `a19` varchar(3) DEFAULT NULL,
  `a20` varchar(3) DEFAULT NULL,
  `a21` varchar(3) DEFAULT NULL,
  `a22` varchar(3) DEFAULT NULL,
  `a23` varchar(3) DEFAULT NULL,
  `a24` varchar(3) DEFAULT NULL,
  `a25` varchar(3) DEFAULT NULL,
  `a26` varchar(3) DEFAULT NULL,
  `a27` varchar(3) DEFAULT NULL,
  `a28` varchar(3) DEFAULT NULL,
  `a29` varchar(3) DEFAULT NULL,
  `a30` varchar(3) DEFAULT NULL,
  `a31` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`attendanceID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `attendance` (`attendanceID`, `schoolyearID`, `studentID`, `classesID`, `sectionID`, `userID`, `usertype`, `monthyear`, `a1`, `a2`, `a3`, `a4`, `a5`, `a6`, `a7`, `a8`, `a9`, `a10`, `a11`, `a12`, `a13`, `a14`, `a15`, `a16`, `a17`, `a18`, `a19`, `a20`, `a21`, `a22`, `a23`, `a24`, `a25`, `a26`, `a27`, `a28`, `a29`, `a30`, `a31`) VALUES (1, 4, 1, 10, 10, 1, 'Admin', '03-2024', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL);
INSERT INTO `attendance` (`attendanceID`, `schoolyearID`, `studentID`, `classesID`, `sectionID`, `userID`, `usertype`, `monthyear`, `a1`, `a2`, `a3`, `a4`, `a5`, `a6`, `a7`, `a8`, `a9`, `a10`, `a11`, `a12`, `a13`, `a14`, `a15`, `a16`, `a17`, `a18`, `a19`, `a20`, `a21`, `a22`, `a23`, `a24`, `a25`, `a26`, `a27`, `a28`, `a29`, `a30`, `a31`) VALUES (2, 4, 1, 10, 10, 1, 'Admin', '04-2024', NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: automation_rec
#

DROP TABLE IF EXISTS `automation_rec`;

CREATE TABLE `automation_rec` (
  `automation_recID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `studentID` int(11) NOT NULL,
  `date` date NOT NULL,
  `day` varchar(3) NOT NULL,
  `month` varchar(3) NOT NULL,
  `year` year(4) NOT NULL,
  `nofmodule` int(11) NOT NULL,
  PRIMARY KEY (`automation_recID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: automation_shudulu
#

DROP TABLE IF EXISTS `automation_shudulu`;

CREATE TABLE `automation_shudulu` (
  `automation_shuduluID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `day` varchar(3) NOT NULL,
  `month` varchar(3) NOT NULL,
  `year` year(4) NOT NULL,
  PRIMARY KEY (`automation_shuduluID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: book
#

DROP TABLE IF EXISTS `book`;

CREATE TABLE `book` (
  `bookID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `book` varchar(60) NOT NULL,
  `subject_code` tinytext NOT NULL,
  `author` varchar(100) NOT NULL,
  `price` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `due_quantity` int(11) NOT NULL,
  `rack` tinytext NOT NULL,
  PRIMARY KEY (`bookID`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (1, 'KLB TOP SCHOLAR -IRE', '605', 'MWANAIDI LYANI', 0, 15, 1, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (2, 'OXFORD HEADSTART-ENGLISH', '601', 'ANGELINA KIOKO', 0, 20, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (3, 'KLB TOP-SCHOLAR - CRE', '605', 'JANE NTAARI', 0, 20, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (4, 'STORY MOJA SPARK -AGRICULTURE', '604', 'JANE MUINDE', 0, 20, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (5, 'MORAN -SOCIAL STUDIES', '605', 'FERDINANDA GACHANG\'I', 0, 18, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (6, 'KLB TOP-SCHOLAR-IRE', '605', 'IDRIS MATSUKHU', 0, 10, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (7, 'MTP HOMESCIENCE', '604', 'MTP', 0, 20, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (8, 'KLB TOP- SCHOLAR-PRE-TECHNICAL', '606', 'OMUKAGA .O.PANYAKO', 0, 20, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (9, 'OXFORD BUSINESS TODAY', '605', 'KENNETH MBUVI', 0, 20, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (10, 'KLB TOP SCHOLAR PRE-TECHINICAL', '606', 'OMUKAGA .O.PANYAKO', 0, 25, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (11, 'SPOTLIGHT- MATHEMATICS', '603', 'BONIFACE TINEGA', 0, 20, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (12, 'KLB TOP-SCHOLAR-C.R.E', '605', 'PHILOMENA.N.MWAURA', 0, 15, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (13, 'MORAN SKILLS IN ENGLISH', '601', 'DIANE OMONDI', 0, 25, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (14, 'SPOTLIGHT- MATHEMATICS G7', '603', 'BONIFACE TINEGA', 0, 25, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (15, 'KLB TOP-SCHOLAR COMPUTER SCIENCE', '606', 'DOROTHY OCHIENG', 0, 20, 0, 'GARDE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (16, 'KLB TOP-SCHOLAR-PHYSICAL EDUCATION AND SPORTS', '604', 'RUTH KAHIGA', 0, 10, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (17, 'OXFORD KISWAHILI', '602', 'AHMED SHIKUKU', 0, 20, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (18, 'KLB TOP SCHOLAR COMPUTER SCIENCE', '606', 'DOROTHY ALOUCH', 0, 20, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (19, 'KLB TOP SCHOLAR COMPUTER SCIENCE 8', '606', 'DOROTHY ALOUCH', 0, 20, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (20, 'OXFORD INTERGRATED SCIENCE', '604', 'JACOB ODHIAMBO', 0, 25, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (21, 'MENTOR HOMESCIENCE', '604', 'ESTHER KARANJA', 0, 10, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (23, 'SMART MINDS SOCIAL STUDIES', '605', 'MOSES ONYANCHA', 0, 20, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (24, 'KLB TOP-SCHOLAR KISWAHILI', '602', 'MUTAHI MIRICHO', 0, 25, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (25, 'MTP BUSINESS STUDIES', '606', 'MTP', 0, 25, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (26, 'MENTOR INTERGRATED SCIENCE', '606', 'C KOGI', 0, 20, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (27, 'STORY MOJA -SPARK AGRICULTURE', '604', 'STORY MOJA', 0, 25, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (28, 'STORY MOJA -SPARK AGRICULTURE G7', '604', 'STORY MOJA', 0, 25, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (29, 'MORAN PUBLISHERS-THRIVING LIFE SKILLS EDUCATION', '605', 'MORAN', 0, 20, 0, 'GRADE 7');


#
# TABLE STRUCTURE FOR: candidate
#

DROP TABLE IF EXISTS `candidate`;

CREATE TABLE `candidate` (
  `candidateID` int(11) NOT NULL AUTO_INCREMENT,
  `studentID` int(11) NOT NULL,
  `verified_by` varchar(100) NOT NULL,
  `date_verification` date DEFAULT NULL,
  `schoolyearID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`candidateID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: category
#

DROP TABLE IF EXISTS `category`;

CREATE TABLE `category` (
  `categoryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hostelID` int(11) NOT NULL,
  `class_type` varchar(60) NOT NULL,
  `hbalance` varchar(20) NOT NULL,
  `note` text,
  PRIMARY KEY (`categoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: certificate_template
#

DROP TABLE IF EXISTS `certificate_template`;

CREATE TABLE `certificate_template` (
  `certificate_templateID` int(11) NOT NULL AUTO_INCREMENT,
  `usertypeID` int(11) NOT NULL,
  `name` varchar(60) NOT NULL,
  `theme` int(11) NOT NULL,
  `top_heading_title` text,
  `top_heading_left` text,
  `top_heading_right` text,
  `top_heading_middle` text,
  `main_middle_text` text NOT NULL,
  `template` text NOT NULL,
  `footer_left_text` text,
  `footer_right_text` text,
  `footer_middle_text` text,
  `background_image` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`certificate_templateID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: childcare
#

DROP TABLE IF EXISTS `childcare`;

CREATE TABLE `childcare` (
  `childcareID` int(11) NOT NULL AUTO_INCREMENT,
  `dropped_at` datetime DEFAULT NULL,
  `received_at` datetime DEFAULT NULL,
  `usertypeID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `parentID` int(11) NOT NULL,
  `signature` text,
  `classesID` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `comment` text,
  `received_status` int(11) NOT NULL DEFAULT '0',
  `receiver_name` varchar(40) NOT NULL,
  `phone` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`childcareID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: classes
#

DROP TABLE IF EXISTS `classes`;

CREATE TABLE `classes` (
  `classesID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `classes` varchar(60) NOT NULL,
  `classes_numeric` int(11) NOT NULL,
  `teacherID` int(11) NOT NULL,
  `studentmaxID` int(11) DEFAULT NULL,
  `note` text,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_username` varchar(60) NOT NULL,
  `create_usertype` varchar(60) NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  PRIMARY KEY (`classesID`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `classes` (`classesID`, `classes`, `classes_numeric`, `teacherID`, `studentmaxID`, `note`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`, `start_time`, `end_time`) VALUES (9, 'GRADE 7', 1, 28, 999999999, '', '2021-09-18 07:11:27', '2024-02-28 08:53:33', 1, 'skooly', 'Admin', '06:00:00', '03:00:00');
INSERT INTO `classes` (`classesID`, `classes`, `classes_numeric`, `teacherID`, `studentmaxID`, `note`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`, `start_time`, `end_time`) VALUES (10, 'GRADE 8', 2, 28, 999999999, '', '2021-09-18 07:11:53', '2024-02-28 08:53:41', 1, 'skooly', 'Admin', '03:00:00', '03:00:00');


#
# TABLE STRUCTURE FOR: clock_in_out
#

DROP TABLE IF EXISTS `clock_in_out`;

CREATE TABLE `clock_in_out` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attendanceID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `check_date` date NOT NULL,
  `clock_in` time DEFAULT NULL,
  `clock_out` time DEFAULT NULL,
  `last_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (1, 1, 1, 3, '2024-03-28', '08:18:13', '08:18:28', '2024-03-28 05:18:28');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (2, 1, 4, 11, '2024-03-28', '08:24:30', NULL, '2024-03-28 05:24:30');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (3, 2, 1, 3, '2024-04-02', '10:46:03', NULL, '2024-04-02 07:46:03');


#
# TABLE STRUCTURE FOR: complain
#

DROP TABLE IF EXISTS `complain`;

CREATE TABLE `complain` (
  `complainID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `userID` int(11) DEFAULT NULL,
  `schoolyearID` int(11) DEFAULT NULL,
  `description` text,
  `attachment` text,
  `originalfile` text,
  `create_userID` int(11) NOT NULL DEFAULT '0',
  `create_usertypeID` int(11) NOT NULL DEFAULT '0',
  `create_date` datetime DEFAULT NULL,
  `modify_date` datetime DEFAULT NULL,
  PRIMARY KEY (`complainID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conversation_message_info
#

DROP TABLE IF EXISTS `conversation_message_info`;

CREATE TABLE `conversation_message_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` int(11) DEFAULT '0',
  `draft` int(11) DEFAULT '0',
  `fav_status` int(11) DEFAULT '0',
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conversation_msg
#

DROP TABLE IF EXISTS `conversation_msg`;

CREATE TABLE `conversation_msg` (
  `msg_id` int(11) NOT NULL AUTO_INCREMENT,
  `conversation_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `msg` text NOT NULL,
  `attach` text,
  `attach_file_name` text,
  `usertypeID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `start` int(11) DEFAULT NULL,
  PRIMARY KEY (`msg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conversation_user
#

DROP TABLE IF EXISTS `conversation_user`;

CREATE TABLE `conversation_user` (
  `conversation_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `is_sender` int(11) DEFAULT '0',
  `trash` int(11) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: document
#

DROP TABLE IF EXISTS `document`;

CREATE TABLE `document` (
  `documentID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(128) CHARACTER SET utf8 NOT NULL,
  `file` varchar(200) CHARACTER SET utf8 NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`documentID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: eattendance
#

DROP TABLE IF EXISTS `eattendance`;

CREATE TABLE `eattendance` (
  `eattendanceID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `examID` int(11) NOT NULL,
  `classesID` int(11) NOT NULL,
  `sectionID` int(11) NOT NULL,
  `subjectID` int(11) NOT NULL,
  `date` date NOT NULL,
  `studentID` int(11) DEFAULT NULL,
  `s_name` varchar(60) DEFAULT NULL,
  `eattendance` varchar(20) DEFAULT NULL,
  `year` year(4) NOT NULL,
  `eextra` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`eattendanceID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (1, 4, 1, 10, 10, 121, '2024-03-23', 1, 'JULIE SAGA HANS', NULL, '2024', NULL);
INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (2, 4, 1, 10, 10, 121, '2024-03-23', 4, 'BLESSING LUYAI', NULL, '2024', NULL);
INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (3, 4, 1, 10, 10, 121, '2024-03-23', 9, 'MICHAEL FREDRICK', NULL, '2024', NULL);
INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (4, 4, 1, 10, 10, 121, '2024-03-23', 11, 'N’NJEMA ISABEL', NULL, '2024', NULL);
INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (5, 4, 1, 10, 10, 121, '2024-03-23', 13, 'ALI WASILWA PAKIA', NULL, '2024', NULL);
INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (6, 4, 1, 10, 10, 121, '2024-03-23', 15, 'ISSA HAMAD', NULL, '2024', NULL);
INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (7, 4, 1, 10, 10, 121, '2024-03-23', 18, 'ALMASI MALAU', NULL, '2024', NULL);
INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (8, 4, 1, 10, 10, 121, '2024-03-23', 19, 'BRIAN KIOKO', NULL, '2024', NULL);
INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (9, 4, 1, 10, 10, 121, '2024-03-23', 46, 'LINDA MAUA', NULL, '2024', NULL);


#
# TABLE STRUCTURE FOR: ebooks
#

DROP TABLE IF EXISTS `ebooks`;

CREATE TABLE `ebooks` (
  `ebooksID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `author` varchar(255) NOT NULL,
  `classesID` int(11) NOT NULL,
  `authority` tinyint(4) NOT NULL DEFAULT '0',
  `cover_photo` varchar(200) NOT NULL,
  `file` varchar(200) NOT NULL,
  PRIMARY KEY (`ebooksID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: emailsetting
#

DROP TABLE IF EXISTS `emailsetting`;

CREATE TABLE `emailsetting` (
  `fieldoption` varchar(100) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`fieldoption`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `emailsetting` (`fieldoption`, `value`) VALUES ('email_engine', 'sendmail');
INSERT INTO `emailsetting` (`fieldoption`, `value`) VALUES ('smtp_password', '');
INSERT INTO `emailsetting` (`fieldoption`, `value`) VALUES ('smtp_port', '');
INSERT INTO `emailsetting` (`fieldoption`, `value`) VALUES ('smtp_security', '');
INSERT INTO `emailsetting` (`fieldoption`, `value`) VALUES ('smtp_server', '');
INSERT INTO `emailsetting` (`fieldoption`, `value`) VALUES ('smtp_username', ' ');


#
# TABLE STRUCTURE FOR: event
#

DROP TABLE IF EXISTS `event`;

CREATE TABLE `event` (
  `eventID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fdate` date NOT NULL,
  `ftime` time NOT NULL,
  `tdate` date NOT NULL,
  `ttime` time NOT NULL,
  `title` varchar(128) NOT NULL,
  `details` text NOT NULL,
  `photo` varchar(200) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `create_userID` int(11) NOT NULL DEFAULT '0',
  `create_usertypeID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`eventID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: eventcounter
#

DROP TABLE IF EXISTS `eventcounter`;

CREATE TABLE `eventcounter` (
  `eventcounterID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eventID` int(11) NOT NULL,
  `username` varchar(40) NOT NULL,
  `type` varchar(20) NOT NULL,
  `name` varchar(128) NOT NULL,
  `photo` varchar(200) DEFAULT NULL,
  `status` int(11) NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`eventcounterID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: exam
#

DROP TABLE IF EXISTS `exam`;

CREATE TABLE `exam` (
  `examID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `exam` varchar(60) NOT NULL,
  `date` date NOT NULL,
  `note` text,
  PRIMARY KEY (`examID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `exam` (`examID`, `exam`, `date`, `note`) VALUES (1, 'FIRST TERM 2024', '2024-02-29', '');


#
# TABLE STRUCTURE FOR: examschedule
#

DROP TABLE IF EXISTS `examschedule`;

CREATE TABLE `examschedule` (
  `examscheduleID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `examID` int(11) NOT NULL,
  `classesID` int(11) NOT NULL,
  `sectionID` int(11) NOT NULL,
  `subjectID` int(11) NOT NULL,
  `edate` date NOT NULL,
  `examfrom` varchar(10) NOT NULL,
  `examto` varchar(10) NOT NULL,
  `room` tinytext,
  `schoolyearID` int(11) NOT NULL,
  PRIMARY KEY (`examscheduleID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `examschedule` (`examscheduleID`, `examID`, `classesID`, `sectionID`, `subjectID`, `edate`, `examfrom`, `examto`, `room`, `schoolyearID`) VALUES (1, 1, 10, 10, 121, '2024-03-29', '7:45 PM', '7:45 PM', '', 4);
INSERT INTO `examschedule` (`examscheduleID`, `examID`, `classesID`, `sectionID`, `subjectID`, `edate`, `examfrom`, `examto`, `room`, `schoolyearID`) VALUES (2, 1, 10, 10, 122, '2024-03-25', '7:15 PM', '7:15 PM', '', 4);


#
# TABLE STRUCTURE FOR: expense
#

DROP TABLE IF EXISTS `expense`;

CREATE TABLE `expense` (
  `expenseID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `create_date` date NOT NULL,
  `date` date NOT NULL,
  `expenseday` varchar(11) NOT NULL,
  `expensemonth` varchar(11) NOT NULL,
  `expenseyear` year(4) NOT NULL,
  `expense` varchar(128) NOT NULL,
  `amount` double NOT NULL,
  `file` varchar(200) DEFAULT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `uname` varchar(60) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `note` text,
  PRIMARY KEY (`expenseID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: feetypes
#

DROP TABLE IF EXISTS `feetypes`;

CREATE TABLE `feetypes` (
  `feetypesID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `feetypes` varchar(60) NOT NULL,
  `note` text,
  PRIMARY KEY (`feetypesID`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8;

INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (1, 'TUITION FEES', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (2, 'ADMISSION FEES', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (3, 'BOARDING', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (4, 'TRANSPORT', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (5, 'TEXTBOOK FUND', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (6, 'UNIFORMS', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (7, 'LAUNDRY', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (8, 'OTHER CHARGES', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (60, 'PREVIOUS BALANCE', '');


#
# TABLE STRUCTURE FOR: fmenu
#

DROP TABLE IF EXISTS `fmenu`;

CREATE TABLE `fmenu` (
  `fmenuID` int(11) NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(128) NOT NULL,
  `status` int(11) NOT NULL COMMENT 'Only for active',
  `topbar` int(11) NOT NULL,
  `social` int(11) NOT NULL,
  PRIMARY KEY (`fmenuID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: fmenu_relation
#

DROP TABLE IF EXISTS `fmenu_relation`;

CREATE TABLE `fmenu_relation` (
  `fmenu_relationID` int(11) NOT NULL AUTO_INCREMENT,
  `fmenuID` int(11) DEFAULT NULL,
  `menu_typeID` int(11) DEFAULT NULL COMMENT '1 => Pages, 2 => Post, 3 => Links',
  `menu_parentID` varchar(128) DEFAULT NULL,
  `menu_orderID` int(11) DEFAULT NULL,
  `menu_pagesID` int(11) DEFAULT NULL,
  `menu_label` varchar(254) DEFAULT NULL,
  `menu_link` text NOT NULL,
  `menu_rand` varchar(128) DEFAULT NULL,
  `menu_rand_parentID` varchar(128) DEFAULT NULL,
  `menu_status` int(11) DEFAULT NULL,
  PRIMARY KEY (`fmenu_relationID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: frontend_setting
#

DROP TABLE IF EXISTS `frontend_setting`;

CREATE TABLE `frontend_setting` (
  `fieldoption` varchar(100) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`fieldoption`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('break', '30');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('description', '');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('facebook', '');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('google', '');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('linkedin', '');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('login_menu_status', '1');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('lunch', '60');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('online_admission_status', '0');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('teacher_email_status', '0');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('teacher_phone_status', '0');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('twitter', '');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('youtube', '');


#
# TABLE STRUCTURE FOR: frontend_template
#

DROP TABLE IF EXISTS `frontend_template`;

CREATE TABLE `frontend_template` (
  `frontend_templateID` int(11) NOT NULL AUTO_INCREMENT,
  `template_name` varchar(128) NOT NULL,
  PRIMARY KEY (`frontend_templateID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (1, 'home');
INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (2, 'about');
INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (3, 'event');
INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (4, 'teacher');
INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (5, 'gallery');
INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (6, 'notice');
INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (7, 'blog');
INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (8, 'contact');
INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (9, 'admission');


#
# TABLE STRUCTURE FOR: globalpayment
#

DROP TABLE IF EXISTS `globalpayment`;

CREATE TABLE `globalpayment` (
  `globalpaymentID` int(11) NOT NULL AUTO_INCREMENT,
  `classesID` int(11) DEFAULT NULL,
  `sectionID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `clearancetype` varchar(40) NOT NULL,
  `invoicename` varchar(128) NOT NULL,
  `invoicedescription` varchar(128) NOT NULL,
  `paymentyear` varchar(5) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `schooltermID` int(11) DEFAULT NULL,
  PRIMARY KEY (`globalpaymentID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (1, 9, 23, 2, 'partial', '002-SALIM. N. MWAKIKOI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (2, 9, 23, 10, 'partial', '010-EVANS MUTUA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (3, 9, 23, 24, 'paid', '024-TYRESE KITHUNGA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (4, 9, 21, 47, 'partial', '0047-LATIFFA BRIGIT MATASA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (5, 9, 21, 3, 'paid', '003-EMMANUEL MWANGI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (6, 10, 10, 9, 'paid', '009-MICHAEL FREDRICK', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (7, 10, 10, 9, 'paid', '009-MICHAEL FREDRICK', '', '2024', 4, 3);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (8, 9, 21, 3, 'paid', '003-EMMANUEL MWANGI', '', '2024', 4, 3);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (9, 9, 23, 2, 'partial', '002-SALIM. N. MWAKIKOI', '', '2024', 4, 1);


#
# TABLE STRUCTURE FOR: grade
#

DROP TABLE IF EXISTS `grade`;

CREATE TABLE `grade` (
  `gradeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `grade` varchar(60) NOT NULL,
  `point` varchar(11) NOT NULL,
  `gradefrom` int(11) NOT NULL,
  `gradeupto` int(11) NOT NULL,
  `note` text,
  PRIMARY KEY (`gradeID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `grade` (`gradeID`, `grade`, `point`, `gradefrom`, `gradeupto`, `note`) VALUES (1, 'EE', '4', 80, 100, 'EXCEEDING EXPECTATION');
INSERT INTO `grade` (`gradeID`, `grade`, `point`, `gradefrom`, `gradeupto`, `note`) VALUES (2, 'ME', '3', 60, 79, 'MEETING EXPECTATION');
INSERT INTO `grade` (`gradeID`, `grade`, `point`, `gradefrom`, `gradeupto`, `note`) VALUES (3, 'AE', '2', 40, 59, 'APPROACHING EXPECTATION');
INSERT INTO `grade` (`gradeID`, `grade`, `point`, `gradefrom`, `gradeupto`, `note`) VALUES (4, 'BE', '1', 0, 39, 'BELOW EXPECTATION');


#
# TABLE STRUCTURE FOR: hmember
#

DROP TABLE IF EXISTS `hmember`;

CREATE TABLE `hmember` (
  `hmemberID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hostelID` int(11) NOT NULL,
  `categoryID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `hbalance` varchar(20) DEFAULT NULL,
  `hjoindate` date NOT NULL,
  PRIMARY KEY (`hmemberID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: holiday
#

DROP TABLE IF EXISTS `holiday`;

CREATE TABLE `holiday` (
  `holidayID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `fdate` date NOT NULL,
  `tdate` date NOT NULL,
  `title` varchar(128) NOT NULL,
  `details` text NOT NULL,
  `photo` varchar(200) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL DEFAULT '0',
  `create_usertypeID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`holidayID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: hostel
#

DROP TABLE IF EXISTS `hostel`;

CREATE TABLE `hostel` (
  `hostelID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `htype` varchar(11) NOT NULL,
  `address` varchar(200) NOT NULL,
  `note` text,
  PRIMARY KEY (`hostelID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: hourly_template
#

DROP TABLE IF EXISTS `hourly_template`;

CREATE TABLE `hourly_template` (
  `hourly_templateID` int(11) NOT NULL AUTO_INCREMENT,
  `hourly_grades` varchar(128) NOT NULL,
  `hourly_rate` int(11) NOT NULL,
  PRIMARY KEY (`hourly_templateID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `incomeID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `date` date NOT NULL,
  `incomeday` varchar(11) NOT NULL,
  `incomemonth` varchar(11) NOT NULL,
  `incomeyear` year(4) NOT NULL,
  `amount` double NOT NULL,
  `file` varchar(200) NOT NULL,
  `note` text NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `create_date` date NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`incomeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: ini_config
#

DROP TABLE IF EXISTS `ini_config`;

CREATE TABLE `ini_config` (
  `configID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `config_key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`configID`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;

INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (1, 'paypal', 'paypal_api_username', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (2, 'paypal', 'paypal_api_password', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (3, 'paypal', 'paypal_api_signature', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (4, 'paypal', 'paypal_email', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (5, 'paypal', 'paypal_demo', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (6, 'stripe', 'stripe_secret', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (7, 'stripe', 'stripe_key', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (8, 'stripe', 'stripe_demo', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (9, 'payumoney', 'payumoney_key', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (10, 'payumoney', 'payumoney_salt', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (11, 'payumoney', 'payumoney_demo', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (12, 'paypal', 'paypal_status', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (13, 'stripe', 'stripe_status', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (14, 'payumoney', 'payumoney_status', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (15, 'voguepay', 'voguepay_merchant_id', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (16, 'voguepay', 'voguepay_merchant_ref', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (17, 'voguepay', 'voguepay_developer_code', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (18, 'voguepay', 'voguepay_demo', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (19, 'voguepay', 'voguepay_status', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (20, 'mpesa', 'mpesa_key', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (21, 'mpesa', 'mpesa_secret', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (22, 'mpesa', 'mpesa_password', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (23, 'mpesa', 'mpesa_status', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (24, 'mpesa', 'mpesa_demo', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (25, 'mpesa', 'mpesa_shortcode', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (26, 'settings', 'footer_message', '<b>Powered By Skooly<b>');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (27, 'settings', 'top_message', '<strong>PAYBILL:</strong> 247247 <br>\r\n<strong>ACC:</strong> 833822# Class ADM NO.<br>\r\n<strong>EQUITY:</strong> 0440284742769');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (28, 'stripe', 'stripe_key', '');


#
# TABLE STRUCTURE FOR: instruction
#

DROP TABLE IF EXISTS `instruction`;

CREATE TABLE `instruction` (
  `instructionID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(512) NOT NULL,
  `content` text NOT NULL,
  PRIMARY KEY (`instructionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: invoice
#

DROP TABLE IF EXISTS `invoice`;

CREATE TABLE `invoice` (
  `invoiceID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `schooltermID` int(11) DEFAULT NULL,
  `classesID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `feetypeID` int(11) DEFAULT NULL,
  `feetype` varchar(128) NOT NULL,
  `amount` double NOT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `userID` int(11) DEFAULT NULL,
  `usertypeID` int(11) DEFAULT NULL,
  `uname` varchar(60) DEFAULT NULL,
  `date` date NOT NULL,
  `create_date` date NOT NULL,
  `day` varchar(20) DEFAULT NULL,
  `month` varchar(20) DEFAULT NULL,
  `year` year(4) NOT NULL,
  `paidstatus` int(11) DEFAULT NULL,
  `deleted_at` int(11) NOT NULL DEFAULT '1',
  `maininvoiceID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`invoiceID`)
) ENGINE=InnoDB AUTO_INCREMENT=214 DEFAULT CHARSET=utf8;

INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (1, 4, 2, 9, 3, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 1);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (2, 4, 2, 9, 3, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 1);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (3, 4, 2, 9, 3, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 1);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (4, 4, 2, 9, 5, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 2);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (5, 4, 2, 9, 5, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 2);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (6, 4, 2, 9, 5, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 2);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (7, 4, 2, 9, 6, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 3);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (8, 4, 2, 9, 6, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 3);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (9, 4, 2, 9, 6, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 3);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (10, 4, 2, 9, 7, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 4);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (11, 4, 2, 9, 7, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 4);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (12, 4, 2, 9, 7, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 4);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (13, 4, 2, 9, 26, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 5);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (14, 4, 2, 9, 26, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 5);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (15, 4, 2, 9, 26, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 5);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (16, 4, 2, 9, 22, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 6);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (17, 4, 2, 9, 22, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 6);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (18, 4, 2, 9, 22, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 6);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (19, 4, 2, 9, 27, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 7);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (20, 4, 2, 9, 27, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 7);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (21, 4, 2, 9, 27, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 7);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (22, 4, 2, 9, 31, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 8);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (23, 4, 2, 9, 31, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 8);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (24, 4, 2, 9, 31, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 8);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (28, 4, 2, 9, 35, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 10);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (29, 4, 2, 9, 35, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 10);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (30, 4, 2, 9, 35, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 10);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (31, 4, 2, 9, 38, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 11);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (32, 4, 2, 9, 38, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 11);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (33, 4, 2, 9, 38, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 11);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (37, 4, 2, 9, 48, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 13);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (38, 4, 2, 9, 48, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 13);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (39, 4, 2, 9, 48, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 13);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (40, 4, 2, 10, 13, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 14);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (41, 4, 2, 10, 13, 4, 'TRANSPORT', '6000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 14);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (42, 4, 2, 10, 13, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 14);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (51, 4, 2, 10, 15, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 17);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (52, 4, 2, 10, 15, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 17);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (53, 4, 2, 10, 15, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 17);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (54, 4, 2, 10, 19, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 18);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (55, 4, 2, 10, 19, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 18);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (56, 4, 2, 10, 19, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 18);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (57, 4, 2, 10, 13, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 0, 19);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (58, 4, 2, 10, 13, 4, 'TRANSPORT', '6000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 0, 19);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (59, 4, 2, 10, 13, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 0, 19);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (60, 4, 2, 9, 10, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1, 20);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (61, 4, 2, 9, 10, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1, 20);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (62, 4, 2, 9, 10, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 20);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (63, 4, 2, 9, 16, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 21);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (64, 4, 2, 9, 16, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 21);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (65, 4, 2, 9, 16, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 21);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (72, 4, 2, 9, 8, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 24);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (73, 4, 2, 9, 8, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 24);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (74, 4, 2, 9, 8, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 24);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (75, 4, 2, 9, 8, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 24);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (76, 4, 2, 9, 14, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 25);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (77, 4, 2, 9, 14, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 25);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (78, 4, 2, 9, 14, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 25);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (79, 4, 2, 9, 14, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 25);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (80, 4, 2, 9, 23, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 26);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (81, 4, 2, 9, 23, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 26);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (82, 4, 2, 9, 23, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 26);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (83, 4, 2, 9, 23, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 26);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (84, 4, 2, 9, 24, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 27);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (85, 4, 2, 9, 24, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 27);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (86, 4, 2, 9, 24, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 27);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (87, 4, 2, 9, 24, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 27);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (88, 4, 2, 9, 36, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 28);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (89, 4, 2, 9, 36, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 28);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (90, 4, 2, 9, 36, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 28);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (91, 4, 2, 9, 36, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 28);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (92, 4, 2, 9, 2, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1, 29);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (93, 4, 2, 9, 2, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1, 29);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (94, 4, 2, 9, 2, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 29);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (95, 4, 2, 9, 2, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 29);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (96, 4, 2, 9, 39, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 30);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (97, 4, 2, 9, 39, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 30);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (98, 4, 2, 9, 39, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 30);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (99, 4, 2, 9, 39, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 30);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (100, 4, 2, 9, 40, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 31);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (101, 4, 2, 9, 40, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 31);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (102, 4, 2, 9, 40, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 31);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (103, 4, 2, 9, 40, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 31);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (104, 4, 2, 10, 9, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 32);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (105, 4, 2, 10, 9, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 32);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (106, 4, 2, 10, 9, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 32);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (107, 4, 2, 10, 9, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 32);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (108, 4, 2, 9, 33, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 33);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (109, 4, 2, 9, 33, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 33);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (110, 4, 2, 9, 33, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 33);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (111, 4, 2, 9, 33, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 33);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (112, 4, 2, 9, 44, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 34);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (113, 4, 2, 9, 44, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 34);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (114, 4, 2, 9, 44, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 34);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (115, 4, 2, 9, 44, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 34);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (116, 4, 2, 9, 45, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 35);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (117, 4, 2, 9, 45, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 35);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (118, 4, 2, 9, 45, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 35);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (119, 4, 2, 9, 45, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 35);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (122, 4, 2, 9, 20, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 37);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (123, 4, 2, 9, 20, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 37);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (124, 4, 2, 9, 34, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 38);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (125, 4, 2, 9, 34, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 38);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (126, 4, 2, 10, 4, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 39);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (127, 4, 2, 10, 4, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 39);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (128, 4, 2, 10, 4, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 39);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (129, 4, 2, 10, 11, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 40);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (130, 4, 2, 10, 11, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 40);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (131, 4, 2, 10, 11, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 40);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (132, 4, 2, 10, 18, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 41);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (133, 4, 2, 10, 18, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 41);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (134, 4, 2, 10, 18, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 41);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (135, 4, 2, 9, 47, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 42);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (136, 4, 2, 9, 47, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 42);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (137, 4, 2, 9, 47, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 42);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (138, 4, 2, 9, 30, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 43);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (139, 4, 2, 9, 30, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 43);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (140, 4, 2, 9, 30, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 43);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (144, 4, 2, 9, 21, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 45);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (145, 4, 2, 9, 21, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 45);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (146, 4, 2, 9, 21, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 45);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (150, 4, 2, 9, 29, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 47);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (151, 4, 2, 9, 29, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 47);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (152, 4, 2, 9, 29, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 47);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (159, 4, 2, 9, 25, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 46);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (160, 4, 2, 9, 25, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 46);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (161, 4, 2, 9, 25, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 46);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (162, 4, 2, 9, 25, 60, 'PREVIOUS BALANCE', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 46);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (163, 4, 2, 9, 32, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 9);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (164, 4, 2, 9, 32, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 9);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (165, 4, 2, 9, 32, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 9);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (166, 4, 2, 9, 32, 60, 'PREVIOUS BALANCE', '6500', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 9);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (167, 4, 2, 9, 41, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 12);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (168, 4, 2, 9, 41, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 12);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (169, 4, 2, 9, 41, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 12);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (170, 4, 2, 9, 41, 60, 'PREVIOUS BALANCE', '20900', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 12);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (171, 4, 2, 9, 42, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 23);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (172, 4, 2, 9, 42, 4, 'TRANSPORT', '6000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 23);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (173, 4, 2, 9, 42, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 23);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (174, 4, 2, 9, 42, 60, 'PREVIOUS BALANCE', '21500', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 23);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (175, 4, 2, 9, 43, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 49);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (176, 4, 2, 9, 43, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 49);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (177, 4, 2, 9, 43, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 49);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (178, 4, 2, 9, 43, 60, 'PREVIOUS BALANCE', '22000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 49);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (179, 4, 2, 9, 12, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 48);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (180, 4, 2, 9, 12, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 48);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (181, 4, 2, 9, 12, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 48);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (182, 4, 2, 9, 12, 60, 'PREVIOUS BALANCE', '15500', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 48);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (183, 4, 2, 9, 17, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 36);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (184, 4, 2, 9, 17, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 36);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (185, 4, 2, 9, 17, 60, 'PREVIOUS BALANCE', '1500', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 36);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (186, 4, 2, 9, 28, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 22);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (187, 4, 2, 9, 28, 4, 'TRANSPORT', '6000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 22);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (188, 4, 2, 9, 28, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 22);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (189, 4, 2, 9, 28, 60, 'PREVIOUS BALANCE', '7500', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 22);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (190, 4, 2, 9, 37, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 44);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (191, 4, 2, 9, 37, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 44);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (192, 4, 2, 9, 37, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 44);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (193, 4, 2, 9, 37, 60, 'PREVIOUS BALANCE', '21000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 44);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (194, 4, 3, 10, 9, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 50);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (195, 4, 3, 10, 9, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 50);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (196, 4, 3, 10, 9, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 50);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (197, 4, 3, 10, 9, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 50);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (198, 4, 3, 9, 3, 1, 'TUITION FEES', '32000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 51);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (199, 4, 3, 9, 3, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 51);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (200, 4, 3, 9, 3, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 51);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (201, 4, 2, 10, 46, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 16);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (202, 4, 2, 10, 46, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 16);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (203, 4, 2, 10, 46, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 16);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (204, 4, 2, 10, 46, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 16);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (209, 4, 2, 10, 1, 1, 'TUITION FEES', '35000', '100', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 15);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (210, 4, 2, 10, 1, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 15);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (211, 4, 2, 10, 1, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 15);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (212, 4, 2, 10, 1, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1, 15);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (213, 4, 1, 9, 2, 1, 'TUITION FEES', '30000', '0', 1, 1, 'Skooly', '2024-04-02', '2024-04-02', '02', '04', '2024', 1, 1, 52);


#
# TABLE STRUCTURE FOR: issue
#

DROP TABLE IF EXISTS `issue`;

CREATE TABLE `issue` (
  `issueID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lID` varchar(128) NOT NULL,
  `bookID` int(11) NOT NULL,
  `serial_no` varchar(40) NOT NULL,
  `issue_date` date NOT NULL,
  `due_date` date NOT NULL,
  `return_date` date DEFAULT NULL,
  `note` text,
  PRIMARY KEY (`issueID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (1, '2', 1, 'av/01/20/2024', '2024-04-17', '2024-05-10', NULL, 'in good condition');


#
# TABLE STRUCTURE FOR: leaveapplications
#

DROP TABLE IF EXISTS `leaveapplications`;

CREATE TABLE `leaveapplications` (
  `leaveapplicationID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `leavecategoryID` int(10) unsigned NOT NULL,
  `apply_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `od_status` tinyint(1) NOT NULL DEFAULT '0',
  `from_date` date NOT NULL,
  `from_time` time DEFAULT NULL,
  `to_date` date NOT NULL,
  `to_time` time DEFAULT NULL,
  `leave_days` int(11) NOT NULL,
  `reason` text,
  `attachment` varchar(200) DEFAULT NULL,
  `attachmentorginalname` varchar(200) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(10) unsigned NOT NULL,
  `applicationto_userID` int(10) unsigned DEFAULT NULL,
  `applicationto_usertypeID` int(10) unsigned DEFAULT NULL,
  `approver_userID` int(10) unsigned DEFAULT NULL,
  `approver_usertypeID` int(10) unsigned DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `schoolyearID` int(11) NOT NULL,
  PRIMARY KEY (`leaveapplicationID`),
  KEY `leave_categoryID` (`leavecategoryID`),
  KEY `from_date` (`from_date`),
  KEY `to_date` (`to_date`),
  KEY `approver_userID` (`approver_userID`),
  KEY `approver_usertypeID` (`approver_usertypeID`),
  KEY `applicationto_usertypeID` (`applicationto_usertypeID`),
  KEY `applicationto_userID` (`applicationto_userID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: leaveassign
#

DROP TABLE IF EXISTS `leaveassign`;

CREATE TABLE `leaveassign` (
  `leaveassignID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `leavecategoryID` int(10) unsigned NOT NULL,
  `usertypeID` int(10) unsigned NOT NULL,
  `leaveassignday` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`leaveassignID`),
  KEY `leave_categoryID` (`leavecategoryID`),
  KEY `usertypeID` (`usertypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: leavecategory
#

DROP TABLE IF EXISTS `leavecategory`;

CREATE TABLE `leavecategory` (
  `leavecategoryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `leavecategory` varchar(255) NOT NULL,
  `leavegender` int(11) DEFAULT '0' COMMENT '1 = General, 2 = Male, 3 = Femele',
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`leavecategoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: lmember
#

DROP TABLE IF EXISTS `lmember`;

CREATE TABLE `lmember` (
  `lmemberID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lID` varchar(40) NOT NULL,
  `studentID` int(11) NOT NULL,
  `name` varchar(60) NOT NULL,
  `email` varchar(40) DEFAULT NULL,
  `phone` tinytext,
  `lbalance` varchar(20) DEFAULT NULL,
  `ljoindate` date NOT NULL,
  PRIMARY KEY (`lmemberID`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8;

INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (1, '001', 1, 'JULIE SAGA HANS', '001@email.com', '0723821682', '0.00', '2024-03-08');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (2, '002', 2, 'SALIM. N. MWAKIKOI', '002@email.com', '0721242304', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (3, '003', 3, 'EMMANUEL MWANGI', '003@email.com', '0718559574', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (4, '005', 5, 'LIAM KIRUHI KAMWERU', '005@email.com', '0710847382', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (5, '006', 6, 'ESTHER MUENI', '006@email.com', '0722275523', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (6, '007', 7, 'JUMA SWALEH', '007@email.com', '0725847742', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (7, '008', 8, 'MARYLNE NJOKI', '008@email.com', '0724729313', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (8, '010', 10, 'EVANS MUTUA', '010@email.com', '0725736549', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (9, '012', 12, 'YUSUF MWINYI', '012@email.com', '0720416331', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (10, '014', 14, 'RICHARD MSOMI', '014@email.com', '0791356119', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (11, '016', 16, 'ALI SAID', '016@email.com', '0720470947', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (12, '017', 17, 'RANDANI KASSIM', '017@email.com', '0714566632', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (13, '020', 20, 'ZAINAB SALIM', '020@email.com', '0712061423', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (14, '021', 21, 'DELPHINE KHALAI', '021@email.com', '0721297829', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (15, '022', 22, 'ISAACK MULEI', '022@email.com', '0724596068', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (16, '023', 23, 'YOHANN’S MUGO', '023@email.com', '0728812791', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (17, '024', 24, 'TYRESE KITHUNGA', '024@email.com', '0723202044', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (18, '025', 25, 'YVONNE KAMENE', '025@email.com', '0728340284', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (19, '026', 26, 'WENDY NDUKU', '026@email.com', '072044052', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (20, '027', 27, 'CHELSEA JULIA', '027@email.com', '0715017692', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (21, '028', 28, 'SHAUN MATHEKA', '028@email.com', '0728577762', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (22, '038', 38, 'ADELIGHT FURAHA', '038@email.com', '0721992929', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (23, '037', 37, 'KHADIJA JUMA', '037@email.com', '0700488072', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (24, '036', 36, 'FORTUNE KAITHYA', '036@email.com', '0721374654', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (25, '035', 35, 'LOUIS KITSAO', '035@email.com', '0705562938', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (26, '029', 29, 'ASHLEY NELIMA', '029@email.com', '0726565822', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (27, '030', 30, 'VANESSA WANGU', '030@email.com', '0720453785', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (28, '031', 31, 'OPRAH WANGARE', '031@email.com', '0724700760', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (29, '032', 32, 'ROBIN  BAYA EDWIN MISTANZE', '032@email.com', '07022208172', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (30, '033', 33, 'LIONELL KADIEDA', '033@email.com', '0713562695', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (31, '034', 34, 'SANDRA NASIKE', '034@email.com', '0722730248', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (32, '048', 48, 'RAINER KIMILU', '048@email.com', '0799212822', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (33, '047', 47, 'LATIFFA BRIGIT MATASA', '047@email.com', '0723342467', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (34, '045', 45, 'LISSY IVY', '045@email.com', '0721970074', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (35, '044', 44, 'ISMAILMGANDI', '044@email.com', '0726370674', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (36, '043', 43, 'KHERI MWANGAZA', '043@email.com', '0720092398', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (37, '042', 42, 'BENJAMIN\nMUTHOMI', '042@email.com', '0743061566', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (38, '041', 41, 'SULEIMANABDALLAH', '041@email.com', '0716781801', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (39, '040', 40, 'SEMIGIL KOOME', '040@email.com', '0712977566', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (40, '039', 39, 'SASHA PEARL', '039@email.com', '0737142919', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (41, '004', 4, 'BLESSING LUYAI', '004@email.com', '0111252511', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (42, '009', 9, 'MICHAEL FREDRICK', '009@email.com', '0721843049', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (43, '011', 11, 'N’NJEMA ISABEL', '011@email.com', '0700494066', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (44, '013', 13, 'ALI WASILWA PAKIA', '013@email.com', '0721212078', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (45, '015', 15, 'ISSA HAMAD', '015@email.com', '0792103291', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (46, '018', 18, 'ALMASI MALAU', '018@email.com', '0797902314', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (47, '019', 19, 'BRIAN KIOKO', '019@email.com', '0726485462,0721894090', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (48, '046', 46, 'LINDA MAUA', '046@email.com', '0721536537', '0.00', '2024-04-17');


#
# TABLE STRUCTURE FOR: location
#

DROP TABLE IF EXISTS `location`;

CREATE TABLE `location` (
  `locationID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `location` varchar(128) NOT NULL,
  `description` text,
  `create_date` date NOT NULL,
  `modify_date` date NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  `active` int(11) NOT NULL,
  PRIMARY KEY (`locationID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: loginlog
#

DROP TABLE IF EXISTS `loginlog`;

CREATE TABLE `loginlog` (
  `loginlogID` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(45) DEFAULT NULL,
  `browser` varchar(128) DEFAULT NULL,
  `operatingsystem` varchar(128) DEFAULT NULL,
  `login` int(10) unsigned DEFAULT NULL,
  `logout` int(10) unsigned DEFAULT NULL,
  `usertypeID` int(11) DEFAULT NULL,
  `userID` int(11) DEFAULT NULL,
  PRIMARY KEY (`loginlogID`)
) ENGINE=InnoDB AUTO_INCREMENT=367 DEFAULT CHARSET=utf8;

INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (1, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709146232, 1709146532, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (2, '102.222.4.116', 'Mozilla Firefox', 'linux', 1709192323, 1709192623, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (3, '102.222.4.116', 'Mozilla Firefox', 'linux', 1709200202, 1709200502, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (4, '102.222.4.116', 'Google Chrome', 'linux', 1709200954, 1709201254, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (5, '102.222.4.116', 'Google Chrome', 'linux', 1709200955, 1709201255, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (6, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709484669, 1709485054, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (7, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709485062, 1709485181, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (8, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709485184, 1709486386, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (9, '102.213.176.14', 'Google Chrome', 'linux', 1709485696, 1709485996, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (10, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709486396, 1709486420, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (11, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709486424, 1709486689, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (12, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709486699, 1709486751, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (13, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709486753, 1709486894, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (14, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709486896, 1709486938, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (15, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709486951, 1709486992, 2, 28);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (16, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709487003, 1709487026, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (17, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709487029, 1709487109, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (18, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709487120, 1709487155, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (19, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709491141, 1709491441, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (20, '41.90.5.7', 'Mozilla Firefox', 'linux', 1709542732, 1709544128, 2, 32);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (21, '41.90.5.7', 'Mozilla Firefox', 'linux', 1709544131, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (22, '102.222.4.116', 'Google Chrome', 'linux', 1709544246, 1709544348, 2, 32);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (23, '102.222.4.116', 'Google Chrome', 'linux', 1709544360, 1709544554, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (24, '41.90.5.51', 'Mozilla Firefox', 'Unknown', 1709544501, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (25, '102.222.4.116', 'Google Chrome', 'linux', 1709544780, NULL, 2, 32);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (26, '41.90.5.136', 'Mozilla Firefox', 'linux', 1709546902, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (27, '102.222.4.116', 'Google Chrome', 'windows', 1709551298, 1709551598, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (28, '196.201.210.106', 'Mozilla Firefox', 'linux', 1709628121, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (29, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709712929, 1709722099, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (30, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709722108, 1709722212, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (31, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709722217, 1709722978, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (32, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709722983, 1709723283, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (33, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709723117, 1709723417, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (34, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709723364, 1709723664, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (35, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709723487, 1709723787, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (36, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709723548, 1709723848, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (37, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709723635, 1709723935, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (38, '102.213.176.14', 'Google Chrome', 'linux', 1709731472, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (39, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709731612, 1709732441, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (40, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709732652, 1709732952, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (41, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709733951, 1709734251, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (42, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709743033, 1709746510, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (43, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709746521, 1709746588, 2, 30);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (44, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709746617, 1709747804, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (45, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709747815, 1709748201, 2, 32);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (46, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709748203, 1709748503, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (47, '196.201.210.122', 'Mozilla Firefox', 'Unknown', 1709797729, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (48, '102.222.4.116', 'Google Chrome', 'windows', 1709804982, 1709805651, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (49, '105.161.138.197', 'Mozilla Firefox', 'linux', 1709805314, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (50, '102.222.4.116', 'Google Chrome', 'windows', 1709805671, 1709805971, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (51, '102.222.4.116', 'Google Chrome', 'linux', 1709806692, 1709806992, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (52, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709823000, 1709823300, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (53, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709866380, 1709866680, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (54, '105.161.45.13', 'Mozilla Firefox', 'Unknown', 1709876586, 1709876886, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (55, '105.161.45.13', 'Mozilla Firefox', 'linux', 1709882999, 1709883438, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (56, '105.161.45.13', 'Mozilla Firefox', 'linux', 1709883441, 1709883741, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (57, '102.222.4.116', 'Google Chrome', 'windows', 1709886012, 1709886965, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (58, '105.161.45.13', 'Mozilla Firefox', 'linux', 1709886312, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (59, '102.222.4.116', 'Google Chrome', 'windows', 1709886974, 1709887274, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (60, '102.222.4.116', 'Google Chrome', 'linux', 1709887599, 1709888706, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (61, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709917352, 1709917652, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (62, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709918573, 1709918873, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (63, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1709920025, 1709920325, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (64, '102.222.4.116', 'Google Chrome', 'windows', 1710140671, 1710140971, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (65, '102.222.4.116', 'Google Chrome', 'windows', 1710140822, 1710141122, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (66, '102.222.4.116', 'Google Chrome', 'windows', 1710140825, 1710141125, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (67, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710211976, 1710212276, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (68, '102.222.4.116', 'Google Chrome', 'windows', 1710329797, 1710331865, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (69, '102.222.4.116', 'Google Chrome', 'windows', 1710331919, 1710333080, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (70, '41.81.83.42', 'Mozilla Firefox', 'Unknown', 1710333813, 1710333847, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (71, '41.81.83.42', 'Mozilla Firefox', 'Unknown', 1710333924, 1710333984, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (72, '41.81.83.42', 'Mozilla Firefox', 'Unknown', 1710333997, 1710335576, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (73, '41.81.83.42', 'Mozilla Firefox', 'Unknown', 1710335666, NULL, 2, 30);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (74, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710350220, 1710350520, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (75, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710351322, 1710351373, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (76, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710351382, 1710351387, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (77, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710351395, 1710351418, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (78, '102.222.4.116', 'Google Chrome', 'windows', 1710390031, 1710390490, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (79, '102.222.4.116', 'Google Chrome', 'windows', 1710390501, 1710390801, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (80, '102.222.4.116', 'Google Chrome', 'windows', 1710390775, 1710391075, 2, 30);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (81, '105.160.89.101', 'Mozilla Firefox', 'Unknown', 1710391829, 1710392030, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (82, '105.160.89.101', 'Mozilla Firefox', 'Unknown', 1710392046, NULL, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (83, '102.222.4.116', 'Google Chrome', 'linux', 1710392423, 1710392723, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (84, '102.222.4.116', 'Google Chrome', 'linux', 1710395398, 1710396603, 2, 30);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (85, '102.222.4.116', 'Google Chrome', 'linux', 1710396631, 1710396931, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (86, '102.222.4.116', 'Google Chrome', 'windows', 1710397298, 1710397598, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (87, '102.222.4.116', 'Google Chrome', 'linux', 1710398003, 1710398303, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (88, '102.222.4.116', 'Google Chrome', 'linux', 1710400881, 1710401181, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (89, '102.222.4.116', 'Google Chrome', 'windows', 1710404739, 1710405039, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (90, '41.90.4.127', 'Google Chrome', 'linux', 1710407905, NULL, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (91, '62.24.116.41', 'Google Chrome', 'windows', 1710416312, NULL, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (92, '102.222.4.116', 'Google Chrome', 'linux', 1710418748, 1710419048, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (93, '102.222.4.116', 'Google Chrome', 'linux', 1710418749, 1710419049, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (94, '102.222.4.116', 'Google Chrome', 'windows', 1710422583, 1710422883, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (95, '102.222.4.116', 'Google Chrome', 'linux', 1710423772, 1710423840, 2, 30);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (96, '102.222.4.116', 'Google Chrome', 'linux', 1710423852, 1710424446, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (97, '102.222.4.116', 'Google Chrome', 'linux', 1710424454, 1710424754, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (98, '102.222.4.116', 'Google Chrome', 'windows', 1710433100, 1710433400, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (99, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1710437471, 1710437771, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (100, '154.159.254.181', 'Google Chrome', 'linux', 1710471341, NULL, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (101, '154.159.254.202', 'Google Chrome', 'linux', 1710475781, NULL, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (102, '102.222.4.116', 'Google Chrome', 'windows', 1710476877, 1710479288, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (103, '102.222.4.116', 'Google Chrome', 'windows', 1710479327, 1710480006, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (104, '102.222.4.116', 'Google Chrome', 'windows', 1710480018, 1710480318, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (105, '102.222.4.116', 'Google Chrome', 'linux', 1710485154, 1710485454, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (106, '105.49.172.92', 'Mozilla Firefox', 'Unknown', 1710487715, 1710490349, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (107, '105.49.172.92', 'Mozilla Firefox', 'Unknown', 1710490368, NULL, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (108, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710493841, 1710497551, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (109, '102.222.4.116', 'Google Chrome', 'linux', 1710494360, 1710494660, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (110, '102.222.4.116', 'Google Chrome', 'windows', 1710494555, 1710494855, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (111, '102.222.4.116', 'Google Chrome', 'linux', 1710495119, 1710496459, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (112, '102.222.4.116', 'Google Chrome', 'linux', 1710496524, 1710496964, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (113, '102.222.4.116', 'Google Chrome', 'linux', 1710497023, 1710499115, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (114, '102.222.4.116', 'Google Chrome', 'linux', 1710497179, 1710497479, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (115, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710497928, 1710502523, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (116, '102.222.4.116', 'Google Chrome', 'windows', 1710499145, 1710502776, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (117, '102.222.4.116', 'Google Chrome', 'linux', 1710499171, 1710499500, 2, 30);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (118, '102.222.4.116', 'Google Chrome', 'linux', 1710499680, 1710500445, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (119, '102.222.4.116', 'Google Chrome', 'linux', 1710500459, 1710500759, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (120, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710502569, 1710502596, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (121, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710502609, 1710502621, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (122, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710502628, 1710502722, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (123, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710502753, 1710503190, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (124, '102.222.4.116', 'Google Chrome', 'linux', 1710502796, 1710503096, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (125, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710503201, 1710503417, 2, 28);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (126, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710503420, 1710503428, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (127, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710503436, 1710503818, 2, 28);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (128, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710503822, 1710504122, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (129, '102.222.4.116', 'Google Chrome', 'windows', 1710504028, 1710506168, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (130, '102.222.4.116', 'Google Chrome', 'windows', 1710506182, 1710506224, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (131, '102.222.4.116', 'Google Chrome', 'windows', 1710506232, 1710506236, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (132, '102.222.4.116', 'Google Chrome', 'windows', 1710506398, 1710506594, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (133, '196.201.210.179', 'Google Chrome', 'linux', 1710506561, 1710506609, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (134, '102.222.4.116', 'Google Chrome', 'windows', 1710506618, 1710506697, 2, 28);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (135, '102.222.4.116', 'Google Chrome', 'windows', 1710506710, 1710506727, 2, 28);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (136, '102.222.4.116', 'Google Chrome', 'windows', 1710506776, 1710506835, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (137, '102.222.4.116', 'Mozilla Firefox', 'Unknown', 1710507132, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (138, '196.201.210.179', 'Google Chrome', 'linux', 1710507384, 1710507569, 9, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (139, '196.201.210.179', 'Google Chrome', 'linux', 1710507573, NULL, 9, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (140, '102.222.4.116', 'Google Chrome', 'windows', 1710509770, 1710510070, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (141, '102.222.4.116', 'Google Chrome', 'windows', 1710563097, 1710565011, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (142, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710564099, 1710565618, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (143, '102.222.4.116', 'Google Chrome', 'windows', 1710565045, 1710565181, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (144, '102.222.4.116', 'Google Chrome', 'windows', 1710565195, 1710565495, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (145, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710565626, 1710565926, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (146, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710566860, 1710567481, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (147, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710567738, 1710567776, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (148, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710567951, 1710568251, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (149, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710568418, 1710568718, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (150, '102.222.4.116', 'Google Chrome', 'linux', 1710577943, 1710578243, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (151, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710581930, 1710582230, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (152, '102.222.4.116', 'Google Chrome', 'windows', 1710585546, 1710585846, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (153, '102.222.4.116', 'Google Chrome', 'windows', 1710585546, 1710746321, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (154, '105.164.143.31', 'Mozilla Firefox', 'linux', 1710684797, 1710685984, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (155, '105.164.143.31', 'Mozilla Firefox', 'linux', 1710685993, 1710686050, 2, 32);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (156, '105.164.143.31', 'Mozilla Firefox', 'linux', 1710686053, 1710686477, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (157, '105.164.143.31', 'Mozilla Firefox', 'linux', 1710686490, NULL, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (158, '105.161.89.250', 'Mozilla Firefox', 'linux', 1710700649, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (159, '102.222.4.116', 'Google Chrome', 'windows', 1710740933, 1710741233, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (160, '102.222.4.116', 'Google Chrome', 'windows', 1710741154, 1710741454, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (161, '102.222.4.116', 'Google Chrome', 'linux', 1710744202, 1710744502, 9, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (162, '102.222.4.116', 'Google Chrome', 'windows', 1710744471, 1710744771, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (163, '102.222.4.116', 'Google Chrome', 'windows', 1710746332, 1710746352, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (164, '102.222.4.116', 'Google Chrome', 'windows', 1710746363, 1710746663, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (165, '102.222.4.116', 'Google Chrome', 'windows', 1710758361, 1710758661, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (166, '102.222.4.116', 'Google Chrome', 'windows', 1710767380, 1710767680, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (167, '102.222.4.116', 'Google Chrome', 'linux', 1710821600, 1710821900, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (168, '102.222.4.116', 'Google Chrome', 'linux', 1710826923, 1710827223, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (169, '102.222.4.116', 'Google Chrome', 'linux', 1710830037, 1710830337, 9, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (170, '102.222.4.116', 'Google Chrome', 'windows', 1710831941, 1710832241, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (171, '102.222.4.116', 'Google Chrome', 'linux', 1710834099, 1710834399, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (172, '102.222.4.116', 'Google Chrome', 'windows', 1710835265, 1710835286, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (173, '102.222.4.116', 'Google Chrome', 'windows', 1710835290, 1710835590, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (174, '102.222.4.116', 'Google Chrome', 'windows', 1710838815, 1710839741, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (175, '102.222.4.116', 'Google Chrome', 'windows', 1710839346, 1710839646, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (176, '154.159.252.5', 'Google Chrome', 'windows', 1710846113, 1710846413, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (177, '102.222.4.116', 'Google Chrome', 'linux', 1710847138, 1710847884, 9, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (178, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710847224, 1710847524, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (179, '102.222.4.116', 'Google Chrome', 'linux', 1710847888, 1710848236, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (180, '102.222.4.116', 'Google Chrome', 'linux', 1710848242, 1710848542, 9, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (181, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710855743, 1710855788, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (182, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710855803, 1710856103, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (183, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710857718, 1710860518, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (184, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710860540, 1710860563, 2, 32);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (185, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710860588, 1710861125, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (186, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710861128, 1710862642, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (187, '154.159.252.5', 'Google Chrome', 'windows', 1710861481, 1710861781, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (188, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710862691, 1710862991, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (189, '102.135.168.106', 'Mozilla Firefox', 'Unknown', 1710862766, 1710862994, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (190, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710863056, NULL, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (191, '154.159.252.5', 'Google Chrome', 'windows', 1710868865, 1710869165, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (192, '102.222.4.116', 'Google Chrome', 'windows', 1710908344, 1710911414, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (193, '154.159.252.5', 'Google Chrome', 'windows', 1710928396, 1710928696, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (194, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710986530, 1710993611, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (195, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710993620, 1710994503, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (196, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710994518, 1710994818, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (197, '102.222.4.116', 'Google Chrome', 'linux', 1711035069, 1711035369, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (198, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711077007, 1711077307, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (199, '102.222.4.116', 'Google Chrome', 'linux', 1711083916, 1711084216, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (200, '102.222.4.116', 'Google Chrome', 'linux', 1711083917, 1711084217, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (201, '102.222.4.116', 'Google Chrome', 'windows', 1711092012, 1711092312, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (202, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711093642, 1711093922, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (203, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711093933, 1711095019, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (204, '102.222.4.116', 'Google Chrome', 'linux', 1711096803, 1711097103, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (205, '154.159.252.5', 'Google Chrome', 'windows', 1711096911, 1711097211, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (206, '102.222.4.116', 'Google Chrome', 'windows', 1711098548, 1711098848, 2, 28);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (207, '154.159.252.5', 'Google Chrome', 'windows', 1711105709, 1711106009, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (208, '102.222.4.116', 'Google Chrome', 'windows', 1711113762, 1711115691, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (209, '154.159.252.5', 'Google Chrome', 'windows', 1711121956, 1711122256, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (210, '154.159.252.5', 'Google Chrome', 'windows', 1711132448, 1711132748, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (211, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711141670, 1711141970, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (212, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711164789, 1711165089, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (213, '102.222.4.116', 'Google Chrome', 'linux', 1711169209, 1711169509, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (214, '102.222.4.116', 'Google Chrome', 'windows', 1711171806, 1711171840, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (215, '102.222.4.116', 'Google Chrome', 'windows', 1711180230, NULL, 2, 28);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (216, '154.159.252.5', 'Google Chrome', 'windows', 1711186062, 1711186362, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (217, '102.222.4.116', 'Google Chrome', 'windows', 1711190052, 1711190352, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (218, '102.222.4.116', 'Google Chrome', 'windows', 1711190684, 1711190927, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (219, '102.222.4.116', 'Google Chrome', 'windows', 1711190931, 1711191231, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (220, '102.222.4.116', 'Google Chrome', 'linux', 1711192774, 1711193074, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (221, '154.159.252.5', 'Google Chrome', 'windows', 1711196056, 1711196356, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (222, '154.159.252.5', 'Google Chrome', 'windows', 1711204166, 1711204466, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (223, '41.215.120.114', 'Mozilla Firefox', 'linux', 1711204696, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (224, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711209996, 1711210296, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (225, '154.159.252.5', 'Google Chrome', 'windows', 1711215601, 1711215901, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (226, '102.222.4.116', 'Google Chrome', 'linux', 1711284552, 1711284852, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (227, '105.161.213.190', 'Google Chrome', 'linux', 1711292051, NULL, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (228, '102.222.4.116', 'Google Chrome', 'linux', 1711345550, 1711345850, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (229, '102.222.4.116', 'Google Chrome', 'linux', 1711345745, 1711346045, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (230, '102.222.4.116', 'Google Chrome', 'windows', 1711346359, 1711346546, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (231, '102.222.4.116', 'Google Chrome', 'windows', 1711346560, 1711346860, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (232, '102.222.4.116', 'Google Chrome', 'windows', 1711346889, 1711349659, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (233, '102.222.4.116', 'Google Chrome', 'linux', 1711347495, 1711347795, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (234, '102.222.4.116', 'Google Chrome', 'windows', 1711350894, 1711352208, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (235, '102.222.4.116', 'Google Chrome', 'windows', 1711357168, 1711357468, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (236, '102.222.4.116', 'Google Chrome', 'linux', 1711357298, 1711357598, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (237, '102.222.4.116', 'Google Chrome', 'windows', 1711358063, 1711358363, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (238, '102.222.4.116', 'Google Chrome', 'linux', 1711358712, 1711359012, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (239, '102.222.4.116', 'Google Chrome', 'linux', 1711359077, 1711359377, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (240, '102.222.4.116', 'Google Chrome', 'linux', 1711360834, 1711361134, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (241, '102.222.4.116', 'Google Chrome', 'windows', 1711372656, 1711372832, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (242, '102.222.4.116', 'Google Chrome', 'windows', 1711372841, 1711373141, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (243, '102.222.4.116', 'Google Chrome', 'linux', 1711437595, 1711437895, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (244, '102.222.4.116', 'Google Chrome', 'windows', 1711449475, 1711449621, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (245, '102.222.4.116', 'Google Chrome', 'windows', 1711449682, 1711449982, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (246, '154.159.252.5', 'Google Chrome', 'windows', 1711458342, 1711458642, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (247, '102.222.4.116', 'Google Chrome', 'linux', 1711460734, 1711461034, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (248, '102.222.4.116', 'Google Chrome', 'linux', 1711515631, 1711515931, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (249, '154.159.254.158', 'Google Chrome', 'linux', 1711518018, NULL, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (250, '102.222.4.116', 'Google Chrome', 'windows', 1711522434, 1711527251, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (251, '154.159.252.5', 'Google Chrome', 'windows', 1711525337, 1711526155, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (252, '154.159.252.5', 'Google Chrome', 'windows', 1711526158, 1711526458, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (253, '102.222.4.116', 'Google Chrome', 'windows', 1711527261, 1711527561, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (254, '102.222.4.116', 'Google Chrome', 'linux', 1711527902, 1711528202, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (255, '102.222.4.116', 'Google Chrome', 'linux', 1711530216, 1711530516, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (256, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711532859, 1711536118, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (257, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711536122, 1711536422, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (258, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711536517, 1711543850, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (259, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711543867, 1711544069, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (260, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711544073, 1711544222, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (261, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711544233, 1711544255, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (262, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711544264, 1711545235, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (263, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711545245, 1711545641, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (264, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711545653, 1711546629, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (265, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711546633, 1711560927, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (266, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711560937, 1711560977, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (267, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711560982, 1711561064, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (268, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711561068, 1711567494, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (269, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711567499, 1711567526, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (270, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711567539, 1711570365, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (271, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711570370, 1711570423, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (272, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711570428, 1711570464, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (273, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711570475, 1711571431, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (274, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711571449, 1711571621, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (275, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711571625, 1711573867, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (276, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711573872, 1711575911, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (277, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711575915, 1711575923, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (278, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711575936, 1711575945, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (279, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711575954, 1711576839, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (280, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711576842, 1711577019, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (281, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711577027, 1711577785, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (282, '154.159.252.5', 'Google Chrome', 'windows', 1711577152, 1711577750, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (283, '154.159.252.5', 'Google Chrome', 'windows', 1711577754, 1711578054, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (284, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711577789, 1711579706, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (285, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711579711, 1711579718, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (286, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711579732, 1711582280, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (287, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711582284, 1711582840, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (288, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711582851, 1711583151, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (289, '102.222.4.116', 'Google Chrome', 'windows', 1711599773, 1711607419, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (290, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711601601, 1711602593, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (291, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711602603, 1711602687, 9, 13);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (292, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711602695, 1711602875, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (293, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711602884, 1711603070, 9, 13);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (294, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1711603021, 1711603321, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (295, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711603074, 1711603225, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (296, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711603235, 1711603263, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (297, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711603272, 1711603287, 2, 29);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (298, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711603291, 1711603312, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (299, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711603337, 1711603354, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (300, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711603363, 1711603395, 2, 34);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (301, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711603400, 1711604253, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (302, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711604271, 1711608383, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (303, '102.222.4.116', 'Google Chrome', 'windows', 1711607472, 1711608782, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (304, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711608388, 1711611926, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (305, '102.222.4.116', 'Google Chrome', 'windows', 1711608841, 1711609141, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (306, '102.222.4.116', 'Google Chrome', 'linux', 1711610809, 1711611405, 3, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (307, '154.159.252.5', 'Google Chrome', 'windows', 1711611424, 1711611673, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (308, '154.159.252.5', 'Google Chrome', 'windows', 1711611681, 1711611981, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (309, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711611931, 1711611947, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (310, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711612001, 1711612171, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (311, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711612176, 1711612489, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (312, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711612497, 1711612797, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (313, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1711612961, 1711612975, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (314, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1711612985, 1711613557, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (315, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711613561, 1711619412, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (316, '105.161.107.254', 'Google Chrome', 'linux', 1711616169, NULL, 3, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (317, '102.222.4.116', 'Google Chrome', 'windows', 1711616713, NULL, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (318, '102.222.4.116', 'Google Chrome', 'windows', 1711618473, 1711619310, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (319, '102.222.4.116', 'Google Chrome', 'linux', 1711618572, 1711618872, 9, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (320, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711619421, 1711619440, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (321, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711619451, 1711619837, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (322, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711619841, 1711620723, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (323, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711620726, 1711624864, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (324, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711624871, 1711624944, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (325, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711624953, 1711628238, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (326, '209.222.101.90', 'Google Chrome', 'windows', 1711625061, NULL, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (327, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711628247, 1711628928, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (328, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711628932, 1711628938, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (329, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711628948, 1711629248, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (330, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1711629174, 1711629605, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (331, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711629609, 1711630780, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (332, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711630788, 1711631088, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (333, '154.159.252.5', 'Google Chrome', 'windows', 1711663624, 1711663924, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (334, '102.222.4.116', 'Google Chrome', 'windows', 1711691292, 1711691433, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (335, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711692468, 1711692619, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (336, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711692625, 1711693013, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (337, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711693017, 1711693317, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (338, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1711696907, 1711696960, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (339, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1711696982, 1711697282, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (340, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711772665, 1711773376, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (341, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711773383, 1711775851, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (342, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711775877, 1711776177, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (343, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711954322, 1711954622, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (344, '102.213.176.14', 'Mozilla Firefox', 'linux', 1712030911, 1712031211, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (345, '196.101.169.149', 'Google Chrome', 'linux', 1712033263, NULL, 3, 34);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (346, '105.160.121.140', 'Google Chrome', 'windows', 1712041011, 1712041311, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (347, '154.159.252.5', 'Google Chrome', 'windows', 1712042080, NULL, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (348, '105.160.121.140', 'Google Chrome', 'linux', 1712043925, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (349, '102.222.4.116', 'Google Chrome', 'windows', 1712135876, NULL, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (350, '102.222.4.116', 'Google Chrome', 'windows', 1712227074, 1712227374, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (351, '154.159.252.5', 'Google Chrome', 'windows', 1712237867, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (352, '102.222.4.116', 'Google Chrome', 'windows', 1712300499, NULL, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (353, '154.159.254.112', 'Google Chrome', 'linux', 1712741633, NULL, 3, 34);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (354, '102.22.152.135', 'Google Chrome', 'linux', 1712745691, NULL, 3, 34);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (355, '102.222.4.116', 'Google Chrome', 'linux', 1713090686, 1713090725, 9, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (356, '197.254.77.166', 'Mozilla Firefox', 'linux', 1713164375, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (357, '102.222.4.116', 'Google Chrome', 'windows', 1713332312, 1713332608, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (358, '102.213.176.14', 'Mozilla Firefox', 'linux', 1713332541, 1713332841, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (359, '102.222.4.116', 'Google Chrome', 'windows', 1713332739, 1713333039, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (360, '102.222.4.116', 'Google Chrome', 'windows', 1713505771, NULL, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (361, '154.159.254.17', 'Google Chrome', 'linux', 1713620163, NULL, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (362, '105.160.47.245', 'Mozilla Firefox', 'linux', 1713950561, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (363, '154.159.254.245', 'Google Chrome', 'linux', 1714045953, NULL, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (364, '154.159.254.218', 'Google Chrome', 'linux', 1714045989, NULL, 2, 28);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (365, '102.213.176.14', 'Mozilla Firefox', 'linux', 1714193349, 1714193649, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (366, '102.213.176.14', 'Mozilla Firefox', 'linux', 1714281477, NULL, 1, 1);


#
# TABLE STRUCTURE FOR: lunch_setting
#

DROP TABLE IF EXISTS `lunch_setting`;

CREATE TABLE `lunch_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `break` double(10,2) NOT NULL,
  `lunch` double(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `lunch_setting` (`id`, `break`, `lunch`) VALUES (1, '70.00', '40.00');


#
# TABLE STRUCTURE FOR: lunchlogs
#

DROP TABLE IF EXISTS `lunchlogs`;

CREATE TABLE `lunchlogs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amount` double(10,2) DEFAULT NULL,
  `studentID` int(11) DEFAULT NULL,
  `schoolyearID` int(11) NOT NULL DEFAULT '3',
  `type` varchar(20) DEFAULT NULL,
  `referenceno` varchar(20) DEFAULT NULL,
  `time` time DEFAULT NULL,
  `date` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: mailandsms
#

DROP TABLE IF EXISTS `mailandsms`;

CREATE TABLE `mailandsms` (
  `mailandsmsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `usertypeID` int(11) NOT NULL,
  `users` text NOT NULL,
  `type` varchar(16) NOT NULL,
  `senderusertypeID` int(11) NOT NULL,
  `senderID` int(11) NOT NULL,
  `message` text NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `year` year(4) NOT NULL,
  PRIMARY KEY (`mailandsmsID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (1, 0, 'SANDRA NASIKE', 'Automated', 1, 1, 'Dear Guardian, the account for SANDRA NASIKE , ADM 034 has been credited with 5000 at 13:47:01 on 10/04/2024. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-04-10 10:47:01', '2024');


#
# TABLE STRUCTURE FOR: mailandsmstemplate
#

DROP TABLE IF EXISTS `mailandsmstemplate`;

CREATE TABLE `mailandsmstemplate` (
  `mailandsmstemplateID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `type` varchar(10) NOT NULL,
  `template` text NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`mailandsmstemplateID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `mailandsmstemplate` (`mailandsmstemplateID`, `name`, `usertypeID`, `type`, `template`, `create_date`) VALUES (1, 'FEES BALANCE REMINDER', 3, 'sms', 'Dear Parent/ Guardian. Please clear the fees balance of [name] ADM [register_no] with a balance of KSHS [balance] to avoid your child being sent home. Ignore if you have cleared. For queries contact our office +254 796 047 282 AVEON SCHOOLS. Powered by SKOOLY.', '2023-03-31 02:54:10');


#
# TABLE STRUCTURE FOR: mailandsmstemplatetag
#

DROP TABLE IF EXISTS `mailandsmstemplatetag`;

CREATE TABLE `mailandsmstemplatetag` (
  `mailandsmstemplatetagID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `usertypeID` int(11) NOT NULL,
  `tagname` varchar(128) NOT NULL,
  `mailandsmstemplatetag_extra` varchar(255) DEFAULT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`mailandsmstemplatetagID`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8;

INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (1, 1, '[name]', NULL, '2016-12-10 14:36:33');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (2, 1, '[dob]', NULL, '2016-12-10 14:37:31');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (3, 1, '[gender]', NULL, '2016-12-10 14:37:31');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (4, 1, '[religion]', NULL, '2016-12-10 14:39:51');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (5, 1, '[email]', NULL, '2016-12-10 14:39:51');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (6, 1, '[phone]', NULL, '2016-12-10 14:39:51');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (7, 1, '[address]', NULL, '2016-12-10 14:39:51');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (8, 1, '[jod]', NULL, '2016-12-10 14:39:51');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (9, 1, '[username]', NULL, '2016-12-10 14:39:51');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (10, 2, '[name]', NULL, '2016-12-10 14:40:50');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (11, 2, '[designation]', NULL, '2016-12-10 14:43:27');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (12, 2, '[dob]', NULL, '2016-12-10 14:46:21');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (13, 2, '[gender]', NULL, '2016-12-10 14:46:21');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (14, 2, '[religion]', NULL, '2016-12-10 14:46:21');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (15, 2, '[email]', NULL, '2016-12-10 14:46:21');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (16, 2, '[phone]', NULL, '2016-12-10 14:46:21');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (17, 2, '[address]', NULL, '2016-12-10 14:46:21');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (18, 2, '[jod]', NULL, '2016-12-10 14:46:21');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (19, 2, '[username]', NULL, '2016-12-10 14:46:21');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (20, 3, '[name]', NULL, '2016-12-10 14:47:09');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (21, 3, '[dob]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (22, 3, '[gender]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (23, 3, '[blood_group]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (24, 3, '[religion]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (25, 3, '[email]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (26, 3, '[phone]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (27, 3, '[address]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (28, 3, '[state]', NULL, '2017-02-11 12:21:49');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (29, 3, '[country]', NULL, '2017-02-11 12:21:27');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (30, 3, '[class]', NULL, '2016-12-18 15:34:20');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (31, 3, '[section]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (32, 3, '[group]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (33, 3, '[optional_subject]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (34, 3, '[register_no]', NULL, '2017-02-11 12:21:27');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (35, 3, '[roll]', NULL, '2017-02-11 12:22:56');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (36, 3, '[extra_curricular_activities]', NULL, '2017-02-11 12:22:56');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (37, 3, '[remarks]', NULL, '2017-02-11 12:22:56');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (38, 3, '[username]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (39, 3, '[result_table]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (40, 4, '[name]', NULL, '2016-12-10 14:57:31');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (41, 4, '[father\'s_name]', NULL, '2016-12-10 15:04:19');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (42, 4, '[mother\'s_name]', NULL, '2016-12-10 15:04:19');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (43, 4, '[father\'s_profession]', NULL, '2016-12-10 15:04:19');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (44, 4, '[mother\'s_profession]', NULL, '2016-12-10 15:04:19');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (45, 4, '[email]', NULL, '2016-12-10 15:04:19');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (46, 4, '[phone]', NULL, '2016-12-10 15:04:19');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (47, 4, '[address]', NULL, '2016-12-10 15:04:19');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (48, 4, '[username]', NULL, '2016-12-10 15:04:19');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (49, 1, '[date]', NULL, '2018-05-11 04:12:12');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (50, 2, '[date]', NULL, '2018-05-11 04:12:27');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (51, 3, '[date]', NULL, '2018-05-11 04:12:36');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (52, 4, '[date]', NULL, '2018-05-11 04:12:49');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (53, 3, '[balance]', NULL, '2018-05-11 04:12:36');


#
# TABLE STRUCTURE FOR: maininvoice
#

DROP TABLE IF EXISTS `maininvoice`;

CREATE TABLE `maininvoice` (
  `maininvoiceID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `maininvoiceschoolyearID` int(11) NOT NULL,
  `maininvoiceschooltermID` int(11) DEFAULT NULL,
  `maininvoiceclassesID` int(11) NOT NULL,
  `maininvoicestudentID` int(11) NOT NULL,
  `maininvoiceuserID` int(11) DEFAULT NULL,
  `maininvoiceusertypeID` int(11) DEFAULT NULL,
  `maininvoiceuname` varchar(60) DEFAULT NULL,
  `maininvoicedate` date NOT NULL,
  `maininvoicecreate_date` date NOT NULL,
  `maininvoiceday` varchar(20) DEFAULT NULL,
  `maininvoicemonth` varchar(20) DEFAULT NULL,
  `maininvoiceyear` year(4) NOT NULL,
  `maininvoicestatus` int(11) DEFAULT NULL,
  `maininvoicedeleted_at` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`maininvoiceID`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8;

INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (1, 4, 2, 9, 3, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (2, 4, 2, 9, 5, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (3, 4, 2, 9, 6, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (4, 4, 2, 9, 7, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (5, 4, 2, 9, 26, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (6, 4, 2, 9, 22, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (7, 4, 2, 9, 27, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (8, 4, 2, 9, 31, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (9, 4, 2, 9, 32, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (10, 4, 2, 9, 35, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (11, 4, 2, 9, 38, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (12, 4, 2, 9, 41, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (13, 4, 2, 9, 48, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (14, 4, 2, 10, 13, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (15, 4, 2, 10, 1, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (16, 4, 2, 10, 46, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (17, 4, 2, 10, 15, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (18, 4, 2, 10, 19, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (19, 4, 2, 10, 13, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 0);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (20, 4, 2, 9, 10, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (21, 4, 2, 9, 16, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (22, 4, 2, 9, 28, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (23, 4, 2, 9, 42, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (24, 4, 2, 9, 8, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (25, 4, 2, 9, 14, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (26, 4, 2, 9, 23, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (27, 4, 2, 9, 24, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (28, 4, 2, 9, 36, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (29, 4, 2, 9, 2, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (30, 4, 2, 9, 39, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (31, 4, 2, 9, 40, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (32, 4, 2, 10, 9, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (33, 4, 2, 9, 33, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (34, 4, 2, 9, 44, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (35, 4, 2, 9, 45, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (36, 4, 2, 9, 17, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (37, 4, 2, 9, 20, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (38, 4, 2, 9, 34, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (39, 4, 2, 10, 4, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (40, 4, 2, 10, 11, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (41, 4, 2, 10, 18, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (42, 4, 2, 9, 47, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (43, 4, 2, 9, 30, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (44, 4, 2, 9, 37, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (45, 4, 2, 9, 21, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (46, 4, 2, 9, 25, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (47, 4, 2, 9, 29, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (48, 4, 2, 9, 12, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (49, 4, 2, 9, 43, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (50, 4, 3, 10, 9, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (51, 4, 3, 9, 3, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (52, 4, 1, 9, 2, 1, 1, 'Skooly', '2024-04-02', '2024-04-02', '02', '04', '2024', 1, 1);


#
# TABLE STRUCTURE FOR: make_payment
#

DROP TABLE IF EXISTS `make_payment`;

CREATE TABLE `make_payment` (
  `make_paymentID` int(11) NOT NULL AUTO_INCREMENT,
  `month` text NOT NULL,
  `gross_salary` text NOT NULL,
  `total_deduction` text NOT NULL,
  `net_salary` text NOT NULL,
  `payment_amount` text NOT NULL,
  `payment_method` int(11) NOT NULL,
  `comments` text,
  `templateID` int(11) NOT NULL,
  `salaryID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `schoolyearID` int(11) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_username` varchar(60) NOT NULL,
  `create_usertype` varchar(60) NOT NULL,
  `total_hours` text,
  PRIMARY KEY (`make_paymentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: manage_salary
#

DROP TABLE IF EXISTS `manage_salary`;

CREATE TABLE `manage_salary` (
  `manage_salaryID` int(11) NOT NULL AUTO_INCREMENT,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `salary` int(11) NOT NULL,
  `template` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_username` varchar(60) NOT NULL,
  `create_usertype` varchar(60) NOT NULL,
  PRIMARY KEY (`manage_salaryID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `manage_salary` (`manage_salaryID`, `userID`, `usertypeID`, `salary`, `template`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`) VALUES (1, 9, 11, 1, 1, '2024-03-08 11:40:32', '2024-03-08 11:40:32', 2, 'admin', 'Admin');
INSERT INTO `manage_salary` (`manage_salaryID`, `userID`, `usertypeID`, `salary`, `template`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`) VALUES (2, 8, 11, 1, 1, '2024-03-08 11:40:52', '2024-03-08 11:40:52', 2, 'admin', 'Admin');


#
# TABLE STRUCTURE FOR: mark
#

DROP TABLE IF EXISTS `mark`;

CREATE TABLE `mark` (
  `markID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `examID` int(11) NOT NULL,
  `exam` varchar(60) NOT NULL,
  `studentID` int(11) NOT NULL,
  `classesID` int(11) NOT NULL,
  `subjectID` int(11) NOT NULL,
  `subject` varchar(60) NOT NULL,
  `year` year(4) NOT NULL,
  `create_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL DEFAULT '0',
  `create_usertypeID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`markID`)
) ENGINE=InnoDB AUTO_INCREMENT=434 DEFAULT CHARSET=utf8;

INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (1, 4, 1, 'FIRST TERM 2024', 1, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (2, 4, 1, 'FIRST TERM 2024', 4, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (3, 4, 1, 'FIRST TERM 2024', 9, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (4, 4, 1, 'FIRST TERM 2024', 11, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (5, 4, 1, 'FIRST TERM 2024', 13, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (6, 4, 1, 'FIRST TERM 2024', 15, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (7, 4, 1, 'FIRST TERM 2024', 18, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (8, 4, 1, 'FIRST TERM 2024', 19, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (9, 4, 1, 'FIRST TERM 2024', 46, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (10, 4, 1, 'FIRST TERM 2024', 49, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (11, 4, 1, 'FIRST TERM 2024', 2, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (12, 4, 1, 'FIRST TERM 2024', 3, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (13, 4, 1, 'FIRST TERM 2024', 5, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (14, 4, 1, 'FIRST TERM 2024', 6, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (15, 4, 1, 'FIRST TERM 2024', 7, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (16, 4, 1, 'FIRST TERM 2024', 8, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (17, 4, 1, 'FIRST TERM 2024', 10, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (18, 4, 1, 'FIRST TERM 2024', 12, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (19, 4, 1, 'FIRST TERM 2024', 14, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (20, 4, 1, 'FIRST TERM 2024', 16, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (21, 4, 1, 'FIRST TERM 2024', 17, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (22, 4, 1, 'FIRST TERM 2024', 20, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (23, 4, 1, 'FIRST TERM 2024', 21, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (24, 4, 1, 'FIRST TERM 2024', 22, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (25, 4, 1, 'FIRST TERM 2024', 23, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (26, 4, 1, 'FIRST TERM 2024', 24, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (27, 4, 1, 'FIRST TERM 2024', 25, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (28, 4, 1, 'FIRST TERM 2024', 26, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (29, 4, 1, 'FIRST TERM 2024', 27, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (30, 4, 1, 'FIRST TERM 2024', 28, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (31, 4, 1, 'FIRST TERM 2024', 29, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (32, 4, 1, 'FIRST TERM 2024', 30, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (33, 4, 1, 'FIRST TERM 2024', 31, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (34, 4, 1, 'FIRST TERM 2024', 32, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (35, 4, 1, 'FIRST TERM 2024', 33, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (36, 4, 1, 'FIRST TERM 2024', 34, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (37, 4, 1, 'FIRST TERM 2024', 35, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (38, 4, 1, 'FIRST TERM 2024', 36, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (39, 4, 1, 'FIRST TERM 2024', 37, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (40, 4, 1, 'FIRST TERM 2024', 38, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (41, 4, 1, 'FIRST TERM 2024', 39, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (42, 4, 1, 'FIRST TERM 2024', 40, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (43, 4, 1, 'FIRST TERM 2024', 41, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (44, 4, 1, 'FIRST TERM 2024', 42, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (45, 4, 1, 'FIRST TERM 2024', 43, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (46, 4, 1, 'FIRST TERM 2024', 44, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (47, 4, 1, 'FIRST TERM 2024', 45, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (48, 4, 1, 'FIRST TERM 2024', 47, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (49, 4, 1, 'FIRST TERM 2024', 48, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (50, 4, 1, 'FIRST TERM 2024', 1, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (51, 4, 1, 'FIRST TERM 2024', 4, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (52, 4, 1, 'FIRST TERM 2024', 9, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (53, 4, 1, 'FIRST TERM 2024', 11, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (54, 4, 1, 'FIRST TERM 2024', 13, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (55, 4, 1, 'FIRST TERM 2024', 15, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (56, 4, 1, 'FIRST TERM 2024', 18, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (57, 4, 1, 'FIRST TERM 2024', 19, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (58, 4, 1, 'FIRST TERM 2024', 46, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (59, 4, 1, 'FIRST TERM 2024', 2, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (60, 4, 1, 'FIRST TERM 2024', 3, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (61, 4, 1, 'FIRST TERM 2024', 5, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (62, 4, 1, 'FIRST TERM 2024', 6, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (63, 4, 1, 'FIRST TERM 2024', 7, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (64, 4, 1, 'FIRST TERM 2024', 8, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (65, 4, 1, 'FIRST TERM 2024', 10, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (66, 4, 1, 'FIRST TERM 2024', 12, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (67, 4, 1, 'FIRST TERM 2024', 14, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (68, 4, 1, 'FIRST TERM 2024', 16, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (69, 4, 1, 'FIRST TERM 2024', 17, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (70, 4, 1, 'FIRST TERM 2024', 20, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (71, 4, 1, 'FIRST TERM 2024', 21, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (72, 4, 1, 'FIRST TERM 2024', 22, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (73, 4, 1, 'FIRST TERM 2024', 23, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (74, 4, 1, 'FIRST TERM 2024', 24, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (75, 4, 1, 'FIRST TERM 2024', 25, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (76, 4, 1, 'FIRST TERM 2024', 26, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (77, 4, 1, 'FIRST TERM 2024', 27, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (78, 4, 1, 'FIRST TERM 2024', 28, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (79, 4, 1, 'FIRST TERM 2024', 29, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (80, 4, 1, 'FIRST TERM 2024', 30, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (81, 4, 1, 'FIRST TERM 2024', 31, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (82, 4, 1, 'FIRST TERM 2024', 32, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (83, 4, 1, 'FIRST TERM 2024', 33, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (84, 4, 1, 'FIRST TERM 2024', 34, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (85, 4, 1, 'FIRST TERM 2024', 35, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (86, 4, 1, 'FIRST TERM 2024', 36, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (87, 4, 1, 'FIRST TERM 2024', 37, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (88, 4, 1, 'FIRST TERM 2024', 38, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (89, 4, 1, 'FIRST TERM 2024', 39, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (90, 4, 1, 'FIRST TERM 2024', 40, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (91, 4, 1, 'FIRST TERM 2024', 41, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (92, 4, 1, 'FIRST TERM 2024', 42, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (93, 4, 1, 'FIRST TERM 2024', 43, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (94, 4, 1, 'FIRST TERM 2024', 44, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (95, 4, 1, 'FIRST TERM 2024', 45, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (96, 4, 1, 'FIRST TERM 2024', 47, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (97, 4, 1, 'FIRST TERM 2024', 48, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (98, 4, 1, 'FIRST TERM 2024', 1, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (99, 4, 1, 'FIRST TERM 2024', 4, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (100, 4, 1, 'FIRST TERM 2024', 9, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (101, 4, 1, 'FIRST TERM 2024', 11, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (102, 4, 1, 'FIRST TERM 2024', 13, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (103, 4, 1, 'FIRST TERM 2024', 15, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (104, 4, 1, 'FIRST TERM 2024', 18, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (105, 4, 1, 'FIRST TERM 2024', 19, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (106, 4, 1, 'FIRST TERM 2024', 46, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (107, 4, 1, 'FIRST TERM 2024', 2, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (108, 4, 1, 'FIRST TERM 2024', 3, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (109, 4, 1, 'FIRST TERM 2024', 5, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (110, 4, 1, 'FIRST TERM 2024', 6, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (111, 4, 1, 'FIRST TERM 2024', 7, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (112, 4, 1, 'FIRST TERM 2024', 8, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (113, 4, 1, 'FIRST TERM 2024', 10, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (114, 4, 1, 'FIRST TERM 2024', 12, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (115, 4, 1, 'FIRST TERM 2024', 14, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (116, 4, 1, 'FIRST TERM 2024', 16, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (117, 4, 1, 'FIRST TERM 2024', 17, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (118, 4, 1, 'FIRST TERM 2024', 20, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (119, 4, 1, 'FIRST TERM 2024', 21, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (120, 4, 1, 'FIRST TERM 2024', 22, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (121, 4, 1, 'FIRST TERM 2024', 23, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (122, 4, 1, 'FIRST TERM 2024', 24, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (123, 4, 1, 'FIRST TERM 2024', 25, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (124, 4, 1, 'FIRST TERM 2024', 26, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (125, 4, 1, 'FIRST TERM 2024', 27, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (126, 4, 1, 'FIRST TERM 2024', 28, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (127, 4, 1, 'FIRST TERM 2024', 29, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (128, 4, 1, 'FIRST TERM 2024', 30, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (129, 4, 1, 'FIRST TERM 2024', 31, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (130, 4, 1, 'FIRST TERM 2024', 32, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (131, 4, 1, 'FIRST TERM 2024', 33, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (132, 4, 1, 'FIRST TERM 2024', 34, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (133, 4, 1, 'FIRST TERM 2024', 35, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (134, 4, 1, 'FIRST TERM 2024', 36, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (135, 4, 1, 'FIRST TERM 2024', 37, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (136, 4, 1, 'FIRST TERM 2024', 38, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (137, 4, 1, 'FIRST TERM 2024', 39, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (138, 4, 1, 'FIRST TERM 2024', 40, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (139, 4, 1, 'FIRST TERM 2024', 41, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (140, 4, 1, 'FIRST TERM 2024', 42, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (141, 4, 1, 'FIRST TERM 2024', 43, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (142, 4, 1, 'FIRST TERM 2024', 44, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (143, 4, 1, 'FIRST TERM 2024', 45, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (144, 4, 1, 'FIRST TERM 2024', 47, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (145, 4, 1, 'FIRST TERM 2024', 48, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (146, 4, 1, 'FIRST TERM 2024', 2, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (147, 4, 1, 'FIRST TERM 2024', 3, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (148, 4, 1, 'FIRST TERM 2024', 5, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (149, 4, 1, 'FIRST TERM 2024', 6, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (150, 4, 1, 'FIRST TERM 2024', 7, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (151, 4, 1, 'FIRST TERM 2024', 8, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (152, 4, 1, 'FIRST TERM 2024', 10, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (153, 4, 1, 'FIRST TERM 2024', 12, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (154, 4, 1, 'FIRST TERM 2024', 14, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (155, 4, 1, 'FIRST TERM 2024', 16, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (156, 4, 1, 'FIRST TERM 2024', 17, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (157, 4, 1, 'FIRST TERM 2024', 20, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (158, 4, 1, 'FIRST TERM 2024', 21, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (159, 4, 1, 'FIRST TERM 2024', 22, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (160, 4, 1, 'FIRST TERM 2024', 23, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (161, 4, 1, 'FIRST TERM 2024', 24, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (162, 4, 1, 'FIRST TERM 2024', 25, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (163, 4, 1, 'FIRST TERM 2024', 26, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (164, 4, 1, 'FIRST TERM 2024', 27, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (165, 4, 1, 'FIRST TERM 2024', 28, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (166, 4, 1, 'FIRST TERM 2024', 29, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (167, 4, 1, 'FIRST TERM 2024', 30, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (168, 4, 1, 'FIRST TERM 2024', 31, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (169, 4, 1, 'FIRST TERM 2024', 32, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (170, 4, 1, 'FIRST TERM 2024', 33, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (171, 4, 1, 'FIRST TERM 2024', 34, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (172, 4, 1, 'FIRST TERM 2024', 35, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (173, 4, 1, 'FIRST TERM 2024', 36, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (174, 4, 1, 'FIRST TERM 2024', 37, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (175, 4, 1, 'FIRST TERM 2024', 38, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (176, 4, 1, 'FIRST TERM 2024', 39, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (177, 4, 1, 'FIRST TERM 2024', 40, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (178, 4, 1, 'FIRST TERM 2024', 41, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (179, 4, 1, 'FIRST TERM 2024', 42, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (180, 4, 1, 'FIRST TERM 2024', 43, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (181, 4, 1, 'FIRST TERM 2024', 44, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (182, 4, 1, 'FIRST TERM 2024', 45, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (183, 4, 1, 'FIRST TERM 2024', 47, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (184, 4, 1, 'FIRST TERM 2024', 48, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (185, 4, 1, 'FIRST TERM 2024', 2, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (186, 4, 1, 'FIRST TERM 2024', 3, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (187, 4, 1, 'FIRST TERM 2024', 5, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (188, 4, 1, 'FIRST TERM 2024', 6, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (189, 4, 1, 'FIRST TERM 2024', 7, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (190, 4, 1, 'FIRST TERM 2024', 8, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (191, 4, 1, 'FIRST TERM 2024', 10, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (192, 4, 1, 'FIRST TERM 2024', 12, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (193, 4, 1, 'FIRST TERM 2024', 14, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (194, 4, 1, 'FIRST TERM 2024', 16, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (195, 4, 1, 'FIRST TERM 2024', 17, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (196, 4, 1, 'FIRST TERM 2024', 20, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (197, 4, 1, 'FIRST TERM 2024', 21, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (198, 4, 1, 'FIRST TERM 2024', 22, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (199, 4, 1, 'FIRST TERM 2024', 23, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (200, 4, 1, 'FIRST TERM 2024', 24, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (201, 4, 1, 'FIRST TERM 2024', 25, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (202, 4, 1, 'FIRST TERM 2024', 26, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (203, 4, 1, 'FIRST TERM 2024', 27, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (204, 4, 1, 'FIRST TERM 2024', 28, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (205, 4, 1, 'FIRST TERM 2024', 29, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (206, 4, 1, 'FIRST TERM 2024', 30, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (207, 4, 1, 'FIRST TERM 2024', 31, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (208, 4, 1, 'FIRST TERM 2024', 32, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (209, 4, 1, 'FIRST TERM 2024', 33, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (210, 4, 1, 'FIRST TERM 2024', 34, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (211, 4, 1, 'FIRST TERM 2024', 35, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (212, 4, 1, 'FIRST TERM 2024', 36, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (213, 4, 1, 'FIRST TERM 2024', 37, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (214, 4, 1, 'FIRST TERM 2024', 38, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (215, 4, 1, 'FIRST TERM 2024', 39, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (216, 4, 1, 'FIRST TERM 2024', 40, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (217, 4, 1, 'FIRST TERM 2024', 41, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (218, 4, 1, 'FIRST TERM 2024', 42, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (219, 4, 1, 'FIRST TERM 2024', 43, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (220, 4, 1, 'FIRST TERM 2024', 44, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (221, 4, 1, 'FIRST TERM 2024', 45, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (222, 4, 1, 'FIRST TERM 2024', 47, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (223, 4, 1, 'FIRST TERM 2024', 48, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (224, 4, 1, 'FIRST TERM 2024', 2, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (225, 4, 1, 'FIRST TERM 2024', 3, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (226, 4, 1, 'FIRST TERM 2024', 5, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (227, 4, 1, 'FIRST TERM 2024', 6, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (228, 4, 1, 'FIRST TERM 2024', 7, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (229, 4, 1, 'FIRST TERM 2024', 8, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (230, 4, 1, 'FIRST TERM 2024', 10, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (231, 4, 1, 'FIRST TERM 2024', 12, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (232, 4, 1, 'FIRST TERM 2024', 14, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (233, 4, 1, 'FIRST TERM 2024', 16, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (234, 4, 1, 'FIRST TERM 2024', 17, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (235, 4, 1, 'FIRST TERM 2024', 20, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (236, 4, 1, 'FIRST TERM 2024', 21, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (237, 4, 1, 'FIRST TERM 2024', 22, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (238, 4, 1, 'FIRST TERM 2024', 23, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (239, 4, 1, 'FIRST TERM 2024', 24, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (240, 4, 1, 'FIRST TERM 2024', 25, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (241, 4, 1, 'FIRST TERM 2024', 26, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (242, 4, 1, 'FIRST TERM 2024', 27, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (243, 4, 1, 'FIRST TERM 2024', 28, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (244, 4, 1, 'FIRST TERM 2024', 29, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (245, 4, 1, 'FIRST TERM 2024', 30, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (246, 4, 1, 'FIRST TERM 2024', 31, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (247, 4, 1, 'FIRST TERM 2024', 32, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (248, 4, 1, 'FIRST TERM 2024', 33, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (249, 4, 1, 'FIRST TERM 2024', 34, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (250, 4, 1, 'FIRST TERM 2024', 35, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (251, 4, 1, 'FIRST TERM 2024', 36, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (252, 4, 1, 'FIRST TERM 2024', 37, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (253, 4, 1, 'FIRST TERM 2024', 38, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (254, 4, 1, 'FIRST TERM 2024', 39, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (255, 4, 1, 'FIRST TERM 2024', 40, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (256, 4, 1, 'FIRST TERM 2024', 41, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (257, 4, 1, 'FIRST TERM 2024', 42, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (258, 4, 1, 'FIRST TERM 2024', 43, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (259, 4, 1, 'FIRST TERM 2024', 44, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (260, 4, 1, 'FIRST TERM 2024', 45, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (261, 4, 1, 'FIRST TERM 2024', 47, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (262, 4, 1, 'FIRST TERM 2024', 48, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (263, 4, 1, 'FIRST TERM 2024', 2, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (264, 4, 1, 'FIRST TERM 2024', 3, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (265, 4, 1, 'FIRST TERM 2024', 5, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (266, 4, 1, 'FIRST TERM 2024', 6, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (267, 4, 1, 'FIRST TERM 2024', 7, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (268, 4, 1, 'FIRST TERM 2024', 8, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (269, 4, 1, 'FIRST TERM 2024', 10, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (270, 4, 1, 'FIRST TERM 2024', 12, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (271, 4, 1, 'FIRST TERM 2024', 14, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (272, 4, 1, 'FIRST TERM 2024', 16, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (273, 4, 1, 'FIRST TERM 2024', 17, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (274, 4, 1, 'FIRST TERM 2024', 20, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (275, 4, 1, 'FIRST TERM 2024', 21, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (276, 4, 1, 'FIRST TERM 2024', 22, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (277, 4, 1, 'FIRST TERM 2024', 23, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (278, 4, 1, 'FIRST TERM 2024', 24, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (279, 4, 1, 'FIRST TERM 2024', 25, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (280, 4, 1, 'FIRST TERM 2024', 26, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (281, 4, 1, 'FIRST TERM 2024', 27, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (282, 4, 1, 'FIRST TERM 2024', 28, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (283, 4, 1, 'FIRST TERM 2024', 29, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (284, 4, 1, 'FIRST TERM 2024', 30, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (285, 4, 1, 'FIRST TERM 2024', 31, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (286, 4, 1, 'FIRST TERM 2024', 32, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (287, 4, 1, 'FIRST TERM 2024', 33, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (288, 4, 1, 'FIRST TERM 2024', 34, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (289, 4, 1, 'FIRST TERM 2024', 35, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (290, 4, 1, 'FIRST TERM 2024', 36, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (291, 4, 1, 'FIRST TERM 2024', 37, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (292, 4, 1, 'FIRST TERM 2024', 38, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (293, 4, 1, 'FIRST TERM 2024', 39, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (294, 4, 1, 'FIRST TERM 2024', 40, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (295, 4, 1, 'FIRST TERM 2024', 41, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (296, 4, 1, 'FIRST TERM 2024', 42, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (297, 4, 1, 'FIRST TERM 2024', 43, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (298, 4, 1, 'FIRST TERM 2024', 44, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (299, 4, 1, 'FIRST TERM 2024', 45, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (300, 4, 1, 'FIRST TERM 2024', 47, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (301, 4, 1, 'FIRST TERM 2024', 48, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (302, 4, 1, 'FIRST TERM 2024', 2, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (303, 4, 1, 'FIRST TERM 2024', 3, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (304, 4, 1, 'FIRST TERM 2024', 5, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (305, 4, 1, 'FIRST TERM 2024', 6, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (306, 4, 1, 'FIRST TERM 2024', 7, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (307, 4, 1, 'FIRST TERM 2024', 8, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (308, 4, 1, 'FIRST TERM 2024', 10, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (309, 4, 1, 'FIRST TERM 2024', 12, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (310, 4, 1, 'FIRST TERM 2024', 14, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (311, 4, 1, 'FIRST TERM 2024', 16, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (312, 4, 1, 'FIRST TERM 2024', 17, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (313, 4, 1, 'FIRST TERM 2024', 20, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (314, 4, 1, 'FIRST TERM 2024', 21, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (315, 4, 1, 'FIRST TERM 2024', 22, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (316, 4, 1, 'FIRST TERM 2024', 23, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (317, 4, 1, 'FIRST TERM 2024', 24, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (318, 4, 1, 'FIRST TERM 2024', 25, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (319, 4, 1, 'FIRST TERM 2024', 26, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (320, 4, 1, 'FIRST TERM 2024', 27, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (321, 4, 1, 'FIRST TERM 2024', 28, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (322, 4, 1, 'FIRST TERM 2024', 29, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (323, 4, 1, 'FIRST TERM 2024', 30, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (324, 4, 1, 'FIRST TERM 2024', 31, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (325, 4, 1, 'FIRST TERM 2024', 32, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (326, 4, 1, 'FIRST TERM 2024', 33, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (327, 4, 1, 'FIRST TERM 2024', 34, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (328, 4, 1, 'FIRST TERM 2024', 35, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (329, 4, 1, 'FIRST TERM 2024', 36, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (330, 4, 1, 'FIRST TERM 2024', 37, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (331, 4, 1, 'FIRST TERM 2024', 38, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (332, 4, 1, 'FIRST TERM 2024', 39, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (333, 4, 1, 'FIRST TERM 2024', 40, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (334, 4, 1, 'FIRST TERM 2024', 41, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (335, 4, 1, 'FIRST TERM 2024', 42, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (336, 4, 1, 'FIRST TERM 2024', 43, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (337, 4, 1, 'FIRST TERM 2024', 44, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (338, 4, 1, 'FIRST TERM 2024', 45, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (339, 4, 1, 'FIRST TERM 2024', 47, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (340, 4, 1, 'FIRST TERM 2024', 48, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (341, 4, 1, 'FIRST TERM 2024', 1, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (342, 4, 1, 'FIRST TERM 2024', 4, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (343, 4, 1, 'FIRST TERM 2024', 9, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (344, 4, 1, 'FIRST TERM 2024', 11, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (345, 4, 1, 'FIRST TERM 2024', 13, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (346, 4, 1, 'FIRST TERM 2024', 15, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (347, 4, 1, 'FIRST TERM 2024', 18, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (348, 4, 1, 'FIRST TERM 2024', 19, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (349, 4, 1, 'FIRST TERM 2024', 46, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (350, 4, 1, 'FIRST TERM 2024', 1, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (351, 4, 1, 'FIRST TERM 2024', 4, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (352, 4, 1, 'FIRST TERM 2024', 9, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (353, 4, 1, 'FIRST TERM 2024', 11, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (354, 4, 1, 'FIRST TERM 2024', 13, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (355, 4, 1, 'FIRST TERM 2024', 15, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (356, 4, 1, 'FIRST TERM 2024', 18, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (357, 4, 1, 'FIRST TERM 2024', 19, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (358, 4, 1, 'FIRST TERM 2024', 46, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (359, 4, 1, 'FIRST TERM 2024', 1, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (360, 4, 1, 'FIRST TERM 2024', 4, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (361, 4, 1, 'FIRST TERM 2024', 9, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (362, 4, 1, 'FIRST TERM 2024', 11, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (363, 4, 1, 'FIRST TERM 2024', 13, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (364, 4, 1, 'FIRST TERM 2024', 15, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (365, 4, 1, 'FIRST TERM 2024', 18, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (366, 4, 1, 'FIRST TERM 2024', 19, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (367, 4, 1, 'FIRST TERM 2024', 46, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (368, 4, 1, 'FIRST TERM 2024', 1, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (369, 4, 1, 'FIRST TERM 2024', 4, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (370, 4, 1, 'FIRST TERM 2024', 9, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (371, 4, 1, 'FIRST TERM 2024', 11, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (372, 4, 1, 'FIRST TERM 2024', 13, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (373, 4, 1, 'FIRST TERM 2024', 15, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (374, 4, 1, 'FIRST TERM 2024', 18, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (375, 4, 1, 'FIRST TERM 2024', 19, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (376, 4, 1, 'FIRST TERM 2024', 46, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (377, 4, 1, 'FIRST TERM 2024', 2, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (378, 4, 1, 'FIRST TERM 2024', 3, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (379, 4, 1, 'FIRST TERM 2024', 5, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (380, 4, 1, 'FIRST TERM 2024', 6, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (381, 4, 1, 'FIRST TERM 2024', 7, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (382, 4, 1, 'FIRST TERM 2024', 8, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (383, 4, 1, 'FIRST TERM 2024', 10, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (384, 4, 1, 'FIRST TERM 2024', 12, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (385, 4, 1, 'FIRST TERM 2024', 14, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (386, 4, 1, 'FIRST TERM 2024', 16, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (387, 4, 1, 'FIRST TERM 2024', 17, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (388, 4, 1, 'FIRST TERM 2024', 20, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (389, 4, 1, 'FIRST TERM 2024', 21, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (390, 4, 1, 'FIRST TERM 2024', 22, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (391, 4, 1, 'FIRST TERM 2024', 23, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (392, 4, 1, 'FIRST TERM 2024', 24, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (393, 4, 1, 'FIRST TERM 2024', 25, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (394, 4, 1, 'FIRST TERM 2024', 26, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (395, 4, 1, 'FIRST TERM 2024', 27, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (396, 4, 1, 'FIRST TERM 2024', 28, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (397, 4, 1, 'FIRST TERM 2024', 29, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (398, 4, 1, 'FIRST TERM 2024', 30, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (399, 4, 1, 'FIRST TERM 2024', 31, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (400, 4, 1, 'FIRST TERM 2024', 32, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (401, 4, 1, 'FIRST TERM 2024', 33, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (402, 4, 1, 'FIRST TERM 2024', 34, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (403, 4, 1, 'FIRST TERM 2024', 35, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (404, 4, 1, 'FIRST TERM 2024', 36, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (405, 4, 1, 'FIRST TERM 2024', 37, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (406, 4, 1, 'FIRST TERM 2024', 38, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (407, 4, 1, 'FIRST TERM 2024', 39, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (408, 4, 1, 'FIRST TERM 2024', 40, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (409, 4, 1, 'FIRST TERM 2024', 41, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (410, 4, 1, 'FIRST TERM 2024', 42, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (411, 4, 1, 'FIRST TERM 2024', 43, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (412, 4, 1, 'FIRST TERM 2024', 44, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (413, 4, 1, 'FIRST TERM 2024', 45, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (414, 4, 1, 'FIRST TERM 2024', 47, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (415, 4, 1, 'FIRST TERM 2024', 48, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (416, 4, 1, 'FIRST TERM 2024', 1, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (417, 4, 1, 'FIRST TERM 2024', 4, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (418, 4, 1, 'FIRST TERM 2024', 9, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (419, 4, 1, 'FIRST TERM 2024', 11, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (420, 4, 1, 'FIRST TERM 2024', 13, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (421, 4, 1, 'FIRST TERM 2024', 15, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (422, 4, 1, 'FIRST TERM 2024', 18, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (423, 4, 1, 'FIRST TERM 2024', 19, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (424, 4, 1, 'FIRST TERM 2024', 46, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (425, 4, 1, 'FIRST TERM 2024', 1, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (426, 4, 1, 'FIRST TERM 2024', 4, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (427, 4, 1, 'FIRST TERM 2024', 9, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (428, 4, 1, 'FIRST TERM 2024', 11, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (429, 4, 1, 'FIRST TERM 2024', 13, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (430, 4, 1, 'FIRST TERM 2024', 15, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (431, 4, 1, 'FIRST TERM 2024', 18, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (432, 4, 1, 'FIRST TERM 2024', 19, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (433, 4, 1, 'FIRST TERM 2024', 46, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);


#
# TABLE STRUCTURE FOR: markpercentage
#

DROP TABLE IF EXISTS `markpercentage`;

CREATE TABLE `markpercentage` (
  `markpercentageID` int(11) NOT NULL AUTO_INCREMENT,
  `markpercentagetype` varchar(100) NOT NULL,
  `percentage` double NOT NULL,
  `examID` int(11) DEFAULT NULL,
  `classesID` int(11) DEFAULT NULL,
  `subjectID` int(11) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_username` varchar(60) NOT NULL,
  `create_usertype` varchar(60) NOT NULL,
  PRIMARY KEY (`markpercentageID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `markpercentage` (`markpercentageID`, `markpercentagetype`, `percentage`, `examID`, `classesID`, `subjectID`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`) VALUES (1, 'OPENER ASSESSMENT', '100', NULL, NULL, NULL, '2017-01-05 06:11:54', '2024-03-08 11:32:31', 1, 'admin', 'Admin');
INSERT INTO `markpercentage` (`markpercentageID`, `markpercentagetype`, `percentage`, `examID`, `classesID`, `subjectID`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`) VALUES (2, 'MID-TERM ASSESSMENT', '100', NULL, NULL, NULL, '2024-02-29 11:33:26', '2024-03-08 11:31:58', 1, 'skooly', 'Admin');
INSERT INTO `markpercentage` (`markpercentageID`, `markpercentagetype`, `percentage`, `examID`, `classesID`, `subjectID`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`) VALUES (3, 'END OF TERM ASSESSMENT', '100', NULL, NULL, NULL, '2024-02-29 11:33:45', '2024-03-08 11:32:17', 1, 'skooly', 'Admin');


#
# TABLE STRUCTURE FOR: markrelation
#

DROP TABLE IF EXISTS `markrelation`;

CREATE TABLE `markrelation` (
  `markrelationID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `markID` int(11) NOT NULL,
  `markpercentageID` int(11) NOT NULL,
  `mark` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`markrelationID`)
) ENGINE=InnoDB AUTO_INCREMENT=1300 DEFAULT CHARSET=utf8;

INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1, 1, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (2, 1, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (3, 1, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (4, 2, 1, '34');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (5, 2, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (6, 2, 3, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (7, 3, 1, '8');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (8, 3, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (9, 3, 3, '14');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (10, 4, 1, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (11, 4, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (12, 4, 3, '94');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (13, 5, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (14, 5, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (15, 5, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (16, 6, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (17, 6, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (18, 6, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (19, 7, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (20, 7, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (21, 7, 3, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (22, 8, 1, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (23, 8, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (24, 8, 3, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (25, 9, 1, '0');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (26, 9, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (27, 9, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (28, 10, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (29, 10, 2, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (30, 10, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (31, 11, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (32, 11, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (33, 11, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (34, 12, 1, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (35, 12, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (36, 12, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (37, 13, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (38, 13, 2, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (39, 13, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (40, 14, 1, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (41, 14, 2, '45');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (42, 14, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (43, 15, 1, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (44, 15, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (45, 15, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (46, 16, 1, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (47, 16, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (48, 16, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (49, 17, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (50, 17, 2, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (51, 17, 3, '16');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (52, 18, 1, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (53, 18, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (54, 18, 3, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (55, 19, 1, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (56, 19, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (57, 19, 3, '100');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (58, 20, 1, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (59, 20, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (60, 20, 3, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (61, 21, 1, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (62, 21, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (63, 21, 3, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (64, 22, 1, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (65, 22, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (66, 22, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (67, 23, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (68, 23, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (69, 23, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (70, 24, 1, '29');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (71, 24, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (72, 24, 3, '39');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (73, 25, 1, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (74, 25, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (75, 25, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (76, 26, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (77, 26, 2, '97');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (78, 26, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (79, 27, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (80, 27, 2, '45');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (81, 27, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (82, 28, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (83, 28, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (84, 28, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (85, 29, 1, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (86, 29, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (87, 29, 3, '91');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (88, 30, 1, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (89, 30, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (90, 30, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (91, 31, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (92, 31, 2, '45');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (93, 31, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (94, 32, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (95, 32, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (96, 32, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (97, 33, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (98, 33, 2, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (99, 33, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (100, 34, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (101, 34, 2, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (102, 34, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (103, 35, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (104, 35, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (105, 35, 3, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (106, 36, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (107, 36, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (108, 36, 3, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (109, 37, 1, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (110, 37, 2, '96');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (111, 37, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (112, 38, 1, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (113, 38, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (114, 38, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (115, 39, 1, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (116, 39, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (117, 39, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (118, 40, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (119, 40, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (120, 40, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (121, 41, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (122, 41, 2, '45');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (123, 41, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (124, 42, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (125, 42, 2, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (126, 42, 3, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (127, 43, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (128, 43, 2, '57');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (129, 43, 3, '16');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (130, 44, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (131, 44, 2, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (132, 44, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (133, 45, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (134, 45, 2, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (135, 45, 3, '16');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (136, 46, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (137, 46, 2, '97');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (138, 46, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (139, 47, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (140, 47, 2, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (141, 47, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (142, 48, 1, '0');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (143, 48, 2, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (144, 48, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (145, 49, 1, '0');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (146, 49, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (147, 49, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (148, 50, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (149, 50, 2, '53');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (150, 50, 3, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (151, 51, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (152, 51, 2, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (153, 51, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (154, 52, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (155, 52, 2, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (156, 52, 3, '41');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (157, 53, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (158, 53, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (159, 53, 3, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (160, 54, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (161, 54, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (162, 54, 3, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (163, 55, 1, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (164, 55, 2, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (165, 55, 3, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (166, 56, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (167, 56, 2, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (168, 56, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (169, 57, 1, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (170, 57, 2, '97');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (171, 57, 3, '89');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (172, 58, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (173, 58, 2, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (174, 58, 3, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (175, 59, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (176, 59, 2, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (177, 59, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (178, 60, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (179, 60, 2, '53');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (180, 60, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (181, 61, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (182, 61, 2, '43');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (183, 61, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (184, 62, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (185, 62, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (186, 62, 3, '51');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (187, 63, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (188, 63, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (189, 63, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (190, 64, 1, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (191, 64, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (192, 64, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (193, 65, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (194, 65, 2, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (195, 65, 3, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (196, 66, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (197, 66, 2, '53');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (198, 66, 3, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (199, 67, 1, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (200, 67, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (201, 67, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (202, 68, 1, '94');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (203, 68, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (204, 68, 3, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (205, 69, 1, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (206, 69, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (207, 69, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (208, 70, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (209, 70, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (210, 70, 3, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (211, 71, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (212, 71, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (213, 71, 3, '37');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (214, 72, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (215, 72, 2, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (216, 72, 3, '29');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (217, 73, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (218, 73, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (219, 73, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (220, 74, 1, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (221, 74, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (222, 74, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (223, 75, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (224, 75, 2, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (225, 75, 3, '29');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (226, 76, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (227, 76, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (228, 76, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (229, 77, 1, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (230, 77, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (231, 77, 3, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (232, 78, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (233, 78, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (234, 78, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (235, 79, 1, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (236, 79, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (237, 79, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (238, 80, 1, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (239, 80, 2, '45');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (240, 80, 3, '37');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (241, 81, 1, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (242, 81, 2, '35');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (243, 81, 3, '31');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (244, 82, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (245, 82, 2, '35');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (246, 82, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (247, 83, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (248, 83, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (249, 83, 3, '71');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (250, 84, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (251, 84, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (252, 84, 3, '57');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (253, 85, 1, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (254, 85, 2, '57');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (255, 85, 3, '57');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (256, 86, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (257, 86, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (258, 86, 3, '49');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (259, 87, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (260, 87, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (261, 87, 3, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (262, 88, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (263, 88, 2, '57');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (264, 88, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (265, 89, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (266, 89, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (267, 89, 3, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (268, 90, 1, '4');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (269, 90, 2, '12');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (270, 90, 3, '8');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (271, 91, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (272, 91, 2, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (273, 91, 3, '35');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (274, 92, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (275, 92, 2, '47');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (276, 92, 3, '59');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (277, 93, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (278, 93, 2, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (279, 93, 3, '26');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (280, 94, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (281, 94, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (282, 94, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (283, 95, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (284, 95, 2, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (285, 95, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (286, 96, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (287, 96, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (288, 96, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (289, 97, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (290, 97, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (291, 97, 3, '31');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (292, 98, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (293, 98, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (294, 98, 3, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (295, 99, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (296, 99, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (297, 99, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (298, 100, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (299, 100, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (300, 100, 3, '45');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (301, 101, 1, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (302, 101, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (303, 101, 3, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (304, 102, 1, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (305, 102, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (306, 102, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (307, 103, 1, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (308, 103, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (309, 103, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (310, 104, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (311, 104, 2, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (312, 104, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (313, 105, 1, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (314, 105, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (315, 105, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (316, 106, 1, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (317, 106, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (318, 106, 3, '94');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (319, 107, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (320, 107, 2, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (321, 107, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (322, 108, 1, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (323, 108, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (324, 108, 3, '47');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (325, 109, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (326, 109, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (327, 109, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (328, 110, 1, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (329, 110, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (330, 110, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (331, 111, 1, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (332, 111, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (333, 111, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (334, 112, 1, '53');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (335, 112, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (336, 112, 3, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (337, 113, 1, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (338, 113, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (339, 113, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (340, 114, 1, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (341, 114, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (342, 114, 3, '15');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (343, 115, 1, '91');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (344, 115, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (345, 115, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (346, 116, 1, '94');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (347, 116, 2, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (348, 116, 3, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (349, 117, 1, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (350, 117, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (351, 117, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (352, 118, 1, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (353, 118, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (354, 118, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (355, 119, 1, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (356, 119, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (357, 119, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (358, 120, 1, '35');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (359, 120, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (360, 120, 3, '5');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (361, 121, 1, '89');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (362, 121, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (363, 121, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (364, 122, 1, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (365, 122, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (366, 122, 3, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (367, 123, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (368, 123, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (369, 123, 3, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (370, 124, 1, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (371, 124, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (372, 124, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (373, 125, 1, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (374, 125, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (375, 125, 3, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (376, 126, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (377, 126, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (378, 126, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (379, 127, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (380, 127, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (381, 127, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (382, 128, 1, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (383, 128, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (384, 128, 3, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (385, 129, 1, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (386, 129, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (387, 129, 3, '16');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (388, 130, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (389, 130, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (390, 130, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (391, 131, 1, '94');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (392, 131, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (393, 131, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (394, 132, 1, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (395, 132, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (396, 132, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (397, 133, 1, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (398, 133, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (399, 133, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (400, 134, 1, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (401, 134, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (402, 134, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (403, 135, 1, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (404, 135, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (405, 135, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (406, 136, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (407, 136, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (408, 136, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (409, 137, 1, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (410, 137, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (411, 137, 3, '24');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (412, 138, 1, '4');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (413, 138, 2, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (414, 138, 3, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (415, 139, 1, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (416, 139, 2, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (417, 139, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (418, 140, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (419, 140, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (420, 140, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (421, 141, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (422, 141, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (423, 141, 3, '12');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (424, 142, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (425, 142, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (426, 142, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (427, 143, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (428, 143, 2, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (429, 143, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (430, 144, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (431, 144, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (432, 144, 3, '45');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (433, 145, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (434, 145, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (435, 145, 3, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (436, 146, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (437, 146, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (438, 146, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (439, 147, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (440, 147, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (441, 147, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (442, 148, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (443, 148, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (444, 148, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (445, 149, 1, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (446, 149, 2, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (447, 149, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (448, 150, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (449, 150, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (450, 150, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (451, 151, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (452, 151, 2, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (453, 151, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (454, 152, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (455, 152, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (456, 152, 3, '34');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (457, 153, 1, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (458, 153, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (459, 153, 3, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (460, 154, 1, '94');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (461, 154, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (462, 154, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (463, 155, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (464, 155, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (465, 155, 3, '98');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (466, 156, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (467, 156, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (468, 156, 3, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (469, 157, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (470, 157, 2, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (471, 157, 3, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (472, 158, 1, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (473, 158, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (474, 158, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (475, 159, 1, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (476, 159, 2, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (477, 159, 3, '5');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (478, 160, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (479, 160, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (480, 160, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (481, 161, 1, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (482, 161, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (483, 161, 3, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (484, 162, 1, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (485, 162, 2, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (486, 162, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (487, 163, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (488, 163, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (489, 163, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (490, 164, 1, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (491, 164, 2, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (492, 164, 3, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (493, 165, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (494, 165, 2, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (495, 165, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (496, 166, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (497, 166, 2, '71');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (498, 166, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (499, 167, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (500, 167, 2, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (501, 167, 3, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (502, 168, 1, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (503, 168, 2, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (504, 168, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (505, 169, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (506, 169, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (507, 169, 3, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (508, 170, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (509, 170, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (510, 170, 3, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (511, 171, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (512, 171, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (513, 171, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (514, 172, 1, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (515, 172, 2, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (516, 172, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (517, 173, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (518, 173, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (519, 173, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (520, 174, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (521, 174, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (522, 174, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (523, 175, 1, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (524, 175, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (525, 175, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (526, 176, 1, '34');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (527, 176, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (528, 176, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (529, 177, 1, '10');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (530, 177, 2, '59');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (531, 177, 3, '5');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (532, 178, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (533, 178, 2, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (534, 178, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (535, 179, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (536, 179, 2, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (537, 179, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (538, 180, 1, '0');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (539, 180, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (540, 180, 3, '22');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (541, 181, 1, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (542, 181, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (543, 181, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (544, 182, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (545, 182, 2, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (546, 182, 3, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (547, 183, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (548, 183, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (549, 183, 3, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (550, 184, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (551, 184, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (552, 184, 3, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (553, 185, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (554, 185, 2, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (555, 185, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (556, 186, 1, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (557, 186, 2, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (558, 186, 3, '47');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (559, 187, 1, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (560, 187, 2, '49');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (561, 187, 3, '51');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (562, 188, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (563, 188, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (564, 188, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (565, 189, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (566, 189, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (567, 189, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (568, 190, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (569, 190, 2, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (570, 190, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (571, 191, 1, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (572, 191, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (573, 191, 3, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (574, 192, 1, '12');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (575, 192, 2, '59');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (576, 192, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (577, 193, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (578, 193, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (579, 193, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (580, 194, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (581, 194, 2, '89');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (582, 194, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (583, 195, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (584, 195, 2, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (585, 195, 3, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (586, 196, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (587, 196, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (588, 196, 3, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (589, 197, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (590, 197, 2, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (591, 197, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (592, 198, 1, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (593, 198, 2, '59');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (594, 198, 3, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (595, 199, 1, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (596, 199, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (597, 199, 3, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (598, 200, 1, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (599, 200, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (600, 200, 3, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (601, 201, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (602, 201, 2, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (603, 201, 3, '51');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (604, 202, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (605, 202, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (606, 202, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (607, 203, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (608, 203, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (609, 203, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (610, 204, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (611, 204, 2, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (612, 204, 3, '47');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (613, 205, 1, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (614, 205, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (615, 205, 3, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (616, 206, 1, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (617, 206, 2, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (618, 206, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (619, 207, 1, '18');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (620, 207, 2, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (621, 207, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (622, 208, 1, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (623, 208, 2, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (624, 208, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (625, 209, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (626, 209, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (627, 209, 3, '61');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (628, 210, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (629, 210, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (630, 210, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (631, 211, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (632, 211, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (633, 211, 3, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (634, 212, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (635, 212, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (636, 212, 3, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (637, 213, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (638, 213, 2, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (639, 213, 3, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (640, 214, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (641, 214, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (642, 214, 3, '71');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (643, 215, 1, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (644, 215, 2, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (645, 215, 3, '51');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (646, 216, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (647, 216, 2, '5');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (648, 216, 3, '4');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (649, 217, 1, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (650, 217, 2, '45');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (651, 217, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (652, 218, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (653, 218, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (654, 218, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (655, 219, 1, '6');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (656, 219, 2, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (657, 219, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (658, 220, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (659, 220, 2, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (660, 220, 3, '61');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (661, 221, 1, '0');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (662, 221, 2, '0');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (663, 221, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (664, 222, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (665, 222, 2, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (666, 222, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (667, 223, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (668, 223, 2, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (669, 223, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (670, 224, 1, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (671, 224, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (672, 224, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (673, 225, 1, '26');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (674, 225, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (675, 225, 3, '34');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (676, 226, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (677, 226, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (678, 226, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (679, 227, 1, '59');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (680, 227, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (681, 227, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (682, 228, 1, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (683, 228, 2, '91');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (684, 228, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (685, 229, 1, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (686, 229, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (687, 229, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (688, 230, 1, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (689, 230, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (690, 230, 3, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (691, 231, 1, '12');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (692, 231, 2, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (693, 231, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (694, 232, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (695, 232, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (696, 232, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (697, 233, 1, '71');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (698, 233, 2, '98');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (699, 233, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (700, 234, 1, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (701, 234, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (702, 234, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (703, 235, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (704, 235, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (705, 235, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (706, 236, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (707, 236, 2, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (708, 236, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (709, 237, 1, '25');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (710, 237, 2, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (711, 237, 3, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (712, 238, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (713, 238, 2, '91');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (714, 238, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (715, 239, 1, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (716, 239, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (717, 239, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (718, 240, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (719, 240, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (720, 240, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (721, 241, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (722, 241, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (723, 241, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (724, 242, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (725, 242, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (726, 242, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (727, 243, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (728, 243, 2, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (729, 243, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (730, 244, 1, '41');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (731, 244, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (732, 244, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (733, 245, 1, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (734, 245, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (735, 245, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (736, 246, 1, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (737, 246, 2, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (738, 246, 3, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (739, 247, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (740, 247, 2, '57');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (741, 247, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (742, 248, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (743, 248, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (744, 248, 3, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (745, 249, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (746, 249, 2, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (747, 249, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (748, 250, 1, '61');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (749, 250, 2, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (750, 250, 3, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (751, 251, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (752, 251, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (753, 251, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (754, 252, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (755, 252, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (756, 252, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (757, 253, 1, '47');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (758, 253, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (759, 253, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (760, 254, 1, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (761, 254, 2, '53');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (762, 254, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (763, 255, 1, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (764, 255, 2, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (765, 255, 3, '4');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (766, 256, 1, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (767, 256, 2, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (768, 256, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (769, 257, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (770, 257, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (771, 257, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (772, 258, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (773, 258, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (774, 258, 3, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (775, 259, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (776, 259, 2, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (777, 259, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (778, 260, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (779, 260, 2, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (780, 260, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (781, 261, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (782, 261, 2, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (783, 261, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (784, 262, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (785, 262, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (786, 262, 3, '34');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (787, 263, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (788, 263, 2, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (789, 263, 3, '26');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (790, 264, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (791, 264, 2, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (792, 264, 3, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (793, 265, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (794, 265, 2, '33');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (795, 265, 3, '22');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (796, 266, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (797, 266, 2, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (798, 266, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (799, 267, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (800, 267, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (801, 267, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (802, 268, 1, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (803, 268, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (804, 268, 3, '12');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (805, 269, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (806, 269, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (807, 269, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (808, 270, 1, '8');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (809, 270, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (810, 270, 3, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (811, 271, 1, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (812, 271, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (813, 271, 3, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (814, 272, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (815, 272, 2, '81');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (816, 272, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (817, 273, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (818, 273, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (819, 273, 3, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (820, 274, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (821, 274, 2, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (822, 274, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (823, 275, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (824, 275, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (825, 275, 3, '8');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (826, 276, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (827, 276, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (828, 276, 3, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (829, 277, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (830, 277, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (831, 277, 3, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (832, 278, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (833, 278, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (834, 278, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (835, 279, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (836, 279, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (837, 279, 3, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (838, 280, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (839, 280, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (840, 280, 3, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (841, 281, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (842, 281, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (843, 281, 3, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (844, 282, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (845, 282, 2, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (846, 282, 3, '6');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (847, 283, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (848, 283, 2, '33');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (849, 283, 3, '34');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (850, 284, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (851, 284, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (852, 284, 3, '12');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (853, 285, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (854, 285, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (855, 285, 3, '14');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (856, 286, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (857, 286, 2, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (858, 286, 3, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (859, 287, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (860, 287, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (861, 287, 3, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (862, 288, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (863, 288, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (864, 288, 3, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (865, 289, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (866, 289, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (867, 289, 3, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (868, 290, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (869, 290, 2, '71');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (870, 290, 3, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (871, 291, 1, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (872, 291, 2, '71');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (873, 291, 3, '24');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (874, 292, 1, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (875, 292, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (876, 292, 3, '26');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (877, 293, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (878, 293, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (879, 293, 3, '22');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (880, 294, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (881, 294, 2, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (882, 294, 3, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (883, 295, 1, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (884, 295, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (885, 295, 3, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (886, 296, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (887, 296, 2, '99');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (888, 296, 3, '24');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (889, 297, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (890, 297, 2, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (891, 297, 3, '24');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (892, 298, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (893, 298, 2, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (894, 298, 3, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (895, 299, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (896, 299, 2, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (897, 299, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (898, 300, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (899, 300, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (900, 300, 3, '34');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (901, 301, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (902, 301, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (903, 301, 3, '10');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (904, 302, 1, '53');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (905, 302, 2, '94');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (906, 302, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (907, 303, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (908, 303, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (909, 303, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (910, 304, 1, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (911, 304, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (912, 304, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (913, 305, 1, '57');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (914, 305, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (915, 305, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (916, 306, 1, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (917, 306, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (918, 306, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (919, 307, 1, '41');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (920, 307, 2, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (921, 307, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (922, 308, 1, '35');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (923, 308, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (924, 308, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (925, 309, 1, '29');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (926, 309, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (927, 309, 3, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (928, 310, 1, '91');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (929, 310, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (930, 310, 3, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (931, 311, 1, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (932, 311, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (933, 311, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (934, 312, 1, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (935, 312, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (936, 312, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (937, 313, 1, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (938, 313, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (939, 313, 3, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (940, 314, 1, '57');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (941, 314, 2, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (942, 314, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (943, 315, 1, '33');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (944, 315, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (945, 315, 3, '26');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (946, 316, 1, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (947, 316, 2, '97');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (948, 316, 3, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (949, 317, 1, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (950, 317, 2, '94');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (951, 317, 3, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (952, 318, 1, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (953, 318, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (954, 318, 3, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (955, 319, 1, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (956, 319, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (957, 319, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (958, 320, 1, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (959, 320, 2, '97');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (960, 320, 3, '96');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (961, 321, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (962, 321, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (963, 321, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (964, 322, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (965, 322, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (966, 322, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (967, 323, 1, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (968, 323, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (969, 323, 3, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (970, 324, 1, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (971, 324, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (972, 324, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (973, 325, 1, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (974, 325, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (975, 325, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (976, 326, 1, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (977, 326, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (978, 326, 3, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (979, 327, 1, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (980, 327, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (981, 327, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (982, 328, 1, '96');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (983, 328, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (984, 328, 3, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (985, 329, 1, '71');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (986, 329, 2, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (987, 329, 3, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (988, 330, 1, '61');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (989, 330, 2, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (990, 330, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (991, 331, 1, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (992, 331, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (993, 331, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (994, 332, 1, '51');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (995, 332, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (996, 332, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (997, 333, 1, '3');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (998, 333, 2, '29');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (999, 333, 3, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1000, 334, 1, '35');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1001, 334, 2, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1002, 334, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1003, 335, 1, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1004, 335, 2, '96');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1005, 335, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1006, 336, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1007, 336, 2, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1008, 336, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1009, 337, 1, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1010, 337, 2, '96');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1011, 337, 3, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1012, 338, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1013, 338, 2, '96');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1014, 338, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1015, 339, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1016, 339, 2, '96');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1017, 339, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1018, 340, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1019, 340, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1020, 340, 3, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1021, 341, 1, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1022, 341, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1023, 341, 3, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1024, 342, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1025, 342, 2, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1026, 342, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1027, 343, 1, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1028, 343, 2, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1029, 343, 3, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1030, 344, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1031, 344, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1032, 344, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1033, 345, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1034, 345, 2, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1035, 345, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1036, 346, 1, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1037, 346, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1038, 346, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1039, 347, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1040, 347, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1041, 347, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1042, 348, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1043, 348, 2, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1044, 348, 3, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1045, 349, 1, '0');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1046, 349, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1047, 349, 3, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1048, 350, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1049, 350, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1050, 350, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1051, 351, 1, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1052, 351, 2, '81');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1053, 351, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1054, 352, 1, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1055, 352, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1056, 352, 3, '22');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1057, 353, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1058, 353, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1059, 353, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1060, 354, 1, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1061, 354, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1062, 354, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1063, 355, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1064, 355, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1065, 355, 3, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1066, 356, 1, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1067, 356, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1068, 356, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1069, 357, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1070, 357, 2, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1071, 357, 3, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1072, 358, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1073, 358, 2, '96');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1074, 358, 3, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1075, 359, 1, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1076, 359, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1077, 359, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1078, 360, 1, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1079, 360, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1080, 360, 3, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1081, 361, 1, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1082, 361, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1083, 361, 3, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1084, 362, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1085, 362, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1086, 362, 3, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1087, 363, 1, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1088, 363, 2, '81');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1089, 363, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1090, 364, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1091, 364, 2, '91');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1092, 364, 3, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1093, 365, 1, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1094, 365, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1095, 365, 3, '26');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1096, 366, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1097, 366, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1098, 366, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1099, 367, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1100, 367, 2, '98');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1101, 367, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1102, 368, 1, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1103, 368, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1104, 368, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1105, 369, 1, '39');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1106, 369, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1107, 369, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1108, 370, 1, '39');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1109, 370, 2, '98');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1110, 370, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1111, 371, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1112, 371, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1113, 371, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1114, 372, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1115, 372, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1116, 372, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1117, 373, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1118, 373, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1119, 373, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1120, 374, 1, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1121, 374, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1122, 374, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1123, 375, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1124, 375, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1125, 375, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1126, 376, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1127, 376, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1128, 376, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1129, 377, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1130, 377, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1131, 377, 3, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1132, 378, 1, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1133, 378, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1134, 378, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1135, 379, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1136, 379, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1137, 379, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1138, 380, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1139, 380, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1140, 380, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1141, 381, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1142, 381, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1143, 381, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1144, 382, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1145, 382, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1146, 382, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1147, 383, 1, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1148, 383, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1149, 383, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1150, 384, 1, '16');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1151, 384, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1152, 384, 3, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1153, 385, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1154, 385, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1155, 385, 3, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1156, 386, 1, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1157, 386, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1158, 386, 3, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1159, 387, 1, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1160, 387, 2, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1161, 387, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1162, 388, 1, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1163, 388, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1164, 388, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1165, 389, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1166, 389, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1167, 389, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1168, 390, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1169, 390, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1170, 390, 3, '18');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1171, 391, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1172, 391, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1173, 391, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1174, 392, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1175, 392, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1176, 392, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1177, 393, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1178, 393, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1179, 393, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1180, 394, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1181, 394, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1182, 394, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1183, 395, 1, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1184, 395, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1185, 395, 3, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1186, 396, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1187, 396, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1188, 396, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1189, 397, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1190, 397, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1191, 397, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1192, 398, 1, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1193, 398, 2, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1194, 398, 3, '26');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1195, 399, 1, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1196, 399, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1197, 399, 3, '34');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1198, 400, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1199, 400, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1200, 400, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1201, 401, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1202, 401, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1203, 401, 3, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1204, 402, 1, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1205, 402, 2, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1206, 402, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1207, 403, 1, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1208, 403, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1209, 403, 3, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1210, 404, 1, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1211, 404, 2, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1212, 404, 3, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1213, 405, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1214, 405, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1215, 405, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1216, 406, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1217, 406, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1218, 406, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1219, 407, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1220, 407, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1221, 407, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1222, 408, 1, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1223, 408, 2, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1224, 408, 3, '6');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1225, 409, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1226, 409, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1227, 409, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1228, 410, 1, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1229, 410, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1230, 410, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1231, 411, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1232, 411, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1233, 411, 3, '18');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1234, 412, 1, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1235, 412, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1236, 412, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1237, 413, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1238, 413, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1239, 413, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1240, 414, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1241, 414, 2, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1242, 414, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1243, 415, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1244, 415, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1245, 415, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1246, 416, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1247, 416, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1248, 416, 3, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1249, 417, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1250, 417, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1251, 417, 3, '47');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1252, 418, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1253, 418, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1254, 418, 3, '41');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1255, 419, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1256, 419, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1257, 419, 3, '61');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1258, 420, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1259, 420, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1260, 420, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1261, 421, 1, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1262, 421, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1263, 421, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1264, 422, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1265, 422, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1266, 422, 3, '29');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1267, 423, 1, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1268, 423, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1269, 423, 3, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1270, 424, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1271, 424, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1272, 424, 3, '61');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1273, 425, 1, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1274, 425, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1275, 425, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1276, 426, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1277, 426, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1278, 426, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1279, 427, 1, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1280, 427, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1281, 427, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1282, 428, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1283, 428, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1284, 428, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1285, 429, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1286, 429, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1287, 429, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1288, 430, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1289, 430, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1290, 430, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1291, 431, 1, '47');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1292, 431, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1293, 431, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1294, 432, 1, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1295, 432, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1296, 432, 3, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1297, 433, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1298, 433, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1299, 433, 3, '82');


#
# TABLE STRUCTURE FOR: marksetting
#

DROP TABLE IF EXISTS `marksetting`;

CREATE TABLE `marksetting` (
  `marksettingID` int(11) NOT NULL AUTO_INCREMENT,
  `examID` int(11) NOT NULL DEFAULT '0',
  `classesID` int(11) NOT NULL DEFAULT '0',
  `subjectID` int(11) DEFAULT '0',
  `marktypeID` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`marksettingID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `marksetting` (`marksettingID`, `examID`, `classesID`, `subjectID`, `marktypeID`) VALUES (4, 1, 0, 0, 0);


#
# TABLE STRUCTURE FOR: marksettingrelation
#

DROP TABLE IF EXISTS `marksettingrelation`;

CREATE TABLE `marksettingrelation` (
  `marksettingrelationID` int(11) NOT NULL AUTO_INCREMENT,
  `marktypeID` int(11) NOT NULL DEFAULT '0',
  `marksettingID` int(11) NOT NULL DEFAULT '0',
  `markpercentageID` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`marksettingrelationID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO `marksettingrelation` (`marksettingrelationID`, `marktypeID`, `marksettingID`, `markpercentageID`) VALUES (7, 0, 4, 1);
INSERT INTO `marksettingrelation` (`marksettingrelationID`, `marktypeID`, `marksettingID`, `markpercentageID`) VALUES (8, 0, 4, 2);
INSERT INTO `marksettingrelation` (`marksettingrelationID`, `marktypeID`, `marksettingID`, `markpercentageID`) VALUES (9, 0, 4, 3);


#
# TABLE STRUCTURE FOR: media
#

DROP TABLE IF EXISTS `media`;

CREATE TABLE `media` (
  `mediaID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `mcategoryID` int(11) NOT NULL DEFAULT '0',
  `file_name` varchar(255) NOT NULL,
  `file_name_display` varchar(255) NOT NULL,
  PRIMARY KEY (`mediaID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: media_category
#

DROP TABLE IF EXISTS `media_category`;

CREATE TABLE `media_category` (
  `mcategoryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `folder_name` varchar(255) NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`mcategoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: media_gallery
#

DROP TABLE IF EXISTS `media_gallery`;

CREATE TABLE `media_gallery` (
  `media_galleryID` int(11) NOT NULL AUTO_INCREMENT,
  `media_gallery_type` int(11) NOT NULL,
  `file_type` varchar(40) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `file_original_name` varchar(255) DEFAULT NULL,
  `file_title` text NOT NULL,
  `file_size` varchar(40) DEFAULT NULL,
  `file_width_height` varchar(40) DEFAULT NULL,
  `file_upload_date` datetime DEFAULT NULL,
  `file_caption` text,
  `file_alt_text` varchar(255) DEFAULT NULL,
  `file_description` text,
  `file_length` varchar(128) DEFAULT NULL,
  `file_artist` varchar(128) DEFAULT NULL,
  `file_album` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`media_galleryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: media_share
#

DROP TABLE IF EXISTS `media_share`;

CREATE TABLE `media_share` (
  `shareID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `classesID` int(11) NOT NULL DEFAULT '0',
  `public` int(11) NOT NULL,
  `file_or_folder` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`shareID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: menu
#

DROP TABLE IF EXISTS `menu`;

CREATE TABLE `menu` (
  `menuID` int(11) NOT NULL AUTO_INCREMENT,
  `menuName` varchar(128) NOT NULL,
  `link` varchar(512) NOT NULL,
  `icon` varchar(128) DEFAULT NULL,
  `pullRight` text,
  `status` int(11) NOT NULL DEFAULT '1',
  `parentID` int(11) NOT NULL DEFAULT '0',
  `priority` int(11) NOT NULL DEFAULT '1000',
  PRIMARY KEY (`menuID`)
) ENGINE=InnoDB AUTO_INCREMENT=211 DEFAULT CHARSET=utf8;

INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (1, 'dashboard', 'dashboard', 'fa-laptop', '', 1, 0, 10000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (2, 'student', 'student', 'icon-student', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (3, 'parents', 'parents', 'fa-user', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (4, 'teacher', 'teacher', 'icon-teacher', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (5, 'user', 'user', 'fa-users', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (6, 'main_academic', '#', 'icon-academicmain', '', 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (7, 'main_attendance', '#', 'icon-attendance', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (8, 'main_exam', '#', 'icon-exam', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (9, 'main_mark', '#', 'icon-markmain', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (10, 'conversation', 'conversation', 'fa-envelope', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (11, 'media', 'media', 'fa-film', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (12, 'mailandsms', '#', 'icon-mailandsms', '', 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (13, 'main_library', '#', 'icon-library', '', 1, 0, 390);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (14, 'main_transport', '#', 'icon-bus', '', 1, 0, 350);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (15, 'main_hostel', '#', 'icon-hhostel', '', 1, 0, 320);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (16, 'main_account', '#', 'icon-account', '', 1, 0, 280);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (17, 'main_announcement', '#', 'icon-noticemain', '', 1, 0, 230);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (18, 'main_report', '#', 'fa-clipboard', '', 1, 0, 190);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (19, 'visitorinfo', 'visitorinfo', 'icon-visitorinfo', '', 1, 0, 150);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (20, 'main_administrator', '#', 'icon-administrator', '', 1, 0, 140);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (21, 'main_settings', '#', 'fa-gavel', '', 1, 0, 30);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (22, 'classes', 'classes', 'fa-sitemap', NULL, 1, 6, 5000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (23, 'section', 'section', 'fa-star', '', 1, 6, 4500);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (24, 'subject', 'subject', 'icon-subject', '', 1, 6, 4000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (25, 'routine', 'routine', 'icon-routine', NULL, 1, 6, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (26, 'syllabus', 'syllabus', 'icon-syllabus', NULL, 1, 6, 3500);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (27, 'assignment', 'assignment', 'icon-assignment', NULL, 1, 6, 3000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (28, 'sattendance', 'sattendance', 'icon-sattendance', NULL, 1, 7, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (29, 'tattendance', 'tattendance', 'icon-tattendance', NULL, 1, 7, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (30, 'exam', 'exam', 'fa-pencil', NULL, 1, 8, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (31, 'examschedule', 'examschedule', 'fa-puzzle-piece', NULL, 1, 8, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (32, 'grade', 'grade', 'fa-signal', NULL, 1, 8, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (33, 'eattendance', 'eattendance', 'icon-eattendance', NULL, 1, 8, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (34, 'mark', 'mark', 'fa-flask', NULL, 1, 9, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (35, 'markpercentage', 'markpercentage', 'icon-markpercentage', NULL, 1, 9, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (36, 'promotion', 'promotion', 'icon-promotion', NULL, 1, 9, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (37, 'notice', 'notice', 'fa-calendar', '', 1, 17, 220);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (38, 'event', 'event', 'fa-calendar-check-o', '', 1, 17, 210);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (39, 'holiday', 'holiday', 'icon-holiday', '', 1, 17, 200);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (40, 'classreport', 'classesreport', 'icon-classreport', '', 1, 18, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (41, 'attendancereport', 'attendancereport', 'icon-attendancereport', '', 1, 18, 940);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (42, 'studentreport', 'studentreport', 'icon-studentreport', '', 1, 18, 990);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (43, 'schoolyear', 'schoolyear', 'fa fa-calendar-plus-o', '', 1, 20, 130);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (44, 'mailandsmstemplate', 'mailandsmstemplate', 'icon-template', '', 1, 12, 100);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (45, 'backup', 'backup', 'fa-download', '', 1, 20, 80);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (46, 'systemadmin', 'systemadmin', 'icon-systemadmin', '', 1, 20, 120);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (47, 'resetpassword', 'resetpassword', 'icon-reset_password', '', 1, 20, 110);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (48, 'permission', 'permission', 'icon-permission', '', 1, 20, 60);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (49, 'usertype', 'usertype', 'icon-role', '', 1, 20, 70);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (50, 'setting', 'setting', 'fa-gears', '', 1, 21, 30);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (51, 'paymentsettings', 'paymentsettings', 'icon-paymentsettings', '', 1, 21, 20);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (52, 'smssettings', 'smssettings', 'fa-wrench', '', 1, 21, 10);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (53, 'invoice', 'invoice', 'icon-invoice', '', 1, 16, 260);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (54, 'paymenthistory', 'paymenthistory', 'icon-payment', '', 1, 16, 250);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (55, 'transport', 'transport', 'icon-sbus', '', 1, 14, 340);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (56, 'member', 'tmember', 'icon-member', '', 1, 14, 330);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (57, 'hostel', 'hostel', 'icon-hostel', '', 1, 15, 310);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (58, 'category', 'category', 'fa-leaf', '', 1, 15, 300);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (59, 'member', 'hmember', 'icon-member', '', 1, 15, 290);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (60, 'feetypes', 'feetypes', 'icon-feetypes', '', 1, 16, 270);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (61, 'expense', 'expense', 'icon-expense', '', 1, 16, 240);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (62, 'member', 'lmember', 'icon-member', '', 1, 13, 380);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (63, 'books', 'book', 'icon-lbooks', '', 1, 13, 370);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (64, 'issue', 'issue', 'icon-issue', '', 1, 13, 360);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (65, 'import', 'bulkimport', 'fa-upload', '', 1, 20, 90);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (66, 'update', 'update', 'fa-refresh', '', 1, 20, 50);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (67, 'main_child', '#', 'fa-child', '', 1, 0, 430);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (68, 'activitiescategory', 'activitiescategory', 'fa-pagelines', '', 1, 67, 420);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (69, 'activities', 'activities', 'fa-fighter-jet', '', 1, 67, 410);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (70, 'childcare', 'childcare', 'fa-wheelchair', '', 1, 67, 400);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (71, 'uattendance', 'uattendance', 'fa-user-secret', NULL, 1, 7, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (72, 'studentgroup', 'studentgroup', 'fa-object-group', '', 1, 20, 129);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (73, 'vendor', 'vendor', 'fa-rss', '', 1, 92, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (74, 'location', 'location', 'fa-newspaper-o', '', 1, 92, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (75, 'asset_category', 'asset_category', 'fa-life-ring', '', 1, 92, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (76, 'asset', 'asset', 'fa-fax', '', 1, 92, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (77, 'complain', 'complain', 'fa-commenting', '', 1, 20, 128);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (78, 'question_group', 'question_group', 'fa-question-circle', '', 1, 84, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (79, 'question_level', 'question_level', 'fa-level-up', '', 1, 84, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (80, 'question_bank', 'question_bank', 'fa-qrcode', '', 1, 84, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (81, 'online_exam', 'online_exam', 'fa-slideshare', '', 1, 84, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (82, 'instruction', 'instruction', 'fa-map-signs', '', 1, 84, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (83, 'take_exam', 'take_exam', 'fa-user-secret', '', 1, 84, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (84, 'main_online_exam', '#', 'fa-graduation-cap', '', 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (85, 'certificatereport', 'certificatereport', 'fa-diamond', '', 1, 18, 860);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (86, 'certificate_template', 'certificate_template', 'fa-certificate', '', 1, 20, 128);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (87, 'main_payroll', '#', 'fa-usd', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (88, 'salary_template', 'salary_template', 'fa-calculator', '', 1, 87, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (89, 'hourly_template', 'hourly_template', 'fa fa-clock-o', '', 1, 87, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (90, 'manage_salary', 'manage_salary', 'fa-beer', '', 1, 87, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (91, 'make_payment', 'make_payment', 'fa-money', '', 1, 87, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (92, 'main_asset_management', '#', 'fa-archive', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (93, 'asset_assignment', 'asset_assignment', 'fa-plug', '', 1, 92, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (94, 'purchase', 'purchase', 'fa-cart-plus', '', 1, 92, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (95, 'main_frontend', '#', 'fa-home', '', 1, 0, 40);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (96, 'pages', 'pages', 'fa-connectdevelop', '', 1, 95, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (97, 'frontend_setting', 'frontend_setting', 'fa-asterisk', '', 1, 21, 25);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (98, 'routinereport', 'routinereport', 'iniicon-routinereport', '', 1, 18, 960);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (99, 'examschedulereport', 'examschedulereport', 'iniicon-examschedulereport', '', 1, 18, 950);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (100, 'feesreport', 'feesreport', 'iniicon-feesreport', '', 1, 18, 850);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (101, 'duefeesreport', 'duefeesreport', 'iniicon-duefeesreport', '', 1, 18, 840);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (102, 'balancefeesreport', 'balancefeesreport', 'iniicon-balancefeesreport', '', 1, 18, 830);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (103, 'transactionreport', 'transactionreport', 'iniicon-transactionreport', '', 1, 18, 820);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (104, 'sociallink', 'sociallink', 'iniicon-sociallink', '', 1, 20, 109);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (105, 'idcardreport', 'idcardreport', 'iniicon-idcardreport', '', 1, 18, 980);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (106, 'admitcardreport', 'admitcardreport', 'iniicon-admitcardreport', '', 1, 18, 970);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (107, 'studentfinereport', 'studentfinereport', 'iniicon-studentfinereport', '', 1, 18, 810);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (108, 'attendanceoverviewreport', 'attendanceoverviewreport', 'iniicon-attendanceoverviewreport', '', 1, 18, 930);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (109, 'income', 'income', 'iniicon-income', '', 1, 16, 239);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (110, 'global_payment', 'global_payment', 'fa-balance-scale', '', 1, 16, 238);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (111, 'terminalreport', 'terminalreport', 'iniicon-terminalreport', '', 1, 18, 920);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (112, 'tabulationsheetreport', 'tabulationsheetreport', 'iniicon-tabulationsheetreport', '', 1, 18, 900);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (113, 'marksheetreport', 'marksheetreport', 'iniicon-marksheetreport', '', 1, 18, 890);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (114, 'meritstagereport', 'meritstagereport', 'iniicon-meritstagereport', '', 1, 18, 910);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (115, 'progresscardreport', 'progresscardreport', 'iniicon-progresscardreport', '', 1, 18, 880);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (116, 'onlineexamreport', 'onlineexamreport', 'iniicon-onlineexamreport', '', 1, 18, 870);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (117, 'main_inventory', '#', 'iniicon-maininventory', '', 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (118, 'productcategory', 'productcategory', 'iniicon-productcategory', '', 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (119, 'product', 'product', 'iniicon-product', '', 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (120, 'productwarehouse', 'productwarehouse', 'iniicon-productwarehouse', '', 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (121, 'productsupplier', 'productsupplier', 'iniicon-productsupplier', '', 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (122, 'productpurchase', 'productpurchase', 'iniicon-productpurchase', '', 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (123, 'productsale', 'productsale', 'iniicon-productsale', '', 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (124, 'main_leaveapplication', '#', 'iniicon-mainleaveapplication', '', 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (125, 'leavecategory', 'leavecategory', 'iniicon-leavecategory', '', 1, 124, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (126, 'leaveassign', 'leaveassign', 'iniicon-leaveassign', '', 1, 124, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (127, 'leaveapply', 'leaveapply', 'iniicon-leaveapply', '', 1, 124, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (128, 'leaveapplication', 'leaveapplication', 'iniicon-leaveapplication', '', 1, 124, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (129, 'librarybooksreport', 'librarybooksreport', 'iniicon-librarybooksreport', '', 1, 18, 925);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (130, 'searchpaymentfeesreport', 'searchpaymentfeesreport', 'iniicon-searchpaymentfeesreport', '', 1, 18, 852);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (131, 'salaryreport', 'salaryreport', 'iniicon-salaryreport', '', 1, 18, 805);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (132, 'productpurchasereport', 'productpurchasereport', 'iniicon-productpurchasereport', '', 1, 18, 854);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (133, 'productsalereport', 'productsalereport', 'iniicon-productsalereport', '', 1, 18, 853);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (134, 'leaveapplicationreport', 'leaveapplicationreport', 'iniicon-leaveapplicationreport', '', 1, 18, 855);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (135, 'posts', 'posts', 'fa-thumb-tack', '', 1, 95, 1005);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (136, 'posts_categories', 'posts_categories', 'fa-anchor', '', 1, 95, 1010);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (137, 'menu', 'frontendmenu', 'iniicon-fmenu', '', 1, 95, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (138, 'librarycardreport', 'librarycardreport', 'iniicon-librarycardreport', '', 1, 18, 924);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (139, 'librarybookissuereport', 'librarybookissuereport', 'iniicon-librarybookissuereport', '', 1, 18, 923);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (140, 'onlineexamquestionreport', 'onlineexamquestionreport', 'iniicon-onlineexamquestionreport', '', 1, 18, 865);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (141, 'ebooks', 'ebooks', 'iniicon-ebook', '', 1, 13, 350);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (142, 'accountledgerreport', 'accountledgerreport', 'iniicon-accountledgerreport', '', 1, 18, 800);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (143, 'onlineadmission', 'onlineadmission', 'iniicon-onlineadmission', '', 1, 0, 160);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (144, 'emailsetting', 'emailsetting', 'iniicon-ini-emailsetting', '', 1, 21, 5);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (145, 'onlineadmissionreport', 'onlineadmissionreport', 'iniicon-onlineadmissionreport', '', 1, 18, 863);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (146, 'marksetting', 'marksetting', 'fa-futbol-o', '', 1, 21, 4);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (147, 'studentsessionreport', 'studentsessionreport', 'fa-recycle', '', 1, 18, 876);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (148, 'overtime', 'overtime', 'fa-retweet', '', 1, 87, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (149, 'overtimereport', 'overtimereport', 'fa-gg-circle', NULL, 1, 18, 808);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (150, 'addons', 'addons', 'fa-crosshairs', '', 1, 20, 55);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (151, 'main_sponsorship', '#', 'fa-gg-circle', '', 1, 0, 300);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (152, 'candidate', 'candidate', 'fa-odnoklassniki', NULL, 1, 151, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (153, 'sponsor', 'sponsor', 'fa-odnoklassniki', '', 1, 151, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (154, 'sponsorship', 'sponsorship', 'fa fa-gg', '', 1, 151, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (155, 'sponsorshipreport', 'sponsorshipreport', 'fa fa-safari', '', 1, 18, 995);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (156, 'onlineexamquestionanswerreport', 'onlineexamquestionanswerreport', 'fa-sticky-note-o', '', 1, 18, 864);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (157, 'Clock In/Out', 'attendance', 'fa-check', '', 1, 7, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (158, 'Student Attendance Report', 'student_attendance_report', 'icon-studentreport', NULL, 1, 18, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (159, 'Teacher Attendance Report', 'teacher_attendance_report', 'icon-attendancereport', '', 1, 18, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (160, 'User Attendance Report', 'user_attendance_report', 'icon-attendancereport', NULL, 1, 18, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (161, 'Scan ID', 'qrcode_attendance', 'fa-qrcode', NULL, 1, 7, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (162, 'Mpesa Transactions', 'mpesa', 'fa-money', NULL, 1, 16, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (163, 'Vendor Purchase Report', 'vendorpurchasereport', 'fa-life-ring', NULL, 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (164, 'Item Purchase Report', 'itempurchasereport', 'fa-flag-o', NULL, 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (165, 'Category Purchase Report', 'categorypurchasereport', 'fa-crosshairs', NULL, 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (166, 'Item Sale Report', 'itemsalereport', 'fa-cart-plus', NULL, 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (167, 'Category Sale Report', 'categorysalereport', 'fa-shopping-cart', NULL, 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (168, 'Wallet Transactions', 'wallet', 'fa-credit-card', NULL, 1, 16, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (169, 'Meal Card', 'lunch', 'fa-cutlery', NULL, 1, 171, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (170, 'Price Settings', 'lunchsetting', 'fa-cog', NULL, 1, 171, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (171, 'Meals', '#', 'fa-cutlery', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (172, 'Meal Logs', 'lunchlogs', 'fa-exchange', NULL, 1, 171, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (205, 'School Term', 'schoolterm', 'fa fa-book', '', 1, 20, 130);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (206, 'Take Student Photo', 'studentids', 'fa-camera', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (207, 'cbcterminalreport', 'cbcterminalreport', 'iniicon-terminalreport', '', 1, 18, 921);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (208, 'sendsms', 'sendsms', 'icon-mailandsms', '', 1, 12, 1001);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (209, 'smsreport', 'mailandsms', 'fa-file', '', 1, 12, 1001);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (210, 'studentleaveout', 'studentleaveout', 'fa-users', '', 1, 124, 1000);


#
# TABLE STRUCTURE FOR: migrations
#

DROP TABLE IF EXISTS `migrations`;

CREATE TABLE `migrations` (
  `version` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `migrations` (`version`) VALUES (1);


#
# TABLE STRUCTURE FOR: mpesa_logs
#

DROP TABLE IF EXISTS `mpesa_logs`;

CREATE TABLE `mpesa_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `referenceNO` varchar(20) DEFAULT NULL,
  `TransID` varchar(20) DEFAULT NULL,
  `TransAmount` double(10,2) DEFAULT NULL,
  `BillRefNumber` varchar(50) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `TransTime` timestamp NULL DEFAULT NULL,
  `name` text,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: notice
#

DROP TABLE IF EXISTS `notice`;

CREATE TABLE `notice` (
  `noticeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(128) NOT NULL,
  `notice` text NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `date` date NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `create_userID` int(11) NOT NULL DEFAULT '0',
  `create_usertypeID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`noticeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: online_exam
#

DROP TABLE IF EXISTS `online_exam`;

CREATE TABLE `online_exam` (
  `onlineExamID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(512) NOT NULL,
  `description` text,
  `classID` int(11) DEFAULT '0',
  `sectionID` int(11) DEFAULT '0',
  `studentGroupID` int(11) DEFAULT '0',
  `subjectID` int(11) DEFAULT '0',
  `userTypeID` int(11) DEFAULT '0',
  `instructionID` int(11) DEFAULT '0',
  `examStatus` varchar(11) NOT NULL,
  `schoolYearID` int(11) NOT NULL,
  `examTypeNumber` int(11) DEFAULT NULL,
  `startDateTime` datetime DEFAULT NULL,
  `endDateTime` datetime DEFAULT NULL,
  `duration` int(11) DEFAULT '0',
  `random` int(11) DEFAULT '0',
  `public` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '1',
  `markType` int(11) NOT NULL,
  `negativeMark` int(11) DEFAULT '0',
  `bonusMark` int(11) DEFAULT '0',
  `point` int(11) DEFAULT '0',
  `percentage` int(11) DEFAULT '0',
  `showMarkAfterExam` int(11) DEFAULT '0',
  `judge` int(11) DEFAULT '1' COMMENT 'Auto Judge = 1, Manually Judge = 0',
  `paid` int(11) DEFAULT '0' COMMENT '0 = Unpaid, 1 = Paid',
  `validDays` int(11) DEFAULT '0',
  `cost` int(11) DEFAULT '0',
  `img` varchar(512) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  `published` int(11) NOT NULL,
  PRIMARY KEY (`onlineExamID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: online_exam_question
#

DROP TABLE IF EXISTS `online_exam_question`;

CREATE TABLE `online_exam_question` (
  `onlineExamQuestionID` int(11) NOT NULL AUTO_INCREMENT,
  `onlineExamID` int(11) NOT NULL,
  `questionID` int(11) DEFAULT NULL,
  PRIMARY KEY (`onlineExamQuestionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: online_exam_type
#

DROP TABLE IF EXISTS `online_exam_type`;

CREATE TABLE `online_exam_type` (
  `onlineExamTypeID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(512) DEFAULT NULL,
  `examTypeNumber` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`onlineExamTypeID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `online_exam_type` (`onlineExamTypeID`, `title`, `examTypeNumber`, `status`) VALUES (1, 'Date , Time and Duration', 5, 1);
INSERT INTO `online_exam_type` (`onlineExamTypeID`, `title`, `examTypeNumber`, `status`) VALUES (2, 'Date and Duration', 4, 1);
INSERT INTO `online_exam_type` (`onlineExamTypeID`, `title`, `examTypeNumber`, `status`) VALUES (3, 'Only Date', 3, 0);
INSERT INTO `online_exam_type` (`onlineExamTypeID`, `title`, `examTypeNumber`, `status`) VALUES (4, 'Only Duration', 2, 1);
INSERT INTO `online_exam_type` (`onlineExamTypeID`, `title`, `examTypeNumber`, `status`) VALUES (5, 'None', 1, 0);


#
# TABLE STRUCTURE FOR: online_exam_user_answer
#

DROP TABLE IF EXISTS `online_exam_user_answer`;

CREATE TABLE `online_exam_user_answer` (
  `onlineExamUserAnswerID` int(11) NOT NULL AUTO_INCREMENT,
  `onlineExamQuestionID` int(11) NOT NULL,
  `onlineExamRegisteredUserID` int(11) DEFAULT NULL,
  `onlineExamID` int(11) NOT NULL,
  `examtimeID` int(11) NOT NULL,
  `userID` int(11) DEFAULT NULL,
  PRIMARY KEY (`onlineExamUserAnswerID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: online_exam_user_answer_option
#

DROP TABLE IF EXISTS `online_exam_user_answer_option`;

CREATE TABLE `online_exam_user_answer_option` (
  `onlineExamUserAnswerOptionID` int(11) NOT NULL AUTO_INCREMENT,
  `questionID` int(11) NOT NULL,
  `optionID` int(11) DEFAULT NULL,
  `typeID` int(11) NOT NULL,
  `text` text,
  `time` datetime NOT NULL,
  `onlineExamID` int(11) NOT NULL,
  `examtimeID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  PRIMARY KEY (`onlineExamUserAnswerOptionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: online_exam_user_status
#

DROP TABLE IF EXISTS `online_exam_user_status`;

CREATE TABLE `online_exam_user_status` (
  `onlineExamUserStatus` int(11) NOT NULL AUTO_INCREMENT,
  `onlineExamID` int(11) NOT NULL,
  `duration` int(11) NOT NULL,
  `score` int(11) NOT NULL,
  `totalQuestion` int(11) NOT NULL,
  `totalAnswer` int(11) NOT NULL,
  `nagetiveMark` int(11) NOT NULL,
  `time` datetime NOT NULL,
  `userID` int(11) NOT NULL,
  `classesID` int(11) DEFAULT NULL,
  `sectionID` int(11) DEFAULT NULL,
  `examtimeID` int(11) DEFAULT NULL,
  `totalCurrectAnswer` int(11) DEFAULT NULL,
  `totalMark` varchar(40) DEFAULT NULL,
  `totalObtainedMark` int(11) DEFAULT NULL,
  `totalPercentage` double DEFAULT NULL,
  `statusID` int(11) DEFAULT NULL,
  PRIMARY KEY (`onlineExamUserStatus`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: onlineadmission
#

DROP TABLE IF EXISTS `onlineadmission`;

CREATE TABLE `onlineadmission` (
  `onlineadmissionID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `sex` varchar(10) DEFAULT NULL,
  `religion` varchar(25) DEFAULT NULL,
  `email` varchar(40) DEFAULT NULL,
  `phone` tinytext,
  `address` varchar(200) DEFAULT NULL,
  `classesID` int(11) DEFAULT NULL,
  `bloodgroup` varchar(5) DEFAULT NULL,
  `country` varchar(128) DEFAULT NULL,
  `photo` varchar(200) DEFAULT NULL,
  `document` varchar(200) DEFAULT NULL,
  `schoolyearID` int(11) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `modify_date` datetime DEFAULT NULL,
  `studentID` int(11) NOT NULL DEFAULT '0',
  `status` int(11) DEFAULT '0' COMMENT '0 = New, 1=Approved, 2 = Waiting, 3 = Declined',
  PRIMARY KEY (`onlineadmissionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: overtime
#

DROP TABLE IF EXISTS `overtime`;

CREATE TABLE `overtime` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `hours` int(11) NOT NULL,
  `amount` double NOT NULL,
  `total_amount` double DEFAULT '0',
  `userID` int(11) NOT NULL,
  `user_table` varchar(40) NOT NULL DEFAULT 'ABCD',
  `usertypeID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: pages
#

DROP TABLE IF EXISTS `pages`;

CREATE TABLE `pages` (
  `pagesID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(128) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `content` text,
  `status` int(11) DEFAULT NULL COMMENT '1 => active, 2 => draft, 3 => trash, 4 => review  ',
  `visibility` int(11) DEFAULT NULL COMMENT '1 => public 2 => protected 3 => private ',
  `publish_date` datetime DEFAULT NULL,
  `parentID` int(11) NOT NULL DEFAULT '0',
  `pageorder` int(11) NOT NULL DEFAULT '0',
  `template` varchar(250) DEFAULT NULL,
  `featured_image` varchar(11) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `modify_date` datetime DEFAULT NULL,
  `create_userID` int(11) DEFAULT NULL,
  `create_username` varchar(60) DEFAULT NULL,
  `create_usertypeID` int(11) DEFAULT NULL,
  `password` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`pagesID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: parents
#

DROP TABLE IF EXISTS `parents`;

CREATE TABLE `parents` (
  `parentsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  `father_name` varchar(60) NOT NULL,
  `mother_name` varchar(60) NOT NULL,
  `father_profession` varchar(40) NOT NULL,
  `mother_profession` varchar(40) NOT NULL,
  `email` varchar(40) DEFAULT NULL,
  `phone` tinytext,
  `address` text,
  `photo` varchar(200) DEFAULT NULL,
  `username` varchar(40) NOT NULL,
  `password` varchar(128) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_username` varchar(60) NOT NULL,
  `create_usertype` varchar(60) NOT NULL,
  `active` int(11) NOT NULL,
  PRIMARY KEY (`parentsID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `parents` (`parentsID`, `name`, `father_name`, `mother_name`, `father_profession`, `mother_profession`, `email`, `phone`, `address`, `photo`, `username`, `password`, `usertypeID`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`, `active`) VALUES (1, 'JAMES AMANI', '', '', '', '', '', '', '', 'default.png', '000001', '2a9e7c6e018e4127eac13315302c2a9a31e15a4d8c8f8024cf2cf993b1ae8d18bf866fd6d4f91f03000116c66d137d4dbb78b6fb4d726cf685192b66cffb5a08', 4, '2024-04-28 08:24:43', '2024-04-28 08:24:43', 1, 'skooly', 'Admin', 1);
INSERT INTO `parents` (`parentsID`, `name`, `father_name`, `mother_name`, `father_profession`, `mother_profession`, `email`, `phone`, `address`, `photo`, `username`, `password`, `usertypeID`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`, `active`) VALUES (2, 'PETER MORGAN', '', '', '', '', '', '', '', 'default.png', 'PETERTM', '29a45ca4e381a282457600684fe73359bc5ab93d47f4bc3b9e4905b355d6e8c3e34fd7b7f7f378cbdc10d588360326c894fc2dd8e7fc2be584851fada428fe0f', 4, '2024-04-28 08:42:54', '2024-04-28 08:42:54', 1, 'skooly', 'Admin', 1);


#
# TABLE STRUCTURE FOR: payment
#

DROP TABLE IF EXISTS `payment`;

CREATE TABLE `payment` (
  `paymentID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `invoiceID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `paymentamount` double DEFAULT NULL,
  `paymenttype` varchar(128) NOT NULL,
  `paymentdate` date NOT NULL,
  `paymentday` varchar(11) NOT NULL,
  `paymentmonth` varchar(10) NOT NULL,
  `paymentyear` year(4) NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `uname` varchar(60) NOT NULL,
  `transactionID` text,
  `globalpaymentID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`paymentID`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;

INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (1, 4, 92, 2, NULL, 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET5033943766350179497', 1);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (2, 4, 93, 2, '13000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8519179937206292211', 1);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (3, 4, 94, 2, '5000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9260749036753122869', 1);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (4, 4, 95, 2, '2000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2024256315949145401', 1);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (5, 4, 60, 10, NULL, 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4346402886210739241', 2);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (6, 4, 61, 10, '2100', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9244027014260470313', 2);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (7, 4, 62, 10, '2000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7433483125802422029', 2);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (8, 4, 84, 24, '35000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7252063764343103621', 3);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (9, 4, 85, 24, '25000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3265826443587301831', 3);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (10, 4, 86, 24, '5000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7483845838835265167', 3);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (11, 4, 87, 24, '2000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3214550057176441586', 3);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (12, 4, 135, 47, NULL, 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4169269661425748208', 4);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (13, 4, 136, 47, '2500', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7953860244732237882', 4);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (14, 4, 137, 47, '2000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4794086352785616914', 4);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (15, 4, 1, 3, '35000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1229856519353498501', 5);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (16, 4, 2, 3, '5000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1232336268733216017', 5);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (17, 4, 3, 3, '2000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3098356018061454268', 5);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (18, 4, 104, 9, '35000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8601376691209691728', 6);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (19, 4, 105, 9, '25000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1718388828533826562', 6);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (20, 4, 106, 9, '5000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1428280816319887408', 6);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (21, 4, 107, 9, '2000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4301941440340176924', 6);


#
# TABLE STRUCTURE FOR: permission_relationships
#

DROP TABLE IF EXISTS `permission_relationships`;

CREATE TABLE `permission_relationships` (
  `permission_id` int(11) NOT NULL,
  `usertype_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (501, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (502, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (506, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (512, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (516, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (531, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (535, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (544, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (548, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (550, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (561, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (571, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (573, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (579, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (580, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (693, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (700, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (709, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (722, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (731, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (748, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (752, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (765, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (769, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (770, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (774, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (775, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (779, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (599, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (501, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (512, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (516, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (531, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (554, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (556, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (579, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (580, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (687, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (688, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (689, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (704, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (705, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (706, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (707, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (708, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (709, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (710, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (711, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (712, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (713, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (714, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (715, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (716, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (717, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (718, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (719, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (720, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (721, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (765, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (769, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (770, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (774, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (775, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (779, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (788, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (789, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (790, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (898, 10);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (906, 10);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (571, 12);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (572, 12);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (573, 12);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (501, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (579, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (744, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (745, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (746, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (748, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (749, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (750, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (751, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (752, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (756, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (757, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (758, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (760, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (761, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (762, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (808, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (502, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (503, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (504, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (506, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (583, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (584, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (585, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (805, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (806, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (807, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (817, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (818, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (895, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (898, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (899, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (905, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (653, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (654, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (655, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (656, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (657, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (658, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (659, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (660, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (661, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (662, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (663, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (664, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (665, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (666, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (667, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (668, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (669, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (670, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (671, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (672, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (673, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (674, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (675, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (676, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (677, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (678, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (900, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (901, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (902, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (903, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (904, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (507, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (508, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (509, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (510, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (501, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (512, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (531, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (544, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (579, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (748, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (765, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (769, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (770, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (774, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (775, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (779, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (501, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (502, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (503, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (504, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (505, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (506, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (522, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (523, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (524, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (525, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (526, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (527, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (528, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (530, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (531, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (532, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (533, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (534, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (579, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (583, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (584, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (585, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (608, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (609, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (610, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (611, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (612, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (613, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (614, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (615, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (616, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (617, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (618, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (619, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (620, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (621, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (622, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (653, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (654, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (655, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (656, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (657, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (658, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (659, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (660, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (661, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (662, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (663, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (664, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (665, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (666, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (667, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (668, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (669, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (670, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (671, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (672, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (673, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (674, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (675, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (676, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (677, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (678, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (744, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (745, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (746, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (747, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (748, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (749, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (750, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (751, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (752, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (753, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (754, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (755, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (756, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (757, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (758, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (759, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (760, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (761, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (762, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (763, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (764, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (765, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (766, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (767, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (768, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (769, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (770, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (771, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (772, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (773, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (774, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (775, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (776, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (777, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (778, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (779, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (802, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (803, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (805, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (806, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (807, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (811, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (812, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (817, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (818, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (819, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (820, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (851, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (894, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (895, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (896, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (897, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (898, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (899, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (900, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (901, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (902, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (903, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (904, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (512, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (513, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (514, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (515, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (516, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (544, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (545, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (546, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (547, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (557, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (558, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (559, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (560, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (565, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (566, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (567, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (568, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (571, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (572, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (573, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (574, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (575, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (576, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (577, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (704, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (705, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (706, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (707, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (708, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (709, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (710, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (711, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (712, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (713, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (714, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (715, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (716, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (791, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (792, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (793, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (795, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (845, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (846, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (847, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (848, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (849, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (784, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (517, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (518, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (519, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (520, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (521, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (915, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (916, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (840, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (917, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (918, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (919, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (920, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (921, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (923, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (922, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (501, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (502, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (503, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (504, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (506, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (512, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (513, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (514, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (522, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (524, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (526, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (528, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (531, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (532, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (533, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (534, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (544, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (545, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (546, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (547, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (579, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (894, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (895, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (896, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (897, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (898, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (557, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (565, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (566, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (567, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (568, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (569, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (570, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (571, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (572, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (573, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (574, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (575, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (576, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (577, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (765, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (766, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (767, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (769, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (770, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (771, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (772, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (774, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (775, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (776, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (777, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (779, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (784, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (785, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (786, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (787, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (791, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (792, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (793, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (795, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (919, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (920, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (921, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (923, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (917, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (501, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (512, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (531, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (544, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (545, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (546, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (571, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (572, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (573, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (579, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (765, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (769, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (770, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (774, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (775, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (779, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (787, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (791, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (793, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (794, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (898, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (522, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (526, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (557, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (565, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (917, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (501, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (502, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (503, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (504, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (512, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (513, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (514, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (579, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (765, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (766, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (767, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (770, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (771, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (772, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (775, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (779, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (791, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (898, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (583, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (584, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (585, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (895, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (896, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (897, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (915, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (916, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (704, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (705, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (706, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (707, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (708, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (709, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (710, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (711, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (712, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (713, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (714, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (715, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (716, 7);


#
# TABLE STRUCTURE FOR: permissions
#

DROP TABLE IF EXISTS `permissions`;

CREATE TABLE `permissions` (
  `permissionID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'In most cases, this should be the name of the module (e.g. news)',
  `active` enum('yes','no') CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`permissionID`)
) ENGINE=InnoDB AUTO_INCREMENT=927 DEFAULT CHARSET=utf8;

INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (501, 'Dashboard', 'dashboard', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (502, 'Student', 'student', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (503, 'Student Add', 'student_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (504, 'Student Edit', 'student_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (505, 'Student Delete', 'student_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (506, 'Student View', 'student_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (507, 'Parents', 'parents', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (508, 'Parents Add', 'parents_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (509, 'Parents Edit', 'parents_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (510, 'Parents Delete', 'parents_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (511, 'Parents View', 'parents_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (512, 'Teacher', 'teacher', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (513, 'Teacher Add', 'teacher_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (514, 'Teacher Edit', 'teacher_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (515, 'Teacher Delete', 'teacher_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (516, 'Teacher View', 'teacher_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (517, 'User', 'user', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (518, 'User Add', 'user_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (519, 'User Edit', 'user_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (520, 'User Delete', 'user_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (521, 'User View', 'user_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (522, 'Class', 'classes', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (523, 'Class Add', 'classes_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (524, 'Class Edit', 'classes_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (525, 'Class Delete', 'classes_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (526, 'Section', 'section', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (527, 'Section Add', 'section_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (528, 'Section Edit', 'section_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (529, 'Semester Delete', 'semester_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (530, 'Section Delete', 'section_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (531, 'Subject', 'subject', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (532, 'Subject Add', 'subject_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (533, 'Subject Edit', 'subject_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (534, 'Subject Delete', 'subject_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (535, 'Syllabus', 'syllabus', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (536, 'Syllabus Add', 'syllabus_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (537, 'Syllabus Edit', 'syllabus_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (538, 'Syllabus Delete', 'syllabus_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (539, 'Assignment', 'assignment', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (540, 'Assignment Add', 'assignment_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (541, 'Assignment Edit', 'assignment_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (542, 'Assignment Delete', 'assignment_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (543, 'Assignment View', 'assignment_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (544, 'Routine', 'routine', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (545, 'Routine Add', 'routine_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (546, 'Routine Edit', 'routine_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (547, 'Routine Delete', 'routine_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (548, 'Student Attendance', 'sattendance', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (549, 'Student Attendance Add', 'sattendance_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (550, 'Student Attendance View', 'sattendance_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (551, 'Teacher Attendance', 'tattendance', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (552, 'Teacher Attendance Add', 'tattendance_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (553, 'Teacher Attendance View', 'tattendance_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (554, 'User Attendance', 'uattendance', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (555, 'User Attendance Add', 'uattendance_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (556, 'User Attendance View', 'uattendance_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (557, 'Exam', 'exam', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (558, 'Exam Add', 'exam_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (559, 'Exam Edit', 'exam_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (560, 'Exam Delete', 'exam_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (561, 'Examschedule', 'examschedule', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (562, 'Examschedule Add', 'examschedule_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (563, 'Examschedule Edit', 'examschedule_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (564, 'Examschedule Delete', 'examschedule_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (565, 'Grade', 'grade', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (566, 'Grade Add', 'grade_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (567, 'Grade Edit', 'grade_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (568, 'Grade Delete', 'grade_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (569, 'Exam Attendance', 'eattendance', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (570, 'Exam Attendance Add', 'eattendance_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (571, 'Mark', 'mark', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (572, 'Mark Add', 'mark_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (573, 'Mark View', 'mark_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (574, 'Mark Distribution', 'markpercentage', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (575, 'Mark Distribution Add', 'markpercentage_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (576, 'Mark Distribution Edit', 'markpercentage_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (577, 'Mark Distribution Delete', 'markpercentage_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (578, 'Promotion', 'promotion', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (579, 'Message', 'conversation', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (580, 'Media', 'media', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (581, 'Media Add', 'media_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (582, 'Media Delete', 'media_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (583, 'Mail / SMS', 'mailandsms', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (584, 'Mail / SMS Add', 'mailandsms_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (585, 'Mail / SMS View', 'mailandsms_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (586, 'Question Group', 'question_group', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (587, 'Question Group Add', 'question_group_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (588, 'Question Group Edit', 'question_group_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (589, 'Question Group Delete', 'question_group_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (590, 'Question Level', 'question_level', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (591, 'Question Level Add', 'question_level_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (592, 'Question Level Edit', 'question_level_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (593, 'Question Level Delete', 'question_level_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (594, 'Question Bank', 'question_bank', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (595, 'Question Bank Add', 'question_bank_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (596, 'Question Bank Edit', 'question_bank_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (597, 'Question Bank Delete', 'question_bank_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (598, 'Question Bank View', 'question_bank_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (599, 'Online Exam', 'online_exam', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (600, 'Online Exam Add', 'online_exam_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (601, 'Online Exam Edit', 'online_exam_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (602, 'Online Exam Delete', 'online_exam_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (603, 'Instruction', 'instruction', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (604, 'Instruction Add', 'instruction_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (605, 'Instruction Edit', 'instruction_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (606, 'Instruction Delete', 'instruction_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (607, 'Instruction View', 'instruction_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (608, 'Salary Template', 'salary_template', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (609, 'Salary Template Add', 'salary_template_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (610, 'Salary Template Edit', 'salary_template_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (611, 'Salary Template Delete', 'salary_template_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (612, 'Salary Template View', 'salary_template_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (613, 'Hourly Template', 'hourly_template', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (614, 'Hourly Template Add', 'hourly_template_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (615, 'Hourly Template Edit', 'hourly_template_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (616, 'Hourly Template Delete', 'hourly_template_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (617, 'Manage Salary', 'manage_salary', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (618, 'Manage Salary Add', 'manage_salary_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (619, 'Manage Salary Edit', 'manage_salary_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (620, 'Manage Salary Delete', 'manage_salary_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (621, 'Manage Salary View', 'manage_salary_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (622, 'Make Payment', 'make_payment', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (623, 'Overtime', 'overtime', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (624, 'Overtime Add', 'overtime_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (625, 'Overtime Edit', 'overtime_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (626, 'Overtime Delete', 'overtime_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (627, 'Vendor', 'vendor', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (628, 'Vendor Add', 'vendor_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (629, 'Vendor Edit', 'vendor_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (630, 'Vendor Delete', 'vendor_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (631, 'Location', 'location', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (632, 'Location Add', 'location_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (633, 'Location Edit', 'location_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (634, 'Location Delete', 'location_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (635, 'Asset Category', 'asset_category', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (636, 'Asset Category Add', 'asset_category_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (637, 'Asset Category Edit', 'asset_category_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (638, 'Asset Category Delete', 'asset_category_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (639, 'Asset', 'asset', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (640, 'Asset Add', 'asset_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (641, 'Asset Edit', 'asset_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (642, 'Asset Delete', 'asset_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (643, 'Asset View', 'asset_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (644, 'Asset Assignment', 'asset_assignment', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (645, 'Asset Assignment Add', 'asset_assignment_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (646, 'Asset Assignment Edit', 'asset_assignment_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (647, 'Asset Assignment Delete', 'asset_assignment_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (648, 'Asset Assignment View', 'asset_assignment_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (649, 'Purchase', 'purchase', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (650, 'Purchase Add', 'purchase_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (651, 'Purchase Edit', 'purchase_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (652, 'Purchase Delete', 'purchase_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (653, 'Product Category', 'productcategory', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (654, 'Product Category Add', 'productcategory_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (655, 'Product Category Edit', 'productcategory_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (656, 'Product Category Delete', 'productcategory_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (657, 'Product', 'product', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (658, 'Product Add', 'product_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (659, 'Product Edit', 'product_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (660, 'Product Delete', 'product_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (661, 'Warehouse', 'productwarehouse', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (662, 'Warehouse Add', 'productwarehouse_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (663, 'Warehouse Edit', 'productwarehouse_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (664, 'Warehouse Delete', 'productwarehouse_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (665, 'Supplier', 'productsupplier', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (666, 'Supplier Add', 'productsupplier_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (667, 'Supplier Edit', 'productsupplier_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (668, 'Supplier Delete', 'productsupplier_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (669, 'Purchase', 'productpurchase', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (670, 'Purchase Add', 'productpurchase_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (671, 'Purchase Edit', 'productpurchase_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (672, 'Purchase Delete', 'productpurchase_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (673, 'Purchase View', 'productpurchase_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (674, 'Sale', 'productsale', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (675, 'Sale Add', 'productsale_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (676, 'Sale Edit', 'productsale_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (677, 'Sale Delete', 'productsale_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (678, 'Sale View', 'productsale_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (679, 'Leave Category', 'leavecategory', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (680, 'Leave Category Add', 'leavecategory_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (681, 'Leave Category Edit', 'leavecategory_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (682, 'Leave Category Delete', 'leavecategory_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (683, 'Leave Assign', 'leaveassign', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (684, 'Leave Assign Add', 'leaveassign_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (685, 'Leave Assign Edit', 'leaveassign_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (686, 'Leave Assign Delete', 'leaveassign_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (687, 'Leave Apply', 'leaveapply', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (688, 'Leave Apply Add', 'leaveapply_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (689, 'Leave Apply Edit', 'leaveapply_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (690, 'Leave Apply Delete', 'leaveapply_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (691, 'Leave Apply View', 'leaveapply_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (692, 'Leave Application', 'leaveapplication', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (693, 'Activities Category', 'activitiescategory', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (694, 'Activities Category Add', 'activitiescategory_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (695, 'Activities Category Edit', 'activitiescategory_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (696, 'Activities Category Delete', 'activitiescategory_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (697, 'Activities', 'activities', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (698, 'Activities Add', 'activities_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (699, 'Activities Delete', 'activities_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (700, 'Child Care', 'childcare', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (701, 'Child Care Add', 'childcare_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (702, 'Child Care Edit', 'childcare_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (703, 'Child Care Delete', 'childcare_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (704, 'Library Member', 'lmember', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (705, 'Library Member Add', 'lmember_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (706, 'Library Member Edit', 'lmember_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (707, 'Library Member Delete', 'lmember_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (708, 'Library Member View', 'lmember_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (709, 'Books', 'book', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (710, 'Books Add', 'book_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (711, 'Books Edit', 'book_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (712, 'Books Delete', 'book_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (713, 'Issue Book', 'issue', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (714, 'Issue Book Add', 'issue_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (715, 'Issue Book Edit', 'issue_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (716, 'Issue Book View', 'issue_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (717, 'E-Books', 'ebooks', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (718, 'E-Books Add', 'ebooks_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (719, 'E-Books Edit', 'ebooks_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (720, 'E-Books Delete', 'ebooks_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (721, 'E-Books View', 'ebooks_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (722, 'Transport', 'transport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (723, 'Transport Add', 'transport_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (724, 'Transport Edit', 'transport_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (725, 'Transport Delete', 'transport_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (726, 'Transport Member', 'tmember', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (727, 'Transport Member Add', 'tmember_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (728, 'Transport Member Edit', 'tmember_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (729, 'Transport Member Delete', 'tmember_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (730, 'Transport Member View', 'tmember_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (731, 'Hostel', 'hostel', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (732, 'Hostel Add', 'hostel_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (733, 'Hostel Edit', 'hostel_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (734, 'Hostel Delete', 'hostel_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (735, 'Hostel Category', 'category', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (736, 'Hostel Category Add', 'category_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (737, 'Hostel Category Edit', 'category_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (738, 'Hostel Category Delete', 'category_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (739, 'Hostel Member', 'hmember', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (740, 'Hostel Member Add', 'hmember_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (741, 'Hostel Member Edit', 'hmember_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (742, 'Hostel Member Delete', 'hmember_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (743, 'Hostel Member View', 'hmember_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (744, 'Fee Types', 'feetypes', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (745, 'Fee Types Add', 'feetypes_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (746, 'Fee Types Edit', 'feetypes_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (747, 'Fee Types Delete', 'feetypes_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (748, 'Invoice', 'invoice', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (749, 'Invoice Add', 'invoice_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (750, 'Invoice Edit', 'invoice_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (751, 'Invoice Delete', 'invoice_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (752, 'Invoice View', 'invoice_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (753, 'Payment History', 'paymenthistory', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (754, 'Payment History Edit', 'paymenthistory_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (755, 'Payment History Delete', 'paymenthistory_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (756, 'Expense', 'expense', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (757, 'Expense Add', 'expense_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (758, 'Expense Edit', 'expense_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (759, 'Expense Delete', 'expense_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (760, 'Income', 'income', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (761, 'Income Add', 'income_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (762, 'Income Edit', 'income_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (763, 'Income Delete', 'income_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (764, 'Global Payment', 'global_payment', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (765, 'Notice', 'notice', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (766, 'Notice Add', 'notice_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (767, 'Notice Edit', 'notice_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (768, 'Notice Delete', 'notice_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (769, 'Notice View', 'notice_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (770, 'Event', 'event', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (771, 'Event Add', 'event_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (772, 'Event Edit', 'event_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (773, 'Event Delete', 'event_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (774, 'Event View', 'event_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (775, 'Holiday', 'holiday', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (776, 'Holiday Add', 'holiday_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (777, 'Holiday Edit', 'holiday_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (778, 'Holiday Delete', 'holiday_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (779, 'Holiday View', 'holiday_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (780, 'Classes Report', 'classesreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (781, 'Student Report', 'studentreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (782, 'ID Card Report', 'idcardreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (783, 'Admit Card Report', 'admitcardreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (784, 'Routine Report', 'routinereport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (785, 'Exam Schedule Report', 'examschedulereport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (786, 'Attendance Report', 'attendancereport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (787, 'Attendance Overview Report', 'attendanceoverviewreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (788, 'Library Books Report', 'librarybooksreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (789, 'Library Card Report', 'librarycardreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (790, 'Library Book Issue Report', 'librarybookissuereport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (791, 'Terminal Report', 'terminalreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (792, 'Merit Stage Report', 'meritstagereport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (793, 'Tabulation Sheet Report', 'tabulationsheetreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (794, 'Mark Sheet Report', 'marksheetreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (795, 'Progress Card Report', 'progresscardreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (796, 'Student Session Report', 'studentsessionreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (797, 'Online Exam Report', 'onlineexamreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (798, 'Online Exam Question Report', 'onlineexamquestionreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (799, 'Online Admission Report', 'onlineadmissionreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (800, 'Certificate Report', 'certificatereport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (801, 'Leave Application Report', 'leaveapplicationreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (802, 'Product Purchase Report', 'productpurchasereport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (803, 'Product Sale Report', 'productsalereport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (804, 'Search Payment Fees Report', 'searchpaymentfeesreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (805, 'Fees Report', 'feesreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (806, 'Due Fees Report', 'duefeesreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (807, 'Balance Fees Report', 'balancefeesreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (808, 'Transaction', 'transactionreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (809, 'Student Fine Report', 'studentfinereport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (810, 'Overtime Report', 'overtimereport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (811, 'Salary Report', 'salaryreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (812, 'Account Ledger Report', 'accountledgerreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (813, 'Online Admission', 'onlineadmission', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (814, 'Visitor Information', 'visitorinfo', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (815, 'Visitor Information Delete', 'visitorinfo_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (816, 'Visitor Infomation View', 'visitorinfo_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (817, 'Academic Year', 'schoolyear', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (818, 'Academic Year Add', 'schoolyear_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (819, 'Academic Year Edit', 'schoolyear_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (820, 'Academic Year Delete', 'schoolyear_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (821, 'Student Group', 'studentgroup', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (822, 'Student Group Add', 'studentgroup_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (823, 'Student Group Edit', 'studentgroup_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (824, 'Student Group Delete', 'studentgroup_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (825, 'Complain', 'complain', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (826, 'Complain Add', 'complain_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (827, 'Complain Edit', 'complain_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (828, 'Complain Delete', 'complain_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (829, 'Complain View', 'complain_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (830, 'Certificate Template', 'certificate_template', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (831, 'Certificate Template Add', 'certificate_template_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (832, 'Certificate Template Edit', 'certificate_template_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (833, 'Certificate Template Delete', 'certificate_template_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (834, 'Certificate Template View', 'certificate_template_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (835, 'System Admin', 'systemadmin', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (836, 'System Admin Add', 'systemadmin_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (837, 'System Admin Edit', 'systemadmin_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (838, 'System Admin Delete', 'systemadmin_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (839, 'System Admin View', 'systemadmin_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (840, 'Reset Password', 'resetpassword', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (841, 'Social Link', 'sociallink', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (842, 'Social Link Add', 'sociallink_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (843, 'Social Link Edit', 'sociallink_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (844, 'Social Link Delete', 'sociallink_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (845, 'Mail / SMS Template', 'mailandsmstemplate', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (846, 'Mail / SMS Template Add', 'mailandsmstemplate_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (847, 'Mail / SMS Template Edit', 'mailandsmstemplate_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (848, 'Mail / SMS Template Delete', 'mailandsmstemplate_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (849, 'Mail / SMS Template View', 'mailandsmstemplate_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (850, 'Import', 'bulkimport ', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (851, 'Backup', 'backup', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (852, 'Role', 'usertype', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (853, 'Role Add', 'usertype_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (854, 'Role Edit', 'usertype_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (855, 'Role Delete', 'usertype_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (856, 'Permission', 'permission', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (857, 'Addons', 'addons', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (858, 'Auto Update', 'update', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (859, 'Posts Categories', 'posts_categories', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (860, 'Posts Categories Add', 'posts_categories_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (861, 'Posts Categories Edit', 'posts_categories_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (862, 'Posts Categories Delete', 'posts_categories_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (863, 'Posts', 'posts', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (864, 'Posts Add', 'posts_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (865, 'Posts Edit', 'posts_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (866, 'Posts Delete', 'posts_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (867, 'Pages', 'pages', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (868, 'Pages Add', 'pages_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (869, 'Pages Edit', 'pages_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (870, 'Pages Delete', 'pages_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (871, 'Menu', 'frontendmenu', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (872, 'General Setting', 'setting', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (873, 'Frontend Setting', 'frontend_setting', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (874, 'Payment Settings', 'paymentsettings', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (875, 'SMS Settings', 'smssettings', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (876, 'Email Setting', 'emailsetting', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (877, 'Mark Settings', 'marksetting', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (878, 'Candidate', 'candidate', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (879, 'Candidate Add', 'candidate_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (880, 'Candidate Edit', 'candidate_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (881, 'Candidate Delete', 'candidate_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (882, 'Candidate View', 'candidate_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (883, 'Sponsor', 'sponsor', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (884, 'Sponsor Add', 'sponsor_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (885, 'Sponsor Edit', 'sponsor_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (886, 'Sponsor Delete', 'sponsor_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (887, 'Sponsor View', 'sponsor_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (888, 'Sponsorship', 'sponsorship', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (889, 'Sponsorship Add', 'sponsorship_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (890, 'Sponsorship Edit', 'sponsorship_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (891, 'Sponsorship Delete', 'sponsorship_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (892, 'Sponsorship Report', 'sponsorshipreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (893, 'Online Exam Question Answer Report', 'onlineexamquestionanswerreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (894, 'Attendance', 'attendance', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (895, 'Student Attendance Report', 'student_attendance_report', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (896, 'Teacher Attendance Report', 'teacher_attendance_report', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (897, 'User Attendance Report', 'user_attendance_report', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (898, 'Qrcode Attendance', 'qrcode_attendance', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (899, 'Mpesa', 'mpesa', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (900, 'Vendor Purchase Report', 'vendorpurchasereport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (901, 'Item Purchase Report', 'itempurchasereport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (902, 'Category Purchase Report', 'categorypurchasereport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (903, 'Item Sale Report', 'itemsalereport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (904, 'Category Sale Report', 'categorysalereport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (905, 'Wallet Transactions', 'wallet', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (906, 'Meal Card', 'lunch', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (907, 'Price Settings', 'lunchsetting', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (908, 'Meal Logs', 'lunchlogs', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (909, 'School Term', 'schoolterm', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (910, 'School Term Add', 'schoolterm_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (911, 'School Term Edit', 'schoolterm_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (912, 'School Term Delete', 'schoolterm_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (913, 'School Term View', 'schoolterm_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (914, 'Generate QRCode', 'generate_qrcode', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (915, 'Process Student IDs', 'studentids', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (916, 'Photo Delete', 'studentids_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (917, 'CBC Terminal Report', 'cbcterminalreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (918, 'SMS Report', 'smsreport', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (919, 'Send SMS', 'sendsms', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (920, 'Student Leave Out', 'studentleaveout', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (921, 'Student Leave Out Edit', 'studentleaveout_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (922, 'Student Leave Out View', 'studentleaveout_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (923, 'Student Leave Out Delete', 'studentleaveout_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (924, 'Database Backup Delete', 'backup_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (925, 'Add Backup', 'backup_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (926, 'Restore Backup', 'backup_restore', 'yes');


#
# TABLE STRUCTURE FOR: posts
#

DROP TABLE IF EXISTS `posts`;

CREATE TABLE `posts` (
  `postsID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(128) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `content` text,
  `status` int(11) DEFAULT NULL COMMENT '1 => active, 2 => draft, 3 => trash, 4 => review  ',
  `visibility` int(11) DEFAULT NULL COMMENT '1 => public 2 => protected 3 => private ',
  `publish_date` datetime DEFAULT NULL,
  `parentID` int(11) NOT NULL DEFAULT '0',
  `postorder` int(11) NOT NULL DEFAULT '0',
  `featured_image` varchar(11) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `modify_date` datetime DEFAULT NULL,
  `create_userID` int(11) DEFAULT NULL,
  `create_username` varchar(60) DEFAULT NULL,
  `create_usertypeID` int(11) DEFAULT NULL,
  `password` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`postsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: posts_categories
#

DROP TABLE IF EXISTS `posts_categories`;

CREATE TABLE `posts_categories` (
  `posts_categoriesID` int(11) NOT NULL AUTO_INCREMENT,
  `posts_categories` varchar(40) DEFAULT NULL,
  `posts_slug` varchar(250) DEFAULT NULL,
  `posts_parent` int(11) DEFAULT '0',
  `posts_description` text,
  PRIMARY KEY (`posts_categoriesID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: posts_category
#

DROP TABLE IF EXISTS `posts_category`;

CREATE TABLE `posts_category` (
  `posts_categoryID` int(11) NOT NULL AUTO_INCREMENT,
  `postsID` int(11) NOT NULL,
  `posts_categoriesID` int(11) NOT NULL,
  PRIMARY KEY (`posts_categoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: product
#

DROP TABLE IF EXISTS `product`;

CREATE TABLE `product` (
  `productID` int(11) NOT NULL AUTO_INCREMENT,
  `productcategoryID` int(11) NOT NULL,
  `productname` varchar(128) NOT NULL,
  `productbuyingprice` double NOT NULL,
  `productsellingprice` double NOT NULL,
  `productdesc` text NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`productID`)
) ENGINE=InnoDB AUTO_INCREMENT=93 DEFAULT CHARSET=utf8;

INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (3, 1, 'BREAD', '60', '0', '', '2023-04-25 14:08:45', '2023-04-25 14:08:45', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (4, 1, 'POJO', '180', '0', '', '2023-04-25 14:09:46', '2023-04-25 14:09:46', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (5, 1, 'MILK', '80', '0', '', '2023-04-25 14:10:25', '2023-04-25 14:10:25', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (6, 1, 'DANIA', '10', '0', '', '2023-04-25 14:10:50', '2023-04-25 14:10:50', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (7, 1, 'ONIONS', '100', '0', '', '2023-04-25 14:11:15', '2023-04-25 14:11:15', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (8, 1, 'GINGER', '10', '0', '', '2023-04-25 14:11:58', '2023-04-25 14:11:58', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (9, 1, 'COOKING OIL', '220', '0', '', '2023-04-25 14:12:53', '2023-04-25 14:12:53', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (10, 4, 'JERRICAN', '30', '0', '', '2023-04-25 14:14:23', '2023-04-25 14:14:23', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (11, 2, 'BODABODA', '50', '0', '', '2023-04-25 14:16:00', '2023-04-25 14:16:00', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (12, 1, 'MEAT', '460', '0', '', '2023-04-25 14:20:41', '2023-04-25 14:20:41', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (13, 4, 'BOTTLED WATER', '25', '0', '', '2023-04-25 14:21:10', '2023-04-25 14:21:10', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (14, 1, 'HOHO', '10', '0', '', '2023-04-25 14:31:28', '2023-04-25 14:31:28', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (15, 1, 'SAUMU', '20', '0', '', '2023-04-25 14:32:10', '2023-04-25 14:32:10', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (16, 1, 'MCHICHA', '100', '0', '', '2023-04-25 14:46:47', '2023-04-25 14:46:47', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (17, 1, 'SUGAR', '160', '0', '', '2023-04-25 15:13:00', '2023-04-25 15:13:00', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (18, 1, 'TOMATOES', '15', '0', '', '2023-04-25 15:14:17', '2023-04-25 15:14:17', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (19, 1, 'MAIZE FLOUR', '100', '0', '', '2023-04-25 15:14:54', '2023-04-25 15:14:54', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (20, 1, 'ROYCO', '10', '0', '', '2023-04-25 15:40:00', '2023-04-25 15:40:00', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (21, 1, 'RICE', '160', '0', '', '2023-04-25 15:53:15', '2023-04-25 15:53:15', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (22, 1, 'SALT', '430', '0', '', '2023-04-25 16:03:41', '2023-04-25 16:03:41', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (23, 1, 'BEANS', '150', '0', '', '2023-04-25 16:05:04', '2023-04-25 16:05:04', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (24, 1, 'POTATOES', '100', '0', '', '2023-04-25 16:12:45', '2023-04-25 16:12:45', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (25, 1, 'PILAU MASALA', '1200', '0', '', '2023-04-25 16:24:44', '2023-04-25 16:24:44', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (26, 1, 'CABBAGE', '100', '0', '', '2023-04-25 16:29:22', '2023-04-25 16:29:22', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (27, 1, 'KALES', '100', '0', '', '2023-04-25 16:30:16', '2023-04-25 16:30:16', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (28, 1, 'FISH', '40', '0', '', '2023-04-25 16:31:03', '2023-04-25 16:31:03', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (29, 5, 'SUPERBRITE', '150', '0', '', '2023-04-25 16:34:09', '2023-04-25 16:34:09', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (30, 5, 'TISSUE', '900', '0', '', '2023-04-25 16:34:43', '2023-04-25 16:34:43', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (31, 5, 'MOP', '350', '0', '', '2023-04-25 16:35:15', '2023-04-25 16:35:15', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (32, 5, 'BROOM', '30', '0', '', '2023-04-25 16:35:44', '2023-04-25 16:35:44', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (33, 5, 'STEEL WIRE', '140', '0', '', '2023-04-25 16:36:35', '2023-04-25 16:36:35', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (34, 6, 'PHOTOCOPYING', '3', '0', '', '2023-04-25 16:37:42', '2023-04-25 16:37:42', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (35, 5, 'SOAP CHEMICAL', '300', '0', '', '2023-04-25 20:15:49', '2023-04-25 20:16:49', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (36, 5, 'JIK CHEMICAL', '130', '0', '', '2023-04-25 20:17:38', '2023-04-25 20:17:38', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (37, 1, 'UJI PWANI', '560', '0', '', '2023-04-25 20:18:14', '2023-04-25 20:18:14', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (38, 5, 'KEROL', '500', '0', '', '2023-04-26 11:25:48', '2023-04-26 11:25:48', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (39, 1, 'CARROT', '80', '0', '', '2023-04-26 11:44:45', '2023-04-26 11:44:45', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (40, 1, 'ROSMARY', '30', '0', '', '2023-04-26 11:45:09', '2023-04-26 11:45:09', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (41, 5, 'KIJIKO CHA MAKAA', '300', '0', '', '2023-04-26 11:45:51', '2023-04-26 11:45:51', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (42, 2, 'TUKTUK', '200', '0', '', '2023-04-26 13:26:42', '2023-04-26 13:26:42', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (43, 5, 'BUCKET', '130', '0', '', '2023-04-26 14:05:20', '2023-04-26 14:05:20', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (44, 5, 'ACID', '100', '0', '', '2023-04-27 12:21:31', '2023-04-27 12:21:31', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (45, 5, 'DUSTBIN', '50', '0', '', '2023-04-27 12:22:24', '2023-04-27 12:22:24', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (46, 3, 'AIRTIME', '20', '0', '', '2023-04-27 12:23:40', '2023-04-27 12:23:40', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (47, 5, 'BASIN', '30', '0', '', '2023-04-27 12:57:17', '2023-04-27 12:57:17', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (48, 6, 'BLACKBOARD RULER', '350', '0', '', '2023-05-02 09:58:43', '2023-05-02 09:58:43', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (49, 6, 'DIARY', '60', '0', '', '2023-05-02 09:59:46', '2023-05-02 09:59:46', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (50, 6, 'GLUE (PER BOTTLE)', '300', '0', '', '2023-05-02 10:01:25', '2023-05-02 10:01:25', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (51, 6, 'WOODGLUE(PER BOTTLE)', '600', '0', '', '2023-05-02 10:02:52', '2023-05-02 10:02:52', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (52, 6, 'CUTTERS', '100', '0', '', '2023-05-02 10:03:59', '2023-05-02 10:03:59', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (53, 6, 'POWDER COLOUR', '200', '0', 'RED,BLUE,GREEN,YELLOW,ORANGE,BROWN', '2023-05-02 10:05:38', '2023-05-02 10:05:38', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (54, 6, 'SCHEMES OF WORK', '250', '0', '', '2023-05-02 10:07:08', '2023-05-02 10:07:08', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (55, 6, 'COLOURED PENCILS...BIG', '150', '0', '', '2023-05-02 10:08:23', '2023-05-02 10:08:23', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (56, 6, 'DUSTERS', '100', '0', '', '2023-05-02 10:10:15', '2023-05-02 10:10:15', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (57, 6, 'PAPER PUNCH', '350', '0', '', '2023-05-02 10:11:55', '2023-05-02 10:11:55', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (58, 6, 'STAPLER', '350', '0', '', '2023-05-02 10:14:40', '2023-05-02 10:14:40', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (59, 6, 'B0X OF STAPLES', '600', '0', '', '2023-05-02 10:15:20', '2023-05-02 10:15:20', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (60, 6, 'FOOLSCAPS', '600', '0', '', '2023-05-02 10:15:48', '2023-05-02 10:15:48', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (61, 6, '30CM RULERS', '22', '0', '', '2023-05-02 10:21:48', '2023-05-02 10:21:48', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (62, 6, 'MANILLA SHEETS', '17', '0', '', '2023-05-02 10:22:22', '2023-05-02 10:22:22', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (63, 6, 'CLASS REGISTERS', '25', '0', '', '2023-05-02 10:23:37', '2023-05-02 10:23:37', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (64, 6, 'WHITE OUT PER BOTTLE', '55', '0', '', '2023-05-02 10:25:27', '2023-05-02 10:25:27', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (65, 6, 'MASKING TAPES', '200', '0', '', '2023-05-02 10:26:37', '2023-05-02 10:26:37', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (66, 6, 'CELLOTAPES', '100', '0', '', '2023-05-02 10:27:27', '2023-05-02 10:27:27', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (67, 6, 'CHALKS(PER CARTON)', '12000', '0', 'OMEGA DUSTLESS', '2023-05-02 10:28:58', '2023-05-02 10:28:58', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (68, 6, 'PENS(PER BOX)', '185', '0', 'RED,BLUE,BLACK', '2023-05-02 10:30:51', '2023-05-02 10:30:51', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (69, 6, 'RUBBERS(PER CONTAINER)', '300', '0', '', '2023-05-02 10:32:59', '2023-05-02 10:32:59', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (70, 6, 'PENCILS(PER GROSS)', '1320', '0', '', '2023-05-02 10:35:19', '2023-05-02 10:35:19', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (71, 6, '96PGS...A4 SINGLE LINES(PER CARTON)', '6000', '0', '', '2023-05-02 10:51:55', '2023-05-02 10:51:55', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (72, 6, '96PGS...A4 SQUARE LINES(PER CARTON)', '6000', '0', '', '2023-05-02 10:57:04', '2023-05-02 10:57:04', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (73, 6, '100PGS..A5 SINGLE LINES.(PER CARTON)', '6000', '0', '', '2023-05-02 10:58:57', '2023-05-02 10:58:57', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (74, 6, '100PGS..A5 SQUARE LINES.(PER CARTON)', '6000', '0', '', '2023-05-02 11:00:27', '2023-05-02 11:00:27', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (75, 6, '100PGS ..A5 PLAIN BOOKS', '6000', '0', '', '2023-05-02 11:04:41', '2023-05-02 11:04:41', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (76, 6, '48PGS..SQUARE LINES 1/2 INCH(PER CARTON)', '6000', '0', '', '2023-05-02 11:06:59', '2023-05-02 11:06:59', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (77, 6, 'THERMO ROLLS', '250', '0', '', '2023-05-02 11:07:58', '2023-05-02 11:07:58', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (78, 1, 'SPINACH', '50', '0', '', '2023-05-13 12:11:53', '2023-05-13 12:11:53', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (79, 1, 'pilipili', '1', '0', '', '2023-05-13 12:26:57', '2023-05-13 12:26:57', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (80, 5, 'KNIFE', '250', '0', '', '2023-05-13 12:42:48', '2023-05-13 12:42:48', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (81, 5, 'PANADOL', '100', '0', '', '2023-05-13 12:43:14', '2023-05-13 12:43:14', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (82, 5, 'ACTAL', '100', '0', '', '2023-05-13 12:43:41', '2023-05-13 12:51:54', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (83, 7, 'TAP & THREADSEAL', '330', '0', '', '2023-05-13 13:13:58', '2023-05-13 13:13:58', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (84, 1, 'MAHAMRI', '5', '0', '', '2023-05-20 10:49:46', '2023-05-20 10:49:46', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (85, 1, 'MCHUNGA', '100', '0', '', '2023-05-20 12:42:09', '2023-05-20 12:42:09', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (86, 5, 'Teepee Toilet Brush', '160', '0', '', '2023-05-26 09:16:44', '2023-05-26 09:16:44', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (87, 5, 'KEY DUPLICATION', '100', '0', '', '2023-05-26 09:51:40', '2023-05-26 09:51:40', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (88, 5, 'MATCHBOX', '5', '0', '', '2023-05-26 10:03:59', '2023-05-26 10:03:59', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (89, 1, 'BANANA', '10', '0', '', '2023-06-03 10:14:11', '2023-06-03 10:14:11', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (90, 1, 'VINEGAR', '100', '0', '', '2023-06-03 10:15:33', '2023-06-03 10:15:33', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (91, 5, 'STRING BALL', '200', '0', '', '2023-06-03 10:18:08', '2023-06-03 10:18:08', 1, 5);
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (92, 5, 'skooly school management', '200', '0', '', '2024-03-08 11:50:48', '2024-03-08 11:50:48', 2, 1);


#
# TABLE STRUCTURE FOR: productcategory
#

DROP TABLE IF EXISTS `productcategory`;

CREATE TABLE `productcategory` (
  `productcategoryID` int(11) NOT NULL AUTO_INCREMENT,
  `productcategoryname` varchar(128) NOT NULL,
  `productcategorydesc` text NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`productcategoryID`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `productcategory` (`productcategoryID`, `productcategoryname`, `productcategorydesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (1, 'FOOD', '', '2023-04-04 16:56:31', '2023-04-04 16:56:31', 1, 5);
INSERT INTO `productcategory` (`productcategoryID`, `productcategoryname`, `productcategorydesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (2, 'TRANSPORT', '', '2023-04-04 17:19:52', '2023-04-04 17:19:52', 1, 5);
INSERT INTO `productcategory` (`productcategoryID`, `productcategoryname`, `productcategorydesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (3, 'UTILITIES', '', '2023-04-04 17:20:45', '2023-04-04 17:20:45', 1, 5);
INSERT INTO `productcategory` (`productcategoryID`, `productcategoryname`, `productcategorydesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (4, 'WATER', '', '2023-04-25 13:34:24', '2023-04-25 13:34:24', 1, 5);
INSERT INTO `productcategory` (`productcategoryID`, `productcategoryname`, `productcategorydesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (5, 'MISCELLANEOUS', '', '2023-04-25 16:32:38', '2023-04-25 16:32:38', 1, 5);
INSERT INTO `productcategory` (`productcategoryID`, `productcategoryname`, `productcategorydesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (6, 'STATIONERY', '', '2023-04-25 16:36:53', '2023-04-25 16:36:53', 1, 5);
INSERT INTO `productcategory` (`productcategoryID`, `productcategoryname`, `productcategorydesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (7, 'REPAIR & MAINTENANCE', '', '2023-05-13 13:12:52', '2023-05-13 13:12:52', 1, 5);


#
# TABLE STRUCTURE FOR: productpurchase
#

DROP TABLE IF EXISTS `productpurchase`;

CREATE TABLE `productpurchase` (
  `productpurchaseID` int(11) NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `productsupplierID` int(11) NOT NULL,
  `productwarehouseID` int(11) NOT NULL,
  `productpurchasereferenceno` varchar(100) NOT NULL,
  `productpurchasedate` date NOT NULL,
  `productpurchasefile` varchar(200) DEFAULT NULL,
  `productpurchasefileorginalname` varchar(200) DEFAULT NULL,
  `productpurchasedescription` text,
  `productpurchasestatus` int(11) NOT NULL COMMENT '0 = pending, 1 = partial_paid,  2 = fully_paid',
  `productpurchaserefund` int(11) NOT NULL DEFAULT '0' COMMENT '0 = not refund, 1 = refund ',
  `productpurchasetaxID` int(11) NOT NULL DEFAULT '0',
  `productpurchasetaxamount` double NOT NULL DEFAULT '0',
  `productpurchasediscount` double NOT NULL DEFAULT '0',
  `productpurchaseshipping` double NOT NULL DEFAULT '0',
  `productpurchasepaymentterm` int(11) NOT NULL DEFAULT '0',
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`productpurchaseID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: productpurchaseitem
#

DROP TABLE IF EXISTS `productpurchaseitem`;

CREATE TABLE `productpurchaseitem` (
  `productpurchaseitemID` int(11) NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `productpurchaseID` int(11) NOT NULL,
  `productID` int(11) NOT NULL,
  `productpurchaseunitprice` double NOT NULL,
  `productpurchasequantity` double NOT NULL,
  PRIMARY KEY (`productpurchaseitemID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: productpurchasepaid
#

DROP TABLE IF EXISTS `productpurchasepaid`;

CREATE TABLE `productpurchasepaid` (
  `productpurchasepaidID` int(11) NOT NULL AUTO_INCREMENT,
  `productpurchasepaidschoolyearID` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `productpurchaseID` int(11) NOT NULL,
  `productpurchasepaiddate` date NOT NULL,
  `productpurchasepaidreferenceno` varchar(100) NOT NULL,
  `productpurchasepaidamount` double NOT NULL,
  `productpurchasepaidpaymentmethod` int(11) NOT NULL COMMENT '1 = cash, 2 = cheque, 3 = crediit card, 4 = other',
  `productpurchasepaidfile` varchar(200) DEFAULT NULL,
  `productpurchasepaidorginalname` varchar(200) DEFAULT NULL,
  `productpurchasepaiddescription` text,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`productpurchasepaidID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: productsale
#

DROP TABLE IF EXISTS `productsale`;

CREATE TABLE `productsale` (
  `productsaleID` int(11) NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `productsalecustomertypeID` int(11) NOT NULL,
  `productsalecustomerID` int(11) NOT NULL,
  `productsalereferenceno` varchar(100) NOT NULL,
  `productsaledate` date NOT NULL,
  `productsalefile` varchar(200) DEFAULT NULL,
  `productsalefileorginalname` varchar(200) DEFAULT NULL,
  `productsaledescription` text,
  `productsalestatus` int(11) NOT NULL COMMENT '0 = select_payment_status, 1 = due,  2 = partial, 3 = Paid',
  `productsalerefund` int(11) NOT NULL DEFAULT '0' COMMENT '0 = not refund, 1 = refund ',
  `productsaletaxID` int(11) NOT NULL DEFAULT '0',
  `productsaletaxamount` double NOT NULL DEFAULT '0',
  `productsalediscount` double NOT NULL DEFAULT '0',
  `productsaleshipping` double NOT NULL DEFAULT '0',
  `productsalepaymentterm` int(11) NOT NULL DEFAULT '0',
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`productsaleID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: productsaleitem
#

DROP TABLE IF EXISTS `productsaleitem`;

CREATE TABLE `productsaleitem` (
  `productsaleitemID` int(11) NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `productsaleID` int(11) NOT NULL,
  `productID` int(11) NOT NULL,
  `productsaleserialno` varchar(100) DEFAULT '0',
  `productsaleunitprice` double NOT NULL,
  `productsalequantity` double NOT NULL,
  PRIMARY KEY (`productsaleitemID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: productsalepaid
#

DROP TABLE IF EXISTS `productsalepaid`;

CREATE TABLE `productsalepaid` (
  `productsalepaidID` int(11) NOT NULL AUTO_INCREMENT,
  `productsalepaidschoolyearID` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `productsaleID` int(11) NOT NULL,
  `productsalepaiddate` date NOT NULL,
  `productsalepaidreferenceno` varchar(100) NOT NULL,
  `productsalepaidamount` double NOT NULL,
  `productsalepaidpaymentmethod` int(11) NOT NULL COMMENT '1 = cash, 2 = cheque, 3 = crediit card, 4 = other',
  `productsalepaidfile` varchar(200) DEFAULT NULL,
  `productsalepaidorginalname` varchar(200) DEFAULT NULL,
  `productsalepaiddescription` text,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`productsalepaidID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: productsupplier
#

DROP TABLE IF EXISTS `productsupplier`;

CREATE TABLE `productsupplier` (
  `productsupplierID` int(11) NOT NULL AUTO_INCREMENT,
  `productsuppliercompanyname` varchar(128) NOT NULL,
  `productsuppliername` varchar(40) NOT NULL,
  `productsupplieremail` varchar(40) DEFAULT NULL,
  `productsupplierphone` varchar(20) DEFAULT NULL,
  `productsupplieraddress` text,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`productsupplierID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `productsupplier` (`productsupplierID`, `productsuppliercompanyname`, `productsuppliername`, `productsupplieremail`, `productsupplierphone`, `productsupplieraddress`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (1, 'skooly', 'skooly', '', '', '', '2024-03-08 11:49:51', '2024-03-08 11:49:51', 2, 1);


#
# TABLE STRUCTURE FOR: productwarehouse
#

DROP TABLE IF EXISTS `productwarehouse`;

CREATE TABLE `productwarehouse` (
  `productwarehouseID` int(11) NOT NULL AUTO_INCREMENT,
  `productwarehousename` varchar(128) NOT NULL,
  `productwarehousecode` varchar(128) NOT NULL,
  `productwarehouseemail` varchar(40) DEFAULT NULL,
  `productwarehousephone` varchar(20) DEFAULT NULL,
  `productwarehouseaddress` text,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`productwarehouseID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `productwarehouse` (`productwarehouseID`, `productwarehousename`, `productwarehousecode`, `productwarehouseemail`, `productwarehousephone`, `productwarehouseaddress`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (1, 'OFFICE', 'OFC', '', '', '', '2022-02-28 18:44:06', '2022-11-01 12:13:34', 2, 1);
INSERT INTO `productwarehouse` (`productwarehouseID`, `productwarehousename`, `productwarehousecode`, `productwarehouseemail`, `productwarehousephone`, `productwarehouseaddress`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (2, 'KITCHEN', 'ktc', '', '', '', '2023-04-04 17:00:50', '2023-04-04 17:00:50', 1, 5);
INSERT INTO `productwarehouse` (`productwarehouseID`, `productwarehousename`, `productwarehousecode`, `productwarehouseemail`, `productwarehousephone`, `productwarehouseaddress`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES (3, 'SCH STORE', 'str', '', '', '', '2023-04-25 20:00:22', '2023-04-25 20:00:45', 1, 5);


#
# TABLE STRUCTURE FOR: promotionlog
#

DROP TABLE IF EXISTS `promotionlog`;

CREATE TABLE `promotionlog` (
  `promotionLogID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `promotionType` varchar(50) DEFAULT NULL,
  `classesID` int(11) NOT NULL,
  `jumpClassID` int(11) NOT NULL,
  `schoolYearID` int(11) NOT NULL,
  `jumpSchoolYearID` int(11) NOT NULL,
  `subjectandsubjectcodeandmark` longtext,
  `exams` longtext,
  `markpercentages` longtext,
  `promoteStudents` longtext,
  `status` int(11) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  PRIMARY KEY (`promotionLogID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: purchase
#

DROP TABLE IF EXISTS `purchase`;

CREATE TABLE `purchase` (
  `purchaseID` int(11) NOT NULL AUTO_INCREMENT,
  `assetID` int(11) NOT NULL,
  `vendorID` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit` int(11) DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `service_date` date DEFAULT NULL,
  `purchase_price` double NOT NULL,
  `purchased_by` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `expire_date` date DEFAULT NULL,
  `create_date` date NOT NULL,
  `modify_date` date NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`purchaseID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: question_answer
#

DROP TABLE IF EXISTS `question_answer`;

CREATE TABLE `question_answer` (
  `answerID` int(11) NOT NULL AUTO_INCREMENT,
  `questionID` int(11) NOT NULL,
  `optionID` int(11) DEFAULT NULL,
  `typeNumber` int(11) NOT NULL,
  `text` text,
  PRIMARY KEY (`answerID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: question_bank
#

DROP TABLE IF EXISTS `question_bank`;

CREATE TABLE `question_bank` (
  `questionBankID` int(11) NOT NULL AUTO_INCREMENT,
  `question` text NOT NULL,
  `explanation` text,
  `levelID` int(11) DEFAULT NULL,
  `groupID` int(11) DEFAULT NULL,
  `totalQuestion` int(11) DEFAULT '0',
  `totalOption` int(11) DEFAULT NULL,
  `typeNumber` int(11) DEFAULT NULL,
  `parentID` int(11) DEFAULT '0',
  `time` int(11) DEFAULT '0',
  `mark` int(11) DEFAULT '0',
  `hints` text,
  `upload` varchar(512) DEFAULT NULL,
  `subjectID` int(11) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`questionBankID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: question_group
#

DROP TABLE IF EXISTS `question_group`;

CREATE TABLE `question_group` (
  `questionGroupID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) NOT NULL,
  PRIMARY KEY (`questionGroupID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `question_group` (`questionGroupID`, `title`) VALUES (1, 'Reasoning');
INSERT INTO `question_group` (`questionGroupID`, `title`) VALUES (2, 'Computer Knowledge');
INSERT INTO `question_group` (`questionGroupID`, `title`) VALUES (3, 'General');
INSERT INTO `question_group` (`questionGroupID`, `title`) VALUES (4, 'Math');
INSERT INTO `question_group` (`questionGroupID`, `title`) VALUES (5, 'GRE');
INSERT INTO `question_group` (`questionGroupID`, `title`) VALUES (6, 'Sports');


#
# TABLE STRUCTURE FOR: question_level
#

DROP TABLE IF EXISTS `question_level`;

CREATE TABLE `question_level` (
  `questionLevelID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  PRIMARY KEY (`questionLevelID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `question_level` (`questionLevelID`, `name`) VALUES (1, 'Easy');
INSERT INTO `question_level` (`questionLevelID`, `name`) VALUES (2, 'Medium');
INSERT INTO `question_level` (`questionLevelID`, `name`) VALUES (3, 'Hard');


#
# TABLE STRUCTURE FOR: question_option
#

DROP TABLE IF EXISTS `question_option`;

CREATE TABLE `question_option` (
  `optionID` int(11) NOT NULL AUTO_INCREMENT,
  `questionID` int(11) NOT NULL,
  `name` varchar(512) NOT NULL,
  `img` varchar(512) DEFAULT NULL,
  PRIMARY KEY (`optionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: question_type
#

DROP TABLE IF EXISTS `question_type`;

CREATE TABLE `question_type` (
  `questionTypeID` int(11) NOT NULL AUTO_INCREMENT,
  `typeNumber` int(11) NOT NULL,
  `name` varchar(512) NOT NULL,
  PRIMARY KEY (`questionTypeID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `question_type` (`questionTypeID`, `typeNumber`, `name`) VALUES (1, 1, 'Single Answer');
INSERT INTO `question_type` (`questionTypeID`, `typeNumber`, `name`) VALUES (2, 2, 'Multi Answer');
INSERT INTO `question_type` (`questionTypeID`, `typeNumber`, `name`) VALUES (3, 3, 'Fill in the blanks');


#
# TABLE STRUCTURE FOR: reminders
#

DROP TABLE IF EXISTS `reminders`;

CREATE TABLE `reminders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(600) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: reset
#

DROP TABLE IF EXISTS `reset`;

CREATE TABLE `reset` (
  `resetID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `keyID` varchar(128) NOT NULL,
  `email` varchar(60) NOT NULL,
  PRIMARY KEY (`resetID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `reset` (`resetID`, `keyID`, `email`) VALUES (1, '02bc25d60de89319ef81cad6d5057dbb22910e2a1cd06dc15b35400d7d7e59766d9a491a3dbe2af4820fe4eac98df003463a922e117e462ae99e32e1fcd0c805', 'kibetamos567@gmail.com');


#
# TABLE STRUCTURE FOR: routine
#

DROP TABLE IF EXISTS `routine`;

CREATE TABLE `routine` (
  `routineID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `classesID` int(11) NOT NULL,
  `sectionID` int(11) NOT NULL,
  `subjectID` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `teacherID` int(11) NOT NULL,
  `day` varchar(60) NOT NULL,
  `start_time` varchar(10) NOT NULL,
  `end_time` varchar(10) NOT NULL,
  `room` tinytext NOT NULL,
  PRIMARY KEY (`routineID`)
) ENGINE=InnoDB AUTO_INCREMENT=188 DEFAULT CHARSET=utf8;

INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (1, 3, 3, 11, 2, 20, '1', '8:00 AM', '8:35 AM', 'G1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (2, 3, 3, 12, 2, 20, '1', '9:25 AM', '10:00 AM', 'G1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (3, 3, 3, 13, 2, 20, '1', '10:00 AM', '10:35 AM', 'G1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (4, 3, 3, 14, 2, 20, '1', '10:35 AM', '11:00 AM', 'G1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (5, 11, 10, 74, 3, 27, '1', '9:00 AM', '9:35 AM', 'hall');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (6, 2, 3, 6, 3, 20, '1', '9:20 AM', '9:50 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (7, 2, 3, 9, 3, 20, '1', '11:00 AM', '11:30 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (8, 1, 9, 78, 3, 29, '1', '9:50 AM', '10:20 AM', 'Pp1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (9, 1, 9, 79, 3, 29, '1', '9:20 AM', '9:50 AM', 'Pp1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (10, 1, 9, 80, 3, 29, '1', '11:30 AM', '12:00 PM', 'Pp1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (11, 2, 3, 7, 3, 20, '1', '8:50 AM', '9:20 AM', 'Pp2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (12, 1, 9, 82, 3, 29, '1', '10:20 AM', '10:50 AM', 'Pp1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (13, 2, 3, 7, 3, 20, '2', '8:50 AM', '9:20 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (14, 2, 21, 141, 1, 37, '1', '9:20 AM', '9:50 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (15, 2, 3, 6, 3, 20, '2', '9:20 AM', '9:50 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (16, 2, 21, 142, 1, 37, '1', '8:50 AM', '9:20 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (17, 2, 21, 143, 1, 37, '1', '11:00 AM', '11:30 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (18, 2, 3, 9, 3, 20, '2', '11:00 AM', '11:30 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (19, 2, 21, 141, 1, 37, '2', '8:50 AM', '9:20 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (20, 2, 21, 142, 1, 37, '2', '9:20 AM', '9:50 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (21, 2, 21, 143, 1, 37, '2', '11:00 AM', '11:30 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (22, 2, 21, 141, 1, 37, '3', '9:20 AM', '9:50 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (23, 2, 3, 7, 3, 20, '3', '8:50 AM', '9:20 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (24, 5, 11, 112, 3, 34, '1', '8:00 AM', '8:30 AM', 'class');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (25, 3, 3, 83, 3, 20, '1', '8:15 AM', '11:15 AM', 'Class');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (26, 11, 10, 74, 3, 27, '2', '9:00 AM', '9:35 AM', 'Hall');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (27, 2, 21, 6, 3, 37, '1', '9:20 AM', '9:50 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (28, 5, 11, 113, 3, 22, '2', '8:30 PM', '9:00 AM', 'CLASS');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (29, 3, 3, 85, 3, 20, '1', '8:20 AM', '8:50 AM', 'Class');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (30, 2, 21, 7, 3, 37, '1', '8:50 AM', '9:20 PM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (31, 2, 21, 9, 3, 37, '1', '11:00 AM', '11:30 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (32, 2, 21, 6, 3, 37, '2', '9:20 AM', '9:50 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (33, 2, 21, 7, 3, 37, '2', '8:50 AM', '9:20 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (34, 2, 21, 9, 3, 37, '2', '11:00 AM', '11:30 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (35, 2, 21, 6, 3, 37, '3', '9:20 AM', '9:50 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (36, 4, 7, 90, 3, 21, '1', '8:20 AM', '8:55 AM', 'Grade 2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (37, 2, 21, 7, 3, 37, '3', '8:50 AM', '9:20 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (38, 2, 3, 6, 3, 20, '3', '9:20 AM', '9:50 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (39, 4, 18, 90, 3, 28, '2', '8:20 AM', '8:55 AM', 'Peak');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (40, 2, 21, 9, 3, 37, '3', '11:00 AM', '11:30 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (41, 2, 3, 9, 3, 20, '3', '11:00 AM', '11:30 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (42, 2, 3, 7, 3, 20, '4', '8:50 AM', '9:20 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (43, 2, 21, 6, 3, 37, '4', '9:20 AM', '9:50 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (44, 4, 7, 90, 3, 21, '1', '8:20 AM', '8:20 PM', '2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (45, 2, 3, 6, 3, 20, '4', '9:20 AM', '9:50 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (46, 2, 21, 7, 3, 37, '4', '8:50 AM', '9:50 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (47, 5, 11, 115, 3, 22, '2', '8:00 AM', '8:30 AM', 'CLASS');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (48, 5, 19, 112, 3, 23, '1', '1:30 PM', '1:30 PM', 'Grade 3');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (49, 2, 3, 9, 3, 20, '4', '11:00 AM', '11:30 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (50, 2, 21, 9, 3, 37, '4', '11:00 AM', '11:30 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (51, 5, 11, 117, 3, 22, '1', '8:45 AM', '8:45 AM', 'CLASS');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (52, 2, 21, 6, 3, 37, '5', '9:20 AM', '9:50 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (53, 8, 14, 59, 3, 38, '1', '2:00 PM', '2:35 PM', 'Hall');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (54, 2, 21, 7, 1, 37, '5', '8:50 AM', '9:20 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (55, 2, 21, 9, 3, 37, '5', '11:00 AM', '11:30 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (56, 2, 21, 7, 3, 37, '5', '8:50 AM', '9:20 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (57, 2, 3, 7, 3, 20, '5', '8:50 AM', '9:20 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (58, 2, 3, 6, 3, 20, '5', '9:20 AM', '9:50 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (59, 2, 3, 9, 3, 20, '5', '11:00 AM', '11:30 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (60, 6, 12, 72, 3, 38, '1', '8:00 AM', '8:35 AM', 'Hall');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (61, 7, 13, 22, 3, 38, '1', '9:25 AM', '10:00 AM', 'hall');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (62, 7, 13, 68, 3, 38, '2', '8:35 AM', '9:10 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (63, 9, 15, 49, 3, 38, '3', '3:10 PM', '4:00 PM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (64, 9, 15, 49, 3, 38, '1', '2:35 PM', '3:10 PM', 'Hall');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (65, 4, 18, 90, 3, 28, '2', '8:00 AM', '8:55 AM', 'Peak');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (66, 10, 16, 127, 3, 44, '1', '2:30 PM', '3:30 PM', 'CLASS');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (67, 2, 21, 8, 3, 37, '1', '9:50 AM', '10:20 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (68, 5, 19, 113, 3, 23, '1', '8:50 AM', '9:20 AM', 'Class');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (69, 2, 21, 8, 3, 37, '2', '9:50 AM', '10:20 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (70, 2, 21, 8, 3, 37, '3', '9:50 AM', '10:20 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (71, 10, 16, 127, 3, 44, '3', '2:30 PM', '3:30 PM', 'CLASS');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (72, 10, 16, 127, 3, 44, '5', '2:30 PM', '3:30 PM', 'CLASS');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (73, 3, 3, 84, 3, 20, '1', '11:40 AM', '12:10 AM', 'Class');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (74, 2, 21, 8, 3, 37, '4', '9:50 AM', '10:20 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (75, 5, 19, 118, 3, 23, '1', '9:50 AM', '10:50 AM', 'Class');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (76, 2, 21, 8, 3, 37, '5', '9:50 AM', '10:20 AM', 'PP2');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (77, 5, 19, 117, 3, 23, '1', '11:49 AM', '12:10 AM', 'class');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (78, 2, 3, 8, 3, 20, '1', '9:50 AM', '10:20 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (79, 2, 3, 8, 3, 20, '2', '9:50 AM', '10:20 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (80, 2, 3, 8, 3, 20, '3', '9:50 AM', '10:20 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (81, 2, 3, 8, 3, 20, '4', '9:50 AM', '10:20 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (82, 2, 3, 8, 3, 20, '5', '9:50 AM', '10:20 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (83, 4, 18, 92, 3, 28, '1', '8:20 AM', '8:55 AM', 'Peak');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (84, 7, 13, 68, 3, 38, '1', '2:00 PM', '2:00 PM', 'Hall');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (85, 6, 12, 72, 3, 38, '2', '8:00 AM', '8:30 AM', 'Hall');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (86, 9, 15, 50, 3, 38, '2', '2:30 PM', '3:15 PM', 'Hall');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (87, 7, 13, 68, 3, 38, '2', '9:30 PM', '10: AM', 'Hall');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (88, 7, 13, 132, 3, 41, '3', '1:15 PM', '2:00 PM', 'Grade 5');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (89, 6, 12, 72, 3, 38, '5', '9:00 PM', '9:00 AM', 'Hall');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (90, 7, 13, 68, 3, 38, '4', '10:00 AM', '10:35 AM', 'Hall');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (91, 7, 13, 22, 3, 38, '2', '8:00 AM', '8:35 AM', 'Hall');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (92, 8, 14, 59, 3, 38, '3', '1:30 AM', '2:00 PM', 'Hall');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (93, 10, 16, 121, 3, 17, '1', '9:00 AM', '10:00 AM', 'HALL');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (94, 8, 23, 59, 3, 38, '2', '3:00 PM', '3:15 PM', '1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (95, 7, 22, 66, 3, 30, '1', '9:25 AM', '10:00 AM', 'Grade 5');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (96, 9, 15, 52, 3, 30, '1', '2:00 PM', '2:35 PM', 'Class 7');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (97, 8, 23, 57, 3, 38, '3', '11:00 AM', '11:35 AM', 'G6');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (98, 8, 14, 140, 3, 30, '5', '8:00 AM', '8:35 AM', '6');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (99, 8, 14, 140, 3, 30, '5', '8:35 AM', '9:10 AM', '6H');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (100, 6, 12, 104, 3, 30, '2', '9:25 AM', '10:00 AM', 'G4');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (101, 8, 14, 60, 3, 30, '3', '2:00 PM', '2:35 PM', 'G6');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (102, 8, 14, 60, 3, 30, '5', '2:35 PM', '3:10 PM', 'G6');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (103, 8, 23, 140, 3, 30, '4', '8:35 AM', '9:10 AM', 'G6');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (104, 3, 3, 83, 3, 20, '1', '8:20 AM', '8:50 AM', 'G1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (105, 3, 3, 84, 3, 20, '1', '11:10 AM', '11:40 AM', 'Peak');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (106, 3, 3, 84, 3, 20, '1', '12:10 AM', '11:40 AM', 'Peak');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (107, 3, 3, 85, 3, 20, '3', '10:00 AM', '10:00 AM', 'Peak');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (108, 3, 3, 87, 3, 20, '3', '10:50 AM', '11:20 AM', 'Peak');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (112, 3, 3, 99, 3, 20, '2', '10:20 AM', '10:50 AM', 'Peak');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (113, 3, 3, 86, 3, 20, '2', '9:50 AM', '10:20 AM', 'Peak');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (114, 3, 3, 85, 4, 20, '1', '8:00 AM', '9:00 AM', 'Grade 1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (115, 10, 16, 124, 3, 38, '1', '10:00 AM', '10:35 AM', 'C8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (116, 8, 14, 137, 4, 44, '3', '11:45 AM', '7:00 PM', 'Grade 6');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (117, 7, 13, 68, 4, 18, '1', '2:00 PM', '2:45 PM', 'G5');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (118, 7, 13, 69, 4, 18, '3', '11:00 AM', '11:45 AM', 'G5');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (119, 8, 14, 60, 4, 18, '5', '10:00 AM', '10:45 AM', 'G6');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (121, 9, 24, 51, 4, 38, '3', '7:00 AM', '7:30 AM', 'Hall');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (122, 8, 14, 137, 4, 44, '1', '8:00 AM', '8:35 AM', 'Grade 6');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (123, 10, 10, 121, 4, 28, '2', '8:00 AM', '8:40 AM', 'C8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (124, 6, 12, 111, 4, 38, '1', '9:00 AM', '9:30 AM', 'Hall');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (125, 8, 14, 59, 4, 38, '4', '2:35 PM', '3:00 PM', 'Hall');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (126, 9, 15, 51, 4, 38, '3', '11:00 AM', '11:30 AM', 'G5');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (127, 8, 14, 137, 4, 44, '1', '8:35 AM', '9:10 AM', 'G6');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (128, 7, 13, 133, 4, 44, '2', '11:00 AM', '11:35 AM', 'G5');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (129, 3, 3, 83, 4, 20, '1', '8:50 AM', '9:20 AM', 'G1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (130, 3, 3, 85, 4, 20, '1', '9:50 AM', '10:20 AM', 'G1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (131, 6, 12, 103, 4, 44, '1', '9:25 AM', '10:00 AM', 'G4');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (132, 3, 3, 100, 4, 20, '1', '11:40 AM', '12:10 PM', 'G1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (133, 3, 3, 99, 4, 20, '2', '9:50 AM', '10:20 AM', 'G1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (134, 3, 3, 84, 4, 20, '2', '10:20 AM', '10:50 AM', 'G1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (135, 9, 15, 52, 4, 44, '2', '3:20 AM', '4:00 AM', 'G7');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (136, 3, 3, 89, 4, 20, '2', '11:40 AM', '12:10 PM', 'G1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (137, 3, 3, 88, 4, 20, '2', '12:10 PM', '12:40 PM', 'G1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (138, 10, 10, 126, 4, 34, '1', '8:00 AM', '8:40 AM', 'CLASS 8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (139, 3, 3, 86, 4, 20, '3', '10:50 AM', '11:20 AM', 'G1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (140, 9, 24, 52, 4, 44, '4', '3:20 PM', '4:00 PM', 'GD7');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (141, 6, 20, 103, 4, 44, '2', '8:35 AM', '9:10 AM', 'GD4');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (142, 9, 24, 52, 4, 44, '1', '3:20 PM', '4:00 PM', 'GD7');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (143, 6, 12, 107, 4, 44, '1', '2:35 PM', '3:10 PM', 'GD4');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (144, 6, 20, 107, 4, 44, '2', '8:15 AM', '8:15 AM', 'G4');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (145, 9, 15, 46, 4, 46, '1', '12:00 AM', '9:20 AM', 'G7');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (146, 9, 24, 54, 4, 46, '1', '8:00 AM', '8:40 AM', 'G7');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (147, 9, 15, 54, 4, 46, '1', '11:50 AM', '12:30 PM', 'G7');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (148, 9, 24, 54, 4, 46, '1', '9:20 AM', '10:00 AM', 'G7');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (149, 9, 15, 53, 4, 46, '1', '12:00 PM', '12:00 PM', 'LAB');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (150, 9, 24, 53, 4, 46, '4', '12:00 PM', '12:00 PM', 'LAB');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (151, 10, 10, 124, 4, 30, '2', '8:40 AM', '9:20 AM', 'CLASS 8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (152, 10, 10, 122, 4, 32, '1', '8:40 AM', '9:20 AM', 'CLASS 8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (153, 3, 3, 87, 4, 20, '4', '10:00 AM', '11:20 AM', 'G1');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (154, 6, 12, 105, 4, 47, '1', '3:15 PM', '3:15 PM', 'G4');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (155, 6, 20, 105, 4, 47, '1', '2:00 AM', '2:15 PM', 'G4');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (156, 9, 15, 46, 4, 46, '1', '8:40 AM', '9:20 AM', 'G7');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (157, 10, 10, 159, 4, 32, '1', '10:10 AM', '10:50 AM', 'C8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (158, 9, 15, 157, 4, 46, '2', '11:10 AM', '11:50 AM', 'G7');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (159, 9, 24, 157, 4, 46, '2', '11:50 AM', '12:30 PM', 'G7');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (160, 6, 20, 147, 4, 42, '1', '2:35 PM', '3:10 PM', 'G4');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (161, 8, 14, 146, 4, 42, '3', '2:00 PM', '2:35 PM', 'G6');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (162, 7, 13, 148, 4, 42, '2', '2:00 PM', '2:35 PM', 'G5');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (163, 6, 12, 147, 4, 42, '4', '2:00 PM', '2:35 PM', 'G7');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (164, 8, 14, 30, 4, 47, '2', '8:35 AM', '9:10 AM', 'G6');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (165, 8, 14, 136, 4, 47, '3', '9:25 AM', '10:00 AM', 'G6');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (166, 8, 14, 57, 4, 47, '2', '8:00 AM', '8:35 AM', 'G6');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (167, 6, 20, 72, 4, 47, '1', '8:00 AM', '8:35 AM', 'G4');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (168, 6, 12, 72, 4, 47, '1', '11:00 AM', '11:35 AM', 'G4');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (169, 10, 10, 121, 4, 28, '1', '9:30 AM', '10:10 AM', 'G8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (170, 10, 10, 127, 4, 31, '1', '11:10 AM', '11:50 AM', 'C8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (171, 10, 10, 160, 4, 33, '1', '11:50 AM', '12:10 PM', 'C8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (172, 10, 10, 128, 4, 28, '1', '2:00 PM', '2:40 PM', 'C8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (173, 10, 10, 124, 4, 30, '1', '2:40 PM', '3:20 PM', 'C8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (174, 10, 10, 122, 4, 32, '2', '9:30 AM', '10:10 AM', 'C8 RED');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (175, 10, 10, 126, 4, 34, '2', '10:10 AM', '10:50 AM', 'C8 RED');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (176, 10, 10, 160, 4, 33, '2', '11:10 AM', '11:50 AM', 'C8 RED');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (177, 10, 10, 127, 4, 31, '2', '11:50 AM', '12:30 AM', 'C8 RED');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (178, 10, 10, 129, 4, 34, '2', '2:00 PM', '2:40 PM', 'C8 RED');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (179, 10, 10, 129, 4, 34, '2', '2:40 PM', '3:20 PM', 'C8 RED');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (180, 10, 10, 128, 4, 28, '3', '8:00 AM', '8:40 AM', 'C8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (181, 10, 10, 127, 4, 31, '3', '8:40 AM', '9:20 AM', 'C8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (182, 10, 10, 121, 4, 28, '3', '9:30 AM', '10:10 AM', 'C8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (183, 10, 10, 160, 4, 33, '3', '10:10 AM', '10:50 AM', 'C8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (184, 10, 10, 126, 4, 34, '3', '11:10 AM', '11:50 AM', 'C8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (185, 10, 10, 159, 4, 32, '3', '11:50 AM', '12:30 PM', 'C8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (186, 10, 10, 124, 4, 30, '3', '2:00 PM', '2:40 PM', 'C8');
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES (187, 10, 10, 122, 4, 32, '3', '2:40 PM', '3:20 PM', 'C8');


#
# TABLE STRUCTURE FOR: salary_option
#

DROP TABLE IF EXISTS `salary_option`;

CREATE TABLE `salary_option` (
  `salary_optionID` int(11) NOT NULL AUTO_INCREMENT,
  `salary_templateID` int(11) NOT NULL,
  `option_type` int(11) NOT NULL COMMENT 'Allowances =1, Dllowances = 2, Increment = 3',
  `label_name` varchar(128) DEFAULT NULL,
  `label_amount` double NOT NULL,
  PRIMARY KEY (`salary_optionID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `salary_option` (`salary_optionID`, `salary_templateID`, `option_type`, `label_name`, `label_amount`) VALUES (1, 1, 1, 'House Rent', '3000');
INSERT INTO `salary_option` (`salary_optionID`, `salary_templateID`, `option_type`, `label_name`, `label_amount`) VALUES (2, 1, 2, 'nhif', '300');
INSERT INTO `salary_option` (`salary_optionID`, `salary_templateID`, `option_type`, `label_name`, `label_amount`) VALUES (3, 1, 2, 'nssf', '500');


#
# TABLE STRUCTURE FOR: salary_template
#

DROP TABLE IF EXISTS `salary_template`;

CREATE TABLE `salary_template` (
  `salary_templateID` int(11) NOT NULL AUTO_INCREMENT,
  `salary_grades` varchar(128) NOT NULL,
  `basic_salary` text NOT NULL,
  `overtime_rate` text NOT NULL,
  PRIMARY KEY (`salary_templateID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `salary_template` (`salary_templateID`, `salary_grades`, `basic_salary`, `overtime_rate`) VALUES (1, 'A', '11500', '0');


#
# TABLE STRUCTURE FOR: school_sessions
#

DROP TABLE IF EXISTS `school_sessions`;

CREATE TABLE `school_sessions` (
  `id` varchar(128) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL,
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ae333ab6d940767da2840e78f9806c950ce5c4d0', '3.250.150.65', 1712164909, '__ci_last_regenerate|i:1712164909;');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6ba9c85a1f86f00c41950569f348e84dc8784523', '54.195.56.254', 1712187566, '__ci_last_regenerate|i:1712187566;');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('131bbaca1c134c443f4e2f186c9f96f3733809e5', '87.236.176.46', 1712207973, '__ci_last_regenerate|i:1712207973;');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6ab6202260e6dbb4a0a773c708f12174b039fc13', '102.222.4.116', 1712227735, '__ci_last_regenerate|i:1712227735;english|N;loginuserID|s:2:\"10\";name|s:14:\"PENINAH MUTUKU\";email|s:17:\"peninah@email.com\";usertypeID|s:1:\"7\";usertype|s:12:\"Receptionist\";username|s:7:\"peninah\";photo|s:11:\"peninah.JPG\";lang|s:7:\"english\";defaultschoolyearID|s:1:\"4\";varifyvaliduser|b:1;loggedin|b:1;get_permission|b:1;master_permission_set|a:426:{s:9:\"dashboard\";s:3:\"yes\";s:7:\"student\";s:3:\"yes\";s:11:\"student_add\";s:3:\"yes\";s:12:\"student_edit\";s:3:\"yes\";s:7:\"teacher\";s:3:\"yes\";s:11:\"teacher_add\";s:3:\"yes\";s:12:\"teacher_edit\";s:3:\"yes\";s:12:\"conversation\";s:3:\"yes\";s:6:\"notice\";s:3:\"yes\";s:10:\"notice_add\";s:3:\"yes\";s:11:\"notice_edit\";s:3:\"yes\";s:5:\"event\";s:3:\"yes\";s:9:\"event_add\";s:3:\"yes\";s:10:\"event_edit\";s:3:\"yes\";s:7:\"holiday\";s:3:\"yes\";s:12:\"holiday_view\";s:3:\"yes\";s:14:\"terminalreport\";s:3:\"yes\";s:17:\"qrcode_attendance\";s:3:\"yes\";s:10:\"mailandsms\";s:3:\"yes\";s:14:\"mailandsms_add\";s:3:\"yes\";s:15:\"mailandsms_view\";s:3:\"yes\";s:25:\"student_attendance_report\";s:3:\"yes\";s:25:\"teacher_attendance_report\";s:3:\"yes\";s:22:\"user_attendance_report\";s:3:\"yes\";s:10:\"studentids\";s:3:\"yes\";s:17:\"studentids_delete\";s:3:\"yes\";s:14:\"student_delete\";s:2:\"no\";s:12:\"student_view\";s:2:\"no\";s:7:\"parents\";s:2:\"no\";s:11:\"parents_add\";s:2:\"no\";s:12:\"parents_edit\";s:2:\"no\";s:14:\"parents_delete\";s:2:\"no\";s:12:\"parents_view\";s:2:\"no\";s:14:\"teacher_delete\";s:2:\"no\";s:12:\"teacher_view\";s:2:\"no\";s:4:\"user\";s:2:\"no\";s:8:\"user_add\";s:2:\"no\";s:9:\"user_edit\";s:2:\"no\";s:11:\"user_delete\";s:2:\"no\";s:9:\"user_view\";s:2:\"no\";s:7:\"classes\";s:2:\"no\";s:11:\"classes_add\";s:2:\"no\";s:12:\"classes_edit\";s:2:\"no\";s:14:\"classes_delete\";s:2:\"no\";s:7:\"section\";s:2:\"no\";s:11:\"section_add\";s:2:\"no\";s:12:\"section_edit\";s:2:\"no\";s:15:\"semester_delete\";s:2:\"no\";s:14:\"section_delete\";s:2:\"no\";s:7:\"subject\";s:2:\"no\";s:11:\"subject_add\";s:2:\"no\";s:12:\"subject_edit\";s:2:\"no\";s:14:\"subject_delete\";s:2:\"no\";s:8:\"syllabus\";s:2:\"no\";s:12:\"syllabus_add\";s:2:\"no\";s:13:\"syllabus_edit\";s:2:\"no\";s:15:\"syllabus_delete\";s:2:\"no\";s:10:\"assignment\";s:2:\"no\";s:14:\"assignment_add\";s:2:\"no\";s:15:\"assignment_edit\";s:2:\"no\";s:17:\"assignment_delete\";s:2:\"no\";s:15:\"assignment_view\";s:2:\"no\";s:7:\"routine\";s:2:\"no\";s:11:\"routine_add\";s:2:\"no\";s:12:\"routine_edit\";s:2:\"no\";s:14:\"routine_delete\";s:2:\"no\";s:11:\"sattendance\";s:2:\"no\";s:15:\"sattendance_add\";s:2:\"no\";s:16:\"sattendance_view\";s:2:\"no\";s:11:\"tattendance\";s:2:\"no\";s:15:\"tattendance_add\";s:2:\"no\";s:16:\"tattendance_view\";s:2:\"no\";s:11:\"uattendance\";s:2:\"no\";s:15:\"uattendance_add\";s:2:\"no\";s:16:\"uattendance_view\";s:2:\"no\";s:4:\"exam\";s:2:\"no\";s:8:\"exam_add\";s:2:\"no\";s:9:\"exam_edit\";s:2:\"no\";s:11:\"exam_delete\";s:2:\"no\";s:12:\"examschedule\";s:2:\"no\";s:16:\"examschedule_add\";s:2:\"no\";s:17:\"examschedule_edit\";s:2:\"no\";s:19:\"examschedule_delete\";s:2:\"no\";s:5:\"grade\";s:2:\"no\";s:9:\"grade_add\";s:2:\"no\";s:10:\"grade_edit\";s:2:\"no\";s:12:\"grade_delete\";s:2:\"no\";s:11:\"eattendance\";s:2:\"no\";s:15:\"eattendance_add\";s:2:\"no\";s:4:\"mark\";s:2:\"no\";s:8:\"mark_add\";s:2:\"no\";s:9:\"mark_view\";s:2:\"no\";s:14:\"markpercentage\";s:2:\"no\";s:18:\"markpercentage_add\";s:2:\"no\";s:19:\"markpercentage_edit\";s:2:\"no\";s:21:\"markpercentage_delete\";s:2:\"no\";s:9:\"promotion\";s:2:\"no\";s:5:\"media\";s:2:\"no\";s:9:\"media_add\";s:2:\"no\";s:12:\"media_delete\";s:2:\"no\";s:14:\"question_group\";s:2:\"no\";s:18:\"question_group_add\";s:2:\"no\";s:19:\"question_group_edit\";s:2:\"no\";s:21:\"question_group_delete\";s:2:\"no\";s:14:\"question_level\";s:2:\"no\";s:18:\"question_level_add\";s:2:\"no\";s:19:\"question_level_edit\";s:2:\"no\";s:21:\"question_level_delete\";s:2:\"no\";s:13:\"question_bank\";s:2:\"no\";s:17:\"question_bank_add\";s:2:\"no\";s:18:\"question_bank_edit\";s:2:\"no\";s:20:\"question_bank_delete\";s:2:\"no\";s:18:\"question_bank_view\";s:2:\"no\";s:11:\"online_exam\";s:2:\"no\";s:15:\"online_exam_add\";s:2:\"no\";s:16:\"online_exam_edit\";s:2:\"no\";s:18:\"online_exam_delete\";s:2:\"no\";s:11:\"instruction\";s:2:\"no\";s:15:\"instruction_add\";s:2:\"no\";s:16:\"instruction_edit\";s:2:\"no\";s:18:\"instruction_delete\";s:2:\"no\";s:16:\"instruction_view\";s:2:\"no\";s:15:\"salary_template\";s:2:\"no\";s:19:\"salary_template_add\";s:2:\"no\";s:20:\"salary_template_edit\";s:2:\"no\";s:22:\"salary_template_delete\";s:2:\"no\";s:20:\"salary_template_view\";s:2:\"no\";s:15:\"hourly_template\";s:2:\"no\";s:19:\"hourly_template_add\";s:2:\"no\";s:20:\"hourly_template_edit\";s:2:\"no\";s:22:\"hourly_template_delete\";s:2:\"no\";s:13:\"manage_salary\";s:2:\"no\";s:17:\"manage_salary_add\";s:2:\"no\";s:18:\"manage_salary_edit\";s:2:\"no\";s:20:\"manage_salary_delete\";s:2:\"no\";s:18:\"manage_salary_view\";s:2:\"no\";s:12:\"make_payment\";s:2:\"no\";s:8:\"overtime\";s:2:\"no\";s:12:\"overtime_add\";s:2:\"no\";s:13:\"overtime_edit\";s:2:\"no\";s:15:\"overtime_delete\";s:2:\"no\";s:6:\"vendor\";s:2:\"no\";s:10:\"vendor_add\";s:2:\"no\";s:11:\"vendor_edit\";s:2:\"no\";s:13:\"vendor_delete\";s:2:\"no\";s:8:\"location\";s:2:\"no\";s:12:\"location_add\";s:2:\"no\";s:13:\"location_edit\";s:2:\"no\";s:15:\"location_delete\";s:2:\"no\";s:14:\"asset_category\";s:2:\"no\";s:18:\"asset_category_add\";s:2:\"no\";s:19:\"asset_category_edit\";s:2:\"no\";s:21:\"asset_category_delete\";s:2:\"no\";s:5:\"asset\";s:2:\"no\";s:9:\"asset_add\";s:2:\"no\";s:10:\"asset_edit\";s:2:\"no\";s:12:\"asset_delete\";s:2:\"no\";s:10:\"asset_view\";s:2:\"no\";s:16:\"asset_assignment\";s:2:\"no\";s:20:\"asset_assignment_add\";s:2:\"no\";s:21:\"asset_assignment_edit\";s:2:\"no\";s:23:\"asset_assignment_delete\";s:2:\"no\";s:21:\"asset_assignment_view\";s:2:\"no\";s:8:\"purchase\";s:2:\"no\";s:12:\"purchase_add\";s:2:\"no\";s:13:\"purchase_edit\";s:2:\"no\";s:15:\"purchase_delete\";s:2:\"no\";s:15:\"productcategory\";s:2:\"no\";s:19:\"productcategory_add\";s:2:\"no\";s:20:\"productcategory_edit\";s:2:\"no\";s:22:\"productcategory_delete\";s:2:\"no\";s:7:\"product\";s:2:\"no\";s:11:\"product_add\";s:2:\"no\";s:12:\"product_edit\";s:2:\"no\";s:14:\"product_delete\";s:2:\"no\";s:16:\"productwarehouse\";s:2:\"no\";s:20:\"productwarehouse_add\";s:2:\"no\";s:21:\"productwarehouse_edit\";s:2:\"no\";s:23:\"productwarehouse_delete\";s:2:\"no\";s:15:\"productsupplier\";s:2:\"no\";s:19:\"productsupplier_add\";s:2:\"no\";s:20:\"productsupplier_edit\";s:2:\"no\";s:22:\"productsupplier_delete\";s:2:\"no\";s:15:\"productpurchase\";s:2:\"no\";s:19:\"productpurchase_add\";s:2:\"no\";s:20:\"productpurchase_edit\";s:2:\"no\";s:22:\"productpurchase_delete\";s:2:\"no\";s:20:\"productpurchase_view\";s:2:\"no\";s:11:\"productsale\";s:2:\"no\";s:15:\"productsale_add\";s:2:\"no\";s:16:\"productsale_edit\";s:2:\"no\";s:18:\"productsale_delete\";s:2:\"no\";s:16:\"productsale_view\";s:2:\"no\";s:13:\"leavecategory\";s:2:\"no\";s:17:\"leavecategory_add\";s:2:\"no\";s:18:\"leavecategory_edit\";s:2:\"no\";s:20:\"leavecategory_delete\";s:2:\"no\";s:11:\"leaveassign\";s:2:\"no\";s:15:\"leaveassign_add\";s:2:\"no\";s:16:\"leaveassign_edit\";s:2:\"no\";s:18:\"leaveassign_delete\";s:2:\"no\";s:10:\"leaveapply\";s:2:\"no\";s:14:\"leaveapply_add\";s:2:\"no\";s:15:\"leaveapply_edit\";s:2:\"no\";s:17:\"leaveapply_delete\";s:2:\"no\";s:15:\"leaveapply_view\";s:2:\"no\";s:16:\"leaveapplication\";s:2:\"no\";s:18:\"activitiescategory\";s:2:\"no\";s:22:\"activitiescategory_add\";s:2:\"no\";s:23:\"activitiescategory_edit\";s:2:\"no\";s:25:\"activitiescategory_delete\";s:2:\"no\";s:10:\"activities\";s:2:\"no\";s:14:\"activities_add\";s:2:\"no\";s:17:\"activities_delete\";s:2:\"no\";s:9:\"childcare\";s:2:\"no\";s:13:\"childcare_add\";s:2:\"no\";s:14:\"childcare_edit\";s:2:\"no\";s:16:\"childcare_delete\";s:2:\"no\";s:7:\"lmember\";s:2:\"no\";s:11:\"lmember_add\";s:2:\"no\";s:12:\"lmember_edit\";s:2:\"no\";s:14:\"lmember_delete\";s:2:\"no\";s:12:\"lmember_view\";s:2:\"no\";s:4:\"book\";s:2:\"no\";s:8:\"book_add\";s:2:\"no\";s:9:\"book_edit\";s:2:\"no\";s:11:\"book_delete\";s:2:\"no\";s:5:\"issue\";s:2:\"no\";s:9:\"issue_add\";s:2:\"no\";s:10:\"issue_edit\";s:2:\"no\";s:10:\"issue_view\";s:2:\"no\";s:6:\"ebooks\";s:2:\"no\";s:10:\"ebooks_add\";s:2:\"no\";s:11:\"ebooks_edit\";s:2:\"no\";s:13:\"ebooks_delete\";s:2:\"no\";s:11:\"ebooks_view\";s:2:\"no\";s:9:\"transport\";s:2:\"no\";s:13:\"transport_add\";s:2:\"no\";s:14:\"transport_edit\";s:2:\"no\";s:16:\"transport_delete\";s:2:\"no\";s:7:\"tmember\";s:2:\"no\";s:11:\"tmember_add\";s:2:\"no\";s:12:\"tmember_edit\";s:2:\"no\";s:14:\"tmember_delete\";s:2:\"no\";s:12:\"tmember_view\";s:2:\"no\";s:6:\"hostel\";s:2:\"no\";s:10:\"hostel_add\";s:2:\"no\";s:11:\"hostel_edit\";s:2:\"no\";s:13:\"hostel_delete\";s:2:\"no\";s:8:\"category\";s:2:\"no\";s:12:\"category_add\";s:2:\"no\";s:13:\"category_edit\";s:2:\"no\";s:15:\"category_delete\";s:2:\"no\";s:7:\"hmember\";s:2:\"no\";s:11:\"hmember_add\";s:2:\"no\";s:12:\"hmember_edit\";s:2:\"no\";s:14:\"hmember_delete\";s:2:\"no\";s:12:\"hmember_view\";s:2:\"no\";s:8:\"feetypes\";s:2:\"no\";s:12:\"feetypes_add\";s:2:\"no\";s:13:\"feetypes_edit\";s:2:\"no\";s:15:\"feetypes_delete\";s:2:\"no\";s:7:\"invoice\";s:2:\"no\";s:11:\"invoice_add\";s:2:\"no\";s:12:\"invoice_edit\";s:2:\"no\";s:14:\"invoice_delete\";s:2:\"no\";s:12:\"invoice_view\";s:2:\"no\";s:14:\"paymenthistory\";s:2:\"no\";s:19:\"paymenthistory_edit\";s:2:\"no\";s:21:\"paymenthistory_delete\";s:2:\"no\";s:7:\"expense\";s:2:\"no\";s:11:\"expense_add\";s:2:\"no\";s:12:\"expense_edit\";s:2:\"no\";s:14:\"expense_delete\";s:2:\"no\";s:6:\"income\";s:2:\"no\";s:10:\"income_add\";s:2:\"no\";s:11:\"income_edit\";s:2:\"no\";s:13:\"income_delete\";s:2:\"no\";s:14:\"global_payment\";s:2:\"no\";s:13:\"notice_delete\";s:2:\"no\";s:11:\"notice_view\";s:2:\"no\";s:12:\"event_delete\";s:2:\"no\";s:10:\"event_view\";s:2:\"no\";s:11:\"holiday_add\";s:2:\"no\";s:12:\"holiday_edit\";s:2:\"no\";s:14:\"holiday_delete\";s:2:\"no\";s:13:\"classesreport\";s:2:\"no\";s:13:\"studentreport\";s:2:\"no\";s:12:\"idcardreport\";s:2:\"no\";s:15:\"admitcardreport\";s:2:\"no\";s:13:\"routinereport\";s:2:\"no\";s:18:\"examschedulereport\";s:2:\"no\";s:16:\"attendancereport\";s:2:\"no\";s:24:\"attendanceoverviewreport\";s:2:\"no\";s:18:\"librarybooksreport\";s:2:\"no\";s:17:\"librarycardreport\";s:2:\"no\";s:22:\"librarybookissuereport\";s:2:\"no\";s:16:\"meritstagereport\";s:2:\"no\";s:21:\"tabulationsheetreport\";s:2:\"no\";s:15:\"marksheetreport\";s:2:\"no\";s:18:\"progresscardreport\";s:2:\"no\";s:20:\"studentsessionreport\";s:2:\"no\";s:16:\"onlineexamreport\";s:2:\"no\";s:24:\"onlineexamquestionreport\";s:2:\"no\";s:21:\"onlineadmissionreport\";s:2:\"no\";s:17:\"certificatereport\";s:2:\"no\";s:22:\"leaveapplicationreport\";s:2:\"no\";s:21:\"productpurchasereport\";s:2:\"no\";s:17:\"productsalereport\";s:2:\"no\";s:23:\"searchpaymentfeesreport\";s:2:\"no\";s:10:\"feesreport\";s:2:\"no\";s:13:\"duefeesreport\";s:2:\"no\";s:17:\"balancefeesreport\";s:2:\"no\";s:17:\"transactionreport\";s:2:\"no\";s:17:\"studentfinereport\";s:2:\"no\";s:14:\"overtimereport\";s:2:\"no\";s:12:\"salaryreport\";s:2:\"no\";s:19:\"accountledgerreport\";s:2:\"no\";s:15:\"onlineadmission\";s:2:\"no\";s:11:\"visitorinfo\";s:2:\"no\";s:18:\"visitorinfo_delete\";s:2:\"no\";s:16:\"visitorinfo_view\";s:2:\"no\";s:10:\"schoolyear\";s:2:\"no\";s:14:\"schoolyear_add\";s:2:\"no\";s:15:\"schoolyear_edit\";s:2:\"no\";s:17:\"schoolyear_delete\";s:2:\"no\";s:12:\"studentgroup\";s:2:\"no\";s:16:\"studentgroup_add\";s:2:\"no\";s:17:\"studentgroup_edit\";s:2:\"no\";s:19:\"studentgroup_delete\";s:2:\"no\";s:8:\"complain\";s:2:\"no\";s:12:\"complain_add\";s:2:\"no\";s:13:\"complain_edit\";s:2:\"no\";s:15:\"complain_delete\";s:2:\"no\";s:13:\"complain_view\";s:2:\"no\";s:20:\"certificate_template\";s:2:\"no\";s:24:\"certificate_template_add\";s:2:\"no\";s:25:\"certificate_template_edit\";s:2:\"no\";s:27:\"certificate_template_delete\";s:2:\"no\";s:25:\"certificate_template_view\";s:2:\"no\";s:11:\"systemadmin\";s:2:\"no\";s:15:\"systemadmin_add\";s:2:\"no\";s:16:\"systemadmin_edit\";s:2:\"no\";s:18:\"systemadmin_delete\";s:2:\"no\";s:16:\"systemadmin_view\";s:2:\"no\";s:13:\"resetpassword\";s:2:\"no\";s:10:\"sociallink\";s:2:\"no\";s:14:\"sociallink_add\";s:2:\"no\";s:15:\"sociallink_edit\";s:2:\"no\";s:17:\"sociallink_delete\";s:2:\"no\";s:18:\"mailandsmstemplate\";s:2:\"no\";s:22:\"mailandsmstemplate_add\";s:2:\"no\";s:23:\"mailandsmstemplate_edit\";s:2:\"no\";s:25:\"mailandsmstemplate_delete\";s:2:\"no\";s:23:\"mailandsmstemplate_view\";s:2:\"no\";s:11:\"bulkimport \";s:2:\"no\";s:6:\"backup\";s:2:\"no\";s:8:\"usertype\";s:2:\"no\";s:12:\"usertype_add\";s:2:\"no\";s:13:\"usertype_edit\";s:2:\"no\";s:15:\"usertype_delete\";s:2:\"no\";s:10:\"permission\";s:2:\"no\";s:6:\"addons\";s:2:\"no\";s:6:\"update\";s:2:\"no\";s:16:\"posts_categories\";s:2:\"no\";s:20:\"posts_categories_add\";s:2:\"no\";s:21:\"posts_categories_edit\";s:2:\"no\";s:23:\"posts_categories_delete\";s:2:\"no\";s:5:\"posts\";s:2:\"no\";s:9:\"posts_add\";s:2:\"no\";s:10:\"posts_edit\";s:2:\"no\";s:12:\"posts_delete\";s:2:\"no\";s:5:\"pages\";s:2:\"no\";s:9:\"pages_add\";s:2:\"no\";s:10:\"pages_edit\";s:2:\"no\";s:12:\"pages_delete\";s:2:\"no\";s:12:\"frontendmenu\";s:2:\"no\";s:7:\"setting\";s:2:\"no\";s:16:\"frontend_setting\";s:2:\"no\";s:15:\"paymentsettings\";s:2:\"no\";s:11:\"smssettings\";s:2:\"no\";s:12:\"emailsetting\";s:2:\"no\";s:11:\"marksetting\";s:2:\"no\";s:9:\"candidate\";s:2:\"no\";s:13:\"candidate_add\";s:2:\"no\";s:14:\"candidate_edit\";s:2:\"no\";s:16:\"candidate_delete\";s:2:\"no\";s:14:\"candidate_view\";s:2:\"no\";s:7:\"sponsor\";s:2:\"no\";s:11:\"sponsor_add\";s:2:\"no\";s:12:\"sponsor_edit\";s:2:\"no\";s:14:\"sponsor_delete\";s:2:\"no\";s:12:\"sponsor_view\";s:2:\"no\";s:11:\"sponsorship\";s:2:\"no\";s:15:\"sponsorship_add\";s:2:\"no\";s:16:\"sponsorship_edit\";s:2:\"no\";s:18:\"sponsorship_delete\";s:2:\"no\";s:17:\"sponsorshipreport\";s:2:\"no\";s:30:\"onlineexamquestionanswerreport\";s:2:\"no\";s:10:\"attendance\";s:2:\"no\";s:5:\"mpesa\";s:2:\"no\";s:20:\"vendorpurchasereport\";s:2:\"no\";s:18:\"itempurchasereport\";s:2:\"no\";s:22:\"categorypurchasereport\";s:2:\"no\";s:14:\"itemsalereport\";s:2:\"no\";s:18:\"categorysalereport\";s:2:\"no\";s:6:\"wallet\";s:2:\"no\";s:5:\"lunch\";s:2:\"no\";s:12:\"lunchsetting\";s:2:\"no\";s:9:\"lunchlogs\";s:2:\"no\";s:10:\"schoolterm\";s:2:\"no\";s:14:\"schoolterm_add\";s:2:\"no\";s:15:\"schoolterm_edit\";s:2:\"no\";s:17:\"schoolterm_delete\";s:2:\"no\";s:15:\"schoolterm_view\";s:2:\"no\";s:15:\"generate_qrcode\";s:2:\"no\";s:17:\"cbcterminalreport\";s:2:\"no\";s:9:\"smsreport\";s:2:\"no\";s:7:\"sendsms\";s:2:\"no\";s:15:\"studentleaveout\";s:2:\"no\";s:20:\"studentleaveout_edit\";s:2:\"no\";s:20:\"studentleaveout_view\";s:2:\"no\";s:22:\"studentleaveout_delete\";s:2:\"no\";s:13:\"backup_delete\";s:2:\"no\";s:10:\"backup_add\";s:2:\"no\";s:14:\"backup_restore\";s:2:\"no\";}');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5e7fad4d2c4e596498f4b5e61730a86d8dff2a73', '102.222.4.116', 1712227741, '__ci_last_regenerate|i:1712227735;english|N;loginuserID|s:2:\"10\";name|s:14:\"PENINAH MUTUKU\";email|s:17:\"peninah@email.com\";usertypeID|s:1:\"7\";usertype|s:12:\"Receptionist\";username|s:7:\"peninah\";photo|s:11:\"peninah.JPG\";lang|s:7:\"english\";defaultschoolyearID|s:1:\"4\";varifyvaliduser|b:1;loggedin|b:1;get_permission|b:1;master_permission_set|a:426:{s:9:\"dashboard\";s:3:\"yes\";s:7:\"student\";s:3:\"yes\";s:11:\"student_add\";s:3:\"yes\";s:12:\"student_edit\";s:3:\"yes\";s:7:\"teacher\";s:3:\"yes\";s:11:\"teacher_add\";s:3:\"yes\";s:12:\"teacher_edit\";s:3:\"yes\";s:12:\"conversation\";s:3:\"yes\";s:6:\"notice\";s:3:\"yes\";s:10:\"notice_add\";s:3:\"yes\";s:11:\"notice_edit\";s:3:\"yes\";s:5:\"event\";s:3:\"yes\";s:9:\"event_add\";s:3:\"yes\";s:10:\"event_edit\";s:3:\"yes\";s:7:\"holiday\";s:3:\"yes\";s:12:\"holiday_view\";s:3:\"yes\";s:14:\"terminalreport\";s:3:\"yes\";s:17:\"qrcode_attendance\";s:3:\"yes\";s:10:\"mailandsms\";s:3:\"yes\";s:14:\"mailandsms_add\";s:3:\"yes\";s:15:\"mailandsms_view\";s:3:\"yes\";s:25:\"student_attendance_report\";s:3:\"yes\";s:25:\"teacher_attendance_report\";s:3:\"yes\";s:22:\"user_attendance_report\";s:3:\"yes\";s:10:\"studentids\";s:3:\"yes\";s:17:\"studentids_delete\";s:3:\"yes\";s:14:\"student_delete\";s:2:\"no\";s:12:\"student_view\";s:2:\"no\";s:7:\"parents\";s:2:\"no\";s:11:\"parents_add\";s:2:\"no\";s:12:\"parents_edit\";s:2:\"no\";s:14:\"parents_delete\";s:2:\"no\";s:12:\"parents_view\";s:2:\"no\";s:14:\"teacher_delete\";s:2:\"no\";s:12:\"teacher_view\";s:2:\"no\";s:4:\"user\";s:2:\"no\";s:8:\"user_add\";s:2:\"no\";s:9:\"user_edit\";s:2:\"no\";s:11:\"user_delete\";s:2:\"no\";s:9:\"user_view\";s:2:\"no\";s:7:\"classes\";s:2:\"no\";s:11:\"classes_add\";s:2:\"no\";s:12:\"classes_edit\";s:2:\"no\";s:14:\"classes_delete\";s:2:\"no\";s:7:\"section\";s:2:\"no\";s:11:\"section_add\";s:2:\"no\";s:12:\"section_edit\";s:2:\"no\";s:15:\"semester_delete\";s:2:\"no\";s:14:\"section_delete\";s:2:\"no\";s:7:\"subject\";s:2:\"no\";s:11:\"subject_add\";s:2:\"no\";s:12:\"subject_edit\";s:2:\"no\";s:14:\"subject_delete\";s:2:\"no\";s:8:\"syllabus\";s:2:\"no\";s:12:\"syllabus_add\";s:2:\"no\";s:13:\"syllabus_edit\";s:2:\"no\";s:15:\"syllabus_delete\";s:2:\"no\";s:10:\"assignment\";s:2:\"no\";s:14:\"assignment_add\";s:2:\"no\";s:15:\"assignment_edit\";s:2:\"no\";s:17:\"assignment_delete\";s:2:\"no\";s:15:\"assignment_view\";s:2:\"no\";s:7:\"routine\";s:2:\"no\";s:11:\"routine_add\";s:2:\"no\";s:12:\"routine_edit\";s:2:\"no\";s:14:\"routine_delete\";s:2:\"no\";s:11:\"sattendance\";s:2:\"no\";s:15:\"sattendance_add\";s:2:\"no\";s:16:\"sattendance_view\";s:2:\"no\";s:11:\"tattendance\";s:2:\"no\";s:15:\"tattendance_add\";s:2:\"no\";s:16:\"tattendance_view\";s:2:\"no\";s:11:\"uattendance\";s:2:\"no\";s:15:\"uattendance_add\";s:2:\"no\";s:16:\"uattendance_view\";s:2:\"no\";s:4:\"exam\";s:2:\"no\";s:8:\"exam_add\";s:2:\"no\";s:9:\"exam_edit\";s:2:\"no\";s:11:\"exam_delete\";s:2:\"no\";s:12:\"examschedule\";s:2:\"no\";s:16:\"examschedule_add\";s:2:\"no\";s:17:\"examschedule_edit\";s:2:\"no\";s:19:\"examschedule_delete\";s:2:\"no\";s:5:\"grade\";s:2:\"no\";s:9:\"grade_add\";s:2:\"no\";s:10:\"grade_edit\";s:2:\"no\";s:12:\"grade_delete\";s:2:\"no\";s:11:\"eattendance\";s:2:\"no\";s:15:\"eattendance_add\";s:2:\"no\";s:4:\"mark\";s:2:\"no\";s:8:\"mark_add\";s:2:\"no\";s:9:\"mark_view\";s:2:\"no\";s:14:\"markpercentage\";s:2:\"no\";s:18:\"markpercentage_add\";s:2:\"no\";s:19:\"markpercentage_edit\";s:2:\"no\";s:21:\"markpercentage_delete\";s:2:\"no\";s:9:\"promotion\";s:2:\"no\";s:5:\"media\";s:2:\"no\";s:9:\"media_add\";s:2:\"no\";s:12:\"media_delete\";s:2:\"no\";s:14:\"question_group\";s:2:\"no\";s:18:\"question_group_add\";s:2:\"no\";s:19:\"question_group_edit\";s:2:\"no\";s:21:\"question_group_delete\";s:2:\"no\";s:14:\"question_level\";s:2:\"no\";s:18:\"question_level_add\";s:2:\"no\";s:19:\"question_level_edit\";s:2:\"no\";s:21:\"question_level_delete\";s:2:\"no\";s:13:\"question_bank\";s:2:\"no\";s:17:\"question_bank_add\";s:2:\"no\";s:18:\"question_bank_edit\";s:2:\"no\";s:20:\"question_bank_delete\";s:2:\"no\";s:18:\"question_bank_view\";s:2:\"no\";s:11:\"online_exam\";s:2:\"no\";s:15:\"online_exam_add\";s:2:\"no\";s:16:\"online_exam_edit\";s:2:\"no\";s:18:\"online_exam_delete\";s:2:\"no\";s:11:\"instruction\";s:2:\"no\";s:15:\"instruction_add\";s:2:\"no\";s:16:\"instruction_edit\";s:2:\"no\";s:18:\"instruction_delete\";s:2:\"no\";s:16:\"instruction_view\";s:2:\"no\";s:15:\"salary_template\";s:2:\"no\";s:19:\"salary_template_add\";s:2:\"no\";s:20:\"salary_template_edit\";s:2:\"no\";s:22:\"salary_template_delete\";s:2:\"no\";s:20:\"salary_template_view\";s:2:\"no\";s:15:\"hourly_template\";s:2:\"no\";s:19:\"hourly_template_add\";s:2:\"no\";s:20:\"hourly_template_edit\";s:2:\"no\";s:22:\"hourly_template_delete\";s:2:\"no\";s:13:\"manage_salary\";s:2:\"no\";s:17:\"manage_salary_add\";s:2:\"no\";s:18:\"manage_salary_edit\";s:2:\"no\";s:20:\"manage_salary_delete\";s:2:\"no\";s:18:\"manage_salary_view\";s:2:\"no\";s:12:\"make_payment\";s:2:\"no\";s:8:\"overtime\";s:2:\"no\";s:12:\"overtime_add\";s:2:\"no\";s:13:\"overtime_edit\";s:2:\"no\";s:15:\"overtime_delete\";s:2:\"no\";s:6:\"vendor\";s:2:\"no\";s:10:\"vendor_add\";s:2:\"no\";s:11:\"vendor_edit\";s:2:\"no\";s:13:\"vendor_delete\";s:2:\"no\";s:8:\"location\";s:2:\"no\";s:12:\"location_add\";s:2:\"no\";s:13:\"location_edit\";s:2:\"no\";s:15:\"location_delete\";s:2:\"no\";s:14:\"asset_category\";s:2:\"no\";s:18:\"asset_category_add\";s:2:\"no\";s:19:\"asset_category_edit\";s:2:\"no\";s:21:\"asset_category_delete\";s:2:\"no\";s:5:\"asset\";s:2:\"no\";s:9:\"asset_add\";s:2:\"no\";s:10:\"asset_edit\";s:2:\"no\";s:12:\"asset_delete\";s:2:\"no\";s:10:\"asset_view\";s:2:\"no\";s:16:\"asset_assignment\";s:2:\"no\";s:20:\"asset_assignment_add\";s:2:\"no\";s:21:\"asset_assignment_edit\";s:2:\"no\";s:23:\"asset_assignment_delete\";s:2:\"no\";s:21:\"asset_assignment_view\";s:2:\"no\";s:8:\"purchase\";s:2:\"no\";s:12:\"purchase_add\";s:2:\"no\";s:13:\"purchase_edit\";s:2:\"no\";s:15:\"purchase_delete\";s:2:\"no\";s:15:\"productcategory\";s:2:\"no\";s:19:\"productcategory_add\";s:2:\"no\";s:20:\"productcategory_edit\";s:2:\"no\";s:22:\"productcategory_delete\";s:2:\"no\";s:7:\"product\";s:2:\"no\";s:11:\"product_add\";s:2:\"no\";s:12:\"product_edit\";s:2:\"no\";s:14:\"product_delete\";s:2:\"no\";s:16:\"productwarehouse\";s:2:\"no\";s:20:\"productwarehouse_add\";s:2:\"no\";s:21:\"productwarehouse_edit\";s:2:\"no\";s:23:\"productwarehouse_delete\";s:2:\"no\";s:15:\"productsupplier\";s:2:\"no\";s:19:\"productsupplier_add\";s:2:\"no\";s:20:\"productsupplier_edit\";s:2:\"no\";s:22:\"productsupplier_delete\";s:2:\"no\";s:15:\"productpurchase\";s:2:\"no\";s:19:\"productpurchase_add\";s:2:\"no\";s:20:\"productpurchase_edit\";s:2:\"no\";s:22:\"productpurchase_delete\";s:2:\"no\";s:20:\"productpurchase_view\";s:2:\"no\";s:11:\"productsale\";s:2:\"no\";s:15:\"productsale_add\";s:2:\"no\";s:16:\"productsale_edit\";s:2:\"no\";s:18:\"productsale_delete\";s:2:\"no\";s:16:\"productsale_view\";s:2:\"no\";s:13:\"leavecategory\";s:2:\"no\";s:17:\"leavecategory_add\";s:2:\"no\";s:18:\"leavecategory_edit\";s:2:\"no\";s:20:\"leavecategory_delete\";s:2:\"no\";s:11:\"leaveassign\";s:2:\"no\";s:15:\"leaveassign_add\";s:2:\"no\";s:16:\"leaveassign_edit\";s:2:\"no\";s:18:\"leaveassign_delete\";s:2:\"no\";s:10:\"leaveapply\";s:2:\"no\";s:14:\"leaveapply_add\";s:2:\"no\";s:15:\"leaveapply_edit\";s:2:\"no\";s:17:\"leaveapply_delete\";s:2:\"no\";s:15:\"leaveapply_view\";s:2:\"no\";s:16:\"leaveapplication\";s:2:\"no\";s:18:\"activitiescategory\";s:2:\"no\";s:22:\"activitiescategory_add\";s:2:\"no\";s:23:\"activitiescategory_edit\";s:2:\"no\";s:25:\"activitiescategory_delete\";s:2:\"no\";s:10:\"activities\";s:2:\"no\";s:14:\"activities_add\";s:2:\"no\";s:17:\"activities_delete\";s:2:\"no\";s:9:\"childcare\";s:2:\"no\";s:13:\"childcare_add\";s:2:\"no\";s:14:\"childcare_edit\";s:2:\"no\";s:16:\"childcare_delete\";s:2:\"no\";s:7:\"lmember\";s:2:\"no\";s:11:\"lmember_add\";s:2:\"no\";s:12:\"lmember_edit\";s:2:\"no\";s:14:\"lmember_delete\";s:2:\"no\";s:12:\"lmember_view\";s:2:\"no\";s:4:\"book\";s:2:\"no\";s:8:\"book_add\";s:2:\"no\";s:9:\"book_edit\";s:2:\"no\";s:11:\"book_delete\";s:2:\"no\";s:5:\"issue\";s:2:\"no\";s:9:\"issue_add\";s:2:\"no\";s:10:\"issue_edit\";s:2:\"no\";s:10:\"issue_view\";s:2:\"no\";s:6:\"ebooks\";s:2:\"no\";s:10:\"ebooks_add\";s:2:\"no\";s:11:\"ebooks_edit\";s:2:\"no\";s:13:\"ebooks_delete\";s:2:\"no\";s:11:\"ebooks_view\";s:2:\"no\";s:9:\"transport\";s:2:\"no\";s:13:\"transport_add\";s:2:\"no\";s:14:\"transport_edit\";s:2:\"no\";s:16:\"transport_delete\";s:2:\"no\";s:7:\"tmember\";s:2:\"no\";s:11:\"tmember_add\";s:2:\"no\";s:12:\"tmember_edit\";s:2:\"no\";s:14:\"tmember_delete\";s:2:\"no\";s:12:\"tmember_view\";s:2:\"no\";s:6:\"hostel\";s:2:\"no\";s:10:\"hostel_add\";s:2:\"no\";s:11:\"hostel_edit\";s:2:\"no\";s:13:\"hostel_delete\";s:2:\"no\";s:8:\"category\";s:2:\"no\";s:12:\"category_add\";s:2:\"no\";s:13:\"category_edit\";s:2:\"no\";s:15:\"category_delete\";s:2:\"no\";s:7:\"hmember\";s:2:\"no\";s:11:\"hmember_add\";s:2:\"no\";s:12:\"hmember_edit\";s:2:\"no\";s:14:\"hmember_delete\";s:2:\"no\";s:12:\"hmember_view\";s:2:\"no\";s:8:\"feetypes\";s:2:\"no\";s:12:\"feetypes_add\";s:2:\"no\";s:13:\"feetypes_edit\";s:2:\"no\";s:15:\"feetypes_delete\";s:2:\"no\";s:7:\"invoice\";s:2:\"no\";s:11:\"invoice_add\";s:2:\"no\";s:12:\"invoice_edit\";s:2:\"no\";s:14:\"invoice_delete\";s:2:\"no\";s:12:\"invoice_view\";s:2:\"no\";s:14:\"paymenthistory\";s:2:\"no\";s:19:\"paymenthistory_edit\";s:2:\"no\";s:21:\"paymenthistory_delete\";s:2:\"no\";s:7:\"expense\";s:2:\"no\";s:11:\"expense_add\";s:2:\"no\";s:12:\"expense_edit\";s:2:\"no\";s:14:\"expense_delete\";s:2:\"no\";s:6:\"income\";s:2:\"no\";s:10:\"income_add\";s:2:\"no\";s:11:\"income_edit\";s:2:\"no\";s:13:\"income_delete\";s:2:\"no\";s:14:\"global_payment\";s:2:\"no\";s:13:\"notice_delete\";s:2:\"no\";s:11:\"notice_view\";s:2:\"no\";s:12:\"event_delete\";s:2:\"no\";s:10:\"event_view\";s:2:\"no\";s:11:\"holiday_add\";s:2:\"no\";s:12:\"holiday_edit\";s:2:\"no\";s:14:\"holiday_delete\";s:2:\"no\";s:13:\"classesreport\";s:2:\"no\";s:13:\"studentreport\";s:2:\"no\";s:12:\"idcardreport\";s:2:\"no\";s:15:\"admitcardreport\";s:2:\"no\";s:13:\"routinereport\";s:2:\"no\";s:18:\"examschedulereport\";s:2:\"no\";s:16:\"attendancereport\";s:2:\"no\";s:24:\"attendanceoverviewreport\";s:2:\"no\";s:18:\"librarybooksreport\";s:2:\"no\";s:17:\"librarycardreport\";s:2:\"no\";s:22:\"librarybookissuereport\";s:2:\"no\";s:16:\"meritstagereport\";s:2:\"no\";s:21:\"tabulationsheetreport\";s:2:\"no\";s:15:\"marksheetreport\";s:2:\"no\";s:18:\"progresscardreport\";s:2:\"no\";s:20:\"studentsessionreport\";s:2:\"no\";s:16:\"onlineexamreport\";s:2:\"no\";s:24:\"onlineexamquestionreport\";s:2:\"no\";s:21:\"onlineadmissionreport\";s:2:\"no\";s:17:\"certificatereport\";s:2:\"no\";s:22:\"leaveapplicationreport\";s:2:\"no\";s:21:\"productpurchasereport\";s:2:\"no\";s:17:\"productsalereport\";s:2:\"no\";s:23:\"searchpaymentfeesreport\";s:2:\"no\";s:10:\"feesreport\";s:2:\"no\";s:13:\"duefeesreport\";s:2:\"no\";s:17:\"balancefeesreport\";s:2:\"no\";s:17:\"transactionreport\";s:2:\"no\";s:17:\"studentfinereport\";s:2:\"no\";s:14:\"overtimereport\";s:2:\"no\";s:12:\"salaryreport\";s:2:\"no\";s:19:\"accountledgerreport\";s:2:\"no\";s:15:\"onlineadmission\";s:2:\"no\";s:11:\"visitorinfo\";s:2:\"no\";s:18:\"visitorinfo_delete\";s:2:\"no\";s:16:\"visitorinfo_view\";s:2:\"no\";s:10:\"schoolyear\";s:2:\"no\";s:14:\"schoolyear_add\";s:2:\"no\";s:15:\"schoolyear_edit\";s:2:\"no\";s:17:\"schoolyear_delete\";s:2:\"no\";s:12:\"studentgroup\";s:2:\"no\";s:16:\"studentgroup_add\";s:2:\"no\";s:17:\"studentgroup_edit\";s:2:\"no\";s:19:\"studentgroup_delete\";s:2:\"no\";s:8:\"complain\";s:2:\"no\";s:12:\"complain_add\";s:2:\"no\";s:13:\"complain_edit\";s:2:\"no\";s:15:\"complain_delete\";s:2:\"no\";s:13:\"complain_view\";s:2:\"no\";s:20:\"certificate_template\";s:2:\"no\";s:24:\"certificate_template_add\";s:2:\"no\";s:25:\"certificate_template_edit\";s:2:\"no\";s:27:\"certificate_template_delete\";s:2:\"no\";s:25:\"certificate_template_view\";s:2:\"no\";s:11:\"systemadmin\";s:2:\"no\";s:15:\"systemadmin_add\";s:2:\"no\";s:16:\"systemadmin_edit\";s:2:\"no\";s:18:\"systemadmin_delete\";s:2:\"no\";s:16:\"systemadmin_view\";s:2:\"no\";s:13:\"resetpassword\";s:2:\"no\";s:10:\"sociallink\";s:2:\"no\";s:14:\"sociallink_add\";s:2:\"no\";s:15:\"sociallink_edit\";s:2:\"no\";s:17:\"sociallink_delete\";s:2:\"no\";s:18:\"mailandsmstemplate\";s:2:\"no\";s:22:\"mailandsmstemplate_add\";s:2:\"no\";s:23:\"mailandsmstemplate_edit\";s:2:\"no\";s:25:\"mailandsmstemplate_delete\";s:2:\"no\";s:23:\"mailandsmstemplate_view\";s:2:\"no\";s:11:\"bulkimport \";s:2:\"no\";s:6:\"backup\";s:2:\"no\";s:8:\"usertype\";s:2:\"no\";s:12:\"usertype_add\";s:2:\"no\";s:13:\"usertype_edit\";s:2:\"no\";s:15:\"usertype_delete\";s:2:\"no\";s:10:\"permission\";s:2:\"no\";s:6:\"addons\";s:2:\"no\";s:6:\"update\";s:2:\"no\";s:16:\"posts_categories\";s:2:\"no\";s:20:\"posts_categories_add\";s:2:\"no\";s:21:\"posts_categories_edit\";s:2:\"no\";s:23:\"posts_categories_delete\";s:2:\"no\";s:5:\"posts\";s:2:\"no\";s:9:\"posts_add\";s:2:\"no\";s:10:\"posts_edit\";s:2:\"no\";s:12:\"posts_delete\";s:2:\"no\";s:5:\"pages\";s:2:\"no\";s:9:\"pages_add\";s:2:\"no\";s:10:\"pages_edit\";s:2:\"no\";s:12:\"pages_delete\";s:2:\"no\";s:12:\"frontendmenu\";s:2:\"no\";s:7:\"setting\";s:2:\"no\";s:16:\"frontend_setting\";s:2:\"no\";s:15:\"paymentsettings\";s:2:\"no\";s:11:\"smssettings\";s:2:\"no\";s:12:\"emailsetting\";s:2:\"no\";s:11:\"marksetting\";s:2:\"no\";s:9:\"candidate\";s:2:\"no\";s:13:\"candidate_add\";s:2:\"no\";s:14:\"candidate_edit\";s:2:\"no\";s:16:\"candidate_delete\";s:2:\"no\";s:14:\"candidate_view\";s:2:\"no\";s:7:\"sponsor\";s:2:\"no\";s:11:\"sponsor_add\";s:2:\"no\";s:12:\"sponsor_edit\";s:2:\"no\";s:14:\"sponsor_delete\";s:2:\"no\";s:12:\"sponsor_view\";s:2:\"no\";s:11:\"sponsorship\";s:2:\"no\";s:15:\"sponsorship_add\";s:2:\"no\";s:16:\"sponsorship_edit\";s:2:\"no\";s:18:\"sponsorship_delete\";s:2:\"no\";s:17:\"sponsorshipreport\";s:2:\"no\";s:30:\"onlineexamquestionanswerreport\";s:2:\"no\";s:10:\"attendance\";s:2:\"no\";s:5:\"mpesa\";s:2:\"no\";s:20:\"vendorpurchasereport\";s:2:\"no\";s:18:\"itempurchasereport\";s:2:\"no\";s:22:\"categorypurchasereport\";s:2:\"no\";s:14:\"itemsalereport\";s:2:\"no\";s:18:\"categorysalereport\";s:2:\"no\";s:6:\"wallet\";s:2:\"no\";s:5:\"lunch\";s:2:\"no\";s:12:\"lunchsetting\";s:2:\"no\";s:9:\"lunchlogs\";s:2:\"no\";s:10:\"schoolterm\";s:2:\"no\";s:14:\"schoolterm_add\";s:2:\"no\";s:15:\"schoolterm_edit\";s:2:\"no\";s:17:\"schoolterm_delete\";s:2:\"no\";s:15:\"schoolterm_view\";s:2:\"no\";s:15:\"generate_qrcode\";s:2:\"no\";s:17:\"cbcterminalreport\";s:2:\"no\";s:9:\"smsreport\";s:2:\"no\";s:7:\"sendsms\";s:2:\"no\";s:15:\"studentleaveout\";s:2:\"no\";s:20:\"studentleaveout_edit\";s:2:\"no\";s:20:\"studentleaveout_view\";s:2:\"no\";s:22:\"studentleaveout_delete\";s:2:\"no\";s:13:\"backup_delete\";s:2:\"no\";s:10:\"backup_add\";s:2:\"no\";s:14:\"backup_restore\";s:2:\"no\";}');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('40c7ebffb1b2552539771cf2efdf5734979a9a5e', '154.159.252.5', 1712237889, '__ci_last_regenerate|i:1712237867;english|N;loginuserID|s:1:\"1\";name|s:6:\"Skooly\";email|s:18:\"matthigu@yahoo.com\";usertypeID|s:1:\"1\";usertype|s:5:\"Admin\";username|s:6:\"skooly\";photo|s:132:\"2f8ab9b11765b18645a5c1dd5670923ca4c4deb754d3b806318e66db220e2b26b42f2e1e24f8a74fdb94004de0ec948b67d2eb0b028e286c724a279574cbf665.png\";lang|s:7:\"english\";defaultschoolyearID|s:1:\"4\";varifyvaliduser|b:1;loggedin|b:1;get_permission|b:1;master_permission_set|a:427:{s:9:\"dashboard\";s:3:\"yes\";s:7:\"student\";s:3:\"yes\";s:11:\"student_add\";s:3:\"yes\";s:12:\"student_edit\";s:3:\"yes\";s:14:\"student_delete\";s:3:\"yes\";s:12:\"student_view\";s:3:\"yes\";s:7:\"parents\";s:3:\"yes\";s:11:\"parents_add\";s:3:\"yes\";s:12:\"parents_edit\";s:3:\"yes\";s:14:\"parents_delete\";s:3:\"yes\";s:12:\"parents_view\";s:3:\"yes\";s:7:\"teacher\";s:3:\"yes\";s:11:\"teacher_add\";s:3:\"yes\";s:12:\"teacher_edit\";s:3:\"yes\";s:14:\"teacher_delete\";s:3:\"yes\";s:12:\"teacher_view\";s:3:\"yes\";s:4:\"user\";s:3:\"yes\";s:8:\"user_add\";s:3:\"yes\";s:9:\"user_edit\";s:3:\"yes\";s:11:\"user_delete\";s:3:\"yes\";s:9:\"user_view\";s:3:\"yes\";s:7:\"classes\";s:3:\"yes\";s:11:\"classes_add\";s:3:\"yes\";s:12:\"classes_edit\";s:3:\"yes\";s:14:\"classes_delete\";s:3:\"yes\";s:7:\"section\";s:3:\"yes\";s:11:\"section_add\";s:3:\"yes\";s:12:\"section_edit\";s:3:\"yes\";s:15:\"semester_delete\";s:3:\"yes\";s:14:\"section_delete\";s:3:\"yes\";s:7:\"subject\";s:3:\"yes\";s:11:\"subject_add\";s:3:\"yes\";s:12:\"subject_edit\";s:3:\"yes\";s:14:\"subject_delete\";s:3:\"yes\";s:8:\"syllabus\";s:3:\"yes\";s:12:\"syllabus_add\";s:3:\"yes\";s:13:\"syllabus_edit\";s:3:\"yes\";s:15:\"syllabus_delete\";s:3:\"yes\";s:10:\"assignment\";s:3:\"yes\";s:14:\"assignment_add\";s:3:\"yes\";s:15:\"assignment_edit\";s:3:\"yes\";s:17:\"assignment_delete\";s:3:\"yes\";s:15:\"assignment_view\";s:3:\"yes\";s:7:\"routine\";s:3:\"yes\";s:11:\"routine_add\";s:3:\"yes\";s:12:\"routine_edit\";s:3:\"yes\";s:14:\"routine_delete\";s:3:\"yes\";s:11:\"sattendance\";s:3:\"yes\";s:15:\"sattendance_add\";s:3:\"yes\";s:16:\"sattendance_view\";s:3:\"yes\";s:11:\"tattendance\";s:3:\"yes\";s:15:\"tattendance_add\";s:3:\"yes\";s:16:\"tattendance_view\";s:3:\"yes\";s:11:\"uattendance\";s:3:\"yes\";s:15:\"uattendance_add\";s:3:\"yes\";s:16:\"uattendance_view\";s:3:\"yes\";s:4:\"exam\";s:3:\"yes\";s:8:\"exam_add\";s:3:\"yes\";s:9:\"exam_edit\";s:3:\"yes\";s:11:\"exam_delete\";s:3:\"yes\";s:12:\"examschedule\";s:3:\"yes\";s:16:\"examschedule_add\";s:3:\"yes\";s:17:\"examschedule_edit\";s:3:\"yes\";s:19:\"examschedule_delete\";s:3:\"yes\";s:5:\"grade\";s:3:\"yes\";s:9:\"grade_add\";s:3:\"yes\";s:10:\"grade_edit\";s:3:\"yes\";s:12:\"grade_delete\";s:3:\"yes\";s:11:\"eattendance\";s:3:\"yes\";s:15:\"eattendance_add\";s:3:\"yes\";s:4:\"mark\";s:3:\"yes\";s:8:\"mark_add\";s:3:\"yes\";s:9:\"mark_view\";s:3:\"yes\";s:14:\"markpercentage\";s:3:\"yes\";s:18:\"markpercentage_add\";s:3:\"yes\";s:19:\"markpercentage_edit\";s:3:\"yes\";s:21:\"markpercentage_delete\";s:3:\"yes\";s:9:\"promotion\";s:3:\"yes\";s:12:\"conversation\";s:3:\"yes\";s:5:\"media\";s:3:\"yes\";s:9:\"media_add\";s:3:\"yes\";s:12:\"media_delete\";s:3:\"yes\";s:10:\"mailandsms\";s:3:\"yes\";s:14:\"mailandsms_add\";s:3:\"yes\";s:15:\"mailandsms_view\";s:3:\"yes\";s:14:\"question_group\";s:3:\"yes\";s:18:\"question_group_add\";s:3:\"yes\";s:19:\"question_group_edit\";s:3:\"yes\";s:21:\"question_group_delete\";s:3:\"yes\";s:14:\"question_level\";s:3:\"yes\";s:18:\"question_level_add\";s:3:\"yes\";s:19:\"question_level_edit\";s:3:\"yes\";s:21:\"question_level_delete\";s:3:\"yes\";s:13:\"question_bank\";s:3:\"yes\";s:17:\"question_bank_add\";s:3:\"yes\";s:18:\"question_bank_edit\";s:3:\"yes\";s:20:\"question_bank_delete\";s:3:\"yes\";s:18:\"question_bank_view\";s:3:\"yes\";s:11:\"online_exam\";s:3:\"yes\";s:15:\"online_exam_add\";s:3:\"yes\";s:16:\"online_exam_edit\";s:3:\"yes\";s:18:\"online_exam_delete\";s:3:\"yes\";s:11:\"instruction\";s:3:\"yes\";s:15:\"instruction_add\";s:3:\"yes\";s:16:\"instruction_edit\";s:3:\"yes\";s:18:\"instruction_delete\";s:3:\"yes\";s:16:\"instruction_view\";s:3:\"yes\";s:15:\"salary_template\";s:3:\"yes\";s:19:\"salary_template_add\";s:3:\"yes\";s:20:\"salary_template_edit\";s:3:\"yes\";s:22:\"salary_template_delete\";s:3:\"yes\";s:20:\"salary_template_view\";s:3:\"yes\";s:15:\"hourly_template\";s:3:\"yes\";s:19:\"hourly_template_add\";s:3:\"yes\";s:20:\"hourly_template_edit\";s:3:\"yes\";s:22:\"hourly_template_delete\";s:3:\"yes\";s:13:\"manage_salary\";s:3:\"yes\";s:17:\"manage_salary_add\";s:3:\"yes\";s:18:\"manage_salary_edit\";s:3:\"yes\";s:20:\"manage_salary_delete\";s:3:\"yes\";s:18:\"manage_salary_view\";s:3:\"yes\";s:12:\"make_payment\";s:3:\"yes\";s:8:\"overtime\";s:3:\"yes\";s:12:\"overtime_add\";s:3:\"yes\";s:13:\"overtime_edit\";s:3:\"yes\";s:15:\"overtime_delete\";s:3:\"yes\";s:6:\"vendor\";s:3:\"yes\";s:10:\"vendor_add\";s:3:\"yes\";s:11:\"vendor_edit\";s:3:\"yes\";s:13:\"vendor_delete\";s:3:\"yes\";s:8:\"location\";s:3:\"yes\";s:12:\"location_add\";s:3:\"yes\";s:13:\"location_edit\";s:3:\"yes\";s:15:\"location_delete\";s:3:\"yes\";s:14:\"asset_category\";s:3:\"yes\";s:18:\"asset_category_add\";s:3:\"yes\";s:19:\"asset_category_edit\";s:3:\"yes\";s:21:\"asset_category_delete\";s:3:\"yes\";s:5:\"asset\";s:3:\"yes\";s:9:\"asset_add\";s:3:\"yes\";s:10:\"asset_edit\";s:3:\"yes\";s:12:\"asset_delete\";s:3:\"yes\";s:10:\"asset_view\";s:3:\"yes\";s:16:\"asset_assignment\";s:3:\"yes\";s:20:\"asset_assignment_add\";s:3:\"yes\";s:21:\"asset_assignment_edit\";s:3:\"yes\";s:23:\"asset_assignment_delete\";s:3:\"yes\";s:21:\"asset_assignment_view\";s:3:\"yes\";s:8:\"purchase\";s:3:\"yes\";s:12:\"purchase_add\";s:3:\"yes\";s:13:\"purchase_edit\";s:3:\"yes\";s:15:\"purchase_delete\";s:3:\"yes\";s:15:\"productcategory\";s:3:\"yes\";s:19:\"productcategory_add\";s:3:\"yes\";s:20:\"productcategory_edit\";s:3:\"yes\";s:22:\"productcategory_delete\";s:3:\"yes\";s:7:\"product\";s:3:\"yes\";s:11:\"product_add\";s:3:\"yes\";s:12:\"product_edit\";s:3:\"yes\";s:14:\"product_delete\";s:3:\"yes\";s:16:\"productwarehouse\";s:3:\"yes\";s:20:\"productwarehouse_add\";s:3:\"yes\";s:21:\"productwarehouse_edit\";s:3:\"yes\";s:23:\"productwarehouse_delete\";s:3:\"yes\";s:15:\"productsupplier\";s:3:\"yes\";s:19:\"productsupplier_add\";s:3:\"yes\";s:20:\"productsupplier_edit\";s:3:\"yes\";s:22:\"productsupplier_delete\";s:3:\"yes\";s:15:\"productpurchase\";s:3:\"yes\";s:19:\"productpurchase_add\";s:3:\"yes\";s:20:\"productpurchase_edit\";s:3:\"yes\";s:22:\"productpurchase_delete\";s:3:\"yes\";s:20:\"productpurchase_view\";s:3:\"yes\";s:11:\"productsale\";s:3:\"yes\";s:15:\"productsale_add\";s:3:\"yes\";s:16:\"productsale_edit\";s:3:\"yes\";s:18:\"productsale_delete\";s:3:\"yes\";s:16:\"productsale_view\";s:3:\"yes\";s:13:\"leavecategory\";s:3:\"yes\";s:17:\"leavecategory_add\";s:3:\"yes\";s:18:\"leavecategory_edit\";s:3:\"yes\";s:20:\"leavecategory_delete\";s:3:\"yes\";s:11:\"leaveassign\";s:3:\"yes\";s:15:\"leaveassign_add\";s:3:\"yes\";s:16:\"leaveassign_edit\";s:3:\"yes\";s:18:\"leaveassign_delete\";s:3:\"yes\";s:10:\"leaveapply\";s:3:\"yes\";s:14:\"leaveapply_add\";s:3:\"yes\";s:15:\"leaveapply_edit\";s:3:\"yes\";s:17:\"leaveapply_delete\";s:3:\"yes\";s:15:\"leaveapply_view\";s:3:\"yes\";s:16:\"leaveapplication\";s:3:\"yes\";s:18:\"activitiescategory\";s:3:\"yes\";s:22:\"activitiescategory_add\";s:3:\"yes\";s:23:\"activitiescategory_edit\";s:3:\"yes\";s:25:\"activitiescategory_delete\";s:3:\"yes\";s:10:\"activities\";s:3:\"yes\";s:14:\"activities_add\";s:3:\"yes\";s:17:\"activities_delete\";s:3:\"yes\";s:9:\"childcare\";s:3:\"yes\";s:13:\"childcare_add\";s:3:\"yes\";s:14:\"childcare_edit\";s:3:\"yes\";s:16:\"childcare_delete\";s:3:\"yes\";s:7:\"lmember\";s:3:\"yes\";s:11:\"lmember_add\";s:3:\"yes\";s:12:\"lmember_edit\";s:3:\"yes\";s:14:\"lmember_delete\";s:3:\"yes\";s:12:\"lmember_view\";s:3:\"yes\";s:4:\"book\";s:3:\"yes\";s:8:\"book_add\";s:3:\"yes\";s:9:\"book_edit\";s:3:\"yes\";s:11:\"book_delete\";s:3:\"yes\";s:5:\"issue\";s:3:\"yes\";s:9:\"issue_add\";s:3:\"yes\";s:10:\"issue_edit\";s:3:\"yes\";s:10:\"issue_view\";s:3:\"yes\";s:6:\"ebooks\";s:3:\"yes\";s:10:\"ebooks_add\";s:3:\"yes\";s:11:\"ebooks_edit\";s:3:\"yes\";s:13:\"ebooks_delete\";s:3:\"yes\";s:11:\"ebooks_view\";s:3:\"yes\";s:9:\"transport\";s:3:\"yes\";s:13:\"transport_add\";s:3:\"yes\";s:14:\"transport_edit\";s:3:\"yes\";s:16:\"transport_delete\";s:3:\"yes\";s:7:\"tmember\";s:3:\"yes\";s:11:\"tmember_add\";s:3:\"yes\";s:12:\"tmember_edit\";s:3:\"yes\";s:14:\"tmember_delete\";s:3:\"yes\";s:12:\"tmember_view\";s:3:\"yes\";s:6:\"hostel\";s:3:\"yes\";s:10:\"hostel_add\";s:3:\"yes\";s:11:\"hostel_edit\";s:3:\"yes\";s:13:\"hostel_delete\";s:3:\"yes\";s:8:\"category\";s:3:\"yes\";s:12:\"category_add\";s:3:\"yes\";s:13:\"category_edit\";s:3:\"yes\";s:15:\"category_delete\";s:3:\"yes\";s:7:\"hmember\";s:3:\"yes\";s:11:\"hmember_add\";s:3:\"yes\";s:12:\"hmember_edit\";s:3:\"yes\";s:14:\"hmember_delete\";s:3:\"yes\";s:12:\"hmember_view\";s:3:\"yes\";s:8:\"feetypes\";s:3:\"yes\";s:12:\"feetypes_add\";s:3:\"yes\";s:13:\"feetypes_edit\";s:3:\"yes\";s:15:\"feetypes_delete\";s:3:\"yes\";s:7:\"invoice\";s:3:\"yes\";s:11:\"invoice_add\";s:3:\"yes\";s:12:\"invoice_edit\";s:3:\"yes\";s:14:\"invoice_delete\";s:3:\"yes\";s:12:\"invoice_view\";s:3:\"yes\";s:14:\"paymenthistory\";s:3:\"yes\";s:19:\"paymenthistory_edit\";s:3:\"yes\";s:21:\"paymenthistory_delete\";s:3:\"yes\";s:7:\"expense\";s:3:\"yes\";s:11:\"expense_add\";s:3:\"yes\";s:12:\"expense_edit\";s:3:\"yes\";s:14:\"expense_delete\";s:3:\"yes\";s:6:\"income\";s:3:\"yes\";s:10:\"income_add\";s:3:\"yes\";s:11:\"income_edit\";s:3:\"yes\";s:13:\"income_delete\";s:3:\"yes\";s:14:\"global_payment\";s:3:\"yes\";s:6:\"notice\";s:3:\"yes\";s:10:\"notice_add\";s:3:\"yes\";s:11:\"notice_edit\";s:3:\"yes\";s:13:\"notice_delete\";s:3:\"yes\";s:11:\"notice_view\";s:3:\"yes\";s:5:\"event\";s:3:\"yes\";s:9:\"event_add\";s:3:\"yes\";s:10:\"event_edit\";s:3:\"yes\";s:12:\"event_delete\";s:3:\"yes\";s:10:\"event_view\";s:3:\"yes\";s:7:\"holiday\";s:3:\"yes\";s:11:\"holiday_add\";s:3:\"yes\";s:12:\"holiday_edit\";s:3:\"yes\";s:14:\"holiday_delete\";s:3:\"yes\";s:12:\"holiday_view\";s:3:\"yes\";s:13:\"classesreport\";s:3:\"yes\";s:13:\"studentreport\";s:3:\"yes\";s:12:\"idcardreport\";s:3:\"yes\";s:15:\"admitcardreport\";s:3:\"yes\";s:13:\"routinereport\";s:3:\"yes\";s:18:\"examschedulereport\";s:3:\"yes\";s:16:\"attendancereport\";s:3:\"yes\";s:24:\"attendanceoverviewreport\";s:3:\"yes\";s:18:\"librarybooksreport\";s:3:\"yes\";s:17:\"librarycardreport\";s:3:\"yes\";s:22:\"librarybookissuereport\";s:3:\"yes\";s:14:\"terminalreport\";s:3:\"yes\";s:16:\"meritstagereport\";s:3:\"yes\";s:21:\"tabulationsheetreport\";s:3:\"yes\";s:15:\"marksheetreport\";s:3:\"yes\";s:18:\"progresscardreport\";s:3:\"yes\";s:20:\"studentsessionreport\";s:3:\"yes\";s:16:\"onlineexamreport\";s:3:\"yes\";s:24:\"onlineexamquestionreport\";s:3:\"yes\";s:21:\"onlineadmissionreport\";s:3:\"yes\";s:17:\"certificatereport\";s:3:\"yes\";s:22:\"leaveapplicationreport\";s:3:\"yes\";s:21:\"productpurchasereport\";s:3:\"yes\";s:17:\"productsalereport\";s:3:\"yes\";s:23:\"searchpaymentfeesreport\";s:3:\"yes\";s:10:\"feesreport\";s:3:\"yes\";s:13:\"duefeesreport\";s:3:\"yes\";s:17:\"balancefeesreport\";s:3:\"yes\";s:17:\"transactionreport\";s:3:\"yes\";s:17:\"studentfinereport\";s:3:\"yes\";s:14:\"overtimereport\";s:3:\"yes\";s:12:\"salaryreport\";s:3:\"yes\";s:19:\"accountledgerreport\";s:3:\"yes\";s:15:\"onlineadmission\";s:3:\"yes\";s:11:\"visitorinfo\";s:3:\"yes\";s:18:\"visitorinfo_delete\";s:3:\"yes\";s:16:\"visitorinfo_view\";s:3:\"yes\";s:10:\"schoolyear\";s:3:\"yes\";s:14:\"schoolyear_add\";s:3:\"yes\";s:15:\"schoolyear_edit\";s:3:\"yes\";s:17:\"schoolyear_delete\";s:3:\"yes\";s:12:\"studentgroup\";s:3:\"yes\";s:16:\"studentgroup_add\";s:3:\"yes\";s:17:\"studentgroup_edit\";s:3:\"yes\";s:19:\"studentgroup_delete\";s:3:\"yes\";s:8:\"complain\";s:3:\"yes\";s:12:\"complain_add\";s:3:\"yes\";s:13:\"complain_edit\";s:3:\"yes\";s:15:\"complain_delete\";s:3:\"yes\";s:13:\"complain_view\";s:3:\"yes\";s:20:\"certificate_template\";s:3:\"yes\";s:24:\"certificate_template_add\";s:3:\"yes\";s:25:\"certificate_template_edit\";s:3:\"yes\";s:27:\"certificate_template_delete\";s:3:\"yes\";s:25:\"certificate_template_view\";s:3:\"yes\";s:11:\"systemadmin\";s:3:\"yes\";s:15:\"systemadmin_add\";s:3:\"yes\";s:16:\"systemadmin_edit\";s:3:\"yes\";s:18:\"systemadmin_delete\";s:3:\"yes\";s:16:\"systemadmin_view\";s:3:\"yes\";s:13:\"resetpassword\";s:3:\"yes\";s:10:\"sociallink\";s:3:\"yes\";s:14:\"sociallink_add\";s:3:\"yes\";s:15:\"sociallink_edit\";s:3:\"yes\";s:17:\"sociallink_delete\";s:3:\"yes\";s:18:\"mailandsmstemplate\";s:3:\"yes\";s:22:\"mailandsmstemplate_add\";s:3:\"yes\";s:23:\"mailandsmstemplate_edit\";s:3:\"yes\";s:25:\"mailandsmstemplate_delete\";s:3:\"yes\";s:23:\"mailandsmstemplate_view\";s:3:\"yes\";s:10:\"bulkimport\";s:3:\"yes\";s:6:\"backup\";s:3:\"yes\";s:8:\"usertype\";s:3:\"yes\";s:12:\"usertype_add\";s:3:\"yes\";s:13:\"usertype_edit\";s:3:\"yes\";s:15:\"usertype_delete\";s:3:\"yes\";s:10:\"permission\";s:3:\"yes\";s:6:\"addons\";s:3:\"yes\";s:6:\"update\";s:3:\"yes\";s:16:\"posts_categories\";s:3:\"yes\";s:20:\"posts_categories_add\";s:3:\"yes\";s:21:\"posts_categories_edit\";s:3:\"yes\";s:23:\"posts_categories_delete\";s:3:\"yes\";s:5:\"posts\";s:3:\"yes\";s:9:\"posts_add\";s:3:\"yes\";s:10:\"posts_edit\";s:3:\"yes\";s:12:\"posts_delete\";s:3:\"yes\";s:5:\"pages\";s:3:\"yes\";s:9:\"pages_add\";s:3:\"yes\";s:10:\"pages_edit\";s:3:\"yes\";s:12:\"pages_delete\";s:3:\"yes\";s:12:\"frontendmenu\";s:3:\"yes\";s:7:\"setting\";s:3:\"yes\";s:16:\"frontend_setting\";s:3:\"yes\";s:15:\"paymentsettings\";s:3:\"yes\";s:11:\"smssettings\";s:3:\"yes\";s:12:\"emailsetting\";s:3:\"yes\";s:11:\"marksetting\";s:3:\"yes\";s:9:\"candidate\";s:3:\"yes\";s:13:\"candidate_add\";s:3:\"yes\";s:14:\"candidate_edit\";s:3:\"yes\";s:16:\"candidate_delete\";s:3:\"yes\";s:14:\"candidate_view\";s:3:\"yes\";s:7:\"sponsor\";s:3:\"yes\";s:11:\"sponsor_add\";s:3:\"yes\";s:12:\"sponsor_edit\";s:3:\"yes\";s:14:\"sponsor_delete\";s:3:\"yes\";s:12:\"sponsor_view\";s:3:\"yes\";s:11:\"sponsorship\";s:3:\"yes\";s:15:\"sponsorship_add\";s:3:\"yes\";s:16:\"sponsorship_edit\";s:3:\"yes\";s:18:\"sponsorship_delete\";s:3:\"yes\";s:17:\"sponsorshipreport\";s:3:\"yes\";s:30:\"onlineexamquestionanswerreport\";s:3:\"yes\";s:10:\"attendance\";s:3:\"yes\";s:25:\"student_attendance_report\";s:3:\"yes\";s:25:\"teacher_attendance_report\";s:3:\"yes\";s:22:\"user_attendance_report\";s:3:\"yes\";s:17:\"qrcode_attendance\";s:3:\"yes\";s:5:\"mpesa\";s:3:\"yes\";s:20:\"vendorpurchasereport\";s:3:\"yes\";s:18:\"itempurchasereport\";s:3:\"yes\";s:22:\"categorypurchasereport\";s:3:\"yes\";s:14:\"itemsalereport\";s:3:\"yes\";s:18:\"categorysalereport\";s:3:\"yes\";s:6:\"wallet\";s:3:\"yes\";s:5:\"lunch\";s:3:\"yes\";s:12:\"lunchsetting\";s:3:\"yes\";s:9:\"lunchlogs\";s:3:\"yes\";s:10:\"schoolterm\";s:3:\"yes\";s:14:\"schoolterm_add\";s:3:\"yes\";s:15:\"schoolterm_edit\";s:3:\"yes\";s:17:\"schoolterm_delete\";s:3:\"yes\";s:15:\"schoolterm_view\";s:3:\"yes\";s:15:\"generate_qrcode\";s:3:\"yes\";s:10:\"studentids\";s:3:\"yes\";s:17:\"studentids_delete\";s:3:\"yes\";s:17:\"cbcterminalreport\";s:3:\"yes\";s:9:\"smsreport\";s:3:\"yes\";s:7:\"sendsms\";s:3:\"yes\";s:15:\"studentleaveout\";s:3:\"yes\";s:20:\"studentleaveout_edit\";s:3:\"yes\";s:20:\"studentleaveout_view\";s:3:\"yes\";s:22:\"studentleaveout_delete\";s:3:\"yes\";s:13:\"backup_delete\";s:3:\"yes\";s:10:\"backup_add\";s:3:\"yes\";s:14:\"backup_restore\";s:3:\"yes\";s:9:\"take_exam\";s:3:\"yes\";}');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('49f8b243023501bad3411f0286404c059a3e54eb', '102.222.4.116', 1712300666, '__ci_last_regenerate|i:1712300499;english|N;loginuserID|s:2:\"33\";name|s:10:\"AMOS KIBET\";email|s:22:\"kibetamos567@gmail.com\";usertypeID|s:1:\"2\";usertype|s:7:\"Teacher\";username|s:6:\"kibett\";photo|s:9:\"kibet.JPG\";lang|s:7:\"english\";defaultschoolyearID|s:1:\"4\";varifyvaliduser|b:1;loggedin|b:1;get_permission|b:1;master_permission_set|a:426:{s:9:\"dashboard\";s:3:\"yes\";s:7:\"teacher\";s:3:\"yes\";s:7:\"subject\";s:3:\"yes\";s:7:\"routine\";s:3:\"yes\";s:11:\"routine_add\";s:3:\"yes\";s:12:\"routine_edit\";s:3:\"yes\";s:4:\"mark\";s:3:\"yes\";s:8:\"mark_add\";s:3:\"yes\";s:9:\"mark_view\";s:3:\"yes\";s:12:\"conversation\";s:3:\"yes\";s:6:\"notice\";s:3:\"yes\";s:11:\"notice_view\";s:3:\"yes\";s:5:\"event\";s:3:\"yes\";s:10:\"event_view\";s:3:\"yes\";s:7:\"holiday\";s:3:\"yes\";s:12:\"holiday_view\";s:3:\"yes\";s:24:\"attendanceoverviewreport\";s:3:\"yes\";s:14:\"terminalreport\";s:3:\"yes\";s:21:\"tabulationsheetreport\";s:3:\"yes\";s:15:\"marksheetreport\";s:3:\"yes\";s:17:\"qrcode_attendance\";s:3:\"yes\";s:7:\"classes\";s:3:\"yes\";s:7:\"section\";s:3:\"yes\";s:4:\"exam\";s:3:\"yes\";s:5:\"grade\";s:3:\"yes\";s:17:\"cbcterminalreport\";s:3:\"yes\";s:7:\"student\";s:2:\"no\";s:11:\"student_add\";s:2:\"no\";s:12:\"student_edit\";s:2:\"no\";s:14:\"student_delete\";s:2:\"no\";s:12:\"student_view\";s:2:\"no\";s:7:\"parents\";s:2:\"no\";s:11:\"parents_add\";s:2:\"no\";s:12:\"parents_edit\";s:2:\"no\";s:14:\"parents_delete\";s:2:\"no\";s:12:\"parents_view\";s:2:\"no\";s:11:\"teacher_add\";s:2:\"no\";s:12:\"teacher_edit\";s:2:\"no\";s:14:\"teacher_delete\";s:2:\"no\";s:12:\"teacher_view\";s:2:\"no\";s:4:\"user\";s:2:\"no\";s:8:\"user_add\";s:2:\"no\";s:9:\"user_edit\";s:2:\"no\";s:11:\"user_delete\";s:2:\"no\";s:9:\"user_view\";s:2:\"no\";s:11:\"classes_add\";s:2:\"no\";s:12:\"classes_edit\";s:2:\"no\";s:14:\"classes_delete\";s:2:\"no\";s:11:\"section_add\";s:2:\"no\";s:12:\"section_edit\";s:2:\"no\";s:15:\"semester_delete\";s:2:\"no\";s:14:\"section_delete\";s:2:\"no\";s:11:\"subject_add\";s:2:\"no\";s:12:\"subject_edit\";s:2:\"no\";s:14:\"subject_delete\";s:2:\"no\";s:8:\"syllabus\";s:2:\"no\";s:12:\"syllabus_add\";s:2:\"no\";s:13:\"syllabus_edit\";s:2:\"no\";s:15:\"syllabus_delete\";s:2:\"no\";s:10:\"assignment\";s:2:\"no\";s:14:\"assignment_add\";s:2:\"no\";s:15:\"assignment_edit\";s:2:\"no\";s:17:\"assignment_delete\";s:2:\"no\";s:15:\"assignment_view\";s:2:\"no\";s:14:\"routine_delete\";s:2:\"no\";s:11:\"sattendance\";s:2:\"no\";s:15:\"sattendance_add\";s:2:\"no\";s:16:\"sattendance_view\";s:2:\"no\";s:11:\"tattendance\";s:2:\"no\";s:15:\"tattendance_add\";s:2:\"no\";s:16:\"tattendance_view\";s:2:\"no\";s:11:\"uattendance\";s:2:\"no\";s:15:\"uattendance_add\";s:2:\"no\";s:16:\"uattendance_view\";s:2:\"no\";s:8:\"exam_add\";s:2:\"no\";s:9:\"exam_edit\";s:2:\"no\";s:11:\"exam_delete\";s:2:\"no\";s:12:\"examschedule\";s:2:\"no\";s:16:\"examschedule_add\";s:2:\"no\";s:17:\"examschedule_edit\";s:2:\"no\";s:19:\"examschedule_delete\";s:2:\"no\";s:9:\"grade_add\";s:2:\"no\";s:10:\"grade_edit\";s:2:\"no\";s:12:\"grade_delete\";s:2:\"no\";s:11:\"eattendance\";s:2:\"no\";s:15:\"eattendance_add\";s:2:\"no\";s:14:\"markpercentage\";s:2:\"no\";s:18:\"markpercentage_add\";s:2:\"no\";s:19:\"markpercentage_edit\";s:2:\"no\";s:21:\"markpercentage_delete\";s:2:\"no\";s:9:\"promotion\";s:2:\"no\";s:5:\"media\";s:2:\"no\";s:9:\"media_add\";s:2:\"no\";s:12:\"media_delete\";s:2:\"no\";s:10:\"mailandsms\";s:2:\"no\";s:14:\"mailandsms_add\";s:2:\"no\";s:15:\"mailandsms_view\";s:2:\"no\";s:14:\"question_group\";s:2:\"no\";s:18:\"question_group_add\";s:2:\"no\";s:19:\"question_group_edit\";s:2:\"no\";s:21:\"question_group_delete\";s:2:\"no\";s:14:\"question_level\";s:2:\"no\";s:18:\"question_level_add\";s:2:\"no\";s:19:\"question_level_edit\";s:2:\"no\";s:21:\"question_level_delete\";s:2:\"no\";s:13:\"question_bank\";s:2:\"no\";s:17:\"question_bank_add\";s:2:\"no\";s:18:\"question_bank_edit\";s:2:\"no\";s:20:\"question_bank_delete\";s:2:\"no\";s:18:\"question_bank_view\";s:2:\"no\";s:11:\"online_exam\";s:2:\"no\";s:15:\"online_exam_add\";s:2:\"no\";s:16:\"online_exam_edit\";s:2:\"no\";s:18:\"online_exam_delete\";s:2:\"no\";s:11:\"instruction\";s:2:\"no\";s:15:\"instruction_add\";s:2:\"no\";s:16:\"instruction_edit\";s:2:\"no\";s:18:\"instruction_delete\";s:2:\"no\";s:16:\"instruction_view\";s:2:\"no\";s:15:\"salary_template\";s:2:\"no\";s:19:\"salary_template_add\";s:2:\"no\";s:20:\"salary_template_edit\";s:2:\"no\";s:22:\"salary_template_delete\";s:2:\"no\";s:20:\"salary_template_view\";s:2:\"no\";s:15:\"hourly_template\";s:2:\"no\";s:19:\"hourly_template_add\";s:2:\"no\";s:20:\"hourly_template_edit\";s:2:\"no\";s:22:\"hourly_template_delete\";s:2:\"no\";s:13:\"manage_salary\";s:2:\"no\";s:17:\"manage_salary_add\";s:2:\"no\";s:18:\"manage_salary_edit\";s:2:\"no\";s:20:\"manage_salary_delete\";s:2:\"no\";s:18:\"manage_salary_view\";s:2:\"no\";s:12:\"make_payment\";s:2:\"no\";s:8:\"overtime\";s:2:\"no\";s:12:\"overtime_add\";s:2:\"no\";s:13:\"overtime_edit\";s:2:\"no\";s:15:\"overtime_delete\";s:2:\"no\";s:6:\"vendor\";s:2:\"no\";s:10:\"vendor_add\";s:2:\"no\";s:11:\"vendor_edit\";s:2:\"no\";s:13:\"vendor_delete\";s:2:\"no\";s:8:\"location\";s:2:\"no\";s:12:\"location_add\";s:2:\"no\";s:13:\"location_edit\";s:2:\"no\";s:15:\"location_delete\";s:2:\"no\";s:14:\"asset_category\";s:2:\"no\";s:18:\"asset_category_add\";s:2:\"no\";s:19:\"asset_category_edit\";s:2:\"no\";s:21:\"asset_category_delete\";s:2:\"no\";s:5:\"asset\";s:2:\"no\";s:9:\"asset_add\";s:2:\"no\";s:10:\"asset_edit\";s:2:\"no\";s:12:\"asset_delete\";s:2:\"no\";s:10:\"asset_view\";s:2:\"no\";s:16:\"asset_assignment\";s:2:\"no\";s:20:\"asset_assignment_add\";s:2:\"no\";s:21:\"asset_assignment_edit\";s:2:\"no\";s:23:\"asset_assignment_delete\";s:2:\"no\";s:21:\"asset_assignment_view\";s:2:\"no\";s:8:\"purchase\";s:2:\"no\";s:12:\"purchase_add\";s:2:\"no\";s:13:\"purchase_edit\";s:2:\"no\";s:15:\"purchase_delete\";s:2:\"no\";s:15:\"productcategory\";s:2:\"no\";s:19:\"productcategory_add\";s:2:\"no\";s:20:\"productcategory_edit\";s:2:\"no\";s:22:\"productcategory_delete\";s:2:\"no\";s:7:\"product\";s:2:\"no\";s:11:\"product_add\";s:2:\"no\";s:12:\"product_edit\";s:2:\"no\";s:14:\"product_delete\";s:2:\"no\";s:16:\"productwarehouse\";s:2:\"no\";s:20:\"productwarehouse_add\";s:2:\"no\";s:21:\"productwarehouse_edit\";s:2:\"no\";s:23:\"productwarehouse_delete\";s:2:\"no\";s:15:\"productsupplier\";s:2:\"no\";s:19:\"productsupplier_add\";s:2:\"no\";s:20:\"productsupplier_edit\";s:2:\"no\";s:22:\"productsupplier_delete\";s:2:\"no\";s:15:\"productpurchase\";s:2:\"no\";s:19:\"productpurchase_add\";s:2:\"no\";s:20:\"productpurchase_edit\";s:2:\"no\";s:22:\"productpurchase_delete\";s:2:\"no\";s:20:\"productpurchase_view\";s:2:\"no\";s:11:\"productsale\";s:2:\"no\";s:15:\"productsale_add\";s:2:\"no\";s:16:\"productsale_edit\";s:2:\"no\";s:18:\"productsale_delete\";s:2:\"no\";s:16:\"productsale_view\";s:2:\"no\";s:13:\"leavecategory\";s:2:\"no\";s:17:\"leavecategory_add\";s:2:\"no\";s:18:\"leavecategory_edit\";s:2:\"no\";s:20:\"leavecategory_delete\";s:2:\"no\";s:11:\"leaveassign\";s:2:\"no\";s:15:\"leaveassign_add\";s:2:\"no\";s:16:\"leaveassign_edit\";s:2:\"no\";s:18:\"leaveassign_delete\";s:2:\"no\";s:10:\"leaveapply\";s:2:\"no\";s:14:\"leaveapply_add\";s:2:\"no\";s:15:\"leaveapply_edit\";s:2:\"no\";s:17:\"leaveapply_delete\";s:2:\"no\";s:15:\"leaveapply_view\";s:2:\"no\";s:16:\"leaveapplication\";s:2:\"no\";s:18:\"activitiescategory\";s:2:\"no\";s:22:\"activitiescategory_add\";s:2:\"no\";s:23:\"activitiescategory_edit\";s:2:\"no\";s:25:\"activitiescategory_delete\";s:2:\"no\";s:10:\"activities\";s:2:\"no\";s:14:\"activities_add\";s:2:\"no\";s:17:\"activities_delete\";s:2:\"no\";s:9:\"childcare\";s:2:\"no\";s:13:\"childcare_add\";s:2:\"no\";s:14:\"childcare_edit\";s:2:\"no\";s:16:\"childcare_delete\";s:2:\"no\";s:7:\"lmember\";s:2:\"no\";s:11:\"lmember_add\";s:2:\"no\";s:12:\"lmember_edit\";s:2:\"no\";s:14:\"lmember_delete\";s:2:\"no\";s:12:\"lmember_view\";s:2:\"no\";s:4:\"book\";s:2:\"no\";s:8:\"book_add\";s:2:\"no\";s:9:\"book_edit\";s:2:\"no\";s:11:\"book_delete\";s:2:\"no\";s:5:\"issue\";s:2:\"no\";s:9:\"issue_add\";s:2:\"no\";s:10:\"issue_edit\";s:2:\"no\";s:10:\"issue_view\";s:2:\"no\";s:6:\"ebooks\";s:2:\"no\";s:10:\"ebooks_add\";s:2:\"no\";s:11:\"ebooks_edit\";s:2:\"no\";s:13:\"ebooks_delete\";s:2:\"no\";s:11:\"ebooks_view\";s:2:\"no\";s:9:\"transport\";s:2:\"no\";s:13:\"transport_add\";s:2:\"no\";s:14:\"transport_edit\";s:2:\"no\";s:16:\"transport_delete\";s:2:\"no\";s:7:\"tmember\";s:2:\"no\";s:11:\"tmember_add\";s:2:\"no\";s:12:\"tmember_edit\";s:2:\"no\";s:14:\"tmember_delete\";s:2:\"no\";s:12:\"tmember_view\";s:2:\"no\";s:6:\"hostel\";s:2:\"no\";s:10:\"hostel_add\";s:2:\"no\";s:11:\"hostel_edit\";s:2:\"no\";s:13:\"hostel_delete\";s:2:\"no\";s:8:\"category\";s:2:\"no\";s:12:\"category_add\";s:2:\"no\";s:13:\"category_edit\";s:2:\"no\";s:15:\"category_delete\";s:2:\"no\";s:7:\"hmember\";s:2:\"no\";s:11:\"hmember_add\";s:2:\"no\";s:12:\"hmember_edit\";s:2:\"no\";s:14:\"hmember_delete\";s:2:\"no\";s:12:\"hmember_view\";s:2:\"no\";s:8:\"feetypes\";s:2:\"no\";s:12:\"feetypes_add\";s:2:\"no\";s:13:\"feetypes_edit\";s:2:\"no\";s:15:\"feetypes_delete\";s:2:\"no\";s:7:\"invoice\";s:2:\"no\";s:11:\"invoice_add\";s:2:\"no\";s:12:\"invoice_edit\";s:2:\"no\";s:14:\"invoice_delete\";s:2:\"no\";s:12:\"invoice_view\";s:2:\"no\";s:14:\"paymenthistory\";s:2:\"no\";s:19:\"paymenthistory_edit\";s:2:\"no\";s:21:\"paymenthistory_delete\";s:2:\"no\";s:7:\"expense\";s:2:\"no\";s:11:\"expense_add\";s:2:\"no\";s:12:\"expense_edit\";s:2:\"no\";s:14:\"expense_delete\";s:2:\"no\";s:6:\"income\";s:2:\"no\";s:10:\"income_add\";s:2:\"no\";s:11:\"income_edit\";s:2:\"no\";s:13:\"income_delete\";s:2:\"no\";s:14:\"global_payment\";s:2:\"no\";s:10:\"notice_add\";s:2:\"no\";s:11:\"notice_edit\";s:2:\"no\";s:13:\"notice_delete\";s:2:\"no\";s:9:\"event_add\";s:2:\"no\";s:10:\"event_edit\";s:2:\"no\";s:12:\"event_delete\";s:2:\"no\";s:11:\"holiday_add\";s:2:\"no\";s:12:\"holiday_edit\";s:2:\"no\";s:14:\"holiday_delete\";s:2:\"no\";s:13:\"classesreport\";s:2:\"no\";s:13:\"studentreport\";s:2:\"no\";s:12:\"idcardreport\";s:2:\"no\";s:15:\"admitcardreport\";s:2:\"no\";s:13:\"routinereport\";s:2:\"no\";s:18:\"examschedulereport\";s:2:\"no\";s:16:\"attendancereport\";s:2:\"no\";s:18:\"librarybooksreport\";s:2:\"no\";s:17:\"librarycardreport\";s:2:\"no\";s:22:\"librarybookissuereport\";s:2:\"no\";s:16:\"meritstagereport\";s:2:\"no\";s:18:\"progresscardreport\";s:2:\"no\";s:20:\"studentsessionreport\";s:2:\"no\";s:16:\"onlineexamreport\";s:2:\"no\";s:24:\"onlineexamquestionreport\";s:2:\"no\";s:21:\"onlineadmissionreport\";s:2:\"no\";s:17:\"certificatereport\";s:2:\"no\";s:22:\"leaveapplicationreport\";s:2:\"no\";s:21:\"productpurchasereport\";s:2:\"no\";s:17:\"productsalereport\";s:2:\"no\";s:23:\"searchpaymentfeesreport\";s:2:\"no\";s:10:\"feesreport\";s:2:\"no\";s:13:\"duefeesreport\";s:2:\"no\";s:17:\"balancefeesreport\";s:2:\"no\";s:17:\"transactionreport\";s:2:\"no\";s:17:\"studentfinereport\";s:2:\"no\";s:14:\"overtimereport\";s:2:\"no\";s:12:\"salaryreport\";s:2:\"no\";s:19:\"accountledgerreport\";s:2:\"no\";s:15:\"onlineadmission\";s:2:\"no\";s:11:\"visitorinfo\";s:2:\"no\";s:18:\"visitorinfo_delete\";s:2:\"no\";s:16:\"visitorinfo_view\";s:2:\"no\";s:10:\"schoolyear\";s:2:\"no\";s:14:\"schoolyear_add\";s:2:\"no\";s:15:\"schoolyear_edit\";s:2:\"no\";s:17:\"schoolyear_delete\";s:2:\"no\";s:12:\"studentgroup\";s:2:\"no\";s:16:\"studentgroup_add\";s:2:\"no\";s:17:\"studentgroup_edit\";s:2:\"no\";s:19:\"studentgroup_delete\";s:2:\"no\";s:8:\"complain\";s:2:\"no\";s:12:\"complain_add\";s:2:\"no\";s:13:\"complain_edit\";s:2:\"no\";s:15:\"complain_delete\";s:2:\"no\";s:13:\"complain_view\";s:2:\"no\";s:20:\"certificate_template\";s:2:\"no\";s:24:\"certificate_template_add\";s:2:\"no\";s:25:\"certificate_template_edit\";s:2:\"no\";s:27:\"certificate_template_delete\";s:2:\"no\";s:25:\"certificate_template_view\";s:2:\"no\";s:11:\"systemadmin\";s:2:\"no\";s:15:\"systemadmin_add\";s:2:\"no\";s:16:\"systemadmin_edit\";s:2:\"no\";s:18:\"systemadmin_delete\";s:2:\"no\";s:16:\"systemadmin_view\";s:2:\"no\";s:13:\"resetpassword\";s:2:\"no\";s:10:\"sociallink\";s:2:\"no\";s:14:\"sociallink_add\";s:2:\"no\";s:15:\"sociallink_edit\";s:2:\"no\";s:17:\"sociallink_delete\";s:2:\"no\";s:18:\"mailandsmstemplate\";s:2:\"no\";s:22:\"mailandsmstemplate_add\";s:2:\"no\";s:23:\"mailandsmstemplate_edit\";s:2:\"no\";s:25:\"mailandsmstemplate_delete\";s:2:\"no\";s:23:\"mailandsmstemplate_view\";s:2:\"no\";s:11:\"bulkimport \";s:2:\"no\";s:6:\"backup\";s:2:\"no\";s:8:\"usertype\";s:2:\"no\";s:12:\"usertype_add\";s:2:\"no\";s:13:\"usertype_edit\";s:2:\"no\";s:15:\"usertype_delete\";s:2:\"no\";s:10:\"permission\";s:2:\"no\";s:6:\"addons\";s:2:\"no\";s:6:\"update\";s:2:\"no\";s:16:\"posts_categories\";s:2:\"no\";s:20:\"posts_categories_add\";s:2:\"no\";s:21:\"posts_categories_edit\";s:2:\"no\";s:23:\"posts_categories_delete\";s:2:\"no\";s:5:\"posts\";s:2:\"no\";s:9:\"posts_add\";s:2:\"no\";s:10:\"posts_edit\";s:2:\"no\";s:12:\"posts_delete\";s:2:\"no\";s:5:\"pages\";s:2:\"no\";s:9:\"pages_add\";s:2:\"no\";s:10:\"pages_edit\";s:2:\"no\";s:12:\"pages_delete\";s:2:\"no\";s:12:\"frontendmenu\";s:2:\"no\";s:7:\"setting\";s:2:\"no\";s:16:\"frontend_setting\";s:2:\"no\";s:15:\"paymentsettings\";s:2:\"no\";s:11:\"smssettings\";s:2:\"no\";s:12:\"emailsetting\";s:2:\"no\";s:11:\"marksetting\";s:2:\"no\";s:9:\"candidate\";s:2:\"no\";s:13:\"candidate_add\";s:2:\"no\";s:14:\"candidate_edit\";s:2:\"no\";s:16:\"candidate_delete\";s:2:\"no\";s:14:\"candidate_view\";s:2:\"no\";s:7:\"sponsor\";s:2:\"no\";s:11:\"sponsor_add\";s:2:\"no\";s:12:\"sponsor_edit\";s:2:\"no\";s:14:\"sponsor_delete\";s:2:\"no\";s:12:\"sponsor_view\";s:2:\"no\";s:11:\"sponsorship\";s:2:\"no\";s:15:\"sponsorship_add\";s:2:\"no\";s:16:\"sponsorship_edit\";s:2:\"no\";s:18:\"sponsorship_delete\";s:2:\"no\";s:17:\"sponsorshipreport\";s:2:\"no\";s:30:\"onlineexamquestionanswerreport\";s:2:\"no\";s:10:\"attendance\";s:2:\"no\";s:25:\"student_attendance_report\";s:2:\"no\";s:25:\"teacher_attendance_report\";s:2:\"no\";s:22:\"user_attendance_report\";s:2:\"no\";s:5:\"mpesa\";s:2:\"no\";s:20:\"vendorpurchasereport\";s:2:\"no\";s:18:\"itempurchasereport\";s:2:\"no\";s:22:\"categorypurchasereport\";s:2:\"no\";s:14:\"itemsalereport\";s:2:\"no\";s:18:\"categorysalereport\";s:2:\"no\";s:6:\"wallet\";s:2:\"no\";s:5:\"lunch\";s:2:\"no\";s:12:\"lunchsetting\";s:2:\"no\";s:9:\"lunchlogs\";s:2:\"no\";s:10:\"schoolterm\";s:2:\"no\";s:14:\"schoolterm_add\";s:2:\"no\";s:15:\"schoolterm_edit\";s:2:\"no\";s:17:\"schoolterm_delete\";s:2:\"no\";s:15:\"schoolterm_view\";s:2:\"no\";s:15:\"generate_qrcode\";s:2:\"no\";s:10:\"studentids\";s:2:\"no\";s:17:\"studentids_delete\";s:2:\"no\";s:9:\"smsreport\";s:2:\"no\";s:7:\"sendsms\";s:2:\"no\";s:15:\"studentleaveout\";s:2:\"no\";s:20:\"studentleaveout_edit\";s:2:\"no\";s:20:\"studentleaveout_view\";s:2:\"no\";s:22:\"studentleaveout_delete\";s:2:\"no\";s:13:\"backup_delete\";s:2:\"no\";s:10:\"backup_add\";s:2:\"no\";s:14:\"backup_restore\";s:2:\"no\";}');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('642f3fc7ad5be3b8ee456222e3e1af12f125f71d', '206.168.34.183', 1712407480, '__ci_last_regenerate|i:1712407480;');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('078dc6612d69126236f9d3249b6738bc441475b9', '199.45.155.36', 1712412701, '__ci_last_regenerate|i:1712412701;');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('681cf1be7ad8eca6c1756ce3b784ec70b2553c38', '64.23.249.136', 1712670808, '__ci_last_regenerate|i:1712670808;');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4dae82ceedb8d38f5f22ce4c6b0e4316f3e8a903', '199.45.155.49', 1712679907, '__ci_last_regenerate|i:1712679907;');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('939151d5937e3dc484390fda1d68396fac768046', '154.159.254.112', 1712741716, '__ci_last_regenerate|i:1712741633;english|N;loginuserID|s:2:\"34\";name|s:13:\"SANDRA NASIKE\";email|s:13:\"034@email.com\";usertypeID|s:1:\"3\";usertype|s:7:\"Student\";username|s:3:\"034\";photo|s:7:\"034.JPG\";lang|s:7:\"english\";defaultschoolyearID|s:1:\"4\";varifyvaliduser|b:1;loggedin|b:1;get_permission|b:1;master_permission_set|a:427:{s:9:\"dashboard\";s:3:\"yes\";s:7:\"teacher\";s:3:\"yes\";s:7:\"subject\";s:3:\"yes\";s:7:\"routine\";s:3:\"yes\";s:12:\"conversation\";s:3:\"yes\";s:7:\"invoice\";s:3:\"yes\";s:6:\"notice\";s:3:\"yes\";s:11:\"notice_view\";s:3:\"yes\";s:5:\"event\";s:3:\"yes\";s:10:\"event_view\";s:3:\"yes\";s:7:\"holiday\";s:3:\"yes\";s:12:\"holiday_view\";s:3:\"yes\";s:7:\"student\";s:2:\"no\";s:11:\"student_add\";s:2:\"no\";s:12:\"student_edit\";s:2:\"no\";s:14:\"student_delete\";s:2:\"no\";s:12:\"student_view\";s:2:\"no\";s:7:\"parents\";s:2:\"no\";s:11:\"parents_add\";s:2:\"no\";s:12:\"parents_edit\";s:2:\"no\";s:14:\"parents_delete\";s:2:\"no\";s:12:\"parents_view\";s:2:\"no\";s:11:\"teacher_add\";s:2:\"no\";s:12:\"teacher_edit\";s:2:\"no\";s:14:\"teacher_delete\";s:2:\"no\";s:12:\"teacher_view\";s:2:\"no\";s:4:\"user\";s:2:\"no\";s:8:\"user_add\";s:2:\"no\";s:9:\"user_edit\";s:2:\"no\";s:11:\"user_delete\";s:2:\"no\";s:9:\"user_view\";s:2:\"no\";s:7:\"classes\";s:2:\"no\";s:11:\"classes_add\";s:2:\"no\";s:12:\"classes_edit\";s:2:\"no\";s:14:\"classes_delete\";s:2:\"no\";s:7:\"section\";s:2:\"no\";s:11:\"section_add\";s:2:\"no\";s:12:\"section_edit\";s:2:\"no\";s:15:\"semester_delete\";s:2:\"no\";s:14:\"section_delete\";s:2:\"no\";s:11:\"subject_add\";s:2:\"no\";s:12:\"subject_edit\";s:2:\"no\";s:14:\"subject_delete\";s:2:\"no\";s:8:\"syllabus\";s:2:\"no\";s:12:\"syllabus_add\";s:2:\"no\";s:13:\"syllabus_edit\";s:2:\"no\";s:15:\"syllabus_delete\";s:2:\"no\";s:10:\"assignment\";s:2:\"no\";s:14:\"assignment_add\";s:2:\"no\";s:15:\"assignment_edit\";s:2:\"no\";s:17:\"assignment_delete\";s:2:\"no\";s:15:\"assignment_view\";s:2:\"no\";s:11:\"routine_add\";s:2:\"no\";s:12:\"routine_edit\";s:2:\"no\";s:14:\"routine_delete\";s:2:\"no\";s:11:\"sattendance\";s:2:\"no\";s:15:\"sattendance_add\";s:2:\"no\";s:16:\"sattendance_view\";s:2:\"no\";s:11:\"tattendance\";s:2:\"no\";s:15:\"tattendance_add\";s:2:\"no\";s:16:\"tattendance_view\";s:2:\"no\";s:11:\"uattendance\";s:2:\"no\";s:15:\"uattendance_add\";s:2:\"no\";s:16:\"uattendance_view\";s:2:\"no\";s:4:\"exam\";s:2:\"no\";s:8:\"exam_add\";s:2:\"no\";s:9:\"exam_edit\";s:2:\"no\";s:11:\"exam_delete\";s:2:\"no\";s:12:\"examschedule\";s:2:\"no\";s:16:\"examschedule_add\";s:2:\"no\";s:17:\"examschedule_edit\";s:2:\"no\";s:19:\"examschedule_delete\";s:2:\"no\";s:5:\"grade\";s:2:\"no\";s:9:\"grade_add\";s:2:\"no\";s:10:\"grade_edit\";s:2:\"no\";s:12:\"grade_delete\";s:2:\"no\";s:11:\"eattendance\";s:2:\"no\";s:15:\"eattendance_add\";s:2:\"no\";s:4:\"mark\";s:2:\"no\";s:8:\"mark_add\";s:2:\"no\";s:9:\"mark_view\";s:2:\"no\";s:14:\"markpercentage\";s:2:\"no\";s:18:\"markpercentage_add\";s:2:\"no\";s:19:\"markpercentage_edit\";s:2:\"no\";s:21:\"markpercentage_delete\";s:2:\"no\";s:9:\"promotion\";s:2:\"no\";s:5:\"media\";s:2:\"no\";s:9:\"media_add\";s:2:\"no\";s:12:\"media_delete\";s:2:\"no\";s:10:\"mailandsms\";s:2:\"no\";s:14:\"mailandsms_add\";s:2:\"no\";s:15:\"mailandsms_view\";s:2:\"no\";s:14:\"question_group\";s:2:\"no\";s:18:\"question_group_add\";s:2:\"no\";s:19:\"question_group_edit\";s:2:\"no\";s:21:\"question_group_delete\";s:2:\"no\";s:14:\"question_level\";s:2:\"no\";s:18:\"question_level_add\";s:2:\"no\";s:19:\"question_level_edit\";s:2:\"no\";s:21:\"question_level_delete\";s:2:\"no\";s:13:\"question_bank\";s:2:\"no\";s:17:\"question_bank_add\";s:2:\"no\";s:18:\"question_bank_edit\";s:2:\"no\";s:20:\"question_bank_delete\";s:2:\"no\";s:18:\"question_bank_view\";s:2:\"no\";s:11:\"online_exam\";s:2:\"no\";s:15:\"online_exam_add\";s:2:\"no\";s:16:\"online_exam_edit\";s:2:\"no\";s:18:\"online_exam_delete\";s:2:\"no\";s:11:\"instruction\";s:2:\"no\";s:15:\"instruction_add\";s:2:\"no\";s:16:\"instruction_edit\";s:2:\"no\";s:18:\"instruction_delete\";s:2:\"no\";s:16:\"instruction_view\";s:2:\"no\";s:15:\"salary_template\";s:2:\"no\";s:19:\"salary_template_add\";s:2:\"no\";s:20:\"salary_template_edit\";s:2:\"no\";s:22:\"salary_template_delete\";s:2:\"no\";s:20:\"salary_template_view\";s:2:\"no\";s:15:\"hourly_template\";s:2:\"no\";s:19:\"hourly_template_add\";s:2:\"no\";s:20:\"hourly_template_edit\";s:2:\"no\";s:22:\"hourly_template_delete\";s:2:\"no\";s:13:\"manage_salary\";s:2:\"no\";s:17:\"manage_salary_add\";s:2:\"no\";s:18:\"manage_salary_edit\";s:2:\"no\";s:20:\"manage_salary_delete\";s:2:\"no\";s:18:\"manage_salary_view\";s:2:\"no\";s:12:\"make_payment\";s:2:\"no\";s:8:\"overtime\";s:2:\"no\";s:12:\"overtime_add\";s:2:\"no\";s:13:\"overtime_edit\";s:2:\"no\";s:15:\"overtime_delete\";s:2:\"no\";s:6:\"vendor\";s:2:\"no\";s:10:\"vendor_add\";s:2:\"no\";s:11:\"vendor_edit\";s:2:\"no\";s:13:\"vendor_delete\";s:2:\"no\";s:8:\"location\";s:2:\"no\";s:12:\"location_add\";s:2:\"no\";s:13:\"location_edit\";s:2:\"no\";s:15:\"location_delete\";s:2:\"no\";s:14:\"asset_category\";s:2:\"no\";s:18:\"asset_category_add\";s:2:\"no\";s:19:\"asset_category_edit\";s:2:\"no\";s:21:\"asset_category_delete\";s:2:\"no\";s:5:\"asset\";s:2:\"no\";s:9:\"asset_add\";s:2:\"no\";s:10:\"asset_edit\";s:2:\"no\";s:12:\"asset_delete\";s:2:\"no\";s:10:\"asset_view\";s:2:\"no\";s:16:\"asset_assignment\";s:2:\"no\";s:20:\"asset_assignment_add\";s:2:\"no\";s:21:\"asset_assignment_edit\";s:2:\"no\";s:23:\"asset_assignment_delete\";s:2:\"no\";s:21:\"asset_assignment_view\";s:2:\"no\";s:8:\"purchase\";s:2:\"no\";s:12:\"purchase_add\";s:2:\"no\";s:13:\"purchase_edit\";s:2:\"no\";s:15:\"purchase_delete\";s:2:\"no\";s:15:\"productcategory\";s:2:\"no\";s:19:\"productcategory_add\";s:2:\"no\";s:20:\"productcategory_edit\";s:2:\"no\";s:22:\"productcategory_delete\";s:2:\"no\";s:7:\"product\";s:2:\"no\";s:11:\"product_add\";s:2:\"no\";s:12:\"product_edit\";s:2:\"no\";s:14:\"product_delete\";s:2:\"no\";s:16:\"productwarehouse\";s:2:\"no\";s:20:\"productwarehouse_add\";s:2:\"no\";s:21:\"productwarehouse_edit\";s:2:\"no\";s:23:\"productwarehouse_delete\";s:2:\"no\";s:15:\"productsupplier\";s:2:\"no\";s:19:\"productsupplier_add\";s:2:\"no\";s:20:\"productsupplier_edit\";s:2:\"no\";s:22:\"productsupplier_delete\";s:2:\"no\";s:15:\"productpurchase\";s:2:\"no\";s:19:\"productpurchase_add\";s:2:\"no\";s:20:\"productpurchase_edit\";s:2:\"no\";s:22:\"productpurchase_delete\";s:2:\"no\";s:20:\"productpurchase_view\";s:2:\"no\";s:11:\"productsale\";s:2:\"no\";s:15:\"productsale_add\";s:2:\"no\";s:16:\"productsale_edit\";s:2:\"no\";s:18:\"productsale_delete\";s:2:\"no\";s:16:\"productsale_view\";s:2:\"no\";s:13:\"leavecategory\";s:2:\"no\";s:17:\"leavecategory_add\";s:2:\"no\";s:18:\"leavecategory_edit\";s:2:\"no\";s:20:\"leavecategory_delete\";s:2:\"no\";s:11:\"leaveassign\";s:2:\"no\";s:15:\"leaveassign_add\";s:2:\"no\";s:16:\"leaveassign_edit\";s:2:\"no\";s:18:\"leaveassign_delete\";s:2:\"no\";s:10:\"leaveapply\";s:2:\"no\";s:14:\"leaveapply_add\";s:2:\"no\";s:15:\"leaveapply_edit\";s:2:\"no\";s:17:\"leaveapply_delete\";s:2:\"no\";s:15:\"leaveapply_view\";s:2:\"no\";s:16:\"leaveapplication\";s:2:\"no\";s:18:\"activitiescategory\";s:2:\"no\";s:22:\"activitiescategory_add\";s:2:\"no\";s:23:\"activitiescategory_edit\";s:2:\"no\";s:25:\"activitiescategory_delete\";s:2:\"no\";s:10:\"activities\";s:2:\"no\";s:14:\"activities_add\";s:2:\"no\";s:17:\"activities_delete\";s:2:\"no\";s:9:\"childcare\";s:2:\"no\";s:13:\"childcare_add\";s:2:\"no\";s:14:\"childcare_edit\";s:2:\"no\";s:16:\"childcare_delete\";s:2:\"no\";s:7:\"lmember\";s:2:\"no\";s:11:\"lmember_add\";s:2:\"no\";s:12:\"lmember_edit\";s:2:\"no\";s:14:\"lmember_delete\";s:2:\"no\";s:12:\"lmember_view\";s:2:\"no\";s:4:\"book\";s:2:\"no\";s:8:\"book_add\";s:2:\"no\";s:9:\"book_edit\";s:2:\"no\";s:11:\"book_delete\";s:2:\"no\";s:5:\"issue\";s:2:\"no\";s:9:\"issue_add\";s:2:\"no\";s:10:\"issue_edit\";s:2:\"no\";s:10:\"issue_view\";s:2:\"no\";s:6:\"ebooks\";s:2:\"no\";s:10:\"ebooks_add\";s:2:\"no\";s:11:\"ebooks_edit\";s:2:\"no\";s:13:\"ebooks_delete\";s:2:\"no\";s:11:\"ebooks_view\";s:2:\"no\";s:9:\"transport\";s:2:\"no\";s:13:\"transport_add\";s:2:\"no\";s:14:\"transport_edit\";s:2:\"no\";s:16:\"transport_delete\";s:2:\"no\";s:7:\"tmember\";s:2:\"no\";s:11:\"tmember_add\";s:2:\"no\";s:12:\"tmember_edit\";s:2:\"no\";s:14:\"tmember_delete\";s:2:\"no\";s:12:\"tmember_view\";s:2:\"no\";s:6:\"hostel\";s:2:\"no\";s:10:\"hostel_add\";s:2:\"no\";s:11:\"hostel_edit\";s:2:\"no\";s:13:\"hostel_delete\";s:2:\"no\";s:8:\"category\";s:2:\"no\";s:12:\"category_add\";s:2:\"no\";s:13:\"category_edit\";s:2:\"no\";s:15:\"category_delete\";s:2:\"no\";s:7:\"hmember\";s:2:\"no\";s:11:\"hmember_add\";s:2:\"no\";s:12:\"hmember_edit\";s:2:\"no\";s:14:\"hmember_delete\";s:2:\"no\";s:12:\"hmember_view\";s:2:\"no\";s:8:\"feetypes\";s:2:\"no\";s:12:\"feetypes_add\";s:2:\"no\";s:13:\"feetypes_edit\";s:2:\"no\";s:15:\"feetypes_delete\";s:2:\"no\";s:11:\"invoice_add\";s:2:\"no\";s:12:\"invoice_edit\";s:2:\"no\";s:14:\"invoice_delete\";s:2:\"no\";s:12:\"invoice_view\";s:2:\"no\";s:14:\"paymenthistory\";s:2:\"no\";s:19:\"paymenthistory_edit\";s:2:\"no\";s:21:\"paymenthistory_delete\";s:2:\"no\";s:7:\"expense\";s:2:\"no\";s:11:\"expense_add\";s:2:\"no\";s:12:\"expense_edit\";s:2:\"no\";s:14:\"expense_delete\";s:2:\"no\";s:6:\"income\";s:2:\"no\";s:10:\"income_add\";s:2:\"no\";s:11:\"income_edit\";s:2:\"no\";s:13:\"income_delete\";s:2:\"no\";s:14:\"global_payment\";s:2:\"no\";s:10:\"notice_add\";s:2:\"no\";s:11:\"notice_edit\";s:2:\"no\";s:13:\"notice_delete\";s:2:\"no\";s:9:\"event_add\";s:2:\"no\";s:10:\"event_edit\";s:2:\"no\";s:12:\"event_delete\";s:2:\"no\";s:11:\"holiday_add\";s:2:\"no\";s:12:\"holiday_edit\";s:2:\"no\";s:14:\"holiday_delete\";s:2:\"no\";s:13:\"classesreport\";s:2:\"no\";s:13:\"studentreport\";s:2:\"no\";s:12:\"idcardreport\";s:2:\"no\";s:15:\"admitcardreport\";s:2:\"no\";s:13:\"routinereport\";s:2:\"no\";s:18:\"examschedulereport\";s:2:\"no\";s:16:\"attendancereport\";s:2:\"no\";s:24:\"attendanceoverviewreport\";s:2:\"no\";s:18:\"librarybooksreport\";s:2:\"no\";s:17:\"librarycardreport\";s:2:\"no\";s:22:\"librarybookissuereport\";s:2:\"no\";s:14:\"terminalreport\";s:2:\"no\";s:16:\"meritstagereport\";s:2:\"no\";s:21:\"tabulationsheetreport\";s:2:\"no\";s:15:\"marksheetreport\";s:2:\"no\";s:18:\"progresscardreport\";s:2:\"no\";s:20:\"studentsessionreport\";s:2:\"no\";s:16:\"onlineexamreport\";s:2:\"no\";s:24:\"onlineexamquestionreport\";s:2:\"no\";s:21:\"onlineadmissionreport\";s:2:\"no\";s:17:\"certificatereport\";s:2:\"no\";s:22:\"leaveapplicationreport\";s:2:\"no\";s:21:\"productpurchasereport\";s:2:\"no\";s:17:\"productsalereport\";s:2:\"no\";s:23:\"searchpaymentfeesreport\";s:2:\"no\";s:10:\"feesreport\";s:2:\"no\";s:13:\"duefeesreport\";s:2:\"no\";s:17:\"balancefeesreport\";s:2:\"no\";s:17:\"transactionreport\";s:2:\"no\";s:17:\"studentfinereport\";s:2:\"no\";s:14:\"overtimereport\";s:2:\"no\";s:12:\"salaryreport\";s:2:\"no\";s:19:\"accountledgerreport\";s:2:\"no\";s:15:\"onlineadmission\";s:2:\"no\";s:11:\"visitorinfo\";s:2:\"no\";s:18:\"visitorinfo_delete\";s:2:\"no\";s:16:\"visitorinfo_view\";s:2:\"no\";s:10:\"schoolyear\";s:2:\"no\";s:14:\"schoolyear_add\";s:2:\"no\";s:15:\"schoolyear_edit\";s:2:\"no\";s:17:\"schoolyear_delete\";s:2:\"no\";s:12:\"studentgroup\";s:2:\"no\";s:16:\"studentgroup_add\";s:2:\"no\";s:17:\"studentgroup_edit\";s:2:\"no\";s:19:\"studentgroup_delete\";s:2:\"no\";s:8:\"complain\";s:2:\"no\";s:12:\"complain_add\";s:2:\"no\";s:13:\"complain_edit\";s:2:\"no\";s:15:\"complain_delete\";s:2:\"no\";s:13:\"complain_view\";s:2:\"no\";s:20:\"certificate_template\";s:2:\"no\";s:24:\"certificate_template_add\";s:2:\"no\";s:25:\"certificate_template_edit\";s:2:\"no\";s:27:\"certificate_template_delete\";s:2:\"no\";s:25:\"certificate_template_view\";s:2:\"no\";s:11:\"systemadmin\";s:2:\"no\";s:15:\"systemadmin_add\";s:2:\"no\";s:16:\"systemadmin_edit\";s:2:\"no\";s:18:\"systemadmin_delete\";s:2:\"no\";s:16:\"systemadmin_view\";s:2:\"no\";s:13:\"resetpassword\";s:2:\"no\";s:10:\"sociallink\";s:2:\"no\";s:14:\"sociallink_add\";s:2:\"no\";s:15:\"sociallink_edit\";s:2:\"no\";s:17:\"sociallink_delete\";s:2:\"no\";s:18:\"mailandsmstemplate\";s:2:\"no\";s:22:\"mailandsmstemplate_add\";s:2:\"no\";s:23:\"mailandsmstemplate_edit\";s:2:\"no\";s:25:\"mailandsmstemplate_delete\";s:2:\"no\";s:23:\"mailandsmstemplate_view\";s:2:\"no\";s:11:\"bulkimport \";s:2:\"no\";s:6:\"backup\";s:2:\"no\";s:8:\"usertype\";s:2:\"no\";s:12:\"usertype_add\";s:2:\"no\";s:13:\"usertype_edit\";s:2:\"no\";s:15:\"usertype_delete\";s:2:\"no\";s:10:\"permission\";s:2:\"no\";s:6:\"addons\";s:2:\"no\";s:6:\"update\";s:2:\"no\";s:16:\"posts_categories\";s:2:\"no\";s:20:\"posts_categories_add\";s:2:\"no\";s:21:\"posts_categories_edit\";s:2:\"no\";s:23:\"posts_categories_delete\";s:2:\"no\";s:5:\"posts\";s:2:\"no\";s:9:\"posts_add\";s:2:\"no\";s:10:\"posts_edit\";s:2:\"no\";s:12:\"posts_delete\";s:2:\"no\";s:5:\"pages\";s:2:\"no\";s:9:\"pages_add\";s:2:\"no\";s:10:\"pages_edit\";s:2:\"no\";s:12:\"pages_delete\";s:2:\"no\";s:12:\"frontendmenu\";s:2:\"no\";s:7:\"setting\";s:2:\"no\";s:16:\"frontend_setting\";s:2:\"no\";s:15:\"paymentsettings\";s:2:\"no\";s:11:\"smssettings\";s:2:\"no\";s:12:\"emailsetting\";s:2:\"no\";s:11:\"marksetting\";s:2:\"no\";s:9:\"candidate\";s:2:\"no\";s:13:\"candidate_add\";s:2:\"no\";s:14:\"candidate_edit\";s:2:\"no\";s:16:\"candidate_delete\";s:2:\"no\";s:14:\"candidate_view\";s:2:\"no\";s:7:\"sponsor\";s:2:\"no\";s:11:\"sponsor_add\";s:2:\"no\";s:12:\"sponsor_edit\";s:2:\"no\";s:14:\"sponsor_delete\";s:2:\"no\";s:12:\"sponsor_view\";s:2:\"no\";s:11:\"sponsorship\";s:2:\"no\";s:15:\"sponsorship_add\";s:2:\"no\";s:16:\"sponsorship_edit\";s:2:\"no\";s:18:\"sponsorship_delete\";s:2:\"no\";s:17:\"sponsorshipreport\";s:2:\"no\";s:30:\"onlineexamquestionanswerreport\";s:2:\"no\";s:10:\"attendance\";s:2:\"no\";s:25:\"student_attendance_report\";s:2:\"no\";s:25:\"teacher_attendance_report\";s:2:\"no\";s:22:\"user_attendance_report\";s:2:\"no\";s:17:\"qrcode_attendance\";s:2:\"no\";s:5:\"mpesa\";s:2:\"no\";s:20:\"vendorpurchasereport\";s:2:\"no\";s:18:\"itempurchasereport\";s:2:\"no\";s:22:\"categorypurchasereport\";s:2:\"no\";s:14:\"itemsalereport\";s:2:\"no\";s:18:\"categorysalereport\";s:2:\"no\";s:6:\"wallet\";s:2:\"no\";s:5:\"lunch\";s:2:\"no\";s:12:\"lunchsetting\";s:2:\"no\";s:9:\"lunchlogs\";s:2:\"no\";s:10:\"schoolterm\";s:2:\"no\";s:14:\"schoolterm_add\";s:2:\"no\";s:15:\"schoolterm_edit\";s:2:\"no\";s:17:\"schoolterm_delete\";s:2:\"no\";s:15:\"schoolterm_view\";s:2:\"no\";s:15:\"generate_qrcode\";s:2:\"no\";s:10:\"studentids\";s:2:\"no\";s:17:\"studentids_delete\";s:2:\"no\";s:17:\"cbcterminalreport\";s:2:\"no\";s:9:\"smsreport\";s:2:\"no\";s:7:\"sendsms\";s:2:\"no\";s:15:\"studentleaveout\";s:2:\"no\";s:20:\"studentleaveout_edit\";s:2:\"no\";s:20:\"studentleaveout_view\";s:2:\"no\";s:22:\"studentleaveout_delete\";s:2:\"no\";s:13:\"backup_delete\";s:2:\"no\";s:10:\"backup_add\";s:2:\"no\";s:14:\"backup_restore\";s:2:\"no\";s:9:\"take_exam\";s:3:\"yes\";}');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d854646d18f7d1bd421d817dc9c5f49875f2ec5c', '102.22.152.135', 1712745995, '__ci_last_regenerate|i:1712745995;english|N;loginuserID|s:2:\"34\";name|s:13:\"SANDRA NASIKE\";email|s:13:\"034@email.com\";usertypeID|s:1:\"3\";usertype|s:7:\"Student\";username|s:3:\"034\";photo|s:7:\"034.JPG\";lang|s:7:\"english\";defaultschoolyearID|s:1:\"4\";varifyvaliduser|b:1;loggedin|b:1;get_permission|b:1;master_permission_set|a:427:{s:9:\"dashboard\";s:3:\"yes\";s:7:\"teacher\";s:3:\"yes\";s:7:\"subject\";s:3:\"yes\";s:7:\"routine\";s:3:\"yes\";s:12:\"conversation\";s:3:\"yes\";s:7:\"invoice\";s:3:\"yes\";s:6:\"notice\";s:3:\"yes\";s:11:\"notice_view\";s:3:\"yes\";s:5:\"event\";s:3:\"yes\";s:10:\"event_view\";s:3:\"yes\";s:7:\"holiday\";s:3:\"yes\";s:12:\"holiday_view\";s:3:\"yes\";s:7:\"student\";s:2:\"no\";s:11:\"student_add\";s:2:\"no\";s:12:\"student_edit\";s:2:\"no\";s:14:\"student_delete\";s:2:\"no\";s:12:\"student_view\";s:2:\"no\";s:7:\"parents\";s:2:\"no\";s:11:\"parents_add\";s:2:\"no\";s:12:\"parents_edit\";s:2:\"no\";s:14:\"parents_delete\";s:2:\"no\";s:12:\"parents_view\";s:2:\"no\";s:11:\"teacher_add\";s:2:\"no\";s:12:\"teacher_edit\";s:2:\"no\";s:14:\"teacher_delete\";s:2:\"no\";s:12:\"teacher_view\";s:2:\"no\";s:4:\"user\";s:2:\"no\";s:8:\"user_add\";s:2:\"no\";s:9:\"user_edit\";s:2:\"no\";s:11:\"user_delete\";s:2:\"no\";s:9:\"user_view\";s:2:\"no\";s:7:\"classes\";s:2:\"no\";s:11:\"classes_add\";s:2:\"no\";s:12:\"classes_edit\";s:2:\"no\";s:14:\"classes_delete\";s:2:\"no\";s:7:\"section\";s:2:\"no\";s:11:\"section_add\";s:2:\"no\";s:12:\"section_edit\";s:2:\"no\";s:15:\"semester_delete\";s:2:\"no\";s:14:\"section_delete\";s:2:\"no\";s:11:\"subject_add\";s:2:\"no\";s:12:\"subject_edit\";s:2:\"no\";s:14:\"subject_delete\";s:2:\"no\";s:8:\"syllabus\";s:2:\"no\";s:12:\"syllabus_add\";s:2:\"no\";s:13:\"syllabus_edit\";s:2:\"no\";s:15:\"syllabus_delete\";s:2:\"no\";s:10:\"assignment\";s:2:\"no\";s:14:\"assignment_add\";s:2:\"no\";s:15:\"assignment_edit\";s:2:\"no\";s:17:\"assignment_delete\";s:2:\"no\";s:15:\"assignment_view\";s:2:\"no\";s:11:\"routine_add\";s:2:\"no\";s:12:\"routine_edit\";s:2:\"no\";s:14:\"routine_delete\";s:2:\"no\";s:11:\"sattendance\";s:2:\"no\";s:15:\"sattendance_add\";s:2:\"no\";s:16:\"sattendance_view\";s:2:\"no\";s:11:\"tattendance\";s:2:\"no\";s:15:\"tattendance_add\";s:2:\"no\";s:16:\"tattendance_view\";s:2:\"no\";s:11:\"uattendance\";s:2:\"no\";s:15:\"uattendance_add\";s:2:\"no\";s:16:\"uattendance_view\";s:2:\"no\";s:4:\"exam\";s:2:\"no\";s:8:\"exam_add\";s:2:\"no\";s:9:\"exam_edit\";s:2:\"no\";s:11:\"exam_delete\";s:2:\"no\";s:12:\"examschedule\";s:2:\"no\";s:16:\"examschedule_add\";s:2:\"no\";s:17:\"examschedule_edit\";s:2:\"no\";s:19:\"examschedule_delete\";s:2:\"no\";s:5:\"grade\";s:2:\"no\";s:9:\"grade_add\";s:2:\"no\";s:10:\"grade_edit\";s:2:\"no\";s:12:\"grade_delete\";s:2:\"no\";s:11:\"eattendance\";s:2:\"no\";s:15:\"eattendance_add\";s:2:\"no\";s:4:\"mark\";s:2:\"no\";s:8:\"mark_add\";s:2:\"no\";s:9:\"mark_view\";s:2:\"no\";s:14:\"markpercentage\";s:2:\"no\";s:18:\"markpercentage_add\";s:2:\"no\";s:19:\"markpercentage_edit\";s:2:\"no\";s:21:\"markpercentage_delete\";s:2:\"no\";s:9:\"promotion\";s:2:\"no\";s:5:\"media\";s:2:\"no\";s:9:\"media_add\";s:2:\"no\";s:12:\"media_delete\";s:2:\"no\";s:10:\"mailandsms\";s:2:\"no\";s:14:\"mailandsms_add\";s:2:\"no\";s:15:\"mailandsms_view\";s:2:\"no\";s:14:\"question_group\";s:2:\"no\";s:18:\"question_group_add\";s:2:\"no\";s:19:\"question_group_edit\";s:2:\"no\";s:21:\"question_group_delete\";s:2:\"no\";s:14:\"question_level\";s:2:\"no\";s:18:\"question_level_add\";s:2:\"no\";s:19:\"question_level_edit\";s:2:\"no\";s:21:\"question_level_delete\";s:2:\"no\";s:13:\"question_bank\";s:2:\"no\";s:17:\"question_bank_add\";s:2:\"no\";s:18:\"question_bank_edit\";s:2:\"no\";s:20:\"question_bank_delete\";s:2:\"no\";s:18:\"question_bank_view\";s:2:\"no\";s:11:\"online_exam\";s:2:\"no\";s:15:\"online_exam_add\";s:2:\"no\";s:16:\"online_exam_edit\";s:2:\"no\";s:18:\"online_exam_delete\";s:2:\"no\";s:11:\"instruction\";s:2:\"no\";s:15:\"instruction_add\";s:2:\"no\";s:16:\"instruction_edit\";s:2:\"no\";s:18:\"instruction_delete\";s:2:\"no\";s:16:\"instruction_view\";s:2:\"no\";s:15:\"salary_template\";s:2:\"no\";s:19:\"salary_template_add\";s:2:\"no\";s:20:\"salary_template_edit\";s:2:\"no\";s:22:\"salary_template_delete\";s:2:\"no\";s:20:\"salary_template_view\";s:2:\"no\";s:15:\"hourly_template\";s:2:\"no\";s:19:\"hourly_template_add\";s:2:\"no\";s:20:\"hourly_template_edit\";s:2:\"no\";s:22:\"hourly_template_delete\";s:2:\"no\";s:13:\"manage_salary\";s:2:\"no\";s:17:\"manage_salary_add\";s:2:\"no\";s:18:\"manage_salary_edit\";s:2:\"no\";s:20:\"manage_salary_delete\";s:2:\"no\";s:18:\"manage_salary_view\";s:2:\"no\";s:12:\"make_payment\";s:2:\"no\";s:8:\"overtime\";s:2:\"no\";s:12:\"overtime_add\";s:2:\"no\";s:13:\"overtime_edit\";s:2:\"no\";s:15:\"overtime_delete\";s:2:\"no\";s:6:\"vendor\";s:2:\"no\";s:10:\"vendor_add\";s:2:\"no\";s:11:\"vendor_edit\";s:2:\"no\";s:13:\"vendor_delete\";s:2:\"no\";s:8:\"location\";s:2:\"no\";s:12:\"location_add\";s:2:\"no\";s:13:\"location_edit\";s:2:\"no\";s:15:\"location_delete\";s:2:\"no\";s:14:\"asset_category\";s:2:\"no\";s:18:\"asset_category_add\";s:2:\"no\";s:19:\"asset_category_edit\";s:2:\"no\";s:21:\"asset_category_delete\";s:2:\"no\";s:5:\"asset\";s:2:\"no\";s:9:\"asset_add\";s:2:\"no\";s:10:\"asset_edit\";s:2:\"no\";s:12:\"asset_delete\";s:2:\"no\";s:10:\"asset_view\";s:2:\"no\";s:16:\"asset_assignment\";s:2:\"no\";s:20:\"asset_assignment_add\";s:2:\"no\";s:21:\"asset_assignment_edit\";s:2:\"no\";s:23:\"asset_assignment_delete\";s:2:\"no\";s:21:\"asset_assignment_view\";s:2:\"no\";s:8:\"purchase\";s:2:\"no\";s:12:\"purchase_add\";s:2:\"no\";s:13:\"purchase_edit\";s:2:\"no\";s:15:\"purchase_delete\";s:2:\"no\";s:15:\"productcategory\";s:2:\"no\";s:19:\"productcategory_add\";s:2:\"no\";s:20:\"productcategory_edit\";s:2:\"no\";s:22:\"productcategory_delete\";s:2:\"no\";s:7:\"product\";s:2:\"no\";s:11:\"product_add\";s:2:\"no\";s:12:\"product_edit\";s:2:\"no\";s:14:\"product_delete\";s:2:\"no\";s:16:\"productwarehouse\";s:2:\"no\";s:20:\"productwarehouse_add\";s:2:\"no\";s:21:\"productwarehouse_edit\";s:2:\"no\";s:23:\"productwarehouse_delete\";s:2:\"no\";s:15:\"productsupplier\";s:2:\"no\";s:19:\"productsupplier_add\";s:2:\"no\";s:20:\"productsupplier_edit\";s:2:\"no\";s:22:\"productsupplier_delete\";s:2:\"no\";s:15:\"productpurchase\";s:2:\"no\";s:19:\"productpurchase_add\";s:2:\"no\";s:20:\"productpurchase_edit\";s:2:\"no\";s:22:\"productpurchase_delete\";s:2:\"no\";s:20:\"productpurchase_view\";s:2:\"no\";s:11:\"productsale\";s:2:\"no\";s:15:\"productsale_add\";s:2:\"no\";s:16:\"productsale_edit\";s:2:\"no\";s:18:\"productsale_delete\";s:2:\"no\";s:16:\"productsale_view\";s:2:\"no\";s:13:\"leavecategory\";s:2:\"no\";s:17:\"leavecategory_add\";s:2:\"no\";s:18:\"leavecategory_edit\";s:2:\"no\";s:20:\"leavecategory_delete\";s:2:\"no\";s:11:\"leaveassign\";s:2:\"no\";s:15:\"leaveassign_add\";s:2:\"no\";s:16:\"leaveassign_edit\";s:2:\"no\";s:18:\"leaveassign_delete\";s:2:\"no\";s:10:\"leaveapply\";s:2:\"no\";s:14:\"leaveapply_add\";s:2:\"no\";s:15:\"leaveapply_edit\";s:2:\"no\";s:17:\"leaveapply_delete\";s:2:\"no\";s:15:\"leaveapply_view\";s:2:\"no\";s:16:\"leaveapplication\";s:2:\"no\";s:18:\"activitiescategory\";s:2:\"no\";s:22:\"activitiescategory_add\";s:2:\"no\";s:23:\"activitiescategory_edit\";s:2:\"no\";s:25:\"activitiescategory_delete\";s:2:\"no\";s:10:\"activities\";s:2:\"no\";s:14:\"activities_add\";s:2:\"no\";s:17:\"activities_delete\";s:2:\"no\";s:9:\"childcare\";s:2:\"no\";s:13:\"childcare_add\";s:2:\"no\";s:14:\"childcare_edit\";s:2:\"no\";s:16:\"childcare_delete\";s:2:\"no\";s:7:\"lmember\";s:2:\"no\";s:11:\"lmember_add\";s:2:\"no\";s:12:\"lmember_edit\";s:2:\"no\";s:14:\"lmember_delete\";s:2:\"no\";s:12:\"lmember_view\";s:2:\"no\";s:4:\"book\";s:2:\"no\";s:8:\"book_add\";s:2:\"no\";s:9:\"book_edit\";s:2:\"no\";s:11:\"book_delete\";s:2:\"no\";s:5:\"issue\";s:2:\"no\";s:9:\"issue_add\";s:2:\"no\";s:10:\"issue_edit\";s:2:\"no\";s:10:\"issue_view\";s:2:\"no\";s:6:\"ebooks\";s:2:\"no\";s:10:\"ebooks_add\";s:2:\"no\";s:11:\"ebooks_edit\";s:2:\"no\";s:13:\"ebooks_delete\";s:2:\"no\";s:11:\"ebooks_view\";s:2:\"no\";s:9:\"transport\";s:2:\"no\";s:13:\"transport_add\";s:2:\"no\";s:14:\"transport_edit\";s:2:\"no\";s:16:\"transport_delete\";s:2:\"no\";s:7:\"tmember\";s:2:\"no\";s:11:\"tmember_add\";s:2:\"no\";s:12:\"tmember_edit\";s:2:\"no\";s:14:\"tmember_delete\";s:2:\"no\";s:12:\"tmember_view\";s:2:\"no\";s:6:\"hostel\";s:2:\"no\";s:10:\"hostel_add\";s:2:\"no\";s:11:\"hostel_edit\";s:2:\"no\";s:13:\"hostel_delete\";s:2:\"no\";s:8:\"category\";s:2:\"no\";s:12:\"category_add\";s:2:\"no\";s:13:\"category_edit\";s:2:\"no\";s:15:\"category_delete\";s:2:\"no\";s:7:\"hmember\";s:2:\"no\";s:11:\"hmember_add\";s:2:\"no\";s:12:\"hmember_edit\";s:2:\"no\";s:14:\"hmember_delete\";s:2:\"no\";s:12:\"hmember_view\";s:2:\"no\";s:8:\"feetypes\";s:2:\"no\";s:12:\"feetypes_add\";s:2:\"no\";s:13:\"feetypes_edit\";s:2:\"no\";s:15:\"feetypes_delete\";s:2:\"no\";s:11:\"invoice_add\";s:2:\"no\";s:12:\"invoice_edit\";s:2:\"no\";s:14:\"invoice_delete\";s:2:\"no\";s:12:\"invoice_view\";s:2:\"no\";s:14:\"paymenthistory\";s:2:\"no\";s:19:\"paymenthistory_edit\";s:2:\"no\";s:21:\"paymenthistory_delete\";s:2:\"no\";s:7:\"expense\";s:2:\"no\";s:11:\"expense_add\";s:2:\"no\";s:12:\"expense_edit\";s:2:\"no\";s:14:\"expense_delete\";s:2:\"no\";s:6:\"income\";s:2:\"no\";s:10:\"income_add\";s:2:\"no\";s:11:\"income_edit\";s:2:\"no\";s:13:\"income_delete\";s:2:\"no\";s:14:\"global_payment\";s:2:\"no\";s:10:\"notice_add\";s:2:\"no\";s:11:\"notice_edit\";s:2:\"no\";s:13:\"notice_delete\";s:2:\"no\";s:9:\"event_add\";s:2:\"no\";s:10:\"event_edit\";s:2:\"no\";s:12:\"event_delete\";s:2:\"no\";s:11:\"holiday_add\";s:2:\"no\";s:12:\"holiday_edit\";s:2:\"no\";s:14:\"holiday_delete\";s:2:\"no\";s:13:\"classesreport\";s:2:\"no\";s:13:\"studentreport\";s:2:\"no\";s:12:\"idcardreport\";s:2:\"no\";s:15:\"admitcardreport\";s:2:\"no\";s:13:\"routinereport\";s:2:\"no\";s:18:\"examschedulereport\";s:2:\"no\";s:16:\"attendancereport\";s:2:\"no\";s:24:\"attendanceoverviewreport\";s:2:\"no\";s:18:\"librarybooksreport\";s:2:\"no\";s:17:\"librarycardreport\";s:2:\"no\";s:22:\"librarybookissuereport\";s:2:\"no\";s:14:\"terminalreport\";s:2:\"no\";s:16:\"meritstagereport\";s:2:\"no\";s:21:\"tabulationsheetreport\";s:2:\"no\";s:15:\"marksheetreport\";s:2:\"no\";s:18:\"progresscardreport\";s:2:\"no\";s:20:\"studentsessionreport\";s:2:\"no\";s:16:\"onlineexamreport\";s:2:\"no\";s:24:\"onlineexamquestionreport\";s:2:\"no\";s:21:\"onlineadmissionreport\";s:2:\"no\";s:17:\"certificatereport\";s:2:\"no\";s:22:\"leaveapplicationreport\";s:2:\"no\";s:21:\"productpurchasereport\";s:2:\"no\";s:17:\"productsalereport\";s:2:\"no\";s:23:\"searchpaymentfeesreport\";s:2:\"no\";s:10:\"feesreport\";s:2:\"no\";s:13:\"duefeesreport\";s:2:\"no\";s:17:\"balancefeesreport\";s:2:\"no\";s:17:\"transactionreport\";s:2:\"no\";s:17:\"studentfinereport\";s:2:\"no\";s:14:\"overtimereport\";s:2:\"no\";s:12:\"salaryreport\";s:2:\"no\";s:19:\"accountledgerreport\";s:2:\"no\";s:15:\"onlineadmission\";s:2:\"no\";s:11:\"visitorinfo\";s:2:\"no\";s:18:\"visitorinfo_delete\";s:2:\"no\";s:16:\"visitorinfo_view\";s:2:\"no\";s:10:\"schoolyear\";s:2:\"no\";s:14:\"schoolyear_add\";s:2:\"no\";s:15:\"schoolyear_edit\";s:2:\"no\";s:17:\"schoolyear_delete\";s:2:\"no\";s:12:\"studentgroup\";s:2:\"no\";s:16:\"studentgroup_add\";s:2:\"no\";s:17:\"studentgroup_edit\";s:2:\"no\";s:19:\"studentgroup_delete\";s:2:\"no\";s:8:\"complain\";s:2:\"no\";s:12:\"complain_add\";s:2:\"no\";s:13:\"complain_edit\";s:2:\"no\";s:15:\"complain_delete\";s:2:\"no\";s:13:\"complain_view\";s:2:\"no\";s:20:\"certificate_template\";s:2:\"no\";s:24:\"certificate_template_add\";s:2:\"no\";s:25:\"certificate_template_edit\";s:2:\"no\";s:27:\"certificate_template_delete\";s:2:\"no\";s:25:\"certificate_template_view\";s:2:\"no\";s:11:\"systemadmin\";s:2:\"no\";s:15:\"systemadmin_add\";s:2:\"no\";s:16:\"systemadmin_edit\";s:2:\"no\";s:18:\"systemadmin_delete\";s:2:\"no\";s:16:\"systemadmin_view\";s:2:\"no\";s:13:\"resetpassword\";s:2:\"no\";s:10:\"sociallink\";s:2:\"no\";s:14:\"sociallink_add\";s:2:\"no\";s:15:\"sociallink_edit\";s:2:\"no\";s:17:\"sociallink_delete\";s:2:\"no\";s:18:\"mailandsmstemplate\";s:2:\"no\";s:22:\"mailandsmstemplate_add\";s:2:\"no\";s:23:\"mailandsmstemplate_edit\";s:2:\"no\";s:25:\"mailandsmstemplate_delete\";s:2:\"no\";s:23:\"mailandsmstemplate_view\";s:2:\"no\";s:11:\"bulkimport \";s:2:\"no\";s:6:\"backup\";s:2:\"no\";s:8:\"usertype\";s:2:\"no\";s:12:\"usertype_add\";s:2:\"no\";s:13:\"usertype_edit\";s:2:\"no\";s:15:\"usertype_delete\";s:2:\"no\";s:10:\"permission\";s:2:\"no\";s:6:\"addons\";s:2:\"no\";s:6:\"update\";s:2:\"no\";s:16:\"posts_categories\";s:2:\"no\";s:20:\"posts_categories_add\";s:2:\"no\";s:21:\"posts_categories_edit\";s:2:\"no\";s:23:\"posts_categories_delete\";s:2:\"no\";s:5:\"posts\";s:2:\"no\";s:9:\"posts_add\";s:2:\"no\";s:10:\"posts_edit\";s:2:\"no\";s:12:\"posts_delete\";s:2:\"no\";s:5:\"pages\";s:2:\"no\";s:9:\"pages_add\";s:2:\"no\";s:10:\"pages_edit\";s:2:\"no\";s:12:\"pages_delete\";s:2:\"no\";s:12:\"frontendmenu\";s:2:\"no\";s:7:\"setting\";s:2:\"no\";s:16:\"frontend_setting\";s:2:\"no\";s:15:\"paymentsettings\";s:2:\"no\";s:11:\"smssettings\";s:2:\"no\";s:12:\"emailsetting\";s:2:\"no\";s:11:\"marksetting\";s:2:\"no\";s:9:\"candidate\";s:2:\"no\";s:13:\"candidate_add\";s:2:\"no\";s:14:\"candidate_edit\";s:2:\"no\";s:16:\"candidate_delete\";s:2:\"no\";s:14:\"candidate_view\";s:2:\"no\";s:7:\"sponsor\";s:2:\"no\";s:11:\"sponsor_add\";s:2:\"no\";s:12:\"sponsor_edit\";s:2:\"no\";s:14:\"sponsor_delete\";s:2:\"no\";s:12:\"sponsor_view\";s:2:\"no\";s:11:\"sponsorship\";s:2:\"no\";s:15:\"sponsorship_add\";s:2:\"no\";s:16:\"sponsorship_edit\";s:2:\"no\";s:18:\"sponsorship_delete\";s:2:\"no\";s:17:\"sponsorshipreport\";s:2:\"no\";s:30:\"onlineexamquestionanswerreport\";s:2:\"no\";s:10:\"attendance\";s:2:\"no\";s:25:\"student_attendance_report\";s:2:\"no\";s:25:\"teacher_attendance_report\";s:2:\"no\";s:22:\"user_attendance_report\";s:2:\"no\";s:17:\"qrcode_attendance\";s:2:\"no\";s:5:\"mpesa\";s:2:\"no\";s:20:\"vendorpurchasereport\";s:2:\"no\";s:18:\"itempurchasereport\";s:2:\"no\";s:22:\"categorypurchasereport\";s:2:\"no\";s:14:\"itemsalereport\";s:2:\"no\";s:18:\"categorysalereport\";s:2:\"no\";s:6:\"wallet\";s:2:\"no\";s:5:\"lunch\";s:2:\"no\";s:12:\"lunchsetting\";s:2:\"no\";s:9:\"lunchlogs\";s:2:\"no\";s:10:\"schoolterm\";s:2:\"no\";s:14:\"schoolterm_add\";s:2:\"no\";s:15:\"schoolterm_edit\";s:2:\"no\";s:17:\"schoolterm_delete\";s:2:\"no\";s:15:\"schoolterm_view\";s:2:\"no\";s:15:\"generate_qrcode\";s:2:\"no\";s:10:\"studentids\";s:2:\"no\";s:17:\"studentids_delete\";s:2:\"no\";s:17:\"cbcterminalreport\";s:2:\"no\";s:9:\"smsreport\";s:2:\"no\";s:7:\"sendsms\";s:2:\"no\";s:15:\"studentleaveout\";s:2:\"no\";s:20:\"studentleaveout_edit\";s:2:\"no\";s:20:\"studentleaveout_view\";s:2:\"no\";s:22:\"studentleaveout_delete\";s:2:\"no\";s:13:\"backup_delete\";s:2:\"no\";s:10:\"backup_add\";s:2:\"no\";s:14:\"backup_restore\";s:2:\"no\";s:9:\"take_exam\";s:3:\"yes\";}');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b37e1d6a979fb51bd5f852c25390ed24b55ab841', '102.22.152.135', 1712746189, '__ci_last_regenerate|i:1712745995;english|N;loginuserID|s:2:\"34\";name|s:13:\"SANDRA NASIKE\";email|s:13:\"034@email.com\";usertypeID|s:1:\"3\";usertype|s:7:\"Student\";username|s:3:\"034\";photo|s:7:\"034.JPG\";lang|s:7:\"english\";defaultschoolyearID|s:1:\"4\";varifyvaliduser|b:1;loggedin|b:1;get_permission|b:1;master_permission_set|a:427:{s:9:\"dashboard\";s:3:\"yes\";s:7:\"teacher\";s:3:\"yes\";s:7:\"subject\";s:3:\"yes\";s:7:\"routine\";s:3:\"yes\";s:12:\"conversation\";s:3:\"yes\";s:7:\"invoice\";s:3:\"yes\";s:6:\"notice\";s:3:\"yes\";s:11:\"notice_view\";s:3:\"yes\";s:5:\"event\";s:3:\"yes\";s:10:\"event_view\";s:3:\"yes\";s:7:\"holiday\";s:3:\"yes\";s:12:\"holiday_view\";s:3:\"yes\";s:7:\"student\";s:2:\"no\";s:11:\"student_add\";s:2:\"no\";s:12:\"student_edit\";s:2:\"no\";s:14:\"student_delete\";s:2:\"no\";s:12:\"student_view\";s:2:\"no\";s:7:\"parents\";s:2:\"no\";s:11:\"parents_add\";s:2:\"no\";s:12:\"parents_edit\";s:2:\"no\";s:14:\"parents_delete\";s:2:\"no\";s:12:\"parents_view\";s:2:\"no\";s:11:\"teacher_add\";s:2:\"no\";s:12:\"teacher_edit\";s:2:\"no\";s:14:\"teacher_delete\";s:2:\"no\";s:12:\"teacher_view\";s:2:\"no\";s:4:\"user\";s:2:\"no\";s:8:\"user_add\";s:2:\"no\";s:9:\"user_edit\";s:2:\"no\";s:11:\"user_delete\";s:2:\"no\";s:9:\"user_view\";s:2:\"no\";s:7:\"classes\";s:2:\"no\";s:11:\"classes_add\";s:2:\"no\";s:12:\"classes_edit\";s:2:\"no\";s:14:\"classes_delete\";s:2:\"no\";s:7:\"section\";s:2:\"no\";s:11:\"section_add\";s:2:\"no\";s:12:\"section_edit\";s:2:\"no\";s:15:\"semester_delete\";s:2:\"no\";s:14:\"section_delete\";s:2:\"no\";s:11:\"subject_add\";s:2:\"no\";s:12:\"subject_edit\";s:2:\"no\";s:14:\"subject_delete\";s:2:\"no\";s:8:\"syllabus\";s:2:\"no\";s:12:\"syllabus_add\";s:2:\"no\";s:13:\"syllabus_edit\";s:2:\"no\";s:15:\"syllabus_delete\";s:2:\"no\";s:10:\"assignment\";s:2:\"no\";s:14:\"assignment_add\";s:2:\"no\";s:15:\"assignment_edit\";s:2:\"no\";s:17:\"assignment_delete\";s:2:\"no\";s:15:\"assignment_view\";s:2:\"no\";s:11:\"routine_add\";s:2:\"no\";s:12:\"routine_edit\";s:2:\"no\";s:14:\"routine_delete\";s:2:\"no\";s:11:\"sattendance\";s:2:\"no\";s:15:\"sattendance_add\";s:2:\"no\";s:16:\"sattendance_view\";s:2:\"no\";s:11:\"tattendance\";s:2:\"no\";s:15:\"tattendance_add\";s:2:\"no\";s:16:\"tattendance_view\";s:2:\"no\";s:11:\"uattendance\";s:2:\"no\";s:15:\"uattendance_add\";s:2:\"no\";s:16:\"uattendance_view\";s:2:\"no\";s:4:\"exam\";s:2:\"no\";s:8:\"exam_add\";s:2:\"no\";s:9:\"exam_edit\";s:2:\"no\";s:11:\"exam_delete\";s:2:\"no\";s:12:\"examschedule\";s:2:\"no\";s:16:\"examschedule_add\";s:2:\"no\";s:17:\"examschedule_edit\";s:2:\"no\";s:19:\"examschedule_delete\";s:2:\"no\";s:5:\"grade\";s:2:\"no\";s:9:\"grade_add\";s:2:\"no\";s:10:\"grade_edit\";s:2:\"no\";s:12:\"grade_delete\";s:2:\"no\";s:11:\"eattendance\";s:2:\"no\";s:15:\"eattendance_add\";s:2:\"no\";s:4:\"mark\";s:2:\"no\";s:8:\"mark_add\";s:2:\"no\";s:9:\"mark_view\";s:2:\"no\";s:14:\"markpercentage\";s:2:\"no\";s:18:\"markpercentage_add\";s:2:\"no\";s:19:\"markpercentage_edit\";s:2:\"no\";s:21:\"markpercentage_delete\";s:2:\"no\";s:9:\"promotion\";s:2:\"no\";s:5:\"media\";s:2:\"no\";s:9:\"media_add\";s:2:\"no\";s:12:\"media_delete\";s:2:\"no\";s:10:\"mailandsms\";s:2:\"no\";s:14:\"mailandsms_add\";s:2:\"no\";s:15:\"mailandsms_view\";s:2:\"no\";s:14:\"question_group\";s:2:\"no\";s:18:\"question_group_add\";s:2:\"no\";s:19:\"question_group_edit\";s:2:\"no\";s:21:\"question_group_delete\";s:2:\"no\";s:14:\"question_level\";s:2:\"no\";s:18:\"question_level_add\";s:2:\"no\";s:19:\"question_level_edit\";s:2:\"no\";s:21:\"question_level_delete\";s:2:\"no\";s:13:\"question_bank\";s:2:\"no\";s:17:\"question_bank_add\";s:2:\"no\";s:18:\"question_bank_edit\";s:2:\"no\";s:20:\"question_bank_delete\";s:2:\"no\";s:18:\"question_bank_view\";s:2:\"no\";s:11:\"online_exam\";s:2:\"no\";s:15:\"online_exam_add\";s:2:\"no\";s:16:\"online_exam_edit\";s:2:\"no\";s:18:\"online_exam_delete\";s:2:\"no\";s:11:\"instruction\";s:2:\"no\";s:15:\"instruction_add\";s:2:\"no\";s:16:\"instruction_edit\";s:2:\"no\";s:18:\"instruction_delete\";s:2:\"no\";s:16:\"instruction_view\";s:2:\"no\";s:15:\"salary_template\";s:2:\"no\";s:19:\"salary_template_add\";s:2:\"no\";s:20:\"salary_template_edit\";s:2:\"no\";s:22:\"salary_template_delete\";s:2:\"no\";s:20:\"salary_template_view\";s:2:\"no\";s:15:\"hourly_template\";s:2:\"no\";s:19:\"hourly_template_add\";s:2:\"no\";s:20:\"hourly_template_edit\";s:2:\"no\";s:22:\"hourly_template_delete\";s:2:\"no\";s:13:\"manage_salary\";s:2:\"no\";s:17:\"manage_salary_add\";s:2:\"no\";s:18:\"manage_salary_edit\";s:2:\"no\";s:20:\"manage_salary_delete\";s:2:\"no\";s:18:\"manage_salary_view\";s:2:\"no\";s:12:\"make_payment\";s:2:\"no\";s:8:\"overtime\";s:2:\"no\";s:12:\"overtime_add\";s:2:\"no\";s:13:\"overtime_edit\";s:2:\"no\";s:15:\"overtime_delete\";s:2:\"no\";s:6:\"vendor\";s:2:\"no\";s:10:\"vendor_add\";s:2:\"no\";s:11:\"vendor_edit\";s:2:\"no\";s:13:\"vendor_delete\";s:2:\"no\";s:8:\"location\";s:2:\"no\";s:12:\"location_add\";s:2:\"no\";s:13:\"location_edit\";s:2:\"no\";s:15:\"location_delete\";s:2:\"no\";s:14:\"asset_category\";s:2:\"no\";s:18:\"asset_category_add\";s:2:\"no\";s:19:\"asset_category_edit\";s:2:\"no\";s:21:\"asset_category_delete\";s:2:\"no\";s:5:\"asset\";s:2:\"no\";s:9:\"asset_add\";s:2:\"no\";s:10:\"asset_edit\";s:2:\"no\";s:12:\"asset_delete\";s:2:\"no\";s:10:\"asset_view\";s:2:\"no\";s:16:\"asset_assignment\";s:2:\"no\";s:20:\"asset_assignment_add\";s:2:\"no\";s:21:\"asset_assignment_edit\";s:2:\"no\";s:23:\"asset_assignment_delete\";s:2:\"no\";s:21:\"asset_assignment_view\";s:2:\"no\";s:8:\"purchase\";s:2:\"no\";s:12:\"purchase_add\";s:2:\"no\";s:13:\"purchase_edit\";s:2:\"no\";s:15:\"purchase_delete\";s:2:\"no\";s:15:\"productcategory\";s:2:\"no\";s:19:\"productcategory_add\";s:2:\"no\";s:20:\"productcategory_edit\";s:2:\"no\";s:22:\"productcategory_delete\";s:2:\"no\";s:7:\"product\";s:2:\"no\";s:11:\"product_add\";s:2:\"no\";s:12:\"product_edit\";s:2:\"no\";s:14:\"product_delete\";s:2:\"no\";s:16:\"productwarehouse\";s:2:\"no\";s:20:\"productwarehouse_add\";s:2:\"no\";s:21:\"productwarehouse_edit\";s:2:\"no\";s:23:\"productwarehouse_delete\";s:2:\"no\";s:15:\"productsupplier\";s:2:\"no\";s:19:\"productsupplier_add\";s:2:\"no\";s:20:\"productsupplier_edit\";s:2:\"no\";s:22:\"productsupplier_delete\";s:2:\"no\";s:15:\"productpurchase\";s:2:\"no\";s:19:\"productpurchase_add\";s:2:\"no\";s:20:\"productpurchase_edit\";s:2:\"no\";s:22:\"productpurchase_delete\";s:2:\"no\";s:20:\"productpurchase_view\";s:2:\"no\";s:11:\"productsale\";s:2:\"no\";s:15:\"productsale_add\";s:2:\"no\";s:16:\"productsale_edit\";s:2:\"no\";s:18:\"productsale_delete\";s:2:\"no\";s:16:\"productsale_view\";s:2:\"no\";s:13:\"leavecategory\";s:2:\"no\";s:17:\"leavecategory_add\";s:2:\"no\";s:18:\"leavecategory_edit\";s:2:\"no\";s:20:\"leavecategory_delete\";s:2:\"no\";s:11:\"leaveassign\";s:2:\"no\";s:15:\"leaveassign_add\";s:2:\"no\";s:16:\"leaveassign_edit\";s:2:\"no\";s:18:\"leaveassign_delete\";s:2:\"no\";s:10:\"leaveapply\";s:2:\"no\";s:14:\"leaveapply_add\";s:2:\"no\";s:15:\"leaveapply_edit\";s:2:\"no\";s:17:\"leaveapply_delete\";s:2:\"no\";s:15:\"leaveapply_view\";s:2:\"no\";s:16:\"leaveapplication\";s:2:\"no\";s:18:\"activitiescategory\";s:2:\"no\";s:22:\"activitiescategory_add\";s:2:\"no\";s:23:\"activitiescategory_edit\";s:2:\"no\";s:25:\"activitiescategory_delete\";s:2:\"no\";s:10:\"activities\";s:2:\"no\";s:14:\"activities_add\";s:2:\"no\";s:17:\"activities_delete\";s:2:\"no\";s:9:\"childcare\";s:2:\"no\";s:13:\"childcare_add\";s:2:\"no\";s:14:\"childcare_edit\";s:2:\"no\";s:16:\"childcare_delete\";s:2:\"no\";s:7:\"lmember\";s:2:\"no\";s:11:\"lmember_add\";s:2:\"no\";s:12:\"lmember_edit\";s:2:\"no\";s:14:\"lmember_delete\";s:2:\"no\";s:12:\"lmember_view\";s:2:\"no\";s:4:\"book\";s:2:\"no\";s:8:\"book_add\";s:2:\"no\";s:9:\"book_edit\";s:2:\"no\";s:11:\"book_delete\";s:2:\"no\";s:5:\"issue\";s:2:\"no\";s:9:\"issue_add\";s:2:\"no\";s:10:\"issue_edit\";s:2:\"no\";s:10:\"issue_view\";s:2:\"no\";s:6:\"ebooks\";s:2:\"no\";s:10:\"ebooks_add\";s:2:\"no\";s:11:\"ebooks_edit\";s:2:\"no\";s:13:\"ebooks_delete\";s:2:\"no\";s:11:\"ebooks_view\";s:2:\"no\";s:9:\"transport\";s:2:\"no\";s:13:\"transport_add\";s:2:\"no\";s:14:\"transport_edit\";s:2:\"no\";s:16:\"transport_delete\";s:2:\"no\";s:7:\"tmember\";s:2:\"no\";s:11:\"tmember_add\";s:2:\"no\";s:12:\"tmember_edit\";s:2:\"no\";s:14:\"tmember_delete\";s:2:\"no\";s:12:\"tmember_view\";s:2:\"no\";s:6:\"hostel\";s:2:\"no\";s:10:\"hostel_add\";s:2:\"no\";s:11:\"hostel_edit\";s:2:\"no\";s:13:\"hostel_delete\";s:2:\"no\";s:8:\"category\";s:2:\"no\";s:12:\"category_add\";s:2:\"no\";s:13:\"category_edit\";s:2:\"no\";s:15:\"category_delete\";s:2:\"no\";s:7:\"hmember\";s:2:\"no\";s:11:\"hmember_add\";s:2:\"no\";s:12:\"hmember_edit\";s:2:\"no\";s:14:\"hmember_delete\";s:2:\"no\";s:12:\"hmember_view\";s:2:\"no\";s:8:\"feetypes\";s:2:\"no\";s:12:\"feetypes_add\";s:2:\"no\";s:13:\"feetypes_edit\";s:2:\"no\";s:15:\"feetypes_delete\";s:2:\"no\";s:11:\"invoice_add\";s:2:\"no\";s:12:\"invoice_edit\";s:2:\"no\";s:14:\"invoice_delete\";s:2:\"no\";s:12:\"invoice_view\";s:2:\"no\";s:14:\"paymenthistory\";s:2:\"no\";s:19:\"paymenthistory_edit\";s:2:\"no\";s:21:\"paymenthistory_delete\";s:2:\"no\";s:7:\"expense\";s:2:\"no\";s:11:\"expense_add\";s:2:\"no\";s:12:\"expense_edit\";s:2:\"no\";s:14:\"expense_delete\";s:2:\"no\";s:6:\"income\";s:2:\"no\";s:10:\"income_add\";s:2:\"no\";s:11:\"income_edit\";s:2:\"no\";s:13:\"income_delete\";s:2:\"no\";s:14:\"global_payment\";s:2:\"no\";s:10:\"notice_add\";s:2:\"no\";s:11:\"notice_edit\";s:2:\"no\";s:13:\"notice_delete\";s:2:\"no\";s:9:\"event_add\";s:2:\"no\";s:10:\"event_edit\";s:2:\"no\";s:12:\"event_delete\";s:2:\"no\";s:11:\"holiday_add\";s:2:\"no\";s:12:\"holiday_edit\";s:2:\"no\";s:14:\"holiday_delete\";s:2:\"no\";s:13:\"classesreport\";s:2:\"no\";s:13:\"studentreport\";s:2:\"no\";s:12:\"idcardreport\";s:2:\"no\";s:15:\"admitcardreport\";s:2:\"no\";s:13:\"routinereport\";s:2:\"no\";s:18:\"examschedulereport\";s:2:\"no\";s:16:\"attendancereport\";s:2:\"no\";s:24:\"attendanceoverviewreport\";s:2:\"no\";s:18:\"librarybooksreport\";s:2:\"no\";s:17:\"librarycardreport\";s:2:\"no\";s:22:\"librarybookissuereport\";s:2:\"no\";s:14:\"terminalreport\";s:2:\"no\";s:16:\"meritstagereport\";s:2:\"no\";s:21:\"tabulationsheetreport\";s:2:\"no\";s:15:\"marksheetreport\";s:2:\"no\";s:18:\"progresscardreport\";s:2:\"no\";s:20:\"studentsessionreport\";s:2:\"no\";s:16:\"onlineexamreport\";s:2:\"no\";s:24:\"onlineexamquestionreport\";s:2:\"no\";s:21:\"onlineadmissionreport\";s:2:\"no\";s:17:\"certificatereport\";s:2:\"no\";s:22:\"leaveapplicationreport\";s:2:\"no\";s:21:\"productpurchasereport\";s:2:\"no\";s:17:\"productsalereport\";s:2:\"no\";s:23:\"searchpaymentfeesreport\";s:2:\"no\";s:10:\"feesreport\";s:2:\"no\";s:13:\"duefeesreport\";s:2:\"no\";s:17:\"balancefeesreport\";s:2:\"no\";s:17:\"transactionreport\";s:2:\"no\";s:17:\"studentfinereport\";s:2:\"no\";s:14:\"overtimereport\";s:2:\"no\";s:12:\"salaryreport\";s:2:\"no\";s:19:\"accountledgerreport\";s:2:\"no\";s:15:\"onlineadmission\";s:2:\"no\";s:11:\"visitorinfo\";s:2:\"no\";s:18:\"visitorinfo_delete\";s:2:\"no\";s:16:\"visitorinfo_view\";s:2:\"no\";s:10:\"schoolyear\";s:2:\"no\";s:14:\"schoolyear_add\";s:2:\"no\";s:15:\"schoolyear_edit\";s:2:\"no\";s:17:\"schoolyear_delete\";s:2:\"no\";s:12:\"studentgroup\";s:2:\"no\";s:16:\"studentgroup_add\";s:2:\"no\";s:17:\"studentgroup_edit\";s:2:\"no\";s:19:\"studentgroup_delete\";s:2:\"no\";s:8:\"complain\";s:2:\"no\";s:12:\"complain_add\";s:2:\"no\";s:13:\"complain_edit\";s:2:\"no\";s:15:\"complain_delete\";s:2:\"no\";s:13:\"complain_view\";s:2:\"no\";s:20:\"certificate_template\";s:2:\"no\";s:24:\"certificate_template_add\";s:2:\"no\";s:25:\"certificate_template_edit\";s:2:\"no\";s:27:\"certificate_template_delete\";s:2:\"no\";s:25:\"certificate_template_view\";s:2:\"no\";s:11:\"systemadmin\";s:2:\"no\";s:15:\"systemadmin_add\";s:2:\"no\";s:16:\"systemadmin_edit\";s:2:\"no\";s:18:\"systemadmin_delete\";s:2:\"no\";s:16:\"systemadmin_view\";s:2:\"no\";s:13:\"resetpassword\";s:2:\"no\";s:10:\"sociallink\";s:2:\"no\";s:14:\"sociallink_add\";s:2:\"no\";s:15:\"sociallink_edit\";s:2:\"no\";s:17:\"sociallink_delete\";s:2:\"no\";s:18:\"mailandsmstemplate\";s:2:\"no\";s:22:\"mailandsmstemplate_add\";s:2:\"no\";s:23:\"mailandsmstemplate_edit\";s:2:\"no\";s:25:\"mailandsmstemplate_delete\";s:2:\"no\";s:23:\"mailandsmstemplate_view\";s:2:\"no\";s:11:\"bulkimport \";s:2:\"no\";s:6:\"backup\";s:2:\"no\";s:8:\"usertype\";s:2:\"no\";s:12:\"usertype_add\";s:2:\"no\";s:13:\"usertype_edit\";s:2:\"no\";s:15:\"usertype_delete\";s:2:\"no\";s:10:\"permission\";s:2:\"no\";s:6:\"addons\";s:2:\"no\";s:6:\"update\";s:2:\"no\";s:16:\"posts_categories\";s:2:\"no\";s:20:\"posts_categories_add\";s:2:\"no\";s:21:\"posts_categories_edit\";s:2:\"no\";s:23:\"posts_categories_delete\";s:2:\"no\";s:5:\"posts\";s:2:\"no\";s:9:\"posts_add\";s:2:\"no\";s:10:\"posts_edit\";s:2:\"no\";s:12:\"posts_delete\";s:2:\"no\";s:5:\"pages\";s:2:\"no\";s:9:\"pages_add\";s:2:\"no\";s:10:\"pages_edit\";s:2:\"no\";s:12:\"pages_delete\";s:2:\"no\";s:12:\"frontendmenu\";s:2:\"no\";s:7:\"setting\";s:2:\"no\";s:16:\"frontend_setting\";s:2:\"no\";s:15:\"paymentsettings\";s:2:\"no\";s:11:\"smssettings\";s:2:\"no\";s:12:\"emailsetting\";s:2:\"no\";s:11:\"marksetting\";s:2:\"no\";s:9:\"candidate\";s:2:\"no\";s:13:\"candidate_add\";s:2:\"no\";s:14:\"candidate_edit\";s:2:\"no\";s:16:\"candidate_delete\";s:2:\"no\";s:14:\"candidate_view\";s:2:\"no\";s:7:\"sponsor\";s:2:\"no\";s:11:\"sponsor_add\";s:2:\"no\";s:12:\"sponsor_edit\";s:2:\"no\";s:14:\"sponsor_delete\";s:2:\"no\";s:12:\"sponsor_view\";s:2:\"no\";s:11:\"sponsorship\";s:2:\"no\";s:15:\"sponsorship_add\";s:2:\"no\";s:16:\"sponsorship_edit\";s:2:\"no\";s:18:\"sponsorship_delete\";s:2:\"no\";s:17:\"sponsorshipreport\";s:2:\"no\";s:30:\"onlineexamquestionanswerreport\";s:2:\"no\";s:10:\"attendance\";s:2:\"no\";s:25:\"student_attendance_report\";s:2:\"no\";s:25:\"teacher_attendance_report\";s:2:\"no\";s:22:\"user_attendance_report\";s:2:\"no\";s:17:\"qrcode_attendance\";s:2:\"no\";s:5:\"mpesa\";s:2:\"no\";s:20:\"vendorpurchasereport\";s:2:\"no\";s:18:\"itempurchasereport\";s:2:\"no\";s:22:\"categorypurchasereport\";s:2:\"no\";s:14:\"itemsalereport\";s:2:\"no\";s:18:\"categorysalereport\";s:2:\"no\";s:6:\"wallet\";s:2:\"no\";s:5:\"lunch\";s:2:\"no\";s:12:\"lunchsetting\";s:2:\"no\";s:9:\"lunchlogs\";s:2:\"no\";s:10:\"schoolterm\";s:2:\"no\";s:14:\"schoolterm_add\";s:2:\"no\";s:15:\"schoolterm_edit\";s:2:\"no\";s:17:\"schoolterm_delete\";s:2:\"no\";s:15:\"schoolterm_view\";s:2:\"no\";s:15:\"generate_qrcode\";s:2:\"no\";s:10:\"studentids\";s:2:\"no\";s:17:\"studentids_delete\";s:2:\"no\";s:17:\"cbcterminalreport\";s:2:\"no\";s:9:\"smsreport\";s:2:\"no\";s:7:\"sendsms\";s:2:\"no\";s:15:\"studentleaveout\";s:2:\"no\";s:20:\"studentleaveout_edit\";s:2:\"no\";s:20:\"studentleaveout_view\";s:2:\"no\";s:22:\"studentleaveout_delete\";s:2:\"no\";s:13:\"backup_delete\";s:2:\"no\";s:10:\"backup_add\";s:2:\"no\";s:14:\"backup_restore\";s:2:\"no\";s:9:\"take_exam\";s:3:\"yes\";}');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fd1b34c783e1398938a47fec57660645c7b81ac0', '167.94.138.52', 1713159269, '__ci_last_regenerate|i:1713159269;');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b5f5126fe0bd59b7dd21d9d4dfda8eb114ec915e', '197.254.77.166', 1713164489, '__ci_last_regenerate|i:1713164375;english|N;loginuserID|s:1:\"1\";name|s:6:\"Skooly\";email|s:18:\"matthigu@yahoo.com\";usertypeID|s:1:\"1\";usertype|s:5:\"Admin\";username|s:6:\"skooly\";photo|s:132:\"2f8ab9b11765b18645a5c1dd5670923ca4c4deb754d3b806318e66db220e2b26b42f2e1e24f8a74fdb94004de0ec948b67d2eb0b028e286c724a279574cbf665.png\";lang|s:7:\"english\";defaultschoolyearID|s:1:\"4\";varifyvaliduser|b:1;loggedin|b:1;get_permission|b:1;master_permission_set|a:427:{s:9:\"dashboard\";s:3:\"yes\";s:7:\"student\";s:3:\"yes\";s:11:\"student_add\";s:3:\"yes\";s:12:\"student_edit\";s:3:\"yes\";s:14:\"student_delete\";s:3:\"yes\";s:12:\"student_view\";s:3:\"yes\";s:7:\"parents\";s:3:\"yes\";s:11:\"parents_add\";s:3:\"yes\";s:12:\"parents_edit\";s:3:\"yes\";s:14:\"parents_delete\";s:3:\"yes\";s:12:\"parents_view\";s:3:\"yes\";s:7:\"teacher\";s:3:\"yes\";s:11:\"teacher_add\";s:3:\"yes\";s:12:\"teacher_edit\";s:3:\"yes\";s:14:\"teacher_delete\";s:3:\"yes\";s:12:\"teacher_view\";s:3:\"yes\";s:4:\"user\";s:3:\"yes\";s:8:\"user_add\";s:3:\"yes\";s:9:\"user_edit\";s:3:\"yes\";s:11:\"user_delete\";s:3:\"yes\";s:9:\"user_view\";s:3:\"yes\";s:7:\"classes\";s:3:\"yes\";s:11:\"classes_add\";s:3:\"yes\";s:12:\"classes_edit\";s:3:\"yes\";s:14:\"classes_delete\";s:3:\"yes\";s:7:\"section\";s:3:\"yes\";s:11:\"section_add\";s:3:\"yes\";s:12:\"section_edit\";s:3:\"yes\";s:15:\"semester_delete\";s:3:\"yes\";s:14:\"section_delete\";s:3:\"yes\";s:7:\"subject\";s:3:\"yes\";s:11:\"subject_add\";s:3:\"yes\";s:12:\"subject_edit\";s:3:\"yes\";s:14:\"subject_delete\";s:3:\"yes\";s:8:\"syllabus\";s:3:\"yes\";s:12:\"syllabus_add\";s:3:\"yes\";s:13:\"syllabus_edit\";s:3:\"yes\";s:15:\"syllabus_delete\";s:3:\"yes\";s:10:\"assignment\";s:3:\"yes\";s:14:\"assignment_add\";s:3:\"yes\";s:15:\"assignment_edit\";s:3:\"yes\";s:17:\"assignment_delete\";s:3:\"yes\";s:15:\"assignment_view\";s:3:\"yes\";s:7:\"routine\";s:3:\"yes\";s:11:\"routine_add\";s:3:\"yes\";s:12:\"routine_edit\";s:3:\"yes\";s:14:\"routine_delete\";s:3:\"yes\";s:11:\"sattendance\";s:3:\"yes\";s:15:\"sattendance_add\";s:3:\"yes\";s:16:\"sattendance_view\";s:3:\"yes\";s:11:\"tattendance\";s:3:\"yes\";s:15:\"tattendance_add\";s:3:\"yes\";s:16:\"tattendance_view\";s:3:\"yes\";s:11:\"uattendance\";s:3:\"yes\";s:15:\"uattendance_add\";s:3:\"yes\";s:16:\"uattendance_view\";s:3:\"yes\";s:4:\"exam\";s:3:\"yes\";s:8:\"exam_add\";s:3:\"yes\";s:9:\"exam_edit\";s:3:\"yes\";s:11:\"exam_delete\";s:3:\"yes\";s:12:\"examschedule\";s:3:\"yes\";s:16:\"examschedule_add\";s:3:\"yes\";s:17:\"examschedule_edit\";s:3:\"yes\";s:19:\"examschedule_delete\";s:3:\"yes\";s:5:\"grade\";s:3:\"yes\";s:9:\"grade_add\";s:3:\"yes\";s:10:\"grade_edit\";s:3:\"yes\";s:12:\"grade_delete\";s:3:\"yes\";s:11:\"eattendance\";s:3:\"yes\";s:15:\"eattendance_add\";s:3:\"yes\";s:4:\"mark\";s:3:\"yes\";s:8:\"mark_add\";s:3:\"yes\";s:9:\"mark_view\";s:3:\"yes\";s:14:\"markpercentage\";s:3:\"yes\";s:18:\"markpercentage_add\";s:3:\"yes\";s:19:\"markpercentage_edit\";s:3:\"yes\";s:21:\"markpercentage_delete\";s:3:\"yes\";s:9:\"promotion\";s:3:\"yes\";s:12:\"conversation\";s:3:\"yes\";s:5:\"media\";s:3:\"yes\";s:9:\"media_add\";s:3:\"yes\";s:12:\"media_delete\";s:3:\"yes\";s:10:\"mailandsms\";s:3:\"yes\";s:14:\"mailandsms_add\";s:3:\"yes\";s:15:\"mailandsms_view\";s:3:\"yes\";s:14:\"question_group\";s:3:\"yes\";s:18:\"question_group_add\";s:3:\"yes\";s:19:\"question_group_edit\";s:3:\"yes\";s:21:\"question_group_delete\";s:3:\"yes\";s:14:\"question_level\";s:3:\"yes\";s:18:\"question_level_add\";s:3:\"yes\";s:19:\"question_level_edit\";s:3:\"yes\";s:21:\"question_level_delete\";s:3:\"yes\";s:13:\"question_bank\";s:3:\"yes\";s:17:\"question_bank_add\";s:3:\"yes\";s:18:\"question_bank_edit\";s:3:\"yes\";s:20:\"question_bank_delete\";s:3:\"yes\";s:18:\"question_bank_view\";s:3:\"yes\";s:11:\"online_exam\";s:3:\"yes\";s:15:\"online_exam_add\";s:3:\"yes\";s:16:\"online_exam_edit\";s:3:\"yes\";s:18:\"online_exam_delete\";s:3:\"yes\";s:11:\"instruction\";s:3:\"yes\";s:15:\"instruction_add\";s:3:\"yes\";s:16:\"instruction_edit\";s:3:\"yes\";s:18:\"instruction_delete\";s:3:\"yes\";s:16:\"instruction_view\";s:3:\"yes\";s:15:\"salary_template\";s:3:\"yes\";s:19:\"salary_template_add\";s:3:\"yes\";s:20:\"salary_template_edit\";s:3:\"yes\";s:22:\"salary_template_delete\";s:3:\"yes\";s:20:\"salary_template_view\";s:3:\"yes\";s:15:\"hourly_template\";s:3:\"yes\";s:19:\"hourly_template_add\";s:3:\"yes\";s:20:\"hourly_template_edit\";s:3:\"yes\";s:22:\"hourly_template_delete\";s:3:\"yes\";s:13:\"manage_salary\";s:3:\"yes\";s:17:\"manage_salary_add\";s:3:\"yes\";s:18:\"manage_salary_edit\";s:3:\"yes\";s:20:\"manage_salary_delete\";s:3:\"yes\";s:18:\"manage_salary_view\";s:3:\"yes\";s:12:\"make_payment\";s:3:\"yes\";s:8:\"overtime\";s:3:\"yes\";s:12:\"overtime_add\";s:3:\"yes\";s:13:\"overtime_edit\";s:3:\"yes\";s:15:\"overtime_delete\";s:3:\"yes\";s:6:\"vendor\";s:3:\"yes\";s:10:\"vendor_add\";s:3:\"yes\";s:11:\"vendor_edit\";s:3:\"yes\";s:13:\"vendor_delete\";s:3:\"yes\";s:8:\"location\";s:3:\"yes\";s:12:\"location_add\";s:3:\"yes\";s:13:\"location_edit\";s:3:\"yes\";s:15:\"location_delete\";s:3:\"yes\";s:14:\"asset_category\";s:3:\"yes\";s:18:\"asset_category_add\";s:3:\"yes\";s:19:\"asset_category_edit\";s:3:\"yes\";s:21:\"asset_category_delete\";s:3:\"yes\";s:5:\"asset\";s:3:\"yes\";s:9:\"asset_add\";s:3:\"yes\";s:10:\"asset_edit\";s:3:\"yes\";s:12:\"asset_delete\";s:3:\"yes\";s:10:\"asset_view\";s:3:\"yes\";s:16:\"asset_assignment\";s:3:\"yes\";s:20:\"asset_assignment_add\";s:3:\"yes\";s:21:\"asset_assignment_edit\";s:3:\"yes\";s:23:\"asset_assignment_delete\";s:3:\"yes\";s:21:\"asset_assignment_view\";s:3:\"yes\";s:8:\"purchase\";s:3:\"yes\";s:12:\"purchase_add\";s:3:\"yes\";s:13:\"purchase_edit\";s:3:\"yes\";s:15:\"purchase_delete\";s:3:\"yes\";s:15:\"productcategory\";s:3:\"yes\";s:19:\"productcategory_add\";s:3:\"yes\";s:20:\"productcategory_edit\";s:3:\"yes\";s:22:\"productcategory_delete\";s:3:\"yes\";s:7:\"product\";s:3:\"yes\";s:11:\"product_add\";s:3:\"yes\";s:12:\"product_edit\";s:3:\"yes\";s:14:\"product_delete\";s:3:\"yes\";s:16:\"productwarehouse\";s:3:\"yes\";s:20:\"productwarehouse_add\";s:3:\"yes\";s:21:\"productwarehouse_edit\";s:3:\"yes\";s:23:\"productwarehouse_delete\";s:3:\"yes\";s:15:\"productsupplier\";s:3:\"yes\";s:19:\"productsupplier_add\";s:3:\"yes\";s:20:\"productsupplier_edit\";s:3:\"yes\";s:22:\"productsupplier_delete\";s:3:\"yes\";s:15:\"productpurchase\";s:3:\"yes\";s:19:\"productpurchase_add\";s:3:\"yes\";s:20:\"productpurchase_edit\";s:3:\"yes\";s:22:\"productpurchase_delete\";s:3:\"yes\";s:20:\"productpurchase_view\";s:3:\"yes\";s:11:\"productsale\";s:3:\"yes\";s:15:\"productsale_add\";s:3:\"yes\";s:16:\"productsale_edit\";s:3:\"yes\";s:18:\"productsale_delete\";s:3:\"yes\";s:16:\"productsale_view\";s:3:\"yes\";s:13:\"leavecategory\";s:3:\"yes\";s:17:\"leavecategory_add\";s:3:\"yes\";s:18:\"leavecategory_edit\";s:3:\"yes\";s:20:\"leavecategory_delete\";s:3:\"yes\";s:11:\"leaveassign\";s:3:\"yes\";s:15:\"leaveassign_add\";s:3:\"yes\";s:16:\"leaveassign_edit\";s:3:\"yes\";s:18:\"leaveassign_delete\";s:3:\"yes\";s:10:\"leaveapply\";s:3:\"yes\";s:14:\"leaveapply_add\";s:3:\"yes\";s:15:\"leaveapply_edit\";s:3:\"yes\";s:17:\"leaveapply_delete\";s:3:\"yes\";s:15:\"leaveapply_view\";s:3:\"yes\";s:16:\"leaveapplication\";s:3:\"yes\";s:18:\"activitiescategory\";s:3:\"yes\";s:22:\"activitiescategory_add\";s:3:\"yes\";s:23:\"activitiescategory_edit\";s:3:\"yes\";s:25:\"activitiescategory_delete\";s:3:\"yes\";s:10:\"activities\";s:3:\"yes\";s:14:\"activities_add\";s:3:\"yes\";s:17:\"activities_delete\";s:3:\"yes\";s:9:\"childcare\";s:3:\"yes\";s:13:\"childcare_add\";s:3:\"yes\";s:14:\"childcare_edit\";s:3:\"yes\";s:16:\"childcare_delete\";s:3:\"yes\";s:7:\"lmember\";s:3:\"yes\";s:11:\"lmember_add\";s:3:\"yes\";s:12:\"lmember_edit\";s:3:\"yes\";s:14:\"lmember_delete\";s:3:\"yes\";s:12:\"lmember_view\";s:3:\"yes\";s:4:\"book\";s:3:\"yes\";s:8:\"book_add\";s:3:\"yes\";s:9:\"book_edit\";s:3:\"yes\";s:11:\"book_delete\";s:3:\"yes\";s:5:\"issue\";s:3:\"yes\";s:9:\"issue_add\";s:3:\"yes\";s:10:\"issue_edit\";s:3:\"yes\";s:10:\"issue_view\";s:3:\"yes\";s:6:\"ebooks\";s:3:\"yes\";s:10:\"ebooks_add\";s:3:\"yes\";s:11:\"ebooks_edit\";s:3:\"yes\";s:13:\"ebooks_delete\";s:3:\"yes\";s:11:\"ebooks_view\";s:3:\"yes\";s:9:\"transport\";s:3:\"yes\";s:13:\"transport_add\";s:3:\"yes\";s:14:\"transport_edit\";s:3:\"yes\";s:16:\"transport_delete\";s:3:\"yes\";s:7:\"tmember\";s:3:\"yes\";s:11:\"tmember_add\";s:3:\"yes\";s:12:\"tmember_edit\";s:3:\"yes\";s:14:\"tmember_delete\";s:3:\"yes\";s:12:\"tmember_view\";s:3:\"yes\";s:6:\"hostel\";s:3:\"yes\";s:10:\"hostel_add\";s:3:\"yes\";s:11:\"hostel_edit\";s:3:\"yes\";s:13:\"hostel_delete\";s:3:\"yes\";s:8:\"category\";s:3:\"yes\";s:12:\"category_add\";s:3:\"yes\";s:13:\"category_edit\";s:3:\"yes\";s:15:\"category_delete\";s:3:\"yes\";s:7:\"hmember\";s:3:\"yes\";s:11:\"hmember_add\";s:3:\"yes\";s:12:\"hmember_edit\";s:3:\"yes\";s:14:\"hmember_delete\";s:3:\"yes\";s:12:\"hmember_view\";s:3:\"yes\";s:8:\"feetypes\";s:3:\"yes\";s:12:\"feetypes_add\";s:3:\"yes\";s:13:\"feetypes_edit\";s:3:\"yes\";s:15:\"feetypes_delete\";s:3:\"yes\";s:7:\"invoice\";s:3:\"yes\";s:11:\"invoice_add\";s:3:\"yes\";s:12:\"invoice_edit\";s:3:\"yes\";s:14:\"invoice_delete\";s:3:\"yes\";s:12:\"invoice_view\";s:3:\"yes\";s:14:\"paymenthistory\";s:3:\"yes\";s:19:\"paymenthistory_edit\";s:3:\"yes\";s:21:\"paymenthistory_delete\";s:3:\"yes\";s:7:\"expense\";s:3:\"yes\";s:11:\"expense_add\";s:3:\"yes\";s:12:\"expense_edit\";s:3:\"yes\";s:14:\"expense_delete\";s:3:\"yes\";s:6:\"income\";s:3:\"yes\";s:10:\"income_add\";s:3:\"yes\";s:11:\"income_edit\";s:3:\"yes\";s:13:\"income_delete\";s:3:\"yes\";s:14:\"global_payment\";s:3:\"yes\";s:6:\"notice\";s:3:\"yes\";s:10:\"notice_add\";s:3:\"yes\";s:11:\"notice_edit\";s:3:\"yes\";s:13:\"notice_delete\";s:3:\"yes\";s:11:\"notice_view\";s:3:\"yes\";s:5:\"event\";s:3:\"yes\";s:9:\"event_add\";s:3:\"yes\";s:10:\"event_edit\";s:3:\"yes\";s:12:\"event_delete\";s:3:\"yes\";s:10:\"event_view\";s:3:\"yes\";s:7:\"holiday\";s:3:\"yes\";s:11:\"holiday_add\";s:3:\"yes\";s:12:\"holiday_edit\";s:3:\"yes\";s:14:\"holiday_delete\";s:3:\"yes\";s:12:\"holiday_view\";s:3:\"yes\";s:13:\"classesreport\";s:3:\"yes\";s:13:\"studentreport\";s:3:\"yes\";s:12:\"idcardreport\";s:3:\"yes\";s:15:\"admitcardreport\";s:3:\"yes\";s:13:\"routinereport\";s:3:\"yes\";s:18:\"examschedulereport\";s:3:\"yes\";s:16:\"attendancereport\";s:3:\"yes\";s:24:\"attendanceoverviewreport\";s:3:\"yes\";s:18:\"librarybooksreport\";s:3:\"yes\";s:17:\"librarycardreport\";s:3:\"yes\";s:22:\"librarybookissuereport\";s:3:\"yes\";s:14:\"terminalreport\";s:3:\"yes\";s:16:\"meritstagereport\";s:3:\"yes\";s:21:\"tabulationsheetreport\";s:3:\"yes\";s:15:\"marksheetreport\";s:3:\"yes\";s:18:\"progresscardreport\";s:3:\"yes\";s:20:\"studentsessionreport\";s:3:\"yes\";s:16:\"onlineexamreport\";s:3:\"yes\";s:24:\"onlineexamquestionreport\";s:3:\"yes\";s:21:\"onlineadmissionreport\";s:3:\"yes\";s:17:\"certificatereport\";s:3:\"yes\";s:22:\"leaveapplicationreport\";s:3:\"yes\";s:21:\"productpurchasereport\";s:3:\"yes\";s:17:\"productsalereport\";s:3:\"yes\";s:23:\"searchpaymentfeesreport\";s:3:\"yes\";s:10:\"feesreport\";s:3:\"yes\";s:13:\"duefeesreport\";s:3:\"yes\";s:17:\"balancefeesreport\";s:3:\"yes\";s:17:\"transactionreport\";s:3:\"yes\";s:17:\"studentfinereport\";s:3:\"yes\";s:14:\"overtimereport\";s:3:\"yes\";s:12:\"salaryreport\";s:3:\"yes\";s:19:\"accountledgerreport\";s:3:\"yes\";s:15:\"onlineadmission\";s:3:\"yes\";s:11:\"visitorinfo\";s:3:\"yes\";s:18:\"visitorinfo_delete\";s:3:\"yes\";s:16:\"visitorinfo_view\";s:3:\"yes\";s:10:\"schoolyear\";s:3:\"yes\";s:14:\"schoolyear_add\";s:3:\"yes\";s:15:\"schoolyear_edit\";s:3:\"yes\";s:17:\"schoolyear_delete\";s:3:\"yes\";s:12:\"studentgroup\";s:3:\"yes\";s:16:\"studentgroup_add\";s:3:\"yes\";s:17:\"studentgroup_edit\";s:3:\"yes\";s:19:\"studentgroup_delete\";s:3:\"yes\";s:8:\"complain\";s:3:\"yes\";s:12:\"complain_add\";s:3:\"yes\";s:13:\"complain_edit\";s:3:\"yes\";s:15:\"complain_delete\";s:3:\"yes\";s:13:\"complain_view\";s:3:\"yes\";s:20:\"certificate_template\";s:3:\"yes\";s:24:\"certificate_template_add\";s:3:\"yes\";s:25:\"certificate_template_edit\";s:3:\"yes\";s:27:\"certificate_template_delete\";s:3:\"yes\";s:25:\"certificate_template_view\";s:3:\"yes\";s:11:\"systemadmin\";s:3:\"yes\";s:15:\"systemadmin_add\";s:3:\"yes\";s:16:\"systemadmin_edit\";s:3:\"yes\";s:18:\"systemadmin_delete\";s:3:\"yes\";s:16:\"systemadmin_view\";s:3:\"yes\";s:13:\"resetpassword\";s:3:\"yes\";s:10:\"sociallink\";s:3:\"yes\";s:14:\"sociallink_add\";s:3:\"yes\";s:15:\"sociallink_edit\";s:3:\"yes\";s:17:\"sociallink_delete\";s:3:\"yes\";s:18:\"mailandsmstemplate\";s:3:\"yes\";s:22:\"mailandsmstemplate_add\";s:3:\"yes\";s:23:\"mailandsmstemplate_edit\";s:3:\"yes\";s:25:\"mailandsmstemplate_delete\";s:3:\"yes\";s:23:\"mailandsmstemplate_view\";s:3:\"yes\";s:10:\"bulkimport\";s:3:\"yes\";s:6:\"backup\";s:3:\"yes\";s:8:\"usertype\";s:3:\"yes\";s:12:\"usertype_add\";s:3:\"yes\";s:13:\"usertype_edit\";s:3:\"yes\";s:15:\"usertype_delete\";s:3:\"yes\";s:10:\"permission\";s:3:\"yes\";s:6:\"addons\";s:3:\"yes\";s:6:\"update\";s:3:\"yes\";s:16:\"posts_categories\";s:3:\"yes\";s:20:\"posts_categories_add\";s:3:\"yes\";s:21:\"posts_categories_edit\";s:3:\"yes\";s:23:\"posts_categories_delete\";s:3:\"yes\";s:5:\"posts\";s:3:\"yes\";s:9:\"posts_add\";s:3:\"yes\";s:10:\"posts_edit\";s:3:\"yes\";s:12:\"posts_delete\";s:3:\"yes\";s:5:\"pages\";s:3:\"yes\";s:9:\"pages_add\";s:3:\"yes\";s:10:\"pages_edit\";s:3:\"yes\";s:12:\"pages_delete\";s:3:\"yes\";s:12:\"frontendmenu\";s:3:\"yes\";s:7:\"setting\";s:3:\"yes\";s:16:\"frontend_setting\";s:3:\"yes\";s:15:\"paymentsettings\";s:3:\"yes\";s:11:\"smssettings\";s:3:\"yes\";s:12:\"emailsetting\";s:3:\"yes\";s:11:\"marksetting\";s:3:\"yes\";s:9:\"candidate\";s:3:\"yes\";s:13:\"candidate_add\";s:3:\"yes\";s:14:\"candidate_edit\";s:3:\"yes\";s:16:\"candidate_delete\";s:3:\"yes\";s:14:\"candidate_view\";s:3:\"yes\";s:7:\"sponsor\";s:3:\"yes\";s:11:\"sponsor_add\";s:3:\"yes\";s:12:\"sponsor_edit\";s:3:\"yes\";s:14:\"sponsor_delete\";s:3:\"yes\";s:12:\"sponsor_view\";s:3:\"yes\";s:11:\"sponsorship\";s:3:\"yes\";s:15:\"sponsorship_add\";s:3:\"yes\";s:16:\"sponsorship_edit\";s:3:\"yes\";s:18:\"sponsorship_delete\";s:3:\"yes\";s:17:\"sponsorshipreport\";s:3:\"yes\";s:30:\"onlineexamquestionanswerreport\";s:3:\"yes\";s:10:\"attendance\";s:3:\"yes\";s:25:\"student_attendance_report\";s:3:\"yes\";s:25:\"teacher_attendance_report\";s:3:\"yes\";s:22:\"user_attendance_report\";s:3:\"yes\";s:17:\"qrcode_attendance\";s:3:\"yes\";s:5:\"mpesa\";s:3:\"yes\";s:20:\"vendorpurchasereport\";s:3:\"yes\";s:18:\"itempurchasereport\";s:3:\"yes\";s:22:\"categorypurchasereport\";s:3:\"yes\";s:14:\"itemsalereport\";s:3:\"yes\";s:18:\"categorysalereport\";s:3:\"yes\";s:6:\"wallet\";s:3:\"yes\";s:5:\"lunch\";s:3:\"yes\";s:12:\"lunchsetting\";s:3:\"yes\";s:9:\"lunchlogs\";s:3:\"yes\";s:10:\"schoolterm\";s:3:\"yes\";s:14:\"schoolterm_add\";s:3:\"yes\";s:15:\"schoolterm_edit\";s:3:\"yes\";s:17:\"schoolterm_delete\";s:3:\"yes\";s:15:\"schoolterm_view\";s:3:\"yes\";s:15:\"generate_qrcode\";s:3:\"yes\";s:10:\"studentids\";s:3:\"yes\";s:17:\"studentids_delete\";s:3:\"yes\";s:17:\"cbcterminalreport\";s:3:\"yes\";s:9:\"smsreport\";s:3:\"yes\";s:7:\"sendsms\";s:3:\"yes\";s:15:\"studentleaveout\";s:3:\"yes\";s:20:\"studentleaveout_edit\";s:3:\"yes\";s:20:\"studentleaveout_view\";s:3:\"yes\";s:22:\"studentleaveout_delete\";s:3:\"yes\";s:13:\"backup_delete\";s:3:\"yes\";s:10:\"backup_add\";s:3:\"yes\";s:14:\"backup_restore\";s:3:\"yes\";s:9:\"take_exam\";s:3:\"yes\";}');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('12a53092e34658f8e208dd573b8ddb142303a2a6', '199.45.155.51', 1713170539, '__ci_last_regenerate|i:1713170539;');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fc660ae4ed74999bc777bdbb4cae0c2ed0a89932', '64.227.182.174', 1713188471, '__ci_last_regenerate|i:1713188471;');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9b9c3e561a2096f142ed70b321411c5fe236c3ef', '102.213.176.14', 1713332868, '__ci_last_regenerate|i:1713332868;english|N;loginuserID|s:1:\"1\";name|s:6:\"Skooly\";email|s:18:\"matthigu@yahoo.com\";usertypeID|s:1:\"1\";usertype|s:5:\"Admin\";username|s:6:\"skooly\";photo|s:132:\"2f8ab9b11765b18645a5c1dd5670923ca4c4deb754d3b806318e66db220e2b26b42f2e1e24f8a74fdb94004de0ec948b67d2eb0b028e286c724a279574cbf665.png\";lang|s:7:\"english\";defaultschoolyearID|s:1:\"4\";varifyvaliduser|b:1;loggedin|b:1;get_permission|b:1;master_permission_set|a:427:{s:9:\"dashboard\";s:3:\"yes\";s:7:\"student\";s:3:\"yes\";s:11:\"student_add\";s:3:\"yes\";s:12:\"student_edit\";s:3:\"yes\";s:14:\"student_delete\";s:3:\"yes\";s:12:\"student_view\";s:3:\"yes\";s:7:\"parents\";s:3:\"yes\";s:11:\"parents_add\";s:3:\"yes\";s:12:\"parents_edit\";s:3:\"yes\";s:14:\"parents_delete\";s:3:\"yes\";s:12:\"parents_view\";s:3:\"yes\";s:7:\"teacher\";s:3:\"yes\";s:11:\"teacher_add\";s:3:\"yes\";s:12:\"teacher_edit\";s:3:\"yes\";s:14:\"teacher_delete\";s:3:\"yes\";s:12:\"teacher_view\";s:3:\"yes\";s:4:\"user\";s:3:\"yes\";s:8:\"user_add\";s:3:\"yes\";s:9:\"user_edit\";s:3:\"yes\";s:11:\"user_delete\";s:3:\"yes\";s:9:\"user_view\";s:3:\"yes\";s:7:\"classes\";s:3:\"yes\";s:11:\"classes_add\";s:3:\"yes\";s:12:\"classes_edit\";s:3:\"yes\";s:14:\"classes_delete\";s:3:\"yes\";s:7:\"section\";s:3:\"yes\";s:11:\"section_add\";s:3:\"yes\";s:12:\"section_edit\";s:3:\"yes\";s:15:\"semester_delete\";s:3:\"yes\";s:14:\"section_delete\";s:3:\"yes\";s:7:\"subject\";s:3:\"yes\";s:11:\"subject_add\";s:3:\"yes\";s:12:\"subject_edit\";s:3:\"yes\";s:14:\"subject_delete\";s:3:\"yes\";s:8:\"syllabus\";s:3:\"yes\";s:12:\"syllabus_add\";s:3:\"yes\";s:13:\"syllabus_edit\";s:3:\"yes\";s:15:\"syllabus_delete\";s:3:\"yes\";s:10:\"assignment\";s:3:\"yes\";s:14:\"assignment_add\";s:3:\"yes\";s:15:\"assignment_edit\";s:3:\"yes\";s:17:\"assignment_delete\";s:3:\"yes\";s:15:\"assignment_view\";s:3:\"yes\";s:7:\"routine\";s:3:\"yes\";s:11:\"routine_add\";s:3:\"yes\";s:12:\"routine_edit\";s:3:\"yes\";s:14:\"routine_delete\";s:3:\"yes\";s:11:\"sattendance\";s:3:\"yes\";s:15:\"sattendance_add\";s:3:\"yes\";s:16:\"sattendance_view\";s:3:\"yes\";s:11:\"tattendance\";s:3:\"yes\";s:15:\"tattendance_add\";s:3:\"yes\";s:16:\"tattendance_view\";s:3:\"yes\";s:11:\"uattendance\";s:3:\"yes\";s:15:\"uattendance_add\";s:3:\"yes\";s:16:\"uattendance_view\";s:3:\"yes\";s:4:\"exam\";s:3:\"yes\";s:8:\"exam_add\";s:3:\"yes\";s:9:\"exam_edit\";s:3:\"yes\";s:11:\"exam_delete\";s:3:\"yes\";s:12:\"examschedule\";s:3:\"yes\";s:16:\"examschedule_add\";s:3:\"yes\";s:17:\"examschedule_edit\";s:3:\"yes\";s:19:\"examschedule_delete\";s:3:\"yes\";s:5:\"grade\";s:3:\"yes\";s:9:\"grade_add\";s:3:\"yes\";s:10:\"grade_edit\";s:3:\"yes\";s:12:\"grade_delete\";s:3:\"yes\";s:11:\"eattendance\";s:3:\"yes\";s:15:\"eattendance_add\";s:3:\"yes\";s:4:\"mark\";s:3:\"yes\";s:8:\"mark_add\";s:3:\"yes\";s:9:\"mark_view\";s:3:\"yes\";s:14:\"markpercentage\";s:3:\"yes\";s:18:\"markpercentage_add\";s:3:\"yes\";s:19:\"markpercentage_edit\";s:3:\"yes\";s:21:\"markpercentage_delete\";s:3:\"yes\";s:9:\"promotion\";s:3:\"yes\";s:12:\"conversation\";s:3:\"yes\";s:5:\"media\";s:3:\"yes\";s:9:\"media_add\";s:3:\"yes\";s:12:\"media_delete\";s:3:\"yes\";s:10:\"mailandsms\";s:3:\"yes\";s:14:\"mailandsms_add\";s:3:\"yes\";s:15:\"mailandsms_view\";s:3:\"yes\";s:14:\"question_group\";s:3:\"yes\";s:18:\"question_group_add\";s:3:\"yes\";s:19:\"question_group_edit\";s:3:\"yes\";s:21:\"question_group_delete\";s:3:\"yes\";s:14:\"question_level\";s:3:\"yes\";s:18:\"question_level_add\";s:3:\"yes\";s:19:\"question_level_edit\";s:3:\"yes\";s:21:\"question_level_delete\";s:3:\"yes\";s:13:\"question_bank\";s:3:\"yes\";s:17:\"question_bank_add\";s:3:\"yes\";s:18:\"question_bank_edit\";s:3:\"yes\";s:20:\"question_bank_delete\";s:3:\"yes\";s:18:\"question_bank_view\";s:3:\"yes\";s:11:\"online_exam\";s:3:\"yes\";s:15:\"online_exam_add\";s:3:\"yes\";s:16:\"online_exam_edit\";s:3:\"yes\";s:18:\"online_exam_delete\";s:3:\"yes\";s:11:\"instruction\";s:3:\"yes\";s:15:\"instruction_add\";s:3:\"yes\";s:16:\"instruction_edit\";s:3:\"yes\";s:18:\"instruction_delete\";s:3:\"yes\";s:16:\"instruction_view\";s:3:\"yes\";s:15:\"salary_template\";s:3:\"yes\";s:19:\"salary_template_add\";s:3:\"yes\";s:20:\"salary_template_edit\";s:3:\"yes\";s:22:\"salary_template_delete\";s:3:\"yes\";s:20:\"salary_template_view\";s:3:\"yes\";s:15:\"hourly_template\";s:3:\"yes\";s:19:\"hourly_template_add\";s:3:\"yes\";s:20:\"hourly_template_edit\";s:3:\"yes\";s:22:\"hourly_template_delete\";s:3:\"yes\";s:13:\"manage_salary\";s:3:\"yes\";s:17:\"manage_salary_add\";s:3:\"yes\";s:18:\"manage_salary_edit\";s:3:\"yes\";s:20:\"manage_salary_delete\";s:3:\"yes\";s:18:\"manage_salary_view\";s:3:\"yes\";s:12:\"make_payment\";s:3:\"yes\";s:8:\"overtime\";s:3:\"yes\";s:12:\"overtime_add\";s:3:\"yes\";s:13:\"overtime_edit\";s:3:\"yes\";s:15:\"overtime_delete\";s:3:\"yes\";s:6:\"vendor\";s:3:\"yes\";s:10:\"vendor_add\";s:3:\"yes\";s:11:\"vendor_edit\";s:3:\"yes\";s:13:\"vendor_delete\";s:3:\"yes\";s:8:\"location\";s:3:\"yes\";s:12:\"location_add\";s:3:\"yes\";s:13:\"location_edit\";s:3:\"yes\";s:15:\"location_delete\";s:3:\"yes\";s:14:\"asset_category\";s:3:\"yes\";s:18:\"asset_category_add\";s:3:\"yes\";s:19:\"asset_category_edit\";s:3:\"yes\";s:21:\"asset_category_delete\";s:3:\"yes\";s:5:\"asset\";s:3:\"yes\";s:9:\"asset_add\";s:3:\"yes\";s:10:\"asset_edit\";s:3:\"yes\";s:12:\"asset_delete\";s:3:\"yes\";s:10:\"asset_view\";s:3:\"yes\";s:16:\"asset_assignment\";s:3:\"yes\";s:20:\"asset_assignment_add\";s:3:\"yes\";s:21:\"asset_assignment_edit\";s:3:\"yes\";s:23:\"asset_assignment_delete\";s:3:\"yes\";s:21:\"asset_assignment_view\";s:3:\"yes\";s:8:\"purchase\";s:3:\"yes\";s:12:\"purchase_add\";s:3:\"yes\";s:13:\"purchase_edit\";s:3:\"yes\";s:15:\"purchase_delete\";s:3:\"yes\";s:15:\"productcategory\";s:3:\"yes\";s:19:\"productcategory_add\";s:3:\"yes\";s:20:\"productcategory_edit\";s:3:\"yes\";s:22:\"productcategory_delete\";s:3:\"yes\";s:7:\"product\";s:3:\"yes\";s:11:\"product_add\";s:3:\"yes\";s:12:\"product_edit\";s:3:\"yes\";s:14:\"product_delete\";s:3:\"yes\";s:16:\"productwarehouse\";s:3:\"yes\";s:20:\"productwarehouse_add\";s:3:\"yes\";s:21:\"productwarehouse_edit\";s:3:\"yes\";s:23:\"productwarehouse_delete\";s:3:\"yes\";s:15:\"productsupplier\";s:3:\"yes\";s:19:\"productsupplier_add\";s:3:\"yes\";s:20:\"productsupplier_edit\";s:3:\"yes\";s:22:\"productsupplier_delete\";s:3:\"yes\";s:15:\"productpurchase\";s:3:\"yes\";s:19:\"productpurchase_add\";s:3:\"yes\";s:20:\"productpurchase_edit\";s:3:\"yes\";s:22:\"productpurchase_delete\";s:3:\"yes\";s:20:\"productpurchase_view\";s:3:\"yes\";s:11:\"productsale\";s:3:\"yes\";s:15:\"productsale_add\";s:3:\"yes\";s:16:\"productsale_edit\";s:3:\"yes\";s:18:\"productsale_delete\";s:3:\"yes\";s:16:\"productsale_view\";s:3:\"yes\";s:13:\"leavecategory\";s:3:\"yes\";s:17:\"leavecategory_add\";s:3:\"yes\";s:18:\"leavecategory_edit\";s:3:\"yes\";s:20:\"leavecategory_delete\";s:3:\"yes\";s:11:\"leaveassign\";s:3:\"yes\";s:15:\"leaveassign_add\";s:3:\"yes\";s:16:\"leaveassign_edit\";s:3:\"yes\";s:18:\"leaveassign_delete\";s:3:\"yes\";s:10:\"leaveapply\";s:3:\"yes\";s:14:\"leaveapply_add\";s:3:\"yes\";s:15:\"leaveapply_edit\";s:3:\"yes\";s:17:\"leaveapply_delete\";s:3:\"yes\";s:15:\"leaveapply_view\";s:3:\"yes\";s:16:\"leaveapplication\";s:3:\"yes\";s:18:\"activitiescategory\";s:3:\"yes\";s:22:\"activitiescategory_add\";s:3:\"yes\";s:23:\"activitiescategory_edit\";s:3:\"yes\";s:25:\"activitiescategory_delete\";s:3:\"yes\";s:10:\"activities\";s:3:\"yes\";s:14:\"activities_add\";s:3:\"yes\";s:17:\"activities_delete\";s:3:\"yes\";s:9:\"childcare\";s:3:\"yes\";s:13:\"childcare_add\";s:3:\"yes\";s:14:\"childcare_edit\";s:3:\"yes\";s:16:\"childcare_delete\";s:3:\"yes\";s:7:\"lmember\";s:3:\"yes\";s:11:\"lmember_add\";s:3:\"yes\";s:12:\"lmember_edit\";s:3:\"yes\";s:14:\"lmember_delete\";s:3:\"yes\";s:12:\"lmember_view\";s:3:\"yes\";s:4:\"book\";s:3:\"yes\";s:8:\"book_add\";s:3:\"yes\";s:9:\"book_edit\";s:3:\"yes\";s:11:\"book_delete\";s:3:\"yes\";s:5:\"issue\";s:3:\"yes\";s:9:\"issue_add\";s:3:\"yes\";s:10:\"issue_edit\";s:3:\"yes\";s:10:\"issue_view\";s:3:\"yes\";s:6:\"ebooks\";s:3:\"yes\";s:10:\"ebooks_add\";s:3:\"yes\";s:11:\"ebooks_edit\";s:3:\"yes\";s:13:\"ebooks_delete\";s:3:\"yes\";s:11:\"ebooks_view\";s:3:\"yes\";s:9:\"transport\";s:3:\"yes\";s:13:\"transport_add\";s:3:\"yes\";s:14:\"transport_edit\";s:3:\"yes\";s:16:\"transport_delete\";s:3:\"yes\";s:7:\"tmember\";s:3:\"yes\";s:11:\"tmember_add\";s:3:\"yes\";s:12:\"tmember_edit\";s:3:\"yes\";s:14:\"tmember_delete\";s:3:\"yes\";s:12:\"tmember_view\";s:3:\"yes\";s:6:\"hostel\";s:3:\"yes\";s:10:\"hostel_add\";s:3:\"yes\";s:11:\"hostel_edit\";s:3:\"yes\";s:13:\"hostel_delete\";s:3:\"yes\";s:8:\"category\";s:3:\"yes\";s:12:\"category_add\";s:3:\"yes\";s:13:\"category_edit\";s:3:\"yes\";s:15:\"category_delete\";s:3:\"yes\";s:7:\"hmember\";s:3:\"yes\";s:11:\"hmember_add\";s:3:\"yes\";s:12:\"hmember_edit\";s:3:\"yes\";s:14:\"hmember_delete\";s:3:\"yes\";s:12:\"hmember_view\";s:3:\"yes\";s:8:\"feetypes\";s:3:\"yes\";s:12:\"feetypes_add\";s:3:\"yes\";s:13:\"feetypes_edit\";s:3:\"yes\";s:15:\"feetypes_delete\";s:3:\"yes\";s:7:\"invoice\";s:3:\"yes\";s:11:\"invoice_add\";s:3:\"yes\";s:12:\"invoice_edit\";s:3:\"yes\";s:14:\"invoice_delete\";s:3:\"yes\";s:12:\"invoice_view\";s:3:\"yes\";s:14:\"paymenthistory\";s:3:\"yes\";s:19:\"paymenthistory_edit\";s:3:\"yes\";s:21:\"paymenthistory_delete\";s:3:\"yes\";s:7:\"expense\";s:3:\"yes\";s:11:\"expense_add\";s:3:\"yes\";s:12:\"expense_edit\";s:3:\"yes\";s:14:\"expense_delete\";s:3:\"yes\";s:6:\"income\";s:3:\"yes\";s:10:\"income_add\";s:3:\"yes\";s:11:\"income_edit\";s:3:\"yes\";s:13:\"income_delete\";s:3:\"yes\";s:14:\"global_payment\";s:3:\"yes\";s:6:\"notice\";s:3:\"yes\";s:10:\"notice_add\";s:3:\"yes\";s:11:\"notice_edit\";s:3:\"yes\";s:13:\"notice_delete\";s:3:\"yes\";s:11:\"notice_view\";s:3:\"yes\";s:5:\"event\";s:3:\"yes\";s:9:\"event_add\";s:3:\"yes\";s:10:\"event_edit\";s:3:\"yes\";s:12:\"event_delete\";s:3:\"yes\";s:10:\"event_view\";s:3:\"yes\";s:7:\"holiday\";s:3:\"yes\";s:11:\"holiday_add\";s:3:\"yes\";s:12:\"holiday_edit\";s:3:\"yes\";s:14:\"holiday_delete\";s:3:\"yes\";s:12:\"holiday_view\";s:3:\"yes\";s:13:\"classesreport\";s:3:\"yes\";s:13:\"studentreport\";s:3:\"yes\";s:12:\"idcardreport\";s:3:\"yes\";s:15:\"admitcardreport\";s:3:\"yes\";s:13:\"routinereport\";s:3:\"yes\";s:18:\"examschedulereport\";s:3:\"yes\";s:16:\"attendancereport\";s:3:\"yes\";s:24:\"attendanceoverviewreport\";s:3:\"yes\";s:18:\"librarybooksreport\";s:3:\"yes\";s:17:\"librarycardreport\";s:3:\"yes\";s:22:\"librarybookissuereport\";s:3:\"yes\";s:14:\"terminalreport\";s:3:\"yes\";s:16:\"meritstagereport\";s:3:\"yes\";s:21:\"tabulationsheetreport\";s:3:\"yes\";s:15:\"marksheetreport\";s:3:\"yes\";s:18:\"progresscardreport\";s:3:\"yes\";s:20:\"studentsessionreport\";s:3:\"yes\";s:16:\"onlineexamreport\";s:3:\"yes\";s:24:\"onlineexamquestionreport\";s:3:\"yes\";s:21:\"onlineadmissionreport\";s:3:\"yes\";s:17:\"certificatereport\";s:3:\"yes\";s:22:\"leaveapplicationreport\";s:3:\"yes\";s:21:\"productpurchasereport\";s:3:\"yes\";s:17:\"productsalereport\";s:3:\"yes\";s:23:\"searchpaymentfeesreport\";s:3:\"yes\";s:10:\"feesreport\";s:3:\"yes\";s:13:\"duefeesreport\";s:3:\"yes\";s:17:\"balancefeesreport\";s:3:\"yes\";s:17:\"transactionreport\";s:3:\"yes\";s:17:\"studentfinereport\";s:3:\"yes\";s:14:\"overtimereport\";s:3:\"yes\";s:12:\"salaryreport\";s:3:\"yes\";s:19:\"accountledgerreport\";s:3:\"yes\";s:15:\"onlineadmission\";s:3:\"yes\";s:11:\"visitorinfo\";s:3:\"yes\";s:18:\"visitorinfo_delete\";s:3:\"yes\";s:16:\"visitorinfo_view\";s:3:\"yes\";s:10:\"schoolyear\";s:3:\"yes\";s:14:\"schoolyear_add\";s:3:\"yes\";s:15:\"schoolyear_edit\";s:3:\"yes\";s:17:\"schoolyear_delete\";s:3:\"yes\";s:12:\"studentgroup\";s:3:\"yes\";s:16:\"studentgroup_add\";s:3:\"yes\";s:17:\"studentgroup_edit\";s:3:\"yes\";s:19:\"studentgroup_delete\";s:3:\"yes\";s:8:\"complain\";s:3:\"yes\";s:12:\"complain_add\";s:3:\"yes\";s:13:\"complain_edit\";s:3:\"yes\";s:15:\"complain_delete\";s:3:\"yes\";s:13:\"complain_view\";s:3:\"yes\";s:20:\"certificate_template\";s:3:\"yes\";s:24:\"certificate_template_add\";s:3:\"yes\";s:25:\"certificate_template_edit\";s:3:\"yes\";s:27:\"certificate_template_delete\";s:3:\"yes\";s:25:\"certificate_template_view\";s:3:\"yes\";s:11:\"systemadmin\";s:3:\"yes\";s:15:\"systemadmin_add\";s:3:\"yes\";s:16:\"systemadmin_edit\";s:3:\"yes\";s:18:\"systemadmin_delete\";s:3:\"yes\";s:16:\"systemadmin_view\";s:3:\"yes\";s:13:\"resetpassword\";s:3:\"yes\";s:10:\"sociallink\";s:3:\"yes\";s:14:\"sociallink_add\";s:3:\"yes\";s:15:\"sociallink_edit\";s:3:\"yes\";s:17:\"sociallink_delete\";s:3:\"yes\";s:18:\"mailandsmstemplate\";s:3:\"yes\";s:22:\"mailandsmstemplate_add\";s:3:\"yes\";s:23:\"mailandsmstemplate_edit\";s:3:\"yes\";s:25:\"mailandsmstemplate_delete\";s:3:\"yes\";s:23:\"mailandsmstemplate_view\";s:3:\"yes\";s:10:\"bulkimport\";s:3:\"yes\";s:6:\"backup\";s:3:\"yes\";s:8:\"usertype\";s:3:\"yes\";s:12:\"usertype_add\";s:3:\"yes\";s:13:\"usertype_edit\";s:3:\"yes\";s:15:\"usertype_delete\";s:3:\"yes\";s:10:\"permission\";s:3:\"yes\";s:6:\"addons\";s:3:\"yes\";s:6:\"update\";s:3:\"yes\";s:16:\"posts_categories\";s:3:\"yes\";s:20:\"posts_categories_add\";s:3:\"yes\";s:21:\"posts_categories_edit\";s:3:\"yes\";s:23:\"posts_categories_delete\";s:3:\"yes\";s:5:\"posts\";s:3:\"yes\";s:9:\"posts_add\";s:3:\"yes\";s:10:\"posts_edit\";s:3:\"yes\";s:12:\"posts_delete\";s:3:\"yes\";s:5:\"pages\";s:3:\"yes\";s:9:\"pages_add\";s:3:\"yes\";s:10:\"pages_edit\";s:3:\"yes\";s:12:\"pages_delete\";s:3:\"yes\";s:12:\"frontendmenu\";s:3:\"yes\";s:7:\"setting\";s:3:\"yes\";s:16:\"frontend_setting\";s:3:\"yes\";s:15:\"paymentsettings\";s:3:\"yes\";s:11:\"smssettings\";s:3:\"yes\";s:12:\"emailsetting\";s:3:\"yes\";s:11:\"marksetting\";s:3:\"yes\";s:9:\"candidate\";s:3:\"yes\";s:13:\"candidate_add\";s:3:\"yes\";s:14:\"candidate_edit\";s:3:\"yes\";s:16:\"candidate_delete\";s:3:\"yes\";s:14:\"candidate_view\";s:3:\"yes\";s:7:\"sponsor\";s:3:\"yes\";s:11:\"sponsor_add\";s:3:\"yes\";s:12:\"sponsor_edit\";s:3:\"yes\";s:14:\"sponsor_delete\";s:3:\"yes\";s:12:\"sponsor_view\";s:3:\"yes\";s:11:\"sponsorship\";s:3:\"yes\";s:15:\"sponsorship_add\";s:3:\"yes\";s:16:\"sponsorship_edit\";s:3:\"yes\";s:18:\"sponsorship_delete\";s:3:\"yes\";s:17:\"sponsorshipreport\";s:3:\"yes\";s:30:\"onlineexamquestionanswerreport\";s:3:\"yes\";s:10:\"attendance\";s:3:\"yes\";s:25:\"student_attendance_report\";s:3:\"yes\";s:25:\"teacher_attendance_report\";s:3:\"yes\";s:22:\"user_attendance_report\";s:3:\"yes\";s:17:\"qrcode_attendance\";s:3:\"yes\";s:5:\"mpesa\";s:3:\"yes\";s:20:\"vendorpurchasereport\";s:3:\"yes\";s:18:\"itempurchasereport\";s:3:\"yes\";s:22:\"categorypurchasereport\";s:3:\"yes\";s:14:\"itemsalereport\";s:3:\"yes\";s:18:\"categorysalereport\";s:3:\"yes\";s:6:\"wallet\";s:3:\"yes\";s:5:\"lunch\";s:3:\"yes\";s:12:\"lunchsetting\";s:3:\"yes\";s:9:\"lunchlogs\";s:3:\"yes\";s:10:\"schoolterm\";s:3:\"yes\";s:14:\"schoolterm_add\";s:3:\"yes\";s:15:\"schoolterm_edit\";s:3:\"yes\";s:17:\"schoolterm_delete\";s:3:\"yes\";s:15:\"schoolterm_view\";s:3:\"yes\";s:15:\"generate_qrcode\";s:3:\"yes\";s:10:\"studentids\";s:3:\"yes\";s:17:\"studentids_delete\";s:3:\"yes\";s:17:\"cbcterminalreport\";s:3:\"yes\";s:9:\"smsreport\";s:3:\"yes\";s:7:\"sendsms\";s:3:\"yes\";s:15:\"studentleaveout\";s:3:\"yes\";s:20:\"studentleaveout_edit\";s:3:\"yes\";s:20:\"studentleaveout_view\";s:3:\"yes\";s:22:\"studentleaveout_delete\";s:3:\"yes\";s:13:\"backup_delete\";s:3:\"yes\";s:10:\"backup_add\";s:3:\"yes\";s:14:\"backup_restore\";s:3:\"yes\";s:9:\"take_exam\";s:3:\"yes\";}');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9258f70838f0ecf309294efa396f8062bb9db967', '102.222.4.116', 1713333209, '__ci_last_regenerate|i:1713333209;english|N;loginuserID|s:2:\"10\";name|s:14:\"PENINAH MUTUKU\";email|s:17:\"peninah@email.com\";usertypeID|s:1:\"7\";usertype|s:12:\"Receptionist\";username|s:7:\"peninah\";photo|s:11:\"peninah.JPG\";lang|s:7:\"english\";defaultschoolyearID|s:1:\"4\";varifyvaliduser|b:1;loggedin|b:1;get_permission|b:1;master_permission_set|a:426:{s:9:\"dashboard\";s:3:\"yes\";s:7:\"student\";s:3:\"yes\";s:11:\"student_add\";s:3:\"yes\";s:12:\"student_edit\";s:3:\"yes\";s:7:\"teacher\";s:3:\"yes\";s:11:\"teacher_add\";s:3:\"yes\";s:12:\"teacher_edit\";s:3:\"yes\";s:12:\"conversation\";s:3:\"yes\";s:6:\"notice\";s:3:\"yes\";s:10:\"notice_add\";s:3:\"yes\";s:11:\"notice_edit\";s:3:\"yes\";s:5:\"event\";s:3:\"yes\";s:9:\"event_add\";s:3:\"yes\";s:10:\"event_edit\";s:3:\"yes\";s:7:\"holiday\";s:3:\"yes\";s:12:\"holiday_view\";s:3:\"yes\";s:14:\"terminalreport\";s:3:\"yes\";s:17:\"qrcode_attendance\";s:3:\"yes\";s:10:\"mailandsms\";s:3:\"yes\";s:14:\"mailandsms_add\";s:3:\"yes\";s:15:\"mailandsms_view\";s:3:\"yes\";s:25:\"student_attendance_report\";s:3:\"yes\";s:25:\"teacher_attendance_report\";s:3:\"yes\";s:22:\"user_attendance_report\";s:3:\"yes\";s:10:\"studentids\";s:3:\"yes\";s:17:\"studentids_delete\";s:3:\"yes\";s:7:\"lmember\";s:3:\"yes\";s:11:\"lmember_add\";s:3:\"yes\";s:12:\"lmember_edit\";s:3:\"yes\";s:14:\"lmember_delete\";s:3:\"yes\";s:12:\"lmember_view\";s:3:\"yes\";s:4:\"book\";s:3:\"yes\";s:8:\"book_add\";s:3:\"yes\";s:9:\"book_edit\";s:3:\"yes\";s:11:\"book_delete\";s:3:\"yes\";s:5:\"issue\";s:3:\"yes\";s:9:\"issue_add\";s:3:\"yes\";s:10:\"issue_edit\";s:3:\"yes\";s:10:\"issue_view\";s:3:\"yes\";s:14:\"student_delete\";s:2:\"no\";s:12:\"student_view\";s:2:\"no\";s:7:\"parents\";s:2:\"no\";s:11:\"parents_add\";s:2:\"no\";s:12:\"parents_edit\";s:2:\"no\";s:14:\"parents_delete\";s:2:\"no\";s:12:\"parents_view\";s:2:\"no\";s:14:\"teacher_delete\";s:2:\"no\";s:12:\"teacher_view\";s:2:\"no\";s:4:\"user\";s:2:\"no\";s:8:\"user_add\";s:2:\"no\";s:9:\"user_edit\";s:2:\"no\";s:11:\"user_delete\";s:2:\"no\";s:9:\"user_view\";s:2:\"no\";s:7:\"classes\";s:2:\"no\";s:11:\"classes_add\";s:2:\"no\";s:12:\"classes_edit\";s:2:\"no\";s:14:\"classes_delete\";s:2:\"no\";s:7:\"section\";s:2:\"no\";s:11:\"section_add\";s:2:\"no\";s:12:\"section_edit\";s:2:\"no\";s:15:\"semester_delete\";s:2:\"no\";s:14:\"section_delete\";s:2:\"no\";s:7:\"subject\";s:2:\"no\";s:11:\"subject_add\";s:2:\"no\";s:12:\"subject_edit\";s:2:\"no\";s:14:\"subject_delete\";s:2:\"no\";s:8:\"syllabus\";s:2:\"no\";s:12:\"syllabus_add\";s:2:\"no\";s:13:\"syllabus_edit\";s:2:\"no\";s:15:\"syllabus_delete\";s:2:\"no\";s:10:\"assignment\";s:2:\"no\";s:14:\"assignment_add\";s:2:\"no\";s:15:\"assignment_edit\";s:2:\"no\";s:17:\"assignment_delete\";s:2:\"no\";s:15:\"assignment_view\";s:2:\"no\";s:7:\"routine\";s:2:\"no\";s:11:\"routine_add\";s:2:\"no\";s:12:\"routine_edit\";s:2:\"no\";s:14:\"routine_delete\";s:2:\"no\";s:11:\"sattendance\";s:2:\"no\";s:15:\"sattendance_add\";s:2:\"no\";s:16:\"sattendance_view\";s:2:\"no\";s:11:\"tattendance\";s:2:\"no\";s:15:\"tattendance_add\";s:2:\"no\";s:16:\"tattendance_view\";s:2:\"no\";s:11:\"uattendance\";s:2:\"no\";s:15:\"uattendance_add\";s:2:\"no\";s:16:\"uattendance_view\";s:2:\"no\";s:4:\"exam\";s:2:\"no\";s:8:\"exam_add\";s:2:\"no\";s:9:\"exam_edit\";s:2:\"no\";s:11:\"exam_delete\";s:2:\"no\";s:12:\"examschedule\";s:2:\"no\";s:16:\"examschedule_add\";s:2:\"no\";s:17:\"examschedule_edit\";s:2:\"no\";s:19:\"examschedule_delete\";s:2:\"no\";s:5:\"grade\";s:2:\"no\";s:9:\"grade_add\";s:2:\"no\";s:10:\"grade_edit\";s:2:\"no\";s:12:\"grade_delete\";s:2:\"no\";s:11:\"eattendance\";s:2:\"no\";s:15:\"eattendance_add\";s:2:\"no\";s:4:\"mark\";s:2:\"no\";s:8:\"mark_add\";s:2:\"no\";s:9:\"mark_view\";s:2:\"no\";s:14:\"markpercentage\";s:2:\"no\";s:18:\"markpercentage_add\";s:2:\"no\";s:19:\"markpercentage_edit\";s:2:\"no\";s:21:\"markpercentage_delete\";s:2:\"no\";s:9:\"promotion\";s:2:\"no\";s:5:\"media\";s:2:\"no\";s:9:\"media_add\";s:2:\"no\";s:12:\"media_delete\";s:2:\"no\";s:14:\"question_group\";s:2:\"no\";s:18:\"question_group_add\";s:2:\"no\";s:19:\"question_group_edit\";s:2:\"no\";s:21:\"question_group_delete\";s:2:\"no\";s:14:\"question_level\";s:2:\"no\";s:18:\"question_level_add\";s:2:\"no\";s:19:\"question_level_edit\";s:2:\"no\";s:21:\"question_level_delete\";s:2:\"no\";s:13:\"question_bank\";s:2:\"no\";s:17:\"question_bank_add\";s:2:\"no\";s:18:\"question_bank_edit\";s:2:\"no\";s:20:\"question_bank_delete\";s:2:\"no\";s:18:\"question_bank_view\";s:2:\"no\";s:11:\"online_exam\";s:2:\"no\";s:15:\"online_exam_add\";s:2:\"no\";s:16:\"online_exam_edit\";s:2:\"no\";s:18:\"online_exam_delete\";s:2:\"no\";s:11:\"instruction\";s:2:\"no\";s:15:\"instruction_add\";s:2:\"no\";s:16:\"instruction_edit\";s:2:\"no\";s:18:\"instruction_delete\";s:2:\"no\";s:16:\"instruction_view\";s:2:\"no\";s:15:\"salary_template\";s:2:\"no\";s:19:\"salary_template_add\";s:2:\"no\";s:20:\"salary_template_edit\";s:2:\"no\";s:22:\"salary_template_delete\";s:2:\"no\";s:20:\"salary_template_view\";s:2:\"no\";s:15:\"hourly_template\";s:2:\"no\";s:19:\"hourly_template_add\";s:2:\"no\";s:20:\"hourly_template_edit\";s:2:\"no\";s:22:\"hourly_template_delete\";s:2:\"no\";s:13:\"manage_salary\";s:2:\"no\";s:17:\"manage_salary_add\";s:2:\"no\";s:18:\"manage_salary_edit\";s:2:\"no\";s:20:\"manage_salary_delete\";s:2:\"no\";s:18:\"manage_salary_view\";s:2:\"no\";s:12:\"make_payment\";s:2:\"no\";s:8:\"overtime\";s:2:\"no\";s:12:\"overtime_add\";s:2:\"no\";s:13:\"overtime_edit\";s:2:\"no\";s:15:\"overtime_delete\";s:2:\"no\";s:6:\"vendor\";s:2:\"no\";s:10:\"vendor_add\";s:2:\"no\";s:11:\"vendor_edit\";s:2:\"no\";s:13:\"vendor_delete\";s:2:\"no\";s:8:\"location\";s:2:\"no\";s:12:\"location_add\";s:2:\"no\";s:13:\"location_edit\";s:2:\"no\";s:15:\"location_delete\";s:2:\"no\";s:14:\"asset_category\";s:2:\"no\";s:18:\"asset_category_add\";s:2:\"no\";s:19:\"asset_category_edit\";s:2:\"no\";s:21:\"asset_category_delete\";s:2:\"no\";s:5:\"asset\";s:2:\"no\";s:9:\"asset_add\";s:2:\"no\";s:10:\"asset_edit\";s:2:\"no\";s:12:\"asset_delete\";s:2:\"no\";s:10:\"asset_view\";s:2:\"no\";s:16:\"asset_assignment\";s:2:\"no\";s:20:\"asset_assignment_add\";s:2:\"no\";s:21:\"asset_assignment_edit\";s:2:\"no\";s:23:\"asset_assignment_delete\";s:2:\"no\";s:21:\"asset_assignment_view\";s:2:\"no\";s:8:\"purchase\";s:2:\"no\";s:12:\"purchase_add\";s:2:\"no\";s:13:\"purchase_edit\";s:2:\"no\";s:15:\"purchase_delete\";s:2:\"no\";s:15:\"productcategory\";s:2:\"no\";s:19:\"productcategory_add\";s:2:\"no\";s:20:\"productcategory_edit\";s:2:\"no\";s:22:\"productcategory_delete\";s:2:\"no\";s:7:\"product\";s:2:\"no\";s:11:\"product_add\";s:2:\"no\";s:12:\"product_edit\";s:2:\"no\";s:14:\"product_delete\";s:2:\"no\";s:16:\"productwarehouse\";s:2:\"no\";s:20:\"productwarehouse_add\";s:2:\"no\";s:21:\"productwarehouse_edit\";s:2:\"no\";s:23:\"productwarehouse_delete\";s:2:\"no\";s:15:\"productsupplier\";s:2:\"no\";s:19:\"productsupplier_add\";s:2:\"no\";s:20:\"productsupplier_edit\";s:2:\"no\";s:22:\"productsupplier_delete\";s:2:\"no\";s:15:\"productpurchase\";s:2:\"no\";s:19:\"productpurchase_add\";s:2:\"no\";s:20:\"productpurchase_edit\";s:2:\"no\";s:22:\"productpurchase_delete\";s:2:\"no\";s:20:\"productpurchase_view\";s:2:\"no\";s:11:\"productsale\";s:2:\"no\";s:15:\"productsale_add\";s:2:\"no\";s:16:\"productsale_edit\";s:2:\"no\";s:18:\"productsale_delete\";s:2:\"no\";s:16:\"productsale_view\";s:2:\"no\";s:13:\"leavecategory\";s:2:\"no\";s:17:\"leavecategory_add\";s:2:\"no\";s:18:\"leavecategory_edit\";s:2:\"no\";s:20:\"leavecategory_delete\";s:2:\"no\";s:11:\"leaveassign\";s:2:\"no\";s:15:\"leaveassign_add\";s:2:\"no\";s:16:\"leaveassign_edit\";s:2:\"no\";s:18:\"leaveassign_delete\";s:2:\"no\";s:10:\"leaveapply\";s:2:\"no\";s:14:\"leaveapply_add\";s:2:\"no\";s:15:\"leaveapply_edit\";s:2:\"no\";s:17:\"leaveapply_delete\";s:2:\"no\";s:15:\"leaveapply_view\";s:2:\"no\";s:16:\"leaveapplication\";s:2:\"no\";s:18:\"activitiescategory\";s:2:\"no\";s:22:\"activitiescategory_add\";s:2:\"no\";s:23:\"activitiescategory_edit\";s:2:\"no\";s:25:\"activitiescategory_delete\";s:2:\"no\";s:10:\"activities\";s:2:\"no\";s:14:\"activities_add\";s:2:\"no\";s:17:\"activities_delete\";s:2:\"no\";s:9:\"childcare\";s:2:\"no\";s:13:\"childcare_add\";s:2:\"no\";s:14:\"childcare_edit\";s:2:\"no\";s:16:\"childcare_delete\";s:2:\"no\";s:6:\"ebooks\";s:2:\"no\";s:10:\"ebooks_add\";s:2:\"no\";s:11:\"ebooks_edit\";s:2:\"no\";s:13:\"ebooks_delete\";s:2:\"no\";s:11:\"ebooks_view\";s:2:\"no\";s:9:\"transport\";s:2:\"no\";s:13:\"transport_add\";s:2:\"no\";s:14:\"transport_edit\";s:2:\"no\";s:16:\"transport_delete\";s:2:\"no\";s:7:\"tmember\";s:2:\"no\";s:11:\"tmember_add\";s:2:\"no\";s:12:\"tmember_edit\";s:2:\"no\";s:14:\"tmember_delete\";s:2:\"no\";s:12:\"tmember_view\";s:2:\"no\";s:6:\"hostel\";s:2:\"no\";s:10:\"hostel_add\";s:2:\"no\";s:11:\"hostel_edit\";s:2:\"no\";s:13:\"hostel_delete\";s:2:\"no\";s:8:\"category\";s:2:\"no\";s:12:\"category_add\";s:2:\"no\";s:13:\"category_edit\";s:2:\"no\";s:15:\"category_delete\";s:2:\"no\";s:7:\"hmember\";s:2:\"no\";s:11:\"hmember_add\";s:2:\"no\";s:12:\"hmember_edit\";s:2:\"no\";s:14:\"hmember_delete\";s:2:\"no\";s:12:\"hmember_view\";s:2:\"no\";s:8:\"feetypes\";s:2:\"no\";s:12:\"feetypes_add\";s:2:\"no\";s:13:\"feetypes_edit\";s:2:\"no\";s:15:\"feetypes_delete\";s:2:\"no\";s:7:\"invoice\";s:2:\"no\";s:11:\"invoice_add\";s:2:\"no\";s:12:\"invoice_edit\";s:2:\"no\";s:14:\"invoice_delete\";s:2:\"no\";s:12:\"invoice_view\";s:2:\"no\";s:14:\"paymenthistory\";s:2:\"no\";s:19:\"paymenthistory_edit\";s:2:\"no\";s:21:\"paymenthistory_delete\";s:2:\"no\";s:7:\"expense\";s:2:\"no\";s:11:\"expense_add\";s:2:\"no\";s:12:\"expense_edit\";s:2:\"no\";s:14:\"expense_delete\";s:2:\"no\";s:6:\"income\";s:2:\"no\";s:10:\"income_add\";s:2:\"no\";s:11:\"income_edit\";s:2:\"no\";s:13:\"income_delete\";s:2:\"no\";s:14:\"global_payment\";s:2:\"no\";s:13:\"notice_delete\";s:2:\"no\";s:11:\"notice_view\";s:2:\"no\";s:12:\"event_delete\";s:2:\"no\";s:10:\"event_view\";s:2:\"no\";s:11:\"holiday_add\";s:2:\"no\";s:12:\"holiday_edit\";s:2:\"no\";s:14:\"holiday_delete\";s:2:\"no\";s:13:\"classesreport\";s:2:\"no\";s:13:\"studentreport\";s:2:\"no\";s:12:\"idcardreport\";s:2:\"no\";s:15:\"admitcardreport\";s:2:\"no\";s:13:\"routinereport\";s:2:\"no\";s:18:\"examschedulereport\";s:2:\"no\";s:16:\"attendancereport\";s:2:\"no\";s:24:\"attendanceoverviewreport\";s:2:\"no\";s:18:\"librarybooksreport\";s:2:\"no\";s:17:\"librarycardreport\";s:2:\"no\";s:22:\"librarybookissuereport\";s:2:\"no\";s:16:\"meritstagereport\";s:2:\"no\";s:21:\"tabulationsheetreport\";s:2:\"no\";s:15:\"marksheetreport\";s:2:\"no\";s:18:\"progresscardreport\";s:2:\"no\";s:20:\"studentsessionreport\";s:2:\"no\";s:16:\"onlineexamreport\";s:2:\"no\";s:24:\"onlineexamquestionreport\";s:2:\"no\";s:21:\"onlineadmissionreport\";s:2:\"no\";s:17:\"certificatereport\";s:2:\"no\";s:22:\"leaveapplicationreport\";s:2:\"no\";s:21:\"productpurchasereport\";s:2:\"no\";s:17:\"productsalereport\";s:2:\"no\";s:23:\"searchpaymentfeesreport\";s:2:\"no\";s:10:\"feesreport\";s:2:\"no\";s:13:\"duefeesreport\";s:2:\"no\";s:17:\"balancefeesreport\";s:2:\"no\";s:17:\"transactionreport\";s:2:\"no\";s:17:\"studentfinereport\";s:2:\"no\";s:14:\"overtimereport\";s:2:\"no\";s:12:\"salaryreport\";s:2:\"no\";s:19:\"accountledgerreport\";s:2:\"no\";s:15:\"onlineadmission\";s:2:\"no\";s:11:\"visitorinfo\";s:2:\"no\";s:18:\"visitorinfo_delete\";s:2:\"no\";s:16:\"visitorinfo_view\";s:2:\"no\";s:10:\"schoolyear\";s:2:\"no\";s:14:\"schoolyear_add\";s:2:\"no\";s:15:\"schoolyear_edit\";s:2:\"no\";s:17:\"schoolyear_delete\";s:2:\"no\";s:12:\"studentgroup\";s:2:\"no\";s:16:\"studentgroup_add\";s:2:\"no\";s:17:\"studentgroup_edit\";s:2:\"no\";s:19:\"studentgroup_delete\";s:2:\"no\";s:8:\"complain\";s:2:\"no\";s:12:\"complain_add\";s:2:\"no\";s:13:\"complain_edit\";s:2:\"no\";s:15:\"complain_delete\";s:2:\"no\";s:13:\"complain_view\";s:2:\"no\";s:20:\"certificate_template\";s:2:\"no\";s:24:\"certificate_template_add\";s:2:\"no\";s:25:\"certificate_template_edit\";s:2:\"no\";s:27:\"certificate_template_delete\";s:2:\"no\";s:25:\"certificate_template_view\";s:2:\"no\";s:11:\"systemadmin\";s:2:\"no\";s:15:\"systemadmin_add\";s:2:\"no\";s:16:\"systemadmin_edit\";s:2:\"no\";s:18:\"systemadmin_delete\";s:2:\"no\";s:16:\"systemadmin_view\";s:2:\"no\";s:13:\"resetpassword\";s:2:\"no\";s:10:\"sociallink\";s:2:\"no\";s:14:\"sociallink_add\";s:2:\"no\";s:15:\"sociallink_edit\";s:2:\"no\";s:17:\"sociallink_delete\";s:2:\"no\";s:18:\"mailandsmstemplate\";s:2:\"no\";s:22:\"mailandsmstemplate_add\";s:2:\"no\";s:23:\"mailandsmstemplate_edit\";s:2:\"no\";s:25:\"mailandsmstemplate_delete\";s:2:\"no\";s:23:\"mailandsmstemplate_view\";s:2:\"no\";s:11:\"bulkimport \";s:2:\"no\";s:6:\"backup\";s:2:\"no\";s:8:\"usertype\";s:2:\"no\";s:12:\"usertype_add\";s:2:\"no\";s:13:\"usertype_edit\";s:2:\"no\";s:15:\"usertype_delete\";s:2:\"no\";s:10:\"permission\";s:2:\"no\";s:6:\"addons\";s:2:\"no\";s:6:\"update\";s:2:\"no\";s:16:\"posts_categories\";s:2:\"no\";s:20:\"posts_categories_add\";s:2:\"no\";s:21:\"posts_categories_edit\";s:2:\"no\";s:23:\"posts_categories_delete\";s:2:\"no\";s:5:\"posts\";s:2:\"no\";s:9:\"posts_add\";s:2:\"no\";s:10:\"posts_edit\";s:2:\"no\";s:12:\"posts_delete\";s:2:\"no\";s:5:\"pages\";s:2:\"no\";s:9:\"pages_add\";s:2:\"no\";s:10:\"pages_edit\";s:2:\"no\";s:12:\"pages_delete\";s:2:\"no\";s:12:\"frontendmenu\";s:2:\"no\";s:7:\"setting\";s:2:\"no\";s:16:\"frontend_setting\";s:2:\"no\";s:15:\"paymentsettings\";s:2:\"no\";s:11:\"smssettings\";s:2:\"no\";s:12:\"emailsetting\";s:2:\"no\";s:11:\"marksetting\";s:2:\"no\";s:9:\"candidate\";s:2:\"no\";s:13:\"candidate_add\";s:2:\"no\";s:14:\"candidate_edit\";s:2:\"no\";s:16:\"candidate_delete\";s:2:\"no\";s:14:\"candidate_view\";s:2:\"no\";s:7:\"sponsor\";s:2:\"no\";s:11:\"sponsor_add\";s:2:\"no\";s:12:\"sponsor_edit\";s:2:\"no\";s:14:\"sponsor_delete\";s:2:\"no\";s:12:\"sponsor_view\";s:2:\"no\";s:11:\"sponsorship\";s:2:\"no\";s:15:\"sponsorship_add\";s:2:\"no\";s:16:\"sponsorship_edit\";s:2:\"no\";s:18:\"sponsorship_delete\";s:2:\"no\";s:17:\"sponsorshipreport\";s:2:\"no\";s:30:\"onlineexamquestionanswerreport\";s:2:\"no\";s:10:\"attendance\";s:2:\"no\";s:5:\"mpesa\";s:2:\"no\";s:20:\"vendorpurchasereport\";s:2:\"no\";s:18:\"itempurchasereport\";s:2:\"no\";s:22:\"categorypurchasereport\";s:2:\"no\";s:14:\"itemsalereport\";s:2:\"no\";s:18:\"categorysalereport\";s:2:\"no\";s:6:\"wallet\";s:2:\"no\";s:5:\"lunch\";s:2:\"no\";s:12:\"lunchsetting\";s:2:\"no\";s:9:\"lunchlogs\";s:2:\"no\";s:10:\"schoolterm\";s:2:\"no\";s:14:\"schoolterm_add\";s:2:\"no\";s:15:\"schoolterm_edit\";s:2:\"no\";s:17:\"schoolterm_delete\";s:2:\"no\";s:15:\"schoolterm_view\";s:2:\"no\";s:15:\"generate_qrcode\";s:2:\"no\";s:17:\"cbcterminalreport\";s:2:\"no\";s:9:\"smsreport\";s:2:\"no\";s:7:\"sendsms\";s:2:\"no\";s:15:\"studentleaveout\";s:2:\"no\";s:20:\"studentleaveout_edit\";s:2:\"no\";s:20:\"studentleaveout_view\";s:2:\"no\";s:22:\"studentleaveout_delete\";s:2:\"no\";s:13:\"backup_delete\";s:2:\"no\";s:10:\"backup_add\";s:2:\"no\";s:14:\"backup_restore\";s:2:\"no\";}');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d25852d04c4a51dd0072c496ac3cd59bfb984bb9', '102.213.176.14', 1713333231, '__ci_last_regenerate|i:1713333231;english|N;loginuserID|s:1:\"1\";name|s:6:\"Skooly\";email|s:18:\"matthigu@yahoo.com\";usertypeID|s:1:\"1\";usertype|s:5:\"Admin\";username|s:6:\"skooly\";photo|s:132:\"2f8ab9b11765b18645a5c1dd5670923ca4c4deb754d3b806318e66db220e2b26b42f2e1e24f8a74fdb94004de0ec948b67d2eb0b028e286c724a279574cbf665.png\";lang|s:7:\"english\";defaultschoolyearID|s:1:\"4\";varifyvaliduser|b:1;loggedin|b:1;get_permission|b:1;master_permission_set|a:427:{s:9:\"dashboard\";s:3:\"yes\";s:7:\"student\";s:3:\"yes\";s:11:\"student_add\";s:3:\"yes\";s:12:\"student_edit\";s:3:\"yes\";s:14:\"student_delete\";s:3:\"yes\";s:12:\"student_view\";s:3:\"yes\";s:7:\"parents\";s:3:\"yes\";s:11:\"parents_add\";s:3:\"yes\";s:12:\"parents_edit\";s:3:\"yes\";s:14:\"parents_delete\";s:3:\"yes\";s:12:\"parents_view\";s:3:\"yes\";s:7:\"teacher\";s:3:\"yes\";s:11:\"teacher_add\";s:3:\"yes\";s:12:\"teacher_edit\";s:3:\"yes\";s:14:\"teacher_delete\";s:3:\"yes\";s:12:\"teacher_view\";s:3:\"yes\";s:4:\"user\";s:3:\"yes\";s:8:\"user_add\";s:3:\"yes\";s:9:\"user_edit\";s:3:\"yes\";s:11:\"user_delete\";s:3:\"yes\";s:9:\"user_view\";s:3:\"yes\";s:7:\"classes\";s:3:\"yes\";s:11:\"classes_add\";s:3:\"yes\";s:12:\"classes_edit\";s:3:\"yes\";s:14:\"classes_delete\";s:3:\"yes\";s:7:\"section\";s:3:\"yes\";s:11:\"section_add\";s:3:\"yes\";s:12:\"section_edit\";s:3:\"yes\";s:15:\"semester_delete\";s:3:\"yes\";s:14:\"section_delete\";s:3:\"yes\";s:7:\"subject\";s:3:\"yes\";s:11:\"subject_add\";s:3:\"yes\";s:12:\"subject_edit\";s:3:\"yes\";s:14:\"subject_delete\";s:3:\"yes\";s:8:\"syllabus\";s:3:\"yes\";s:12:\"syllabus_add\";s:3:\"yes\";s:13:\"syllabus_edit\";s:3:\"yes\";s:15:\"syllabus_delete\";s:3:\"yes\";s:10:\"assignment\";s:3:\"yes\";s:14:\"assignment_add\";s:3:\"yes\";s:15:\"assignment_edit\";s:3:\"yes\";s:17:\"assignment_delete\";s:3:\"yes\";s:15:\"assignment_view\";s:3:\"yes\";s:7:\"routine\";s:3:\"yes\";s:11:\"routine_add\";s:3:\"yes\";s:12:\"routine_edit\";s:3:\"yes\";s:14:\"routine_delete\";s:3:\"yes\";s:11:\"sattendance\";s:3:\"yes\";s:15:\"sattendance_add\";s:3:\"yes\";s:16:\"sattendance_view\";s:3:\"yes\";s:11:\"tattendance\";s:3:\"yes\";s:15:\"tattendance_add\";s:3:\"yes\";s:16:\"tattendance_view\";s:3:\"yes\";s:11:\"uattendance\";s:3:\"yes\";s:15:\"uattendance_add\";s:3:\"yes\";s:16:\"uattendance_view\";s:3:\"yes\";s:4:\"exam\";s:3:\"yes\";s:8:\"exam_add\";s:3:\"yes\";s:9:\"exam_edit\";s:3:\"yes\";s:11:\"exam_delete\";s:3:\"yes\";s:12:\"examschedule\";s:3:\"yes\";s:16:\"examschedule_add\";s:3:\"yes\";s:17:\"examschedule_edit\";s:3:\"yes\";s:19:\"examschedule_delete\";s:3:\"yes\";s:5:\"grade\";s:3:\"yes\";s:9:\"grade_add\";s:3:\"yes\";s:10:\"grade_edit\";s:3:\"yes\";s:12:\"grade_delete\";s:3:\"yes\";s:11:\"eattendance\";s:3:\"yes\";s:15:\"eattendance_add\";s:3:\"yes\";s:4:\"mark\";s:3:\"yes\";s:8:\"mark_add\";s:3:\"yes\";s:9:\"mark_view\";s:3:\"yes\";s:14:\"markpercentage\";s:3:\"yes\";s:18:\"markpercentage_add\";s:3:\"yes\";s:19:\"markpercentage_edit\";s:3:\"yes\";s:21:\"markpercentage_delete\";s:3:\"yes\";s:9:\"promotion\";s:3:\"yes\";s:12:\"conversation\";s:3:\"yes\";s:5:\"media\";s:3:\"yes\";s:9:\"media_add\";s:3:\"yes\";s:12:\"media_delete\";s:3:\"yes\";s:10:\"mailandsms\";s:3:\"yes\";s:14:\"mailandsms_add\";s:3:\"yes\";s:15:\"mailandsms_view\";s:3:\"yes\";s:14:\"question_group\";s:3:\"yes\";s:18:\"question_group_add\";s:3:\"yes\";s:19:\"question_group_edit\";s:3:\"yes\";s:21:\"question_group_delete\";s:3:\"yes\";s:14:\"question_level\";s:3:\"yes\";s:18:\"question_level_add\";s:3:\"yes\";s:19:\"question_level_edit\";s:3:\"yes\";s:21:\"question_level_delete\";s:3:\"yes\";s:13:\"question_bank\";s:3:\"yes\";s:17:\"question_bank_add\";s:3:\"yes\";s:18:\"question_bank_edit\";s:3:\"yes\";s:20:\"question_bank_delete\";s:3:\"yes\";s:18:\"question_bank_view\";s:3:\"yes\";s:11:\"online_exam\";s:3:\"yes\";s:15:\"online_exam_add\";s:3:\"yes\";s:16:\"online_exam_edit\";s:3:\"yes\";s:18:\"online_exam_delete\";s:3:\"yes\";s:11:\"instruction\";s:3:\"yes\";s:15:\"instruction_add\";s:3:\"yes\";s:16:\"instruction_edit\";s:3:\"yes\";s:18:\"instruction_delete\";s:3:\"yes\";s:16:\"instruction_view\";s:3:\"yes\";s:15:\"salary_template\";s:3:\"yes\";s:19:\"salary_template_add\";s:3:\"yes\";s:20:\"salary_template_edit\";s:3:\"yes\";s:22:\"salary_template_delete\";s:3:\"yes\";s:20:\"salary_template_view\";s:3:\"yes\";s:15:\"hourly_template\";s:3:\"yes\";s:19:\"hourly_template_add\";s:3:\"yes\";s:20:\"hourly_template_edit\";s:3:\"yes\";s:22:\"hourly_template_delete\";s:3:\"yes\";s:13:\"manage_salary\";s:3:\"yes\";s:17:\"manage_salary_add\";s:3:\"yes\";s:18:\"manage_salary_edit\";s:3:\"yes\";s:20:\"manage_salary_delete\";s:3:\"yes\";s:18:\"manage_salary_view\";s:3:\"yes\";s:12:\"make_payment\";s:3:\"yes\";s:8:\"overtime\";s:3:\"yes\";s:12:\"overtime_add\";s:3:\"yes\";s:13:\"overtime_edit\";s:3:\"yes\";s:15:\"overtime_delete\";s:3:\"yes\";s:6:\"vendor\";s:3:\"yes\";s:10:\"vendor_add\";s:3:\"yes\";s:11:\"vendor_edit\";s:3:\"yes\";s:13:\"vendor_delete\";s:3:\"yes\";s:8:\"location\";s:3:\"yes\";s:12:\"location_add\";s:3:\"yes\";s:13:\"location_edit\";s:3:\"yes\";s:15:\"location_delete\";s:3:\"yes\";s:14:\"asset_category\";s:3:\"yes\";s:18:\"asset_category_add\";s:3:\"yes\";s:19:\"asset_category_edit\";s:3:\"yes\";s:21:\"asset_category_delete\";s:3:\"yes\";s:5:\"asset\";s:3:\"yes\";s:9:\"asset_add\";s:3:\"yes\";s:10:\"asset_edit\";s:3:\"yes\";s:12:\"asset_delete\";s:3:\"yes\";s:10:\"asset_view\";s:3:\"yes\";s:16:\"asset_assignment\";s:3:\"yes\";s:20:\"asset_assignment_add\";s:3:\"yes\";s:21:\"asset_assignment_edit\";s:3:\"yes\";s:23:\"asset_assignment_delete\";s:3:\"yes\";s:21:\"asset_assignment_view\";s:3:\"yes\";s:8:\"purchase\";s:3:\"yes\";s:12:\"purchase_add\";s:3:\"yes\";s:13:\"purchase_edit\";s:3:\"yes\";s:15:\"purchase_delete\";s:3:\"yes\";s:15:\"productcategory\";s:3:\"yes\";s:19:\"productcategory_add\";s:3:\"yes\";s:20:\"productcategory_edit\";s:3:\"yes\";s:22:\"productcategory_delete\";s:3:\"yes\";s:7:\"product\";s:3:\"yes\";s:11:\"product_add\";s:3:\"yes\";s:12:\"product_edit\";s:3:\"yes\";s:14:\"product_delete\";s:3:\"yes\";s:16:\"productwarehouse\";s:3:\"yes\";s:20:\"productwarehouse_add\";s:3:\"yes\";s:21:\"productwarehouse_edit\";s:3:\"yes\";s:23:\"productwarehouse_delete\";s:3:\"yes\";s:15:\"productsupplier\";s:3:\"yes\";s:19:\"productsupplier_add\";s:3:\"yes\";s:20:\"productsupplier_edit\";s:3:\"yes\";s:22:\"productsupplier_delete\";s:3:\"yes\";s:15:\"productpurchase\";s:3:\"yes\";s:19:\"productpurchase_add\";s:3:\"yes\";s:20:\"productpurchase_edit\";s:3:\"yes\";s:22:\"productpurchase_delete\";s:3:\"yes\";s:20:\"productpurchase_view\";s:3:\"yes\";s:11:\"productsale\";s:3:\"yes\";s:15:\"productsale_add\";s:3:\"yes\";s:16:\"productsale_edit\";s:3:\"yes\";s:18:\"productsale_delete\";s:3:\"yes\";s:16:\"productsale_view\";s:3:\"yes\";s:13:\"leavecategory\";s:3:\"yes\";s:17:\"leavecategory_add\";s:3:\"yes\";s:18:\"leavecategory_edit\";s:3:\"yes\";s:20:\"leavecategory_delete\";s:3:\"yes\";s:11:\"leaveassign\";s:3:\"yes\";s:15:\"leaveassign_add\";s:3:\"yes\";s:16:\"leaveassign_edit\";s:3:\"yes\";s:18:\"leaveassign_delete\";s:3:\"yes\";s:10:\"leaveapply\";s:3:\"yes\";s:14:\"leaveapply_add\";s:3:\"yes\";s:15:\"leaveapply_edit\";s:3:\"yes\";s:17:\"leaveapply_delete\";s:3:\"yes\";s:15:\"leaveapply_view\";s:3:\"yes\";s:16:\"leaveapplication\";s:3:\"yes\";s:18:\"activitiescategory\";s:3:\"yes\";s:22:\"activitiescategory_add\";s:3:\"yes\";s:23:\"activitiescategory_edit\";s:3:\"yes\";s:25:\"activitiescategory_delete\";s:3:\"yes\";s:10:\"activities\";s:3:\"yes\";s:14:\"activities_add\";s:3:\"yes\";s:17:\"activities_delete\";s:3:\"yes\";s:9:\"childcare\";s:3:\"yes\";s:13:\"childcare_add\";s:3:\"yes\";s:14:\"childcare_edit\";s:3:\"yes\";s:16:\"childcare_delete\";s:3:\"yes\";s:7:\"lmember\";s:3:\"yes\";s:11:\"lmember_add\";s:3:\"yes\";s:12:\"lmember_edit\";s:3:\"yes\";s:14:\"lmember_delete\";s:3:\"yes\";s:12:\"lmember_view\";s:3:\"yes\";s:4:\"book\";s:3:\"yes\";s:8:\"book_add\";s:3:\"yes\";s:9:\"book_edit\";s:3:\"yes\";s:11:\"book_delete\";s:3:\"yes\";s:5:\"issue\";s:3:\"yes\";s:9:\"issue_add\";s:3:\"yes\";s:10:\"issue_edit\";s:3:\"yes\";s:10:\"issue_view\";s:3:\"yes\";s:6:\"ebooks\";s:3:\"yes\";s:10:\"ebooks_add\";s:3:\"yes\";s:11:\"ebooks_edit\";s:3:\"yes\";s:13:\"ebooks_delete\";s:3:\"yes\";s:11:\"ebooks_view\";s:3:\"yes\";s:9:\"transport\";s:3:\"yes\";s:13:\"transport_add\";s:3:\"yes\";s:14:\"transport_edit\";s:3:\"yes\";s:16:\"transport_delete\";s:3:\"yes\";s:7:\"tmember\";s:3:\"yes\";s:11:\"tmember_add\";s:3:\"yes\";s:12:\"tmember_edit\";s:3:\"yes\";s:14:\"tmember_delete\";s:3:\"yes\";s:12:\"tmember_view\";s:3:\"yes\";s:6:\"hostel\";s:3:\"yes\";s:10:\"hostel_add\";s:3:\"yes\";s:11:\"hostel_edit\";s:3:\"yes\";s:13:\"hostel_delete\";s:3:\"yes\";s:8:\"category\";s:3:\"yes\";s:12:\"category_add\";s:3:\"yes\";s:13:\"category_edit\";s:3:\"yes\";s:15:\"category_delete\";s:3:\"yes\";s:7:\"hmember\";s:3:\"yes\";s:11:\"hmember_add\";s:3:\"yes\";s:12:\"hmember_edit\";s:3:\"yes\";s:14:\"hmember_delete\";s:3:\"yes\";s:12:\"hmember_view\";s:3:\"yes\";s:8:\"feetypes\";s:3:\"yes\";s:12:\"feetypes_add\";s:3:\"yes\";s:13:\"feetypes_edit\";s:3:\"yes\";s:15:\"feetypes_delete\";s:3:\"yes\";s:7:\"invoice\";s:3:\"yes\";s:11:\"invoice_add\";s:3:\"yes\";s:12:\"invoice_edit\";s:3:\"yes\";s:14:\"invoice_delete\";s:3:\"yes\";s:12:\"invoice_view\";s:3:\"yes\";s:14:\"paymenthistory\";s:3:\"yes\";s:19:\"paymenthistory_edit\";s:3:\"yes\";s:21:\"paymenthistory_delete\";s:3:\"yes\";s:7:\"expense\";s:3:\"yes\";s:11:\"expense_add\";s:3:\"yes\";s:12:\"expense_edit\";s:3:\"yes\";s:14:\"expense_delete\";s:3:\"yes\";s:6:\"income\";s:3:\"yes\";s:10:\"income_add\";s:3:\"yes\";s:11:\"income_edit\";s:3:\"yes\";s:13:\"income_delete\";s:3:\"yes\";s:14:\"global_payment\";s:3:\"yes\";s:6:\"notice\";s:3:\"yes\";s:10:\"notice_add\";s:3:\"yes\";s:11:\"notice_edit\";s:3:\"yes\";s:13:\"notice_delete\";s:3:\"yes\";s:11:\"notice_view\";s:3:\"yes\";s:5:\"event\";s:3:\"yes\";s:9:\"event_add\";s:3:\"yes\";s:10:\"event_edit\";s:3:\"yes\";s:12:\"event_delete\";s:3:\"yes\";s:10:\"event_view\";s:3:\"yes\";s:7:\"holiday\";s:3:\"yes\";s:11:\"holiday_add\";s:3:\"yes\";s:12:\"holiday_edit\";s:3:\"yes\";s:14:\"holiday_delete\";s:3:\"yes\";s:12:\"holiday_view\";s:3:\"yes\";s:13:\"classesreport\";s:3:\"yes\";s:13:\"studentreport\";s:3:\"yes\";s:12:\"idcardreport\";s:3:\"yes\";s:15:\"admitcardreport\";s:3:\"yes\";s:13:\"routinereport\";s:3:\"yes\";s:18:\"examschedulereport\";s:3:\"yes\";s:16:\"attendancereport\";s:3:\"yes\";s:24:\"attendanceoverviewreport\";s:3:\"yes\";s:18:\"librarybooksreport\";s:3:\"yes\";s:17:\"librarycardreport\";s:3:\"yes\";s:22:\"librarybookissuereport\";s:3:\"yes\";s:14:\"terminalreport\";s:3:\"yes\";s:16:\"meritstagereport\";s:3:\"yes\";s:21:\"tabulationsheetreport\";s:3:\"yes\";s:15:\"marksheetreport\";s:3:\"yes\";s:18:\"progresscardreport\";s:3:\"yes\";s:20:\"studentsessionreport\";s:3:\"yes\";s:16:\"onlineexamreport\";s:3:\"yes\";s:24:\"onlineexamquestionreport\";s:3:\"yes\";s:21:\"onlineadmissionreport\";s:3:\"yes\";s:17:\"certificatereport\";s:3:\"yes\";s:22:\"leaveapplicationreport\";s:3:\"yes\";s:21:\"productpurchasereport\";s:3:\"yes\";s:17:\"productsalereport\";s:3:\"yes\";s:23:\"searchpaymentfeesreport\";s:3:\"yes\";s:10:\"feesreport\";s:3:\"yes\";s:13:\"duefeesreport\";s:3:\"yes\";s:17:\"balancefeesreport\";s:3:\"yes\";s:17:\"transactionreport\";s:3:\"yes\";s:17:\"studentfinereport\";s:3:\"yes\";s:14:\"overtimereport\";s:3:\"yes\";s:12:\"salaryreport\";s:3:\"yes\";s:19:\"accountledgerreport\";s:3:\"yes\";s:15:\"onlineadmission\";s:3:\"yes\";s:11:\"visitorinfo\";s:3:\"yes\";s:18:\"visitorinfo_delete\";s:3:\"yes\";s:16:\"visitorinfo_view\";s:3:\"yes\";s:10:\"schoolyear\";s:3:\"yes\";s:14:\"schoolyear_add\";s:3:\"yes\";s:15:\"schoolyear_edit\";s:3:\"yes\";s:17:\"schoolyear_delete\";s:3:\"yes\";s:12:\"studentgroup\";s:3:\"yes\";s:16:\"studentgroup_add\";s:3:\"yes\";s:17:\"studentgroup_edit\";s:3:\"yes\";s:19:\"studentgroup_delete\";s:3:\"yes\";s:8:\"complain\";s:3:\"yes\";s:12:\"complain_add\";s:3:\"yes\";s:13:\"complain_edit\";s:3:\"yes\";s:15:\"complain_delete\";s:3:\"yes\";s:13:\"complain_view\";s:3:\"yes\";s:20:\"certificate_template\";s:3:\"yes\";s:24:\"certificate_template_add\";s:3:\"yes\";s:25:\"certificate_template_edit\";s:3:\"yes\";s:27:\"certificate_template_delete\";s:3:\"yes\";s:25:\"certificate_template_view\";s:3:\"yes\";s:11:\"systemadmin\";s:3:\"yes\";s:15:\"systemadmin_add\";s:3:\"yes\";s:16:\"systemadmin_edit\";s:3:\"yes\";s:18:\"systemadmin_delete\";s:3:\"yes\";s:16:\"systemadmin_view\";s:3:\"yes\";s:13:\"resetpassword\";s:3:\"yes\";s:10:\"sociallink\";s:3:\"yes\";s:14:\"sociallink_add\";s:3:\"yes\";s:15:\"sociallink_edit\";s:3:\"yes\";s:17:\"sociallink_delete\";s:3:\"yes\";s:18:\"mailandsmstemplate\";s:3:\"yes\";s:22:\"mailandsmstemplate_add\";s:3:\"yes\";s:23:\"mailandsmstemplate_edit\";s:3:\"yes\";s:25:\"mailandsmstemplate_delete\";s:3:\"yes\";s:23:\"mailandsmstemplate_view\";s:3:\"yes\";s:10:\"bulkimport\";s:3:\"yes\";s:6:\"backup\";s:3:\"yes\";s:8:\"usertype\";s:3:\"yes\";s:12:\"usertype_add\";s:3:\"yes\";s:13:\"usertype_edit\";s:3:\"yes\";s:15:\"usertype_delete\";s:3:\"yes\";s:10:\"permission\";s:3:\"yes\";s:6:\"addons\";s:3:\"yes\";s:6:\"update\";s:3:\"yes\";s:16:\"posts_categories\";s:3:\"yes\";s:20:\"posts_categories_add\";s:3:\"yes\";s:21:\"posts_categories_edit\";s:3:\"yes\";s:23:\"posts_categories_delete\";s:3:\"yes\";s:5:\"posts\";s:3:\"yes\";s:9:\"posts_add\";s:3:\"yes\";s:10:\"posts_edit\";s:3:\"yes\";s:12:\"posts_delete\";s:3:\"yes\";s:5:\"pages\";s:3:\"yes\";s:9:\"pages_add\";s:3:\"yes\";s:10:\"pages_edit\";s:3:\"yes\";s:12:\"pages_delete\";s:3:\"yes\";s:12:\"frontendmenu\";s:3:\"yes\";s:7:\"setting\";s:3:\"yes\";s:16:\"frontend_setting\";s:3:\"yes\";s:15:\"paymentsettings\";s:3:\"yes\";s:11:\"smssettings\";s:3:\"yes\";s:12:\"emailsetting\";s:3:\"yes\";s:11:\"marksetting\";s:3:\"yes\";s:9:\"candidate\";s:3:\"yes\";s:13:\"candidate_add\";s:3:\"yes\";s:14:\"candidate_edit\";s:3:\"yes\";s:16:\"candidate_delete\";s:3:\"yes\";s:14:\"candidate_view\";s:3:\"yes\";s:7:\"sponsor\";s:3:\"yes\";s:11:\"sponsor_add\";s:3:\"yes\";s:12:\"sponsor_edit\";s:3:\"yes\";s:14:\"sponsor_delete\";s:3:\"yes\";s:12:\"sponsor_view\";s:3:\"yes\";s:11:\"sponsorship\";s:3:\"yes\";s:15:\"sponsorship_add\";s:3:\"yes\";s:16:\"sponsorship_edit\";s:3:\"yes\";s:18:\"sponsorship_delete\";s:3:\"yes\";s:17:\"sponsorshipreport\";s:3:\"yes\";s:30:\"onlineexamquestionanswerreport\";s:3:\"yes\";s:10:\"attendance\";s:3:\"yes\";s:25:\"student_attendance_report\";s:3:\"yes\";s:25:\"teacher_attendance_report\";s:3:\"yes\";s:22:\"user_attendance_report\";s:3:\"yes\";s:17:\"qrcode_attendance\";s:3:\"yes\";s:5:\"mpesa\";s:3:\"yes\";s:20:\"vendorpurchasereport\";s:3:\"yes\";s:18:\"itempurchasereport\";s:3:\"yes\";s:22:\"categorypurchasereport\";s:3:\"yes\";s:14:\"itemsalereport\";s:3:\"yes\";s:18:\"categorysalereport\";s:3:\"yes\";s:6:\"wallet\";s:3:\"yes\";s:5:\"lunch\";s:3:\"yes\";s:12:\"lunchsetting\";s:3:\"yes\";s:9:\"lunchlogs\";s:3:\"yes\";s:10:\"schoolterm\";s:3:\"yes\";s:14:\"schoolterm_add\";s:3:\"yes\";s:15:\"schoolterm_edit\";s:3:\"yes\";s:17:\"schoolterm_delete\";s:3:\"yes\";s:15:\"schoolterm_view\";s:3:\"yes\";s:15:\"generate_qrcode\";s:3:\"yes\";s:10:\"studentids\";s:3:\"yes\";s:17:\"studentids_delete\";s:3:\"yes\";s:17:\"cbcterminalreport\";s:3:\"yes\";s:9:\"smsreport\";s:3:\"yes\";s:7:\"sendsms\";s:3:\"yes\";s:15:\"studentleaveout\";s:3:\"yes\";s:20:\"studentleaveout_edit\";s:3:\"yes\";s:20:\"studentleaveout_view\";s:3:\"yes\";s:22:\"studentleaveout_delete\";s:3:\"yes\";s:13:\"backup_delete\";s:3:\"yes\";s:10:\"backup_add\";s:3:\"yes\";s:14:\"backup_restore\";s:3:\"yes\";s:9:\"take_exam\";s:3:\"yes\";}');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('392d81552c3cd3da8dc66968d2b559412fc44062', '102.213.176.14', 1713332890, '__ci_last_regenerate|i:1713332890;');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5527b46ad606e130467119be7b15304440dcd7c6', '102.222.4.116', 1713337320, '__ci_last_regenerate|i:1713337320;english|N;loginuserID|s:2:\"10\";name|s:14:\"PENINAH MUTUKU\";email|s:17:\"peninah@email.com\";usertypeID|s:1:\"7\";usertype|s:12:\"Receptionist\";username|s:7:\"peninah\";photo|s:11:\"peninah.JPG\";lang|s:7:\"english\";defaultschoolyearID|s:1:\"4\";varifyvaliduser|b:1;loggedin|b:1;get_permission|b:1;master_permission_set|a:426:{s:9:\"dashboard\";s:3:\"yes\";s:7:\"student\";s:3:\"yes\";s:11:\"student_add\";s:3:\"yes\";s:12:\"student_edit\";s:3:\"yes\";s:7:\"teacher\";s:3:\"yes\";s:11:\"teacher_add\";s:3:\"yes\";s:12:\"teacher_edit\";s:3:\"yes\";s:12:\"conversation\";s:3:\"yes\";s:6:\"notice\";s:3:\"yes\";s:10:\"notice_add\";s:3:\"yes\";s:11:\"notice_edit\";s:3:\"yes\";s:5:\"event\";s:3:\"yes\";s:9:\"event_add\";s:3:\"yes\";s:10:\"event_edit\";s:3:\"yes\";s:7:\"holiday\";s:3:\"yes\";s:12:\"holiday_view\";s:3:\"yes\";s:14:\"terminalreport\";s:3:\"yes\";s:17:\"qrcode_attendance\";s:3:\"yes\";s:10:\"mailandsms\";s:3:\"yes\";s:14:\"mailandsms_add\";s:3:\"yes\";s:15:\"mailandsms_view\";s:3:\"yes\";s:25:\"student_attendance_report\";s:3:\"yes\";s:25:\"teacher_attendance_report\";s:3:\"yes\";s:22:\"user_attendance_report\";s:3:\"yes\";s:10:\"studentids\";s:3:\"yes\";s:17:\"studentids_delete\";s:3:\"yes\";s:7:\"lmember\";s:3:\"yes\";s:11:\"lmember_add\";s:3:\"yes\";s:12:\"lmember_edit\";s:3:\"yes\";s:14:\"lmember_delete\";s:3:\"yes\";s:12:\"lmember_view\";s:3:\"yes\";s:4:\"book\";s:3:\"yes\";s:8:\"book_add\";s:3:\"yes\";s:9:\"book_edit\";s:3:\"yes\";s:11:\"book_delete\";s:3:\"yes\";s:5:\"issue\";s:3:\"yes\";s:9:\"issue_add\";s:3:\"yes\";s:10:\"issue_edit\";s:3:\"yes\";s:10:\"issue_view\";s:3:\"yes\";s:14:\"student_delete\";s:2:\"no\";s:12:\"student_view\";s:2:\"no\";s:7:\"parents\";s:2:\"no\";s:11:\"parents_add\";s:2:\"no\";s:12:\"parents_edit\";s:2:\"no\";s:14:\"parents_delete\";s:2:\"no\";s:12:\"parents_view\";s:2:\"no\";s:14:\"teacher_delete\";s:2:\"no\";s:12:\"teacher_view\";s:2:\"no\";s:4:\"user\";s:2:\"no\";s:8:\"user_add\";s:2:\"no\";s:9:\"user_edit\";s:2:\"no\";s:11:\"user_delete\";s:2:\"no\";s:9:\"user_view\";s:2:\"no\";s:7:\"classes\";s:2:\"no\";s:11:\"classes_add\";s:2:\"no\";s:12:\"classes_edit\";s:2:\"no\";s:14:\"classes_delete\";s:2:\"no\";s:7:\"section\";s:2:\"no\";s:11:\"section_add\";s:2:\"no\";s:12:\"section_edit\";s:2:\"no\";s:15:\"semester_delete\";s:2:\"no\";s:14:\"section_delete\";s:2:\"no\";s:7:\"subject\";s:2:\"no\";s:11:\"subject_add\";s:2:\"no\";s:12:\"subject_edit\";s:2:\"no\";s:14:\"subject_delete\";s:2:\"no\";s:8:\"syllabus\";s:2:\"no\";s:12:\"syllabus_add\";s:2:\"no\";s:13:\"syllabus_edit\";s:2:\"no\";s:15:\"syllabus_delete\";s:2:\"no\";s:10:\"assignment\";s:2:\"no\";s:14:\"assignment_add\";s:2:\"no\";s:15:\"assignment_edit\";s:2:\"no\";s:17:\"assignment_delete\";s:2:\"no\";s:15:\"assignment_view\";s:2:\"no\";s:7:\"routine\";s:2:\"no\";s:11:\"routine_add\";s:2:\"no\";s:12:\"routine_edit\";s:2:\"no\";s:14:\"routine_delete\";s:2:\"no\";s:11:\"sattendance\";s:2:\"no\";s:15:\"sattendance_add\";s:2:\"no\";s:16:\"sattendance_view\";s:2:\"no\";s:11:\"tattendance\";s:2:\"no\";s:15:\"tattendance_add\";s:2:\"no\";s:16:\"tattendance_view\";s:2:\"no\";s:11:\"uattendance\";s:2:\"no\";s:15:\"uattendance_add\";s:2:\"no\";s:16:\"uattendance_view\";s:2:\"no\";s:4:\"exam\";s:2:\"no\";s:8:\"exam_add\";s:2:\"no\";s:9:\"exam_edit\";s:2:\"no\";s:11:\"exam_delete\";s:2:\"no\";s:12:\"examschedule\";s:2:\"no\";s:16:\"examschedule_add\";s:2:\"no\";s:17:\"examschedule_edit\";s:2:\"no\";s:19:\"examschedule_delete\";s:2:\"no\";s:5:\"grade\";s:2:\"no\";s:9:\"grade_add\";s:2:\"no\";s:10:\"grade_edit\";s:2:\"no\";s:12:\"grade_delete\";s:2:\"no\";s:11:\"eattendance\";s:2:\"no\";s:15:\"eattendance_add\";s:2:\"no\";s:4:\"mark\";s:2:\"no\";s:8:\"mark_add\";s:2:\"no\";s:9:\"mark_view\";s:2:\"no\";s:14:\"markpercentage\";s:2:\"no\";s:18:\"markpercentage_add\";s:2:\"no\";s:19:\"markpercentage_edit\";s:2:\"no\";s:21:\"markpercentage_delete\";s:2:\"no\";s:9:\"promotion\";s:2:\"no\";s:5:\"media\";s:2:\"no\";s:9:\"media_add\";s:2:\"no\";s:12:\"media_delete\";s:2:\"no\";s:14:\"question_group\";s:2:\"no\";s:18:\"question_group_add\";s:2:\"no\";s:19:\"question_group_edit\";s:2:\"no\";s:21:\"question_group_delete\";s:2:\"no\";s:14:\"question_level\";s:2:\"no\";s:18:\"question_level_add\";s:2:\"no\";s:19:\"question_level_edit\";s:2:\"no\";s:21:\"question_level_delete\";s:2:\"no\";s:13:\"question_bank\";s:2:\"no\";s:17:\"question_bank_add\";s:2:\"no\";s:18:\"question_bank_edit\";s:2:\"no\";s:20:\"question_bank_delete\";s:2:\"no\";s:18:\"question_bank_view\";s:2:\"no\";s:11:\"online_exam\";s:2:\"no\";s:15:\"online_exam_add\";s:2:\"no\";s:16:\"online_exam_edit\";s:2:\"no\";s:18:\"online_exam_delete\";s:2:\"no\";s:11:\"instruction\";s:2:\"no\";s:15:\"instruction_add\";s:2:\"no\";s:16:\"instruction_edit\";s:2:\"no\";s:18:\"instruction_delete\";s:2:\"no\";s:16:\"instruction_view\";s:2:\"no\";s:15:\"salary_template\";s:2:\"no\";s:19:\"salary_template_add\";s:2:\"no\";s:20:\"salary_template_edit\";s:2:\"no\";s:22:\"salary_template_delete\";s:2:\"no\";s:20:\"salary_template_view\";s:2:\"no\";s:15:\"hourly_template\";s:2:\"no\";s:19:\"hourly_template_add\";s:2:\"no\";s:20:\"hourly_template_edit\";s:2:\"no\";s:22:\"hourly_template_delete\";s:2:\"no\";s:13:\"manage_salary\";s:2:\"no\";s:17:\"manage_salary_add\";s:2:\"no\";s:18:\"manage_salary_edit\";s:2:\"no\";s:20:\"manage_salary_delete\";s:2:\"no\";s:18:\"manage_salary_view\";s:2:\"no\";s:12:\"make_payment\";s:2:\"no\";s:8:\"overtime\";s:2:\"no\";s:12:\"overtime_add\";s:2:\"no\";s:13:\"overtime_edit\";s:2:\"no\";s:15:\"overtime_delete\";s:2:\"no\";s:6:\"vendor\";s:2:\"no\";s:10:\"vendor_add\";s:2:\"no\";s:11:\"vendor_edit\";s:2:\"no\";s:13:\"vendor_delete\";s:2:\"no\";s:8:\"location\";s:2:\"no\";s:12:\"location_add\";s:2:\"no\";s:13:\"location_edit\";s:2:\"no\";s:15:\"location_delete\";s:2:\"no\";s:14:\"asset_category\";s:2:\"no\";s:18:\"asset_category_add\";s:2:\"no\";s:19:\"asset_category_edit\";s:2:\"no\";s:21:\"asset_category_delete\";s:2:\"no\";s:5:\"asset\";s:2:\"no\";s:9:\"asset_add\";s:2:\"no\";s:10:\"asset_edit\";s:2:\"no\";s:12:\"asset_delete\";s:2:\"no\";s:10:\"asset_view\";s:2:\"no\";s:16:\"asset_assignment\";s:2:\"no\";s:20:\"asset_assignment_add\";s:2:\"no\";s:21:\"asset_assignment_edit\";s:2:\"no\";s:23:\"asset_assignment_delete\";s:2:\"no\";s:21:\"asset_assignment_view\";s:2:\"no\";s:8:\"purchase\";s:2:\"no\";s:12:\"purchase_add\";s:2:\"no\";s:13:\"purchase_edit\";s:2:\"no\";s:15:\"purchase_delete\";s:2:\"no\";s:15:\"productcategory\";s:2:\"no\";s:19:\"productcategory_add\";s:2:\"no\";s:20:\"productcategory_edit\";s:2:\"no\";s:22:\"productcategory_delete\";s:2:\"no\";s:7:\"product\";s:2:\"no\";s:11:\"product_add\";s:2:\"no\";s:12:\"product_edit\";s:2:\"no\";s:14:\"product_delete\";s:2:\"no\";s:16:\"productwarehouse\";s:2:\"no\";s:20:\"productwarehouse_add\";s:2:\"no\";s:21:\"productwarehouse_edit\";s:2:\"no\";s:23:\"productwarehouse_delete\";s:2:\"no\";s:15:\"productsupplier\";s:2:\"no\";s:19:\"productsupplier_add\";s:2:\"no\";s:20:\"productsupplier_edit\";s:2:\"no\";s:22:\"productsupplier_delete\";s:2:\"no\";s:15:\"productpurchase\";s:2:\"no\";s:19:\"productpurchase_add\";s:2:\"no\";s:20:\"productpurchase_edit\";s:2:\"no\";s:22:\"productpurchase_delete\";s:2:\"no\";s:20:\"productpurchase_view\";s:2:\"no\";s:11:\"productsale\";s:2:\"no\";s:15:\"productsale_add\";s:2:\"no\";s:16:\"productsale_edit\";s:2:\"no\";s:18:\"productsale_delete\";s:2:\"no\";s:16:\"productsale_view\";s:2:\"no\";s:13:\"leavecategory\";s:2:\"no\";s:17:\"leavecategory_add\";s:2:\"no\";s:18:\"leavecategory_edit\";s:2:\"no\";s:20:\"leavecategory_delete\";s:2:\"no\";s:11:\"leaveassign\";s:2:\"no\";s:15:\"leaveassign_add\";s:2:\"no\";s:16:\"leaveassign_edit\";s:2:\"no\";s:18:\"leaveassign_delete\";s:2:\"no\";s:10:\"leaveapply\";s:2:\"no\";s:14:\"leaveapply_add\";s:2:\"no\";s:15:\"leaveapply_edit\";s:2:\"no\";s:17:\"leaveapply_delete\";s:2:\"no\";s:15:\"leaveapply_view\";s:2:\"no\";s:16:\"leaveapplication\";s:2:\"no\";s:18:\"activitiescategory\";s:2:\"no\";s:22:\"activitiescategory_add\";s:2:\"no\";s:23:\"activitiescategory_edit\";s:2:\"no\";s:25:\"activitiescategory_delete\";s:2:\"no\";s:10:\"activities\";s:2:\"no\";s:14:\"activities_add\";s:2:\"no\";s:17:\"activities_delete\";s:2:\"no\";s:9:\"childcare\";s:2:\"no\";s:13:\"childcare_add\";s:2:\"no\";s:14:\"childcare_edit\";s:2:\"no\";s:16:\"childcare_delete\";s:2:\"no\";s:6:\"ebooks\";s:2:\"no\";s:10:\"ebooks_add\";s:2:\"no\";s:11:\"ebooks_edit\";s:2:\"no\";s:13:\"ebooks_delete\";s:2:\"no\";s:11:\"ebooks_view\";s:2:\"no\";s:9:\"transport\";s:2:\"no\";s:13:\"transport_add\";s:2:\"no\";s:14:\"transport_edit\";s:2:\"no\";s:16:\"transport_delete\";s:2:\"no\";s:7:\"tmember\";s:2:\"no\";s:11:\"tmember_add\";s:2:\"no\";s:12:\"tmember_edit\";s:2:\"no\";s:14:\"tmember_delete\";s:2:\"no\";s:12:\"tmember_view\";s:2:\"no\";s:6:\"hostel\";s:2:\"no\";s:10:\"hostel_add\";s:2:\"no\";s:11:\"hostel_edit\";s:2:\"no\";s:13:\"hostel_delete\";s:2:\"no\";s:8:\"category\";s:2:\"no\";s:12:\"category_add\";s:2:\"no\";s:13:\"category_edit\";s:2:\"no\";s:15:\"category_delete\";s:2:\"no\";s:7:\"hmember\";s:2:\"no\";s:11:\"hmember_add\";s:2:\"no\";s:12:\"hmember_edit\";s:2:\"no\";s:14:\"hmember_delete\";s:2:\"no\";s:12:\"hmember_view\";s:2:\"no\";s:8:\"feetypes\";s:2:\"no\";s:12:\"feetypes_add\";s:2:\"no\";s:13:\"feetypes_edit\";s:2:\"no\";s:15:\"feetypes_delete\";s:2:\"no\";s:7:\"invoice\";s:2:\"no\";s:11:\"invoice_add\";s:2:\"no\";s:12:\"invoice_edit\";s:2:\"no\";s:14:\"invoice_delete\";s:2:\"no\";s:12:\"invoice_view\";s:2:\"no\";s:14:\"paymenthistory\";s:2:\"no\";s:19:\"paymenthistory_edit\";s:2:\"no\";s:21:\"paymenthistory_delete\";s:2:\"no\";s:7:\"expense\";s:2:\"no\";s:11:\"expense_add\";s:2:\"no\";s:12:\"expense_edit\";s:2:\"no\";s:14:\"expense_delete\";s:2:\"no\";s:6:\"income\";s:2:\"no\";s:10:\"income_add\";s:2:\"no\";s:11:\"income_edit\";s:2:\"no\";s:13:\"income_delete\";s:2:\"no\";s:14:\"global_payment\";s:2:\"no\";s:13:\"notice_delete\";s:2:\"no\";s:11:\"notice_view\";s:2:\"no\";s:12:\"event_delete\";s:2:\"no\";s:10:\"event_view\";s:2:\"no\";s:11:\"holiday_add\";s:2:\"no\";s:12:\"holiday_edit\";s:2:\"no\";s:14:\"holiday_delete\";s:2:\"no\";s:13:\"classesreport\";s:2:\"no\";s:13:\"studentreport\";s:2:\"no\";s:12:\"idcardreport\";s:2:\"no\";s:15:\"admitcardreport\";s:2:\"no\";s:13:\"routinereport\";s:2:\"no\";s:18:\"examschedulereport\";s:2:\"no\";s:16:\"attendancereport\";s:2:\"no\";s:24:\"attendanceoverviewreport\";s:2:\"no\";s:18:\"librarybooksreport\";s:2:\"no\";s:17:\"librarycardreport\";s:2:\"no\";s:22:\"librarybookissuereport\";s:2:\"no\";s:16:\"meritstagereport\";s:2:\"no\";s:21:\"tabulationsheetreport\";s:2:\"no\";s:15:\"marksheetreport\";s:2:\"no\";s:18:\"progresscardreport\";s:2:\"no\";s:20:\"studentsessionreport\";s:2:\"no\";s:16:\"onlineexamreport\";s:2:\"no\";s:24:\"onlineexamquestionreport\";s:2:\"no\";s:21:\"onlineadmissionreport\";s:2:\"no\";s:17:\"certificatereport\";s:2:\"no\";s:22:\"leaveapplicationreport\";s:2:\"no\";s:21:\"productpurchasereport\";s:2:\"no\";s:17:\"productsalereport\";s:2:\"no\";s:23:\"searchpaymentfeesreport\";s:2:\"no\";s:10:\"feesreport\";s:2:\"no\";s:13:\"duefeesreport\";s:2:\"no\";s:17:\"balancefeesreport\";s:2:\"no\";s:17:\"transactionreport\";s:2:\"no\";s:17:\"studentfinereport\";s:2:\"no\";s:14:\"overtimereport\";s:2:\"no\";s:12:\"salaryreport\";s:2:\"no\";s:19:\"accountledgerreport\";s:2:\"no\";s:15:\"onlineadmission\";s:2:\"no\";s:11:\"visitorinfo\";s:2:\"no\";s:18:\"visitorinfo_delete\";s:2:\"no\";s:16:\"visitorinfo_view\";s:2:\"no\";s:10:\"schoolyear\";s:2:\"no\";s:14:\"schoolyear_add\";s:2:\"no\";s:15:\"schoolyear_edit\";s:2:\"no\";s:17:\"schoolyear_delete\";s:2:\"no\";s:12:\"studentgroup\";s:2:\"no\";s:16:\"studentgroup_add\";s:2:\"no\";s:17:\"studentgroup_edit\";s:2:\"no\";s:19:\"studentgroup_delete\";s:2:\"no\";s:8:\"complain\";s:2:\"no\";s:12:\"complain_add\";s:2:\"no\";s:13:\"complain_edit\";s:2:\"no\";s:15:\"complain_delete\";s:2:\"no\";s:13:\"complain_view\";s:2:\"no\";s:20:\"certificate_template\";s:2:\"no\";s:24:\"certificate_template_add\";s:2:\"no\";s:25:\"certificate_template_edit\";s:2:\"no\";s:27:\"certificate_template_delete\";s:2:\"no\";s:25:\"certificate_template_view\";s:2:\"no\";s:11:\"systemadmin\";s:2:\"no\";s:15:\"systemadmin_add\";s:2:\"no\";s:16:\"systemadmin_edit\";s:2:\"no\";s:18:\"systemadmin_delete\";s:2:\"no\";s:16:\"systemadmin_view\";s:2:\"no\";s:13:\"resetpassword\";s:2:\"no\";s:10:\"sociallink\";s:2:\"no\";s:14:\"sociallink_add\";s:2:\"no\";s:15:\"sociallink_edit\";s:2:\"no\";s:17:\"sociallink_delete\";s:2:\"no\";s:18:\"mailandsmstemplate\";s:2:\"no\";s:22:\"mailandsmstemplate_add\";s:2:\"no\";s:23:\"mailandsmstemplate_edit\";s:2:\"no\";s:25:\"mailandsmstemplate_delete\";s:2:\"no\";s:23:\"mailandsmstemplate_view\";s:2:\"no\";s:11:\"bulkimport \";s:2:\"no\";s:6:\"backup\";s:2:\"no\";s:8:\"usertype\";s:2:\"no\";s:12:\"usertype_add\";s:2:\"no\";s:13:\"usertype_edit\";s:2:\"no\";s:15:\"usertype_delete\";s:2:\"no\";s:10:\"permission\";s:2:\"no\";s:6:\"addons\";s:2:\"no\";s:6:\"update\";s:2:\"no\";s:16:\"posts_categories\";s:2:\"no\";s:20:\"posts_categories_add\";s:2:\"no\";s:21:\"posts_categories_edit\";s:2:\"no\";s:23:\"posts_categories_delete\";s:2:\"no\";s:5:\"posts\";s:2:\"no\";s:9:\"posts_add\";s:2:\"no\";s:10:\"posts_edit\";s:2:\"no\";s:12:\"posts_delete\";s:2:\"no\";s:5:\"pages\";s:2:\"no\";s:9:\"pages_add\";s:2:\"no\";s:10:\"pages_edit\";s:2:\"no\";s:12:\"pages_delete\";s:2:\"no\";s:12:\"frontendmenu\";s:2:\"no\";s:7:\"setting\";s:2:\"no\";s:16:\"frontend_setting\";s:2:\"no\";s:15:\"paymentsettings\";s:2:\"no\";s:11:\"smssettings\";s:2:\"no\";s:12:\"emailsetting\";s:2:\"no\";s:11:\"marksetting\";s:2:\"no\";s:9:\"candidate\";s:2:\"no\";s:13:\"candidate_add\";s:2:\"no\";s:14:\"candidate_edit\";s:2:\"no\";s:16:\"candidate_delete\";s:2:\"no\";s:14:\"candidate_view\";s:2:\"no\";s:7:\"sponsor\";s:2:\"no\";s:11:\"sponsor_add\";s:2:\"no\";s:12:\"sponsor_edit\";s:2:\"no\";s:14:\"sponsor_delete\";s:2:\"no\";s:12:\"sponsor_view\";s:2:\"no\";s:11:\"sponsorship\";s:2:\"no\";s:15:\"sponsorship_add\";s:2:\"no\";s:16:\"sponsorship_edit\";s:2:\"no\";s:18:\"sponsorship_delete\";s:2:\"no\";s:17:\"sponsorshipreport\";s:2:\"no\";s:30:\"onlineexamquestionanswerreport\";s:2:\"no\";s:10:\"attendance\";s:2:\"no\";s:5:\"mpesa\";s:2:\"no\";s:20:\"vendorpurchasereport\";s:2:\"no\";s:18:\"itempurchasereport\";s:2:\"no\";s:22:\"categorypurchasereport\";s:2:\"no\";s:14:\"itemsalereport\";s:2:\"no\";s:18:\"categorysalereport\";s:2:\"no\";s:6:\"wallet\";s:2:\"no\";s:5:\"lunch\";s:2:\"no\";s:12:\"lunchsetting\";s:2:\"no\";s:9:\"lunchlogs\";s:2:\"no\";s:10:\"schoolterm\";s:2:\"no\";s:14:\"schoolterm_add\";s:2:\"no\";s:15:\"schoolterm_edit\";s:2:\"no\";s:17:\"schoolterm_delete\";s:2:\"no\";s:15:\"schoolterm_view\";s:2:\"no\";s:15:\"generate_qrcode\";s:2:\"no\";s:17:\"cbcterminalreport\";s:2:\"no\";s:9:\"smsreport\";s:2:\"no\";s:7:\"sendsms\";s:2:\"no\";s:15:\"studentleaveout\";s:2:\"no\";s:20:\"studentleaveout_edit\";s:2:\"no\";s:20:\"studentleaveout_view\";s:2:\"no\";s:22:\"studentleaveout_delete\";s:2:\"no\";s:13:\"backup_delete\";s:2:\"no\";s:10:\"backup_add\";s:2:\"no\";s:14:\"backup_restore\";s:2:\"no\";}');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6dd85039eca3b3540f97e09065476fd7c1f85f71', '102.213.176.14', 1713333380, '__ci_last_regenerate|i:1713333231;english|N;loginuserID|s:1:\"1\";name|s:6:\"Skooly\";email|s:18:\"matthigu@yahoo.com\";usertypeID|s:1:\"1\";usertype|s:5:\"Admin\";username|s:6:\"skooly\";photo|s:132:\"2f8ab9b11765b18645a5c1dd5670923ca4c4deb754d3b806318e66db220e2b26b42f2e1e24f8a74fdb94004de0ec948b67d2eb0b028e286c724a279574cbf665.png\";lang|s:7:\"english\";defaultschoolyearID|s:1:\"4\";varifyvaliduser|b:1;loggedin|b:1;get_permission|b:1;master_permission_set|a:427:{s:9:\"dashboard\";s:3:\"yes\";s:7:\"student\";s:3:\"yes\";s:11:\"student_add\";s:3:\"yes\";s:12:\"student_edit\";s:3:\"yes\";s:14:\"student_delete\";s:3:\"yes\";s:12:\"student_view\";s:3:\"yes\";s:7:\"parents\";s:3:\"yes\";s:11:\"parents_add\";s:3:\"yes\";s:12:\"parents_edit\";s:3:\"yes\";s:14:\"parents_delete\";s:3:\"yes\";s:12:\"parents_view\";s:3:\"yes\";s:7:\"teacher\";s:3:\"yes\";s:11:\"teacher_add\";s:3:\"yes\";s:12:\"teacher_edit\";s:3:\"yes\";s:14:\"teacher_delete\";s:3:\"yes\";s:12:\"teacher_view\";s:3:\"yes\";s:4:\"user\";s:3:\"yes\";s:8:\"user_add\";s:3:\"yes\";s:9:\"user_edit\";s:3:\"yes\";s:11:\"user_delete\";s:3:\"yes\";s:9:\"user_view\";s:3:\"yes\";s:7:\"classes\";s:3:\"yes\";s:11:\"classes_add\";s:3:\"yes\";s:12:\"classes_edit\";s:3:\"yes\";s:14:\"classes_delete\";s:3:\"yes\";s:7:\"section\";s:3:\"yes\";s:11:\"section_add\";s:3:\"yes\";s:12:\"section_edit\";s:3:\"yes\";s:15:\"semester_delete\";s:3:\"yes\";s:14:\"section_delete\";s:3:\"yes\";s:7:\"subject\";s:3:\"yes\";s:11:\"subject_add\";s:3:\"yes\";s:12:\"subject_edit\";s:3:\"yes\";s:14:\"subject_delete\";s:3:\"yes\";s:8:\"syllabus\";s:3:\"yes\";s:12:\"syllabus_add\";s:3:\"yes\";s:13:\"syllabus_edit\";s:3:\"yes\";s:15:\"syllabus_delete\";s:3:\"yes\";s:10:\"assignment\";s:3:\"yes\";s:14:\"assignment_add\";s:3:\"yes\";s:15:\"assignment_edit\";s:3:\"yes\";s:17:\"assignment_delete\";s:3:\"yes\";s:15:\"assignment_view\";s:3:\"yes\";s:7:\"routine\";s:3:\"yes\";s:11:\"routine_add\";s:3:\"yes\";s:12:\"routine_edit\";s:3:\"yes\";s:14:\"routine_delete\";s:3:\"yes\";s:11:\"sattendance\";s:3:\"yes\";s:15:\"sattendance_add\";s:3:\"yes\";s:16:\"sattendance_view\";s:3:\"yes\";s:11:\"tattendance\";s:3:\"yes\";s:15:\"tattendance_add\";s:3:\"yes\";s:16:\"tattendance_view\";s:3:\"yes\";s:11:\"uattendance\";s:3:\"yes\";s:15:\"uattendance_add\";s:3:\"yes\";s:16:\"uattendance_view\";s:3:\"yes\";s:4:\"exam\";s:3:\"yes\";s:8:\"exam_add\";s:3:\"yes\";s:9:\"exam_edit\";s:3:\"yes\";s:11:\"exam_delete\";s:3:\"yes\";s:12:\"examschedule\";s:3:\"yes\";s:16:\"examschedule_add\";s:3:\"yes\";s:17:\"examschedule_edit\";s:3:\"yes\";s:19:\"examschedule_delete\";s:3:\"yes\";s:5:\"grade\";s:3:\"yes\";s:9:\"grade_add\";s:3:\"yes\";s:10:\"grade_edit\";s:3:\"yes\";s:12:\"grade_delete\";s:3:\"yes\";s:11:\"eattendance\";s:3:\"yes\";s:15:\"eattendance_add\";s:3:\"yes\";s:4:\"mark\";s:3:\"yes\";s:8:\"mark_add\";s:3:\"yes\";s:9:\"mark_view\";s:3:\"yes\";s:14:\"markpercentage\";s:3:\"yes\";s:18:\"markpercentage_add\";s:3:\"yes\";s:19:\"markpercentage_edit\";s:3:\"yes\";s:21:\"markpercentage_delete\";s:3:\"yes\";s:9:\"promotion\";s:3:\"yes\";s:12:\"conversation\";s:3:\"yes\";s:5:\"media\";s:3:\"yes\";s:9:\"media_add\";s:3:\"yes\";s:12:\"media_delete\";s:3:\"yes\";s:10:\"mailandsms\";s:3:\"yes\";s:14:\"mailandsms_add\";s:3:\"yes\";s:15:\"mailandsms_view\";s:3:\"yes\";s:14:\"question_group\";s:3:\"yes\";s:18:\"question_group_add\";s:3:\"yes\";s:19:\"question_group_edit\";s:3:\"yes\";s:21:\"question_group_delete\";s:3:\"yes\";s:14:\"question_level\";s:3:\"yes\";s:18:\"question_level_add\";s:3:\"yes\";s:19:\"question_level_edit\";s:3:\"yes\";s:21:\"question_level_delete\";s:3:\"yes\";s:13:\"question_bank\";s:3:\"yes\";s:17:\"question_bank_add\";s:3:\"yes\";s:18:\"question_bank_edit\";s:3:\"yes\";s:20:\"question_bank_delete\";s:3:\"yes\";s:18:\"question_bank_view\";s:3:\"yes\";s:11:\"online_exam\";s:3:\"yes\";s:15:\"online_exam_add\";s:3:\"yes\";s:16:\"online_exam_edit\";s:3:\"yes\";s:18:\"online_exam_delete\";s:3:\"yes\";s:11:\"instruction\";s:3:\"yes\";s:15:\"instruction_add\";s:3:\"yes\";s:16:\"instruction_edit\";s:3:\"yes\";s:18:\"instruction_delete\";s:3:\"yes\";s:16:\"instruction_view\";s:3:\"yes\";s:15:\"salary_template\";s:3:\"yes\";s:19:\"salary_template_add\";s:3:\"yes\";s:20:\"salary_template_edit\";s:3:\"yes\";s:22:\"salary_template_delete\";s:3:\"yes\";s:20:\"salary_template_view\";s:3:\"yes\";s:15:\"hourly_template\";s:3:\"yes\";s:19:\"hourly_template_add\";s:3:\"yes\";s:20:\"hourly_template_edit\";s:3:\"yes\";s:22:\"hourly_template_delete\";s:3:\"yes\";s:13:\"manage_salary\";s:3:\"yes\";s:17:\"manage_salary_add\";s:3:\"yes\";s:18:\"manage_salary_edit\";s:3:\"yes\";s:20:\"manage_salary_delete\";s:3:\"yes\";s:18:\"manage_salary_view\";s:3:\"yes\";s:12:\"make_payment\";s:3:\"yes\";s:8:\"overtime\";s:3:\"yes\";s:12:\"overtime_add\";s:3:\"yes\";s:13:\"overtime_edit\";s:3:\"yes\";s:15:\"overtime_delete\";s:3:\"yes\";s:6:\"vendor\";s:3:\"yes\";s:10:\"vendor_add\";s:3:\"yes\";s:11:\"vendor_edit\";s:3:\"yes\";s:13:\"vendor_delete\";s:3:\"yes\";s:8:\"location\";s:3:\"yes\";s:12:\"location_add\";s:3:\"yes\";s:13:\"location_edit\";s:3:\"yes\";s:15:\"location_delete\";s:3:\"yes\";s:14:\"asset_category\";s:3:\"yes\";s:18:\"asset_category_add\";s:3:\"yes\";s:19:\"asset_category_edit\";s:3:\"yes\";s:21:\"asset_category_delete\";s:3:\"yes\";s:5:\"asset\";s:3:\"yes\";s:9:\"asset_add\";s:3:\"yes\";s:10:\"asset_edit\";s:3:\"yes\";s:12:\"asset_delete\";s:3:\"yes\";s:10:\"asset_view\";s:3:\"yes\";s:16:\"asset_assignment\";s:3:\"yes\";s:20:\"asset_assignment_add\";s:3:\"yes\";s:21:\"asset_assignment_edit\";s:3:\"yes\";s:23:\"asset_assignment_delete\";s:3:\"yes\";s:21:\"asset_assignment_view\";s:3:\"yes\";s:8:\"purchase\";s:3:\"yes\";s:12:\"purchase_add\";s:3:\"yes\";s:13:\"purchase_edit\";s:3:\"yes\";s:15:\"purchase_delete\";s:3:\"yes\";s:15:\"productcategory\";s:3:\"yes\";s:19:\"productcategory_add\";s:3:\"yes\";s:20:\"productcategory_edit\";s:3:\"yes\";s:22:\"productcategory_delete\";s:3:\"yes\";s:7:\"product\";s:3:\"yes\";s:11:\"product_add\";s:3:\"yes\";s:12:\"product_edit\";s:3:\"yes\";s:14:\"product_delete\";s:3:\"yes\";s:16:\"productwarehouse\";s:3:\"yes\";s:20:\"productwarehouse_add\";s:3:\"yes\";s:21:\"productwarehouse_edit\";s:3:\"yes\";s:23:\"productwarehouse_delete\";s:3:\"yes\";s:15:\"productsupplier\";s:3:\"yes\";s:19:\"productsupplier_add\";s:3:\"yes\";s:20:\"productsupplier_edit\";s:3:\"yes\";s:22:\"productsupplier_delete\";s:3:\"yes\";s:15:\"productpurchase\";s:3:\"yes\";s:19:\"productpurchase_add\";s:3:\"yes\";s:20:\"productpurchase_edit\";s:3:\"yes\";s:22:\"productpurchase_delete\";s:3:\"yes\";s:20:\"productpurchase_view\";s:3:\"yes\";s:11:\"productsale\";s:3:\"yes\";s:15:\"productsale_add\";s:3:\"yes\";s:16:\"productsale_edit\";s:3:\"yes\";s:18:\"productsale_delete\";s:3:\"yes\";s:16:\"productsale_view\";s:3:\"yes\";s:13:\"leavecategory\";s:3:\"yes\";s:17:\"leavecategory_add\";s:3:\"yes\";s:18:\"leavecategory_edit\";s:3:\"yes\";s:20:\"leavecategory_delete\";s:3:\"yes\";s:11:\"leaveassign\";s:3:\"yes\";s:15:\"leaveassign_add\";s:3:\"yes\";s:16:\"leaveassign_edit\";s:3:\"yes\";s:18:\"leaveassign_delete\";s:3:\"yes\";s:10:\"leaveapply\";s:3:\"yes\";s:14:\"leaveapply_add\";s:3:\"yes\";s:15:\"leaveapply_edit\";s:3:\"yes\";s:17:\"leaveapply_delete\";s:3:\"yes\";s:15:\"leaveapply_view\";s:3:\"yes\";s:16:\"leaveapplication\";s:3:\"yes\";s:18:\"activitiescategory\";s:3:\"yes\";s:22:\"activitiescategory_add\";s:3:\"yes\";s:23:\"activitiescategory_edit\";s:3:\"yes\";s:25:\"activitiescategory_delete\";s:3:\"yes\";s:10:\"activities\";s:3:\"yes\";s:14:\"activities_add\";s:3:\"yes\";s:17:\"activities_delete\";s:3:\"yes\";s:9:\"childcare\";s:3:\"yes\";s:13:\"childcare_add\";s:3:\"yes\";s:14:\"childcare_edit\";s:3:\"yes\";s:16:\"childcare_delete\";s:3:\"yes\";s:7:\"lmember\";s:3:\"yes\";s:11:\"lmember_add\";s:3:\"yes\";s:12:\"lmember_edit\";s:3:\"yes\";s:14:\"lmember_delete\";s:3:\"yes\";s:12:\"lmember_view\";s:3:\"yes\";s:4:\"book\";s:3:\"yes\";s:8:\"book_add\";s:3:\"yes\";s:9:\"book_edit\";s:3:\"yes\";s:11:\"book_delete\";s:3:\"yes\";s:5:\"issue\";s:3:\"yes\";s:9:\"issue_add\";s:3:\"yes\";s:10:\"issue_edit\";s:3:\"yes\";s:10:\"issue_view\";s:3:\"yes\";s:6:\"ebooks\";s:3:\"yes\";s:10:\"ebooks_add\";s:3:\"yes\";s:11:\"ebooks_edit\";s:3:\"yes\";s:13:\"ebooks_delete\";s:3:\"yes\";s:11:\"ebooks_view\";s:3:\"yes\";s:9:\"transport\";s:3:\"yes\";s:13:\"transport_add\";s:3:\"yes\";s:14:\"transport_edit\";s:3:\"yes\";s:16:\"transport_delete\";s:3:\"yes\";s:7:\"tmember\";s:3:\"yes\";s:11:\"tmember_add\";s:3:\"yes\";s:12:\"tmember_edit\";s:3:\"yes\";s:14:\"tmember_delete\";s:3:\"yes\";s:12:\"tmember_view\";s:3:\"yes\";s:6:\"hostel\";s:3:\"yes\";s:10:\"hostel_add\";s:3:\"yes\";s:11:\"hostel_edit\";s:3:\"yes\";s:13:\"hostel_delete\";s:3:\"yes\";s:8:\"category\";s:3:\"yes\";s:12:\"category_add\";s:3:\"yes\";s:13:\"category_edit\";s:3:\"yes\";s:15:\"category_delete\";s:3:\"yes\";s:7:\"hmember\";s:3:\"yes\";s:11:\"hmember_add\";s:3:\"yes\";s:12:\"hmember_edit\";s:3:\"yes\";s:14:\"hmember_delete\";s:3:\"yes\";s:12:\"hmember_view\";s:3:\"yes\";s:8:\"feetypes\";s:3:\"yes\";s:12:\"feetypes_add\";s:3:\"yes\";s:13:\"feetypes_edit\";s:3:\"yes\";s:15:\"feetypes_delete\";s:3:\"yes\";s:7:\"invoice\";s:3:\"yes\";s:11:\"invoice_add\";s:3:\"yes\";s:12:\"invoice_edit\";s:3:\"yes\";s:14:\"invoice_delete\";s:3:\"yes\";s:12:\"invoice_view\";s:3:\"yes\";s:14:\"paymenthistory\";s:3:\"yes\";s:19:\"paymenthistory_edit\";s:3:\"yes\";s:21:\"paymenthistory_delete\";s:3:\"yes\";s:7:\"expense\";s:3:\"yes\";s:11:\"expense_add\";s:3:\"yes\";s:12:\"expense_edit\";s:3:\"yes\";s:14:\"expense_delete\";s:3:\"yes\";s:6:\"income\";s:3:\"yes\";s:10:\"income_add\";s:3:\"yes\";s:11:\"income_edit\";s:3:\"yes\";s:13:\"income_delete\";s:3:\"yes\";s:14:\"global_payment\";s:3:\"yes\";s:6:\"notice\";s:3:\"yes\";s:10:\"notice_add\";s:3:\"yes\";s:11:\"notice_edit\";s:3:\"yes\";s:13:\"notice_delete\";s:3:\"yes\";s:11:\"notice_view\";s:3:\"yes\";s:5:\"event\";s:3:\"yes\";s:9:\"event_add\";s:3:\"yes\";s:10:\"event_edit\";s:3:\"yes\";s:12:\"event_delete\";s:3:\"yes\";s:10:\"event_view\";s:3:\"yes\";s:7:\"holiday\";s:3:\"yes\";s:11:\"holiday_add\";s:3:\"yes\";s:12:\"holiday_edit\";s:3:\"yes\";s:14:\"holiday_delete\";s:3:\"yes\";s:12:\"holiday_view\";s:3:\"yes\";s:13:\"classesreport\";s:3:\"yes\";s:13:\"studentreport\";s:3:\"yes\";s:12:\"idcardreport\";s:3:\"yes\";s:15:\"admitcardreport\";s:3:\"yes\";s:13:\"routinereport\";s:3:\"yes\";s:18:\"examschedulereport\";s:3:\"yes\";s:16:\"attendancereport\";s:3:\"yes\";s:24:\"attendanceoverviewreport\";s:3:\"yes\";s:18:\"librarybooksreport\";s:3:\"yes\";s:17:\"librarycardreport\";s:3:\"yes\";s:22:\"librarybookissuereport\";s:3:\"yes\";s:14:\"terminalreport\";s:3:\"yes\";s:16:\"meritstagereport\";s:3:\"yes\";s:21:\"tabulationsheetreport\";s:3:\"yes\";s:15:\"marksheetreport\";s:3:\"yes\";s:18:\"progresscardreport\";s:3:\"yes\";s:20:\"studentsessionreport\";s:3:\"yes\";s:16:\"onlineexamreport\";s:3:\"yes\";s:24:\"onlineexamquestionreport\";s:3:\"yes\";s:21:\"onlineadmissionreport\";s:3:\"yes\";s:17:\"certificatereport\";s:3:\"yes\";s:22:\"leaveapplicationreport\";s:3:\"yes\";s:21:\"productpurchasereport\";s:3:\"yes\";s:17:\"productsalereport\";s:3:\"yes\";s:23:\"searchpaymentfeesreport\";s:3:\"yes\";s:10:\"feesreport\";s:3:\"yes\";s:13:\"duefeesreport\";s:3:\"yes\";s:17:\"balancefeesreport\";s:3:\"yes\";s:17:\"transactionreport\";s:3:\"yes\";s:17:\"studentfinereport\";s:3:\"yes\";s:14:\"overtimereport\";s:3:\"yes\";s:12:\"salaryreport\";s:3:\"yes\";s:19:\"accountledgerreport\";s:3:\"yes\";s:15:\"onlineadmission\";s:3:\"yes\";s:11:\"visitorinfo\";s:3:\"yes\";s:18:\"visitorinfo_delete\";s:3:\"yes\";s:16:\"visitorinfo_view\";s:3:\"yes\";s:10:\"schoolyear\";s:3:\"yes\";s:14:\"schoolyear_add\";s:3:\"yes\";s:15:\"schoolyear_edit\";s:3:\"yes\";s:17:\"schoolyear_delete\";s:3:\"yes\";s:12:\"studentgroup\";s:3:\"yes\";s:16:\"studentgroup_add\";s:3:\"yes\";s:17:\"studentgroup_edit\";s:3:\"yes\";s:19:\"studentgroup_delete\";s:3:\"yes\";s:8:\"complain\";s:3:\"yes\";s:12:\"complain_add\";s:3:\"yes\";s:13:\"complain_edit\";s:3:\"yes\";s:15:\"complain_delete\";s:3:\"yes\";s:13:\"complain_view\";s:3:\"yes\";s:20:\"certificate_template\";s:3:\"yes\";s:24:\"certificate_template_add\";s:3:\"yes\";s:25:\"certificate_template_edit\";s:3:\"yes\";s:27:\"certificate_template_delete\";s:3:\"yes\";s:25:\"certificate_template_view\";s:3:\"yes\";s:11:\"systemadmin\";s:3:\"yes\";s:15:\"systemadmin_add\";s:3:\"yes\";s:16:\"systemadmin_edit\";s:3:\"yes\";s:18:\"systemadmin_delete\";s:3:\"yes\";s:16:\"systemadmin_view\";s:3:\"yes\";s:13:\"resetpassword\";s:3:\"yes\";s:10:\"sociallink\";s:3:\"yes\";s:14:\"sociallink_add\";s:3:\"yes\";s:15:\"sociallink_edit\";s:3:\"yes\";s:17:\"sociallink_delete\";s:3:\"yes\";s:18:\"mailandsmstemplate\";s:3:\"yes\";s:22:\"mailandsmstemplate_add\";s:3:\"yes\";s:23:\"mailandsmstemplate_edit\";s:3:\"yes\";s:25:\"mailandsmstemplate_delete\";s:3:\"yes\";s:23:\"mailandsmstemplate_view\";s:3:\"yes\";s:10:\"bulkimport\";s:3:\"yes\";s:6:\"backup\";s:3:\"yes\";s:8:\"usertype\";s:3:\"yes\";s:12:\"usertype_add\";s:3:\"yes\";s:13:\"usertype_edit\";s:3:\"yes\";s:15:\"usertype_delete\";s:3:\"yes\";s:10:\"permission\";s:3:\"yes\";s:6:\"addons\";s:3:\"yes\";s:6:\"update\";s:3:\"yes\";s:16:\"posts_categories\";s:3:\"yes\";s:20:\"posts_categories_add\";s:3:\"yes\";s:21:\"posts_categories_edit\";s:3:\"yes\";s:23:\"posts_categories_delete\";s:3:\"yes\";s:5:\"posts\";s:3:\"yes\";s:9:\"posts_add\";s:3:\"yes\";s:10:\"posts_edit\";s:3:\"yes\";s:12:\"posts_delete\";s:3:\"yes\";s:5:\"pages\";s:3:\"yes\";s:9:\"pages_add\";s:3:\"yes\";s:10:\"pages_edit\";s:3:\"yes\";s:12:\"pages_delete\";s:3:\"yes\";s:12:\"frontendmenu\";s:3:\"yes\";s:7:\"setting\";s:3:\"yes\";s:16:\"frontend_setting\";s:3:\"yes\";s:15:\"paymentsettings\";s:3:\"yes\";s:11:\"smssettings\";s:3:\"yes\";s:12:\"emailsetting\";s:3:\"yes\";s:11:\"marksetting\";s:3:\"yes\";s:9:\"candidate\";s:3:\"yes\";s:13:\"candidate_add\";s:3:\"yes\";s:14:\"candidate_edit\";s:3:\"yes\";s:16:\"candidate_delete\";s:3:\"yes\";s:14:\"candidate_view\";s:3:\"yes\";s:7:\"sponsor\";s:3:\"yes\";s:11:\"sponsor_add\";s:3:\"yes\";s:12:\"sponsor_edit\";s:3:\"yes\";s:14:\"sponsor_delete\";s:3:\"yes\";s:12:\"sponsor_view\";s:3:\"yes\";s:11:\"sponsorship\";s:3:\"yes\";s:15:\"sponsorship_add\";s:3:\"yes\";s:16:\"sponsorship_edit\";s:3:\"yes\";s:18:\"sponsorship_delete\";s:3:\"yes\";s:17:\"sponsorshipreport\";s:3:\"yes\";s:30:\"onlineexamquestionanswerreport\";s:3:\"yes\";s:10:\"attendance\";s:3:\"yes\";s:25:\"student_attendance_report\";s:3:\"yes\";s:25:\"teacher_attendance_report\";s:3:\"yes\";s:22:\"user_attendance_report\";s:3:\"yes\";s:17:\"qrcode_attendance\";s:3:\"yes\";s:5:\"mpesa\";s:3:\"yes\";s:20:\"vendorpurchasereport\";s:3:\"yes\";s:18:\"itempurchasereport\";s:3:\"yes\";s:22:\"categorypurchasereport\";s:3:\"yes\";s:14:\"itemsalereport\";s:3:\"yes\";s:18:\"categorysalereport\";s:3:\"yes\";s:6:\"wallet\";s:3:\"yes\";s:5:\"lunch\";s:3:\"yes\";s:12:\"lunchsetting\";s:3:\"yes\";s:9:\"lunchlogs\";s:3:\"yes\";s:10:\"schoolterm\";s:3:\"yes\";s:14:\"schoolterm_add\";s:3:\"yes\";s:15:\"schoolterm_edit\";s:3:\"yes\";s:17:\"schoolterm_delete\";s:3:\"yes\";s:15:\"schoolterm_view\";s:3:\"yes\";s:15:\"generate_qrcode\";s:3:\"yes\";s:10:\"studentids\";s:3:\"yes\";s:17:\"studentids_delete\";s:3:\"yes\";s:17:\"cbcterminalreport\";s:3:\"yes\";s:9:\"smsreport\";s:3:\"yes\";s:7:\"sendsms\";s:3:\"yes\";s:15:\"studentleaveout\";s:3:\"yes\";s:20:\"studentleaveout_edit\";s:3:\"yes\";s:20:\"studentleaveout_view\";s:3:\"yes\";s:22:\"studentleaveout_delete\";s:3:\"yes\";s:13:\"backup_delete\";s:3:\"yes\";s:10:\"backup_add\";s:3:\"yes\";s:14:\"backup_restore\";s:3:\"yes\";s:9:\"take_exam\";s:3:\"yes\";}');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('275de68d9fab31520b7de6080657c9c9259f515b', '102.222.4.116', 1713333889, '__ci_last_regenerate|i:1713333889;english|N;loginuserID|s:2:\"10\";name|s:14:\"PENINAH MUTUKU\";email|s:17:\"peninah@email.com\";usertypeID|s:1:\"7\";usertype|s:12:\"Receptionist\";username|s:7:\"peninah\";photo|s:11:\"peninah.JPG\";lang|s:7:\"english\";defaultschoolyearID|s:1:\"4\";varifyvaliduser|b:1;loggedin|b:1;get_permission|b:1;master_permission_set|a:426:{s:9:\"dashboard\";s:3:\"yes\";s:7:\"student\";s:3:\"yes\";s:11:\"student_add\";s:3:\"yes\";s:12:\"student_edit\";s:3:\"yes\";s:7:\"teacher\";s:3:\"yes\";s:11:\"teacher_add\";s:3:\"yes\";s:12:\"teacher_edit\";s:3:\"yes\";s:12:\"conversation\";s:3:\"yes\";s:6:\"notice\";s:3:\"yes\";s:10:\"notice_add\";s:3:\"yes\";s:11:\"notice_edit\";s:3:\"yes\";s:5:\"event\";s:3:\"yes\";s:9:\"event_add\";s:3:\"yes\";s:10:\"event_edit\";s:3:\"yes\";s:7:\"holiday\";s:3:\"yes\";s:12:\"holiday_view\";s:3:\"yes\";s:14:\"terminalreport\";s:3:\"yes\";s:17:\"qrcode_attendance\";s:3:\"yes\";s:10:\"mailandsms\";s:3:\"yes\";s:14:\"mailandsms_add\";s:3:\"yes\";s:15:\"mailandsms_view\";s:3:\"yes\";s:25:\"student_attendance_report\";s:3:\"yes\";s:25:\"teacher_attendance_report\";s:3:\"yes\";s:22:\"user_attendance_report\";s:3:\"yes\";s:10:\"studentids\";s:3:\"yes\";s:17:\"studentids_delete\";s:3:\"yes\";s:7:\"lmember\";s:3:\"yes\";s:11:\"lmember_add\";s:3:\"yes\";s:12:\"lmember_edit\";s:3:\"yes\";s:14:\"lmember_delete\";s:3:\"yes\";s:12:\"lmember_view\";s:3:\"yes\";s:4:\"book\";s:3:\"yes\";s:8:\"book_add\";s:3:\"yes\";s:9:\"book_edit\";s:3:\"yes\";s:11:\"book_delete\";s:3:\"yes\";s:5:\"issue\";s:3:\"yes\";s:9:\"issue_add\";s:3:\"yes\";s:10:\"issue_edit\";s:3:\"yes\";s:10:\"issue_view\";s:3:\"yes\";s:14:\"student_delete\";s:2:\"no\";s:12:\"student_view\";s:2:\"no\";s:7:\"parents\";s:2:\"no\";s:11:\"parents_add\";s:2:\"no\";s:12:\"parents_edit\";s:2:\"no\";s:14:\"parents_delete\";s:2:\"no\";s:12:\"parents_view\";s:2:\"no\";s:14:\"teacher_delete\";s:2:\"no\";s:12:\"teacher_view\";s:2:\"no\";s:4:\"user\";s:2:\"no\";s:8:\"user_add\";s:2:\"no\";s:9:\"user_edit\";s:2:\"no\";s:11:\"user_delete\";s:2:\"no\";s:9:\"user_view\";s:2:\"no\";s:7:\"classes\";s:2:\"no\";s:11:\"classes_add\";s:2:\"no\";s:12:\"classes_edit\";s:2:\"no\";s:14:\"classes_delete\";s:2:\"no\";s:7:\"section\";s:2:\"no\";s:11:\"section_add\";s:2:\"no\";s:12:\"section_edit\";s:2:\"no\";s:15:\"semester_delete\";s:2:\"no\";s:14:\"section_delete\";s:2:\"no\";s:7:\"subject\";s:2:\"no\";s:11:\"subject_add\";s:2:\"no\";s:12:\"subject_edit\";s:2:\"no\";s:14:\"subject_delete\";s:2:\"no\";s:8:\"syllabus\";s:2:\"no\";s:12:\"syllabus_add\";s:2:\"no\";s:13:\"syllabus_edit\";s:2:\"no\";s:15:\"syllabus_delete\";s:2:\"no\";s:10:\"assignment\";s:2:\"no\";s:14:\"assignment_add\";s:2:\"no\";s:15:\"assignment_edit\";s:2:\"no\";s:17:\"assignment_delete\";s:2:\"no\";s:15:\"assignment_view\";s:2:\"no\";s:7:\"routine\";s:2:\"no\";s:11:\"routine_add\";s:2:\"no\";s:12:\"routine_edit\";s:2:\"no\";s:14:\"routine_delete\";s:2:\"no\";s:11:\"sattendance\";s:2:\"no\";s:15:\"sattendance_add\";s:2:\"no\";s:16:\"sattendance_view\";s:2:\"no\";s:11:\"tattendance\";s:2:\"no\";s:15:\"tattendance_add\";s:2:\"no\";s:16:\"tattendance_view\";s:2:\"no\";s:11:\"uattendance\";s:2:\"no\";s:15:\"uattendance_add\";s:2:\"no\";s:16:\"uattendance_view\";s:2:\"no\";s:4:\"exam\";s:2:\"no\";s:8:\"exam_add\";s:2:\"no\";s:9:\"exam_edit\";s:2:\"no\";s:11:\"exam_delete\";s:2:\"no\";s:12:\"examschedule\";s:2:\"no\";s:16:\"examschedule_add\";s:2:\"no\";s:17:\"examschedule_edit\";s:2:\"no\";s:19:\"examschedule_delete\";s:2:\"no\";s:5:\"grade\";s:2:\"no\";s:9:\"grade_add\";s:2:\"no\";s:10:\"grade_edit\";s:2:\"no\";s:12:\"grade_delete\";s:2:\"no\";s:11:\"eattendance\";s:2:\"no\";s:15:\"eattendance_add\";s:2:\"no\";s:4:\"mark\";s:2:\"no\";s:8:\"mark_add\";s:2:\"no\";s:9:\"mark_view\";s:2:\"no\";s:14:\"markpercentage\";s:2:\"no\";s:18:\"markpercentage_add\";s:2:\"no\";s:19:\"markpercentage_edit\";s:2:\"no\";s:21:\"markpercentage_delete\";s:2:\"no\";s:9:\"promotion\";s:2:\"no\";s:5:\"media\";s:2:\"no\";s:9:\"media_add\";s:2:\"no\";s:12:\"media_delete\";s:2:\"no\";s:14:\"question_group\";s:2:\"no\";s:18:\"question_group_add\";s:2:\"no\";s:19:\"question_group_edit\";s:2:\"no\";s:21:\"question_group_delete\";s:2:\"no\";s:14:\"question_level\";s:2:\"no\";s:18:\"question_level_add\";s:2:\"no\";s:19:\"question_level_edit\";s:2:\"no\";s:21:\"question_level_delete\";s:2:\"no\";s:13:\"question_bank\";s:2:\"no\";s:17:\"question_bank_add\";s:2:\"no\";s:18:\"question_bank_edit\";s:2:\"no\";s:20:\"question_bank_delete\";s:2:\"no\";s:18:\"question_bank_view\";s:2:\"no\";s:11:\"online_exam\";s:2:\"no\";s:15:\"online_exam_add\";s:2:\"no\";s:16:\"online_exam_edit\";s:2:\"no\";s:18:\"online_exam_delete\";s:2:\"no\";s:11:\"instruction\";s:2:\"no\";s:15:\"instruction_add\";s:2:\"no\";s:16:\"instruction_edit\";s:2:\"no\";s:18:\"instruction_delete\";s:2:\"no\";s:16:\"instruction_view\";s:2:\"no\";s:15:\"salary_template\";s:2:\"no\";s:19:\"salary_template_add\";s:2:\"no\";s:20:\"salary_template_edit\";s:2:\"no\";s:22:\"salary_template_delete\";s:2:\"no\";s:20:\"salary_template_view\";s:2:\"no\";s:15:\"hourly_template\";s:2:\"no\";s:19:\"hourly_template_add\";s:2:\"no\";s:20:\"hourly_template_edit\";s:2:\"no\";s:22:\"hourly_template_delete\";s:2:\"no\";s:13:\"manage_salary\";s:2:\"no\";s:17:\"manage_salary_add\";s:2:\"no\";s:18:\"manage_salary_edit\";s:2:\"no\";s:20:\"manage_salary_delete\";s:2:\"no\";s:18:\"manage_salary_view\";s:2:\"no\";s:12:\"make_payment\";s:2:\"no\";s:8:\"overtime\";s:2:\"no\";s:12:\"overtime_add\";s:2:\"no\";s:13:\"overtime_edit\";s:2:\"no\";s:15:\"overtime_delete\";s:2:\"no\";s:6:\"vendor\";s:2:\"no\";s:10:\"vendor_add\";s:2:\"no\";s:11:\"vendor_edit\";s:2:\"no\";s:13:\"vendor_delete\";s:2:\"no\";s:8:\"location\";s:2:\"no\";s:12:\"location_add\";s:2:\"no\";s:13:\"location_edit\";s:2:\"no\";s:15:\"location_delete\";s:2:\"no\";s:14:\"asset_category\";s:2:\"no\";s:18:\"asset_category_add\";s:2:\"no\";s:19:\"asset_category_edit\";s:2:\"no\";s:21:\"asset_category_delete\";s:2:\"no\";s:5:\"asset\";s:2:\"no\";s:9:\"asset_add\";s:2:\"no\";s:10:\"asset_edit\";s:2:\"no\";s:12:\"asset_delete\";s:2:\"no\";s:10:\"asset_view\";s:2:\"no\";s:16:\"asset_assignment\";s:2:\"no\";s:20:\"asset_assignment_add\";s:2:\"no\";s:21:\"asset_assignment_edit\";s:2:\"no\";s:23:\"asset_assignment_delete\";s:2:\"no\";s:21:\"asset_assignment_view\";s:2:\"no\";s:8:\"purchase\";s:2:\"no\";s:12:\"purchase_add\";s:2:\"no\";s:13:\"purchase_edit\";s:2:\"no\";s:15:\"purchase_delete\";s:2:\"no\";s:15:\"productcategory\";s:2:\"no\";s:19:\"productcategory_add\";s:2:\"no\";s:20:\"productcategory_edit\";s:2:\"no\";s:22:\"productcategory_delete\";s:2:\"no\";s:7:\"product\";s:2:\"no\";s:11:\"product_add\";s:2:\"no\";s:12:\"product_edit\";s:2:\"no\";s:14:\"product_delete\";s:2:\"no\";s:16:\"productwarehouse\";s:2:\"no\";s:20:\"productwarehouse_add\";s:2:\"no\";s:21:\"productwarehouse_edit\";s:2:\"no\";s:23:\"productwarehouse_delete\";s:2:\"no\";s:15:\"productsupplier\";s:2:\"no\";s:19:\"productsupplier_add\";s:2:\"no\";s:20:\"productsupplier_edit\";s:2:\"no\";s:22:\"productsupplier_delete\";s:2:\"no\";s:15:\"productpurchase\";s:2:\"no\";s:19:\"productpurchase_add\";s:2:\"no\";s:20:\"productpurchase_edit\";s:2:\"no\";s:22:\"productpurchase_delete\";s:2:\"no\";s:20:\"productpurchase_view\";s:2:\"no\";s:11:\"productsale\";s:2:\"no\";s:15:\"productsale_add\";s:2:\"no\";s:16:\"productsale_edit\";s:2:\"no\";s:18:\"productsale_delete\";s:2:\"no\";s:16:\"productsale_view\";s:2:\"no\";s:13:\"leavecategory\";s:2:\"no\";s:17:\"leavecategory_add\";s:2:\"no\";s:18:\"leavecategory_edit\";s:2:\"no\";s:20:\"leavecategory_delete\";s:2:\"no\";s:11:\"leaveassign\";s:2:\"no\";s:15:\"leaveassign_add\";s:2:\"no\";s:16:\"leaveassign_edit\";s:2:\"no\";s:18:\"leaveassign_delete\";s:2:\"no\";s:10:\"leaveapply\";s:2:\"no\";s:14:\"leaveapply_add\";s:2:\"no\";s:15:\"leaveapply_edit\";s:2:\"no\";s:17:\"leaveapply_delete\";s:2:\"no\";s:15:\"leaveapply_view\";s:2:\"no\";s:16:\"leaveapplication\";s:2:\"no\";s:18:\"activitiescategory\";s:2:\"no\";s:22:\"activitiescategory_add\";s:2:\"no\";s:23:\"activitiescategory_edit\";s:2:\"no\";s:25:\"activitiescategory_delete\";s:2:\"no\";s:10:\"activities\";s:2:\"no\";s:14:\"activities_add\";s:2:\"no\";s:17:\"activities_delete\";s:2:\"no\";s:9:\"childcare\";s:2:\"no\";s:13:\"childcare_add\";s:2:\"no\";s:14:\"childcare_edit\";s:2:\"no\";s:16:\"childcare_delete\";s:2:\"no\";s:6:\"ebooks\";s:2:\"no\";s:10:\"ebooks_add\";s:2:\"no\";s:11:\"ebooks_edit\";s:2:\"no\";s:13:\"ebooks_delete\";s:2:\"no\";s:11:\"ebooks_view\";s:2:\"no\";s:9:\"transport\";s:2:\"no\";s:13:\"transport_add\";s:2:\"no\";s:14:\"transport_edit\";s:2:\"no\";s:16:\"transport_delete\";s:2:\"no\";s:7:\"tmember\";s:2:\"no\";s:11:\"tmember_add\";s:2:\"no\";s:12:\"tmember_edit\";s:2:\"no\";s:14:\"tmember_delete\";s:2:\"no\";s:12:\"tmember_view\";s:2:\"no\";s:6:\"hostel\";s:2:\"no\";s:10:\"hostel_add\";s:2:\"no\";s:11:\"hostel_edit\";s:2:\"no\";s:13:\"hostel_delete\";s:2:\"no\";s:8:\"category\";s:2:\"no\";s:12:\"category_add\";s:2:\"no\";s:13:\"category_edit\";s:2:\"no\";s:15:\"category_delete\";s:2:\"no\";s:7:\"hmember\";s:2:\"no\";s:11:\"hmember_add\";s:2:\"no\";s:12:\"hmember_edit\";s:2:\"no\";s:14:\"hmember_delete\";s:2:\"no\";s:12:\"hmember_view\";s:2:\"no\";s:8:\"feetypes\";s:2:\"no\";s:12:\"feetypes_add\";s:2:\"no\";s:13:\"feetypes_edit\";s:2:\"no\";s:15:\"feetypes_delete\";s:2:\"no\";s:7:\"invoice\";s:2:\"no\";s:11:\"invoice_add\";s:2:\"no\";s:12:\"invoice_edit\";s:2:\"no\";s:14:\"invoice_delete\";s:2:\"no\";s:12:\"invoice_view\";s:2:\"no\";s:14:\"paymenthistory\";s:2:\"no\";s:19:\"paymenthistory_edit\";s:2:\"no\";s:21:\"paymenthistory_delete\";s:2:\"no\";s:7:\"expense\";s:2:\"no\";s:11:\"expense_add\";s:2:\"no\";s:12:\"expense_edit\";s:2:\"no\";s:14:\"expense_delete\";s:2:\"no\";s:6:\"income\";s:2:\"no\";s:10:\"income_add\";s:2:\"no\";s:11:\"income_edit\";s:2:\"no\";s:13:\"income_delete\";s:2:\"no\";s:14:\"global_payment\";s:2:\"no\";s:13:\"notice_delete\";s:2:\"no\";s:11:\"notice_view\";s:2:\"no\";s:12:\"event_delete\";s:2:\"no\";s:10:\"event_view\";s:2:\"no\";s:11:\"holiday_add\";s:2:\"no\";s:12:\"holiday_edit\";s:2:\"no\";s:14:\"holiday_delete\";s:2:\"no\";s:13:\"classesreport\";s:2:\"no\";s:13:\"studentreport\";s:2:\"no\";s:12:\"idcardreport\";s:2:\"no\";s:15:\"admitcardreport\";s:2:\"no\";s:13:\"routinereport\";s:2:\"no\";s:18:\"examschedulereport\";s:2:\"no\";s:16:\"attendancereport\";s:2:\"no\";s:24:\"attendanceoverviewreport\";s:2:\"no\";s:18:\"librarybooksreport\";s:2:\"no\";s:17:\"librarycardreport\";s:2:\"no\";s:22:\"librarybookissuereport\";s:2:\"no\";s:16:\"meritstagereport\";s:2:\"no\";s:21:\"tabulationsheetreport\";s:2:\"no\";s:15:\"marksheetreport\";s:2:\"no\";s:18:\"progresscardreport\";s:2:\"no\";s:20:\"studentsessionreport\";s:2:\"no\";s:16:\"onlineexamreport\";s:2:\"no\";s:24:\"onlineexamquestionreport\";s:2:\"no\";s:21:\"onlineadmissionreport\";s:2:\"no\";s:17:\"certificatereport\";s:2:\"no\";s:22:\"leaveapplicationreport\";s:2:\"no\";s:21:\"productpurchasereport\";s:2:\"no\";s:17:\"productsalereport\";s:2:\"no\";s:23:\"searchpaymentfeesreport\";s:2:\"no\";s:10:\"feesreport\";s:2:\"no\";s:13:\"duefeesreport\";s:2:\"no\";s:17:\"balancefeesreport\";s:2:\"no\";s:17:\"transactionreport\";s:2:\"no\";s:17:\"studentfinereport\";s:2:\"no\";s:14:\"overtimereport\";s:2:\"no\";s:12:\"salaryreport\";s:2:\"no\";s:19:\"accountledgerreport\";s:2:\"no\";s:15:\"onlineadmission\";s:2:\"no\";s:11:\"visitorinfo\";s:2:\"no\";s:18:\"visitorinfo_delete\";s:2:\"no\";s:16:\"visitorinfo_view\";s:2:\"no\";s:10:\"schoolyear\";s:2:\"no\";s:14:\"schoolyear_add\";s:2:\"no\";s:15:\"schoolyear_edit\";s:2:\"no\";s:17:\"schoolyear_delete\";s:2:\"no\";s:12:\"studentgroup\";s:2:\"no\";s:16:\"studentgroup_add\";s:2:\"no\";s:17:\"studentgroup_edit\";s:2:\"no\";s:19:\"studentgroup_delete\";s:2:\"no\";s:8:\"complain\";s:2:\"no\";s:12:\"complain_add\";s:2:\"no\";s:13:\"complain_edit\";s:2:\"no\";s:15:\"complain_delete\";s:2:\"no\";s:13:\"complain_view\";s:2:\"no\";s:20:\"certificate_template\";s:2:\"no\";s:24:\"certificate_template_add\";s:2:\"no\";s:25:\"certificate_template_edit\";s:2:\"no\";s:27:\"certificate_template_delete\";s:2:\"no\";s:25:\"certificate_template_view\";s:2:\"no\";s:11:\"systemadmin\";s:2:\"no\";s:15:\"systemadmin_add\";s:2:\"no\";s:16:\"systemadmin_edit\";s:2:\"no\";s:18:\"systemadmin_delete\";s:2:\"no\";s:16:\"systemadmin_view\";s:2:\"no\";s:13:\"resetpassword\";s:2:\"no\";s:10:\"sociallink\";s:2:\"no\";s:14:\"sociallink_add\";s:2:\"no\";s:15:\"sociallink_edit\";s:2:\"no\";s:17:\"sociallink_delete\";s:2:\"no\";s:18:\"mailandsmstemplate\";s:2:\"no\";s:22:\"mailandsmstemplate_add\";s:2:\"no\";s:23:\"mailandsmstemplate_edit\";s:2:\"no\";s:25:\"mailandsmstemplate_delete\";s:2:\"no\";s:23:\"mailandsmstemplate_view\";s:2:\"no\";s:11:\"bulkimport \";s:2:\"no\";s:6:\"backup\";s:2:\"no\";s:8:\"usertype\";s:2:\"no\";s:12:\"usertype_add\";s:2:\"no\";s:13:\"usertype_edit\";s:2:\"no\";s:15:\"usertype_delete\";s:2:\"no\";s:10:\"permission\";s:2:\"no\";s:6:\"addons\";s:2:\"no\";s:6:\"update\";s:2:\"no\";s:16:\"posts_categories\";s:2:\"no\";s:20:\"posts_categories_add\";s:2:\"no\";s:21:\"posts_categories_edit\";s:2:\"no\";s:23:\"posts_categories_delete\";s:2:\"no\";s:5:\"posts\";s:2:\"no\";s:9:\"posts_add\";s:2:\"no\";s:10:\"posts_edit\";s:2:\"no\";s:12:\"posts_delete\";s:2:\"no\";s:5:\"pages\";s:2:\"no\";s:9:\"pages_add\";s:2:\"no\";s:10:\"pages_edit\";s:2:\"no\";s:12:\"pages_delete\";s:2:\"no\";s:12:\"frontendmenu\";s:2:\"no\";s:7:\"setting\";s:2:\"no\";s:16:\"frontend_setting\";s:2:\"no\";s:15:\"paymentsettings\";s:2:\"no\";s:11:\"smssettings\";s:2:\"no\";s:12:\"emailsetting\";s:2:\"no\";s:11:\"marksetting\";s:2:\"no\";s:9:\"candidate\";s:2:\"no\";s:13:\"candidate_add\";s:2:\"no\";s:14:\"candidate_edit\";s:2:\"no\";s:16:\"candidate_delete\";s:2:\"no\";s:14:\"candidate_view\";s:2:\"no\";s:7:\"sponsor\";s:2:\"no\";s:11:\"sponsor_add\";s:2:\"no\";s:12:\"sponsor_edit\";s:2:\"no\";s:14:\"sponsor_delete\";s:2:\"no\";s:12:\"sponsor_view\";s:2:\"no\";s:11:\"sponsorship\";s:2:\"no\";s:15:\"sponsorship_add\";s:2:\"no\";s:16:\"sponsorship_edit\";s:2:\"no\";s:18:\"sponsorship_delete\";s:2:\"no\";s:17:\"sponsorshipreport\";s:2:\"no\";s:30:\"onlineexamquestionanswerreport\";s:2:\"no\";s:10:\"attendance\";s:2:\"no\";s:5:\"mpesa\";s:2:\"no\";s:20:\"vendorpurchasereport\";s:2:\"no\";s:18:\"itempurchasereport\";s:2:\"no\";s:22:\"categorypurchasereport\";s:2:\"no\";s:14:\"itemsalereport\";s:2:\"no\";s:18:\"categorysalereport\";s:2:\"no\";s:6:\"wallet\";s:2:\"no\";s:5:\"lunch\";s:2:\"no\";s:12:\"lunchsetting\";s:2:\"no\";s:9:\"lunchlogs\";s:2:\"no\";s:10:\"schoolterm\";s:2:\"no\";s:14:\"schoolterm_add\";s:2:\"no\";s:15:\"schoolterm_edit\";s:2:\"no\";s:17:\"schoolterm_delete\";s:2:\"no\";s:15:\"schoolterm_view\";s:2:\"no\";s:15:\"generate_qrcode\";s:2:\"no\";s:17:\"cbcterminalreport\";s:2:\"no\";s:9:\"smsreport\";s:2:\"no\";s:7:\"sendsms\";s:2:\"no\";s:15:\"studentleaveout\";s:2:\"no\";s:20:\"studentleaveout_edit\";s:2:\"no\";s:20:\"studentleaveout_view\";s:2:\"no\";s:22:\"studentleaveout_delete\";s:2:\"no\";s:13:\"backup_delete\";s:2:\"no\";s:10:\"backup_add\";s:2:\"no\";s:14:\"backup_restore\";s:2:\"no\";}');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('db5721e699347b511ca8477265f0bb7f4bbdd029', '102.222.4.116', 1713337655, '__ci_last_regenerate|i:1713337655;english|N;loginuserID|s:2:\"10\";name|s:14:\"PENINAH MUTUKU\";email|s:17:\"peninah@email.com\";usertypeID|s:1:\"7\";usertype|s:12:\"Receptionist\";username|s:7:\"peninah\";photo|s:11:\"peninah.JPG\";lang|s:7:\"english\";defaultschoolyearID|s:1:\"4\";varifyvaliduser|b:1;loggedin|b:1;get_permission|b:1;master_permission_set|a:426:{s:9:\"dashboard\";s:3:\"yes\";s:7:\"student\";s:3:\"yes\";s:11:\"student_add\";s:3:\"yes\";s:12:\"student_edit\";s:3:\"yes\";s:7:\"teacher\";s:3:\"yes\";s:11:\"teacher_add\";s:3:\"yes\";s:12:\"teacher_edit\";s:3:\"yes\";s:12:\"conversation\";s:3:\"yes\";s:6:\"notice\";s:3:\"yes\";s:10:\"notice_add\";s:3:\"yes\";s:11:\"notice_edit\";s:3:\"yes\";s:5:\"event\";s:3:\"yes\";s:9:\"event_add\";s:3:\"yes\";s:10:\"event_edit\";s:3:\"yes\";s:7:\"holiday\";s:3:\"yes\";s:12:\"holiday_view\";s:3:\"yes\";s:14:\"terminalreport\";s:3:\"yes\";s:17:\"qrcode_attendance\";s:3:\"yes\";s:10:\"mailandsms\";s:3:\"yes\";s:14:\"mailandsms_add\";s:3:\"yes\";s:15:\"mailandsms_view\";s:3:\"yes\";s:25:\"student_attendance_report\";s:3:\"yes\";s:25:\"teacher_attendance_report\";s:3:\"yes\";s:22:\"user_attendance_report\";s:3:\"yes\";s:10:\"studentids\";s:3:\"yes\";s:17:\"studentids_delete\";s:3:\"yes\";s:7:\"lmember\";s:3:\"yes\";s:11:\"lmember_add\";s:3:\"yes\";s:12:\"lmember_edit\";s:3:\"yes\";s:14:\"lmember_delete\";s:3:\"yes\";s:12:\"lmember_view\";s:3:\"yes\";s:4:\"book\";s:3:\"yes\";s:8:\"book_add\";s:3:\"yes\";s:9:\"book_edit\";s:3:\"yes\";s:11:\"book_delete\";s:3:\"yes\";s:5:\"issue\";s:3:\"yes\";s:9:\"issue_add\";s:3:\"yes\";s:10:\"issue_edit\";s:3:\"yes\";s:10:\"issue_view\";s:3:\"yes\";s:14:\"student_delete\";s:2:\"no\";s:12:\"student_view\";s:2:\"no\";s:7:\"parents\";s:2:\"no\";s:11:\"parents_add\";s:2:\"no\";s:12:\"parents_edit\";s:2:\"no\";s:14:\"parents_delete\";s:2:\"no\";s:12:\"parents_view\";s:2:\"no\";s:14:\"teacher_delete\";s:2:\"no\";s:12:\"teacher_view\";s:2:\"no\";s:4:\"user\";s:2:\"no\";s:8:\"user_add\";s:2:\"no\";s:9:\"user_edit\";s:2:\"no\";s:11:\"user_delete\";s:2:\"no\";s:9:\"user_view\";s:2:\"no\";s:7:\"classes\";s:2:\"no\";s:11:\"classes_add\";s:2:\"no\";s:12:\"classes_edit\";s:2:\"no\";s:14:\"classes_delete\";s:2:\"no\";s:7:\"section\";s:2:\"no\";s:11:\"section_add\";s:2:\"no\";s:12:\"section_edit\";s:2:\"no\";s:15:\"semester_delete\";s:2:\"no\";s:14:\"section_delete\";s:2:\"no\";s:7:\"subject\";s:2:\"no\";s:11:\"subject_add\";s:2:\"no\";s:12:\"subject_edit\";s:2:\"no\";s:14:\"subject_delete\";s:2:\"no\";s:8:\"syllabus\";s:2:\"no\";s:12:\"syllabus_add\";s:2:\"no\";s:13:\"syllabus_edit\";s:2:\"no\";s:15:\"syllabus_delete\";s:2:\"no\";s:10:\"assignment\";s:2:\"no\";s:14:\"assignment_add\";s:2:\"no\";s:15:\"assignment_edit\";s:2:\"no\";s:17:\"assignment_delete\";s:2:\"no\";s:15:\"assignment_view\";s:2:\"no\";s:7:\"routine\";s:2:\"no\";s:11:\"routine_add\";s:2:\"no\";s:12:\"routine_edit\";s:2:\"no\";s:14:\"routine_delete\";s:2:\"no\";s:11:\"sattendance\";s:2:\"no\";s:15:\"sattendance_add\";s:2:\"no\";s:16:\"sattendance_view\";s:2:\"no\";s:11:\"tattendance\";s:2:\"no\";s:15:\"tattendance_add\";s:2:\"no\";s:16:\"tattendance_view\";s:2:\"no\";s:11:\"uattendance\";s:2:\"no\";s:15:\"uattendance_add\";s:2:\"no\";s:16:\"uattendance_view\";s:2:\"no\";s:4:\"exam\";s:2:\"no\";s:8:\"exam_add\";s:2:\"no\";s:9:\"exam_edit\";s:2:\"no\";s:11:\"exam_delete\";s:2:\"no\";s:12:\"examschedule\";s:2:\"no\";s:16:\"examschedule_add\";s:2:\"no\";s:17:\"examschedule_edit\";s:2:\"no\";s:19:\"examschedule_delete\";s:2:\"no\";s:5:\"grade\";s:2:\"no\";s:9:\"grade_add\";s:2:\"no\";s:10:\"grade_edit\";s:2:\"no\";s:12:\"grade_delete\";s:2:\"no\";s:11:\"eattendance\";s:2:\"no\";s:15:\"eattendance_add\";s:2:\"no\";s:4:\"mark\";s:2:\"no\";s:8:\"mark_add\";s:2:\"no\";s:9:\"mark_view\";s:2:\"no\";s:14:\"markpercentage\";s:2:\"no\";s:18:\"markpercentage_add\";s:2:\"no\";s:19:\"markpercentage_edit\";s:2:\"no\";s:21:\"markpercentage_delete\";s:2:\"no\";s:9:\"promotion\";s:2:\"no\";s:5:\"media\";s:2:\"no\";s:9:\"media_add\";s:2:\"no\";s:12:\"media_delete\";s:2:\"no\";s:14:\"question_group\";s:2:\"no\";s:18:\"question_group_add\";s:2:\"no\";s:19:\"question_group_edit\";s:2:\"no\";s:21:\"question_group_delete\";s:2:\"no\";s:14:\"question_level\";s:2:\"no\";s:18:\"question_level_add\";s:2:\"no\";s:19:\"question_level_edit\";s:2:\"no\";s:21:\"question_level_delete\";s:2:\"no\";s:13:\"question_bank\";s:2:\"no\";s:17:\"question_bank_add\";s:2:\"no\";s:18:\"question_bank_edit\";s:2:\"no\";s:20:\"question_bank_delete\";s:2:\"no\";s:18:\"question_bank_view\";s:2:\"no\";s:11:\"online_exam\";s:2:\"no\";s:15:\"online_exam_add\";s:2:\"no\";s:16:\"online_exam_edit\";s:2:\"no\";s:18:\"online_exam_delete\";s:2:\"no\";s:11:\"instruction\";s:2:\"no\";s:15:\"instruction_add\";s:2:\"no\";s:16:\"instruction_edit\";s:2:\"no\";s:18:\"instruction_delete\";s:2:\"no\";s:16:\"instruction_view\";s:2:\"no\";s:15:\"salary_template\";s:2:\"no\";s:19:\"salary_template_add\";s:2:\"no\";s:20:\"salary_template_edit\";s:2:\"no\";s:22:\"salary_template_delete\";s:2:\"no\";s:20:\"salary_template_view\";s:2:\"no\";s:15:\"hourly_template\";s:2:\"no\";s:19:\"hourly_template_add\";s:2:\"no\";s:20:\"hourly_template_edit\";s:2:\"no\";s:22:\"hourly_template_delete\";s:2:\"no\";s:13:\"manage_salary\";s:2:\"no\";s:17:\"manage_salary_add\";s:2:\"no\";s:18:\"manage_salary_edit\";s:2:\"no\";s:20:\"manage_salary_delete\";s:2:\"no\";s:18:\"manage_salary_view\";s:2:\"no\";s:12:\"make_payment\";s:2:\"no\";s:8:\"overtime\";s:2:\"no\";s:12:\"overtime_add\";s:2:\"no\";s:13:\"overtime_edit\";s:2:\"no\";s:15:\"overtime_delete\";s:2:\"no\";s:6:\"vendor\";s:2:\"no\";s:10:\"vendor_add\";s:2:\"no\";s:11:\"vendor_edit\";s:2:\"no\";s:13:\"vendor_delete\";s:2:\"no\";s:8:\"location\";s:2:\"no\";s:12:\"location_add\";s:2:\"no\";s:13:\"location_edit\";s:2:\"no\";s:15:\"location_delete\";s:2:\"no\";s:14:\"asset_category\";s:2:\"no\";s:18:\"asset_category_add\";s:2:\"no\";s:19:\"asset_category_edit\";s:2:\"no\";s:21:\"asset_category_delete\";s:2:\"no\";s:5:\"asset\";s:2:\"no\";s:9:\"asset_add\";s:2:\"no\";s:10:\"asset_edit\";s:2:\"no\";s:12:\"asset_delete\";s:2:\"no\";s:10:\"asset_view\";s:2:\"no\";s:16:\"asset_assignment\";s:2:\"no\";s:20:\"asset_assignment_add\";s:2:\"no\";s:21:\"asset_assignment_edit\";s:2:\"no\";s:23:\"asset_assignment_delete\";s:2:\"no\";s:21:\"asset_assignment_view\";s:2:\"no\";s:8:\"purchase\";s:2:\"no\";s:12:\"purchase_add\";s:2:\"no\";s:13:\"purchase_edit\";s:2:\"no\";s:15:\"purchase_delete\";s:2:\"no\";s:15:\"productcategory\";s:2:\"no\";s:19:\"productcategory_add\";s:2:\"no\";s:20:\"productcategory_edit\";s:2:\"no\";s:22:\"productcategory_delete\";s:2:\"no\";s:7:\"product\";s:2:\"no\";s:11:\"product_add\";s:2:\"no\";s:12:\"product_edit\";s:2:\"no\";s:14:\"product_delete\";s:2:\"no\";s:16:\"productwarehouse\";s:2:\"no\";s:20:\"productwarehouse_add\";s:2:\"no\";s:21:\"productwarehouse_edit\";s:2:\"no\";s:23:\"productwarehouse_delete\";s:2:\"no\";s:15:\"productsupplier\";s:2:\"no\";s:19:\"productsupplier_add\";s:2:\"no\";s:20:\"productsupplier_edit\";s:2:\"no\";s:22:\"productsupplier_delete\";s:2:\"no\";s:15:\"productpurchase\";s:2:\"no\";s:19:\"productpurchase_add\";s:2:\"no\";s:20:\"productpurchase_edit\";s:2:\"no\";s:22:\"productpurchase_delete\";s:2:\"no\";s:20:\"productpurchase_view\";s:2:\"no\";s:11:\"productsale\";s:2:\"no\";s:15:\"productsale_add\";s:2:\"no\";s:16:\"productsale_edit\";s:2:\"no\";s:18:\"productsale_delete\";s:2:\"no\";s:16:\"productsale_view\";s:2:\"no\";s:13:\"leavecategory\";s:2:\"no\";s:17:\"leavecategory_add\";s:2:\"no\";s:18:\"leavecategory_edit\";s:2:\"no\";s:20:\"leavecategory_delete\";s:2:\"no\";s:11:\"leaveassign\";s:2:\"no\";s:15:\"leaveassign_add\";s:2:\"no\";s:16:\"leaveassign_edit\";s:2:\"no\";s:18:\"leaveassign_delete\";s:2:\"no\";s:10:\"leaveapply\";s:2:\"no\";s:14:\"leaveapply_add\";s:2:\"no\";s:15:\"leaveapply_edit\";s:2:\"no\";s:17:\"leaveapply_delete\";s:2:\"no\";s:15:\"leaveapply_view\";s:2:\"no\";s:16:\"leaveapplication\";s:2:\"no\";s:18:\"activitiescategory\";s:2:\"no\";s:22:\"activitiescategory_add\";s:2:\"no\";s:23:\"activitiescategory_edit\";s:2:\"no\";s:25:\"activitiescategory_delete\";s:2:\"no\";s:10:\"activities\";s:2:\"no\";s:14:\"activities_add\";s:2:\"no\";s:17:\"activities_delete\";s:2:\"no\";s:9:\"childcare\";s:2:\"no\";s:13:\"childcare_add\";s:2:\"no\";s:14:\"childcare_edit\";s:2:\"no\";s:16:\"childcare_delete\";s:2:\"no\";s:6:\"ebooks\";s:2:\"no\";s:10:\"ebooks_add\";s:2:\"no\";s:11:\"ebooks_edit\";s:2:\"no\";s:13:\"ebooks_delete\";s:2:\"no\";s:11:\"ebooks_view\";s:2:\"no\";s:9:\"transport\";s:2:\"no\";s:13:\"transport_add\";s:2:\"no\";s:14:\"transport_edit\";s:2:\"no\";s:16:\"transport_delete\";s:2:\"no\";s:7:\"tmember\";s:2:\"no\";s:11:\"tmember_add\";s:2:\"no\";s:12:\"tmember_edit\";s:2:\"no\";s:14:\"tmember_delete\";s:2:\"no\";s:12:\"tmember_view\";s:2:\"no\";s:6:\"hostel\";s:2:\"no\";s:10:\"hostel_add\";s:2:\"no\";s:11:\"hostel_edit\";s:2:\"no\";s:13:\"hostel_delete\";s:2:\"no\";s:8:\"category\";s:2:\"no\";s:12:\"category_add\";s:2:\"no\";s:13:\"category_edit\";s:2:\"no\";s:15:\"category_delete\";s:2:\"no\";s:7:\"hmember\";s:2:\"no\";s:11:\"hmember_add\";s:2:\"no\";s:12:\"hmember_edit\";s:2:\"no\";s:14:\"hmember_delete\";s:2:\"no\";s:12:\"hmember_view\";s:2:\"no\";s:8:\"feetypes\";s:2:\"no\";s:12:\"feetypes_add\";s:2:\"no\";s:13:\"feetypes_edit\";s:2:\"no\";s:15:\"feetypes_delete\";s:2:\"no\";s:7:\"invoice\";s:2:\"no\";s:11:\"invoice_add\";s:2:\"no\";s:12:\"invoice_edit\";s:2:\"no\";s:14:\"invoice_delete\";s:2:\"no\";s:12:\"invoice_view\";s:2:\"no\";s:14:\"paymenthistory\";s:2:\"no\";s:19:\"paymenthistory_edit\";s:2:\"no\";s:21:\"paymenthistory_delete\";s:2:\"no\";s:7:\"expense\";s:2:\"no\";s:11:\"expense_add\";s:2:\"no\";s:12:\"expense_edit\";s:2:\"no\";s:14:\"expense_delete\";s:2:\"no\";s:6:\"income\";s:2:\"no\";s:10:\"income_add\";s:2:\"no\";s:11:\"income_edit\";s:2:\"no\";s:13:\"income_delete\";s:2:\"no\";s:14:\"global_payment\";s:2:\"no\";s:13:\"notice_delete\";s:2:\"no\";s:11:\"notice_view\";s:2:\"no\";s:12:\"event_delete\";s:2:\"no\";s:10:\"event_view\";s:2:\"no\";s:11:\"holiday_add\";s:2:\"no\";s:12:\"holiday_edit\";s:2:\"no\";s:14:\"holiday_delete\";s:2:\"no\";s:13:\"classesreport\";s:2:\"no\";s:13:\"studentreport\";s:2:\"no\";s:12:\"idcardreport\";s:2:\"no\";s:15:\"admitcardreport\";s:2:\"no\";s:13:\"routinereport\";s:2:\"no\";s:18:\"examschedulereport\";s:2:\"no\";s:16:\"attendancereport\";s:2:\"no\";s:24:\"attendanceoverviewreport\";s:2:\"no\";s:18:\"librarybooksreport\";s:2:\"no\";s:17:\"librarycardreport\";s:2:\"no\";s:22:\"librarybookissuereport\";s:2:\"no\";s:16:\"meritstagereport\";s:2:\"no\";s:21:\"tabulationsheetreport\";s:2:\"no\";s:15:\"marksheetreport\";s:2:\"no\";s:18:\"progresscardreport\";s:2:\"no\";s:20:\"studentsessionreport\";s:2:\"no\";s:16:\"onlineexamreport\";s:2:\"no\";s:24:\"onlineexamquestionreport\";s:2:\"no\";s:21:\"onlineadmissionreport\";s:2:\"no\";s:17:\"certificatereport\";s:2:\"no\";s:22:\"leaveapplicationreport\";s:2:\"no\";s:21:\"productpurchasereport\";s:2:\"no\";s:17:\"productsalereport\";s:2:\"no\";s:23:\"searchpaymentfeesreport\";s:2:\"no\";s:10:\"feesreport\";s:2:\"no\";s:13:\"duefeesreport\";s:2:\"no\";s:17:\"balancefeesreport\";s:2:\"no\";s:17:\"transactionreport\";s:2:\"no\";s:17:\"studentfinereport\";s:2:\"no\";s:14:\"overtimereport\";s:2:\"no\";s:12:\"salaryreport\";s:2:\"no\";s:19:\"accountledgerreport\";s:2:\"no\";s:15:\"onlineadmission\";s:2:\"no\";s:11:\"visitorinfo\";s:2:\"no\";s:18:\"visitorinfo_delete\";s:2:\"no\";s:16:\"visitorinfo_view\";s:2:\"no\";s:10:\"schoolyear\";s:2:\"no\";s:14:\"schoolyear_add\";s:2:\"no\";s:15:\"schoolyear_edit\";s:2:\"no\";s:17:\"schoolyear_delete\";s:2:\"no\";s:12:\"studentgroup\";s:2:\"no\";s:16:\"studentgroup_add\";s:2:\"no\";s:17:\"studentgroup_edit\";s:2:\"no\";s:19:\"studentgroup_delete\";s:2:\"no\";s:8:\"complain\";s:2:\"no\";s:12:\"complain_add\";s:2:\"no\";s:13:\"complain_edit\";s:2:\"no\";s:15:\"complain_delete\";s:2:\"no\";s:13:\"complain_view\";s:2:\"no\";s:20:\"certificate_template\";s:2:\"no\";s:24:\"certificate_template_add\";s:2:\"no\";s:25:\"certificate_template_edit\";s:2:\"no\";s:27:\"certificate_template_delete\";s:2:\"no\";s:25:\"certificate_template_view\";s:2:\"no\";s:11:\"systemadmin\";s:2:\"no\";s:15:\"systemadmin_add\";s:2:\"no\";s:16:\"systemadmin_edit\";s:2:\"no\";s:18:\"systemadmin_delete\";s:2:\"no\";s:16:\"systemadmin_view\";s:2:\"no\";s:13:\"resetpassword\";s:2:\"no\";s:10:\"sociallink\";s:2:\"no\";s:14:\"sociallink_add\";s:2:\"no\";s:15:\"sociallink_edit\";s:2:\"no\";s:17:\"sociallink_delete\";s:2:\"no\";s:18:\"mailandsmstemplate\";s:2:\"no\";s:22:\"mailandsmstemplate_add\";s:2:\"no\";s:23:\"mailandsmstemplate_edit\";s:2:\"no\";s:25:\"mailandsmstemplate_delete\";s:2:\"no\";s:23:\"mailandsmstemplate_view\";s:2:\"no\";s:11:\"bulkimport \";s:2:\"no\";s:6:\"backup\";s:2:\"no\";s:8:\"usertype\";s:2:\"no\";s:12:\"usertype_add\";s:2:\"no\";s:13:\"usertype_edit\";s:2:\"no\";s:15:\"usertype_delete\";s:2:\"no\";s:10:\"permission\";s:2:\"no\";s:6:\"addons\";s:2:\"no\";s:6:\"update\";s:2:\"no\";s:16:\"posts_categories\";s:2:\"no\";s:20:\"posts_categories_add\";s:2:\"no\";s:21:\"posts_categories_edit\";s:2:\"no\";s:23:\"posts_categories_delete\";s:2:\"no\";s:5:\"posts\";s:2:\"no\";s:9:\"posts_add\";s:2:\"no\";s:10:\"posts_edit\";s:2:\"no\";s:12:\"posts_delete\";s:2:\"no\";s:5:\"pages\";s:2:\"no\";s:9:\"pages_add\";s:2:\"no\";s:10:\"pages_edit\";s:2:\"no\";s:12:\"pages_delete\";s:2:\"no\";s:12:\"frontendmenu\";s:2:\"no\";s:7:\"setting\";s:2:\"no\";s:16:\"frontend_setting\";s:2:\"no\";s:15:\"paymentsettings\";s:2:\"no\";s:11:\"smssettings\";s:2:\"no\";s:12:\"emailsetting\";s:2:\"no\";s:11:\"marksetting\";s:2:\"no\";s:9:\"candidate\";s:2:\"no\";s:13:\"candidate_add\";s:2:\"no\";s:14:\"candidate_edit\";s:2:\"no\";s:16:\"candidate_delete\";s:2:\"no\";s:14:\"candidate_view\";s:2:\"no\";s:7:\"sponsor\";s:2:\"no\";s:11:\"sponsor_add\";s:2:\"no\";s:12:\"sponsor_edit\";s:2:\"no\";s:14:\"sponsor_delete\";s:2:\"no\";s:12:\"sponsor_view\";s:2:\"no\";s:11:\"sponsorship\";s:2:\"no\";s:15:\"sponsorship_add\";s:2:\"no\";s:16:\"sponsorship_edit\";s:2:\"no\";s:18:\"sponsorship_delete\";s:2:\"no\";s:17:\"sponsorshipreport\";s:2:\"no\";s:30:\"onlineexamquestionanswerreport\";s:2:\"no\";s:10:\"attendance\";s:2:\"no\";s:5:\"mpesa\";s:2:\"no\";s:20:\"vendorpurchasereport\";s:2:\"no\";s:18:\"itempurchasereport\";s:2:\"no\";s:22:\"categorypurchasereport\";s:2:\"no\";s:14:\"itemsalereport\";s:2:\"no\";s:18:\"categorysalereport\";s:2:\"no\";s:6:\"wallet\";s:2:\"no\";s:5:\"lunch\";s:2:\"no\";s:12:\"lunchsetting\";s:2:\"no\";s:9:\"lunchlogs\";s:2:\"no\";s:10:\"schoolterm\";s:2:\"no\";s:14:\"schoolterm_add\";s:2:\"no\";s:15:\"schoolterm_edit\";s:2:\"no\";s:17:\"schoolterm_delete\";s:2:\"no\";s:15:\"schoolterm_view\";s:2:\"no\";s:15:\"generate_qrcode\";s:2:\"no\";s:17:\"cbcterminalreport\";s:2:\"no\";s:9:\"smsreport\";s:2:\"no\";s:7:\"sendsms\";s:2:\"no\";s:15:\"studentleaveout\";s:2:\"no\";s:20:\"studentleaveout_edit\";s:2:\"no\";s:20:\"studentleaveout_view\";s:2:\"no\";s:22:\"studentleaveout_delete\";s:2:\"no\";s:13:\"backup_delete\";s:2:\"no\";s:10:\"backup_add\";s:2:\"no\";s:14:\"backup_restore\";s:2:\"no\";}');
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9cca609baf4edb692b23b45fd5ab9cd23950ad33', '102.222.4.116', 1713338000, '__ci_last_regenerate|i:1713338000;english|N;loginuserID|s:2:\"10\";name|s:14:\"PENINAH MUTUKU\";email|s:17:\"peninah@email.com\";usertypeID|s:1:\"7\";usertype|s:12:\"Receptionist\";username|s:7:\"peninah\";photo|s:11:\"peninah.JPG\";lang|s:7:\"english\";defaultschoolyearID|s:1:\"4\";varifyvaliduser|b:1;loggedin|b:1;get_permission|b:1;master_permission_set|a:426:{s:9:\"dashboard\";s:3:\"yes\";s:7:\"student\";s:3:\"yes\";s:11:\"student_add\";s:3:\"yes\";s:12:\"student_edit\";s:3:\"yes\";s:7:\"teacher\";s:3:\"yes\";s:11:\"teacher_add\";s:3:\"yes\";s:12:\"teacher_edit\";s:3:\"yes\";s:12:\"conversation\";s:3:\"yes\";s:6:\"notice\";s:3:\"yes\";s:10:\"notice_add\";s:3:\"yes\";s:11:\"notice_edit\";s:3:\"yes\";s:5:\"event\";s:3:\"yes\";s:9:\"event_add\";s:3:\"yes\";s:10:\"event_edit\";s:3:\"yes\";s:7:\"holiday\";s:3:\"yes\";s:12:\"holiday_view\";s:3:\"yes\";s:14:\"terminalreport\";s:3:\"yes\";s:17:\"qrcode_attendance\";s:3:\"yes\";s:10:\"mailandsms\";s:3:\"yes\";s:14:\"mailandsms_add\";s:3:\"yes\";s:15:\"mailandsms_view\";s:3:\"yes\";s:25:\"student_attendance_report\";s:3:\"yes\";s:25:\"teacher_attendance_report\";s:3:\"yes\";s:22:\"user_attendance_report\";s:3:\"yes\";s:10:\"studentids\";s:3:\"yes\";s:17:\"studentids_delete\";s:3:\"yes\";s:7:\"lmember\";s:3:\"yes\";s:11:\"lmember_add\";s:3:\"yes\";s:12:\"lmember_edit\";s:3:\"yes\";s:14:\"lmember_delete\";s:3:\"yes\";s:12:\"lmember_view\";s:3:\"yes\";s:4:\"book\";s:3:\"yes\";s:8:\"book_add\";s:3:\"yes\";s:9:\"book_edit\";s:3:\"yes\";s:11:\"book_delete\";s:3:\"yes\";s:5:\"issue\";s:3:\"yes\";s:9:\"issue_add\";s:3:\"yes\";s:10:\"issue_edit\";s:3:\"yes\";s:10:\"issue_view\";s:3:\"yes\";s:14:\"student_delete\";s:2:\"no\";s:12:\"student_view\";s:2:\"no\";s:7:\"parents\";s:2:\"no\";s:11:\"parents_add\";s:2:\"no\";s:12:\"parents_edit\";s:2:\"no\";s:14:\"parents_delete\";s:2:\"no\";s:12:\"parents_view\";s:2:\"no\";s:14:\"teacher_delete\";s:2:\"no\";s:12:\"teacher_view\";s:2:\"no\";s:4:\"user\";s:2:\"no\";s:8:\"user_add\";s:2:\"no\";s:9:\"user_edit\";s:2:\"no\";s:11:\"user_delete\";s:2:\"no\";s:9:\"user_view\";s:2:\"no\";s:7:\"classes\";s:2:\"no\";s:11:\"classes_add\";s:2:\"no\";s:12:\"classes_edit\";s:2:\"no\";s:14:\"classes_delete\";s:2:\"no\";s:7:\"section\";s:2:\"no\";s:11:\"section_add\";s:2:\"no\";s:12:\"section_edit\";s:2:\"no\";s:15:\"semester_delete\";s:2:\"no\";s:14:\"section_delete\";s:2:\"no\";s:7:\"subject\";s:2:\"no\";s:11:\"subject_add\";s:2:\"no\";s:12:\"subject_edit\";s:2:\"no\";s:14:\"subject_delete\";s:2:\"no\";s:8:\"syllabus\";s:2:\"no\";s:12:\"syllabus_add\";s:2:\"no\";s:13:\"syllabus_edit\";s:2:\"no\";s:15:\"syllabus_delete\";s:2:\"no\";s:10:\"assignment\";s:2:\"no\";s:14:\"assignment_add\";s:2:\"no\";s:15:\"assignment_edit\";s:2:\"no\";s:17:\"assignment_delete\";s:2:\"no\";s:15:\"assignment_view\";s:2:\"no\";s:7:\"routine\";s:2:\"no\";s:11:\"routine_add\";s:2:\"no\";s:12:\"routine_edit\";s:2:\"no\";s:14:\"routine_delete\";s:2:\"no\";s:11:\"sattendance\";s:2:\"no\";s:15:\"sattendance_add\";s:2:\"no\";s:16:\"sattendance_view\";s:2:\"no\";s:11:\"tattendance\";s:2:\"no\";s:15:\"tattendance_add\";s:2:\"no\";s:16:\"tattendance_view\";s:2:\"no\";s:11:\"uattendance\";s:2:\"no\";s:15:\"uattendance_add\";s:2:\"no\";s:16:\"uattendance_view\";s:2:\"no\";s:4:\"exam\";s:2:\"no\";s:8:\"exam_add\";s:2:\"no\";s:9:\"exam_edit\";s:2:\"no\";s:11:\"exam_delete\";s:2:\"no\";s:12:\"examschedule\";s:2:\"no\";s:16:\"examschedule_add\";s:2:\"no\";s:17:\"examschedule_edit\";s:2:\"no\";s:19:\"examschedule_delete\";s:2:\"no\";s:5:\"grade\";s:2:\"no\";s:9:\"grade_add\";s:2:\"no\";s:10:\"grade_edit\";s:2:\"no\";s:12:\"grade_delete\";s:2:\"no\";s:11:\"eattendance\";s:2:\"no\";s:15:\"eattendance_add\";s:2:\"no\";s:4:\"mark\";s:2:\"no\";s:8:\"mark_add\";s:2:\"no\";s:9:\"mark_view\";s:2:\"no\";s:14:\"markpercentage\";s:2:\"no\";s:18:\"markpercentage_add\";s:2:\"no\";s:19:\"markpercentage_edit\";s:2:\"no\";s:21:\"markpercentage_delete\";s:2:\"no\";s:9:\"promotion\";s:2:\"no\";s:5:\"media\";s:2:\"no\";s:9:\"media_add\";s:2:\"no\";s:12:\"media_delete\";s:2:\"no\";s:14:\"question_group\";s:2:\"no\";s:18:\"question_group_add\";s:2:\"no\";s:19:\"question_group_edit\";s:2:\"no\";s:21:\"question_group_delete\";s:2:\"no\";s:14:\"question_level\";s:2:\"no\";s:18:\"question_level_add\";s:2:\"no\";s:19:\"question_level_edit\";s:2:\"no\";s:21:\"question_level_delete\";s:2:\"no\";s:13:\"question_bank\";s:2:\"no\";s:17:\"question_bank_add\";s:2:\"no\";s:18:\"question_bank_edit\";s:2:\"no\";s:20:\"question_bank_delete\";s:2:\"no\";s:18:\"question_bank_view\";s:2:\"no\";s:11:\"online_exam\";s:2:\"no\";s:15:\"online_exam_add\";s:2:\"no\";s:16:\"online_exam_edit\";s:2:\"no\";s:18:\"online_exam_delete\";s:2:\"no\";s:11:\"instruction\";s:2:\"no\";s:15:\"instruction_add\";s:2:\"no\";s:16:\"instruction_edit\";s:2:\"no\";s:18:\"instruction_delete\";s:2:\"no\";s:16:\"instruction_view\";s:2:\"no\";s:15:\"salary_template\";s:2:\"no\";s:19:\"salary_template_add\";s:2:\"no\";s:20:\"salary_template_edit\";s:2:\"no\";s:22:\"salary_template_delete\";s:2:\"no\";s:20:\"salary_template_view\";s:2:\"no\";s:15:\"hourly_template\";s:2:\"no\";s:19:\"hourly_template_add\";s:2:\"no\";s:20:\"hourly_template_edit\";s:2:\"no\";s:22:\"hourly_template_delete\";s:2:\"no\";s:13:\"manage_salary\";s:2:\"no\";s:17:\"manage_salary_add\";s:2:\"no\";s:18:\"manage_salary_ed